package com.crytek.jira.plugins.crashHandler.signature;

import static org.junit.Assert.assertEquals;

import org.junit.Before;
import org.junit.Test;

import com.crytek.jira.plugins.crashHandler.SignatureInfo;

//TODO: add real life examples, the test here is useful to doublecheck the validity of algorithms
public class PrefixMatcherUnitTest
{

	private PrefixComparer comparer;
	private SignatureInfo signature;
	private static final int AN_ID = 0;

	private static final String tenA = "a a a a a a a a a a";
	private static final String bAndNineA = "b a a a a a a a a a";
	private static final String aAndNineB = "a b b b b b b b b b";
	private static final String tenB = "b b b b b b b b b b";
	private static final String emptyCallStack = "";
	private static final double delta = 0.;

	@Before
	public void setUp()
	{

	}

	@Test
	public void rateSimilarity_withSameString_returns1()
	{
		comparer = getComparerForCallStack(tenA);
		signature = new SignatureInfo(AN_ID, "", tenA);

		double similarity = comparer.rateSimilarity(signature);
		assertEquals(1., similarity, delta);
	}

	@Test
	public void rateSimilarity_withEmptyCallStack_returns0()
	{
		comparer = getComparerForCallStack(emptyCallStack);
		signature = getSignatureForCallStack(emptyCallStack);

		double similarity = comparer.rateSimilarity(signature);
		assertEquals(0., similarity, delta);
	}

	@Test
	public void rateSimilairty_firstDifferent_returns0()
	{
		comparer = getComparerForCallStack(tenA);
		signature = getSignatureForCallStack(bAndNineA);

		double similarity = comparer.rateSimilarity(signature);
		assertEquals(0., similarity, delta);
	}

	@Test
	public void rateSimilarity_onlyFirst_returnsATenth()
	{
		comparer = getComparerForCallStack(tenA);
		signature = getSignatureForCallStack(aAndNineB);

		double similarity = comparer.rateSimilarity(signature);
		assertEquals(0.1, similarity, delta);
	}

	@Test
	public void rateSimilarity_againstEmpty_returns0()
	{
		comparer = getComparerForCallStack(tenA);
		signature = getSignatureForCallStack(emptyCallStack);

		double similarity = comparer.rateSimilarity(signature);
		assertEquals(0, similarity, delta);
	}

	@Test
	public void rateSimilarity_completelyDifferent_returns0()
	{
		comparer = getComparerForCallStack(tenA);
		signature = getSignatureForCallStack(tenB);

		double similarity = comparer.rateSimilarity(signature);
		assertEquals(0, similarity, delta);
	}

	private PrefixComparer getComparerForCallStack(String callstack)
	{
		SignatureInfo info = new SignatureInfo(AN_ID, "", callstack);
		return new PrefixComparer(info);
	}

	private SignatureInfo getSignatureForCallStack(String callStack)
	{
		return new SignatureInfo(AN_ID, "", callStack);
	}
}
