package com.onresolve.jira.crytek.settings;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;
import static org.junit.Assert.fail;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import com.atlassian.jira.config.ConstantsManager;

public class SettingsUnitTest
{
	ConstantsManager constantsManager;
	Settings settings;

	@Before
	public void setUp()
	{
		constantsManager = mock(ConstantsManager.class);
		when(constantsManager.getPriorityName(null)).thenThrow(new RuntimeException());
		when(constantsManager.getPriorityName(Settings.DEFAULT_PRIORITY)).thenReturn("");

		settings = Settings.getDefaultSettings(constantsManager);
	}

	/**
	 * This method has been added in order to be sure that all the settings
	 * fields are initialised. When a new field in settings is added we need to
	 * make sure it's properly initialized with a default value.
	 */
	@Test
	public void getDefault_initialiseAllFields()
	{
		assertTrue(gettersNotNullOrEmpty(settings));
	}

	public static <T> boolean gettersNotNullOrEmpty(T object)
	{
		List<Method> allGetters = gettersForObject(object);
		try
		{
			for (Method field : allGetters)
			{
				Object value = field.invoke(object);
				assertTrue(
						"The following getter doesn't contain an initialized value: " + field.getName() + " initialise it in Settings.initialiseWithDefault",
						isGetterValueInitialised(value));
			}
		}
		catch (Exception e)
		{
			fail("exception calling gettersNotNullOrEmpty: " + e.getMessage());
		}
		return true;
	}

	private static <T> List<Method> gettersForObject(T object)
	{
		Method[] allDeclaredFields = object.getClass().getMethods();
		List<Method> allGetters = new ArrayList<Method>();
		for (Method field : allDeclaredFields)
		{
			if (field.getName().matches("get.*") && field.getGenericParameterTypes().length == 0 && !Modifier.isStatic(field.getModifiers()))
			{
				field.setAccessible(true);
				allGetters.add(field);
			}
		}
		return allGetters;
	}

	private static boolean isGetterValueInitialised(Object value)
	{
		return (value != null);
	}

	@Test
	public void noBasicTypes_inSettings()
	{
		List<Method> allGetters = gettersForObject(settings);
		for (Method method : allGetters)
		{
			String errorMessage = "Settings shouldn't have a primitive return type:" + method.getName() + "() "
					+ " The default value for int, double etc.. is zero and it can't be compared with values inserted by the user";

			assertFalse(errorMessage, method.getReturnType().isPrimitive());
		}
	}

}
