﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Diagnostics;
using System.IO;

namespace Ps3CrashHandler
{
    class CommandLine
    {
        private String command;
        private String error;
        private String output;
        private String arguments;

        
        public System.String Error
        {
            get { return error; }
        }

        public bool IsError(){
            return !String.IsNullOrEmpty(error);
        }
        
        public System.String Output
        {
            get { return output; }
        }

        public CommandLine(String command, String arguments){
            this.command = command;
            error = String.Empty;
            output = String.Empty;
            this.arguments = arguments;
        }


        public void Run()
        {
            Process process = new Process();
            process.StartInfo.UseShellExecute = false;
            process.StartInfo.RedirectStandardError = true;
            process.StartInfo.RedirectStandardOutput = true;
            process.StartInfo.CreateNoWindow = true;
            process.StartInfo.FileName = command;
            process.StartInfo.Arguments = arguments;
            process.Start();

            output = process.StandardOutput.ReadToEnd();
            error = process.StandardError.ReadToEnd();
        }
    }
}
