﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;
using CrashHandler;
using System.IO;
using PcCrashHandler = CrashHandler.CrashHandler;

namespace Ps3CrashHandler
{
    class Ps3CrashHandler : PcCrashHandler
    {
        const String selfFileNameArgument = "-self";
        const String DialogTitle = "Please select the self file you executed on PS3™";
        
        [STAThread]
        public static void Main(String[] args)
        {

            IDictionary<String, String> arguments = Util.GetNamedArgumentsWithProperties(args);
            String file = null;
            if(!arguments.ContainsKey(selfFileNameArgument)){
                OpenFileDialog filePicker = new OpenFileDialog();
                filePicker.InitialDirectory = Path.GetDirectoryName(Application.ExecutablePath);
                filePicker.Filter = "self files(*.self)|*.self";
                filePicker.FilterIndex = 1;
                filePicker.RestoreDirectory = true;
                
                filePicker.Title = DialogTitle;
                if (filePicker.ShowDialog() == DialogResult.OK)
                {
                    file = filePicker.FileName;
                } else {
                    MessageBox.Show("Please pick a valid self file");
                    return;
                }
            }else{
                file = arguments[selfFileNameArgument];
            }
            //TODO: please kill me, move me in the ps3CrashHandler as the xbox version does...
            String decodedCallStack = Ps3CommandLineTools.DecodeCallstack(file);
            //MessageBox.Show(decodedCallStack);
            Ps3CrashHandler crashHandler = new Ps3CrashHandler(Path.GetDirectoryName(file), "Game.log", Ps3CommandLineTools.newErrorLogName);
            crashHandler.HandleGameCrash();
            Environment.Exit(0);
            
        }

        public Ps3CrashHandler(String buildFolder, String gameLogFilename, String errorLogName)
            : base(buildFolder, gameLogFilename, errorLogName)
        {
            m_crashInfo.Platform = m_settings.PlatformPS3;
            m_crashInfo.OperatingSystemInfo = "<not implemented>";
            
        }
        protected override void RetrievePlatformAttachments()
        {
            
        }

    }
}
