#include "stdafx.h"
#include "CrashHandler.h"

#include "JiraSoapClientWrapper.h"
#include "Utils.h"


const string CrashHandler::kBuildFolderArgumentKey = "buildFolder";
const string CrashHandler::kLogFileNameArgumentKey = "logFileName";
const string CrashHandler::kErrorLogNameArgumentKey = "errorLog";
const string CrashHandler::kCallStackHeader = "Call Stack Trace:";

CrashHandler::CrashHandler()
{
}

CrashHandler::~CrashHandler()
{
}

bool CrashHandler::ParseCommandLine(const string& commandLine)
{
	map<string, string> out;
	Utils::MakeArgumentKeyValueMap(commandLine, &out);

	m_buildFolder = out[kBuildFolderArgumentKey];
	m_logFileName = out[kLogFileNameArgumentKey];
	m_errorLogName = out[kErrorLogNameArgumentKey];
	if (m_errorLogName.empty())
		m_errorLogName = "error.log";

	if (m_buildFolder.empty() || m_logFileName.empty())
		return false;

	return true;
}

bool CrashHandler::RetrieveCallStackInfo(OUT string* callStackInfo)
{
	if (callStackInfo == NULL)
		return false;

	string fileText;
	if (false == Utils::ReadFileToString(Utils::ConcatenatePathAndFile(m_buildFolder, m_errorLogName), &fileText))
		return false;

	int callStackStartPos = fileText.find(kCallStackHeader);
	if (callStackStartPos != string::npos)
		callStackInfo->assign(fileText.substr(callStackStartPos));

	return true;
}

bool CrashHandler::ReportIssue(const string& id, const string& password, const string& description, FILE* errorLog)
{
	JiraSoapClientWrapper jiraSoap(id, password);
	jiraSoap.SetErrorLog(errorLog);

	string issueKey;
	if (false == jiraSoap.CreateIssue("SDK", "Sent By CrashHandler", "18", description, &issueKey))
		return false;

	IssueAttachments attachments;
	attachments.Add(m_buildFolder, m_logFileName);
	attachments.Add(m_buildFolder, m_errorLogName);
	return jiraSoap.AddAttachmentsToIssue(issueKey, &attachments);
	return true;
}
