#pragma once


class CrashHandler
{
public:
	static const string kBuildFolderArgumentKey;
	static const string kLogFileNameArgumentKey;
	static const string kErrorLogNameArgumentKey;
	static const string kCallStackHeader;

public:
	CrashHandler();
	~CrashHandler();

	bool ParseCommandLine(const string& commandLine);
	bool RetrieveCallStackInfo(OUT string* callStackInfo);
	bool ReportIssue(const string& id, const string& password, const string& description, FILE* errorLog);

private:
	string m_buildFolder;
	string m_logFileName;
	string m_errorLogName;

	DISALLOW_COPY_AND_ASSIGN(CrashHandler);
};