
// CrashHandlerLicensingDlg.cpp : implementation file
//

#include "stdafx.h"
#include "CrashHandlerLicensing.h"
#include "CrashHandlerLicensingDlg.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CCrashHandlerLicensingDlg dialog




CCrashHandlerLicensingDlg::CCrashHandlerLicensingDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CCrashHandlerLicensingDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CCrashHandlerLicensingDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CALL_STACK, m_callStack);
	DDX_Control(pDX, IDC_DESCRIPTION, m_description);
	DDX_Control(pDX, IDC_USER_ID, m_userId);
	DDX_Control(pDX, IDC_PASSWORD, m_password);
	DDX_Control(pDX, IDOK, m_sendToCrytek);
}

BEGIN_MESSAGE_MAP(CCrashHandlerLicensingDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDOK, &CCrashHandlerLicensingDlg::OnBnClickedSendToCrytek)
	ON_EN_CHANGE(IDC_USER_ID, &CCrashHandlerLicensingDlg::OnEnChangeInputControls)
	ON_EN_CHANGE(IDC_PASSWORD, &CCrashHandlerLicensingDlg::OnEnChangeInputControls)
	ON_EN_CHANGE(IDC_DESCRIPTION, &CCrashHandlerLicensingDlg::OnEnChangeInputControls)
END_MESSAGE_MAP()


// CCrashHandlerLicensingDlg message handlers

BOOL CCrashHandlerLicensingDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	InitCrashHandler();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CCrashHandlerLicensingDlg::InitCrashHandler()
{
	// CrashHandler Initialize with command-line input.
	string commandLineStr = GetCommandLine();
	if (false == crashHandler.ParseCommandLine(commandLineStr))
		ShowHelpAndExit();

	// Shows the call stack.
	string callStack;
	if (true == crashHandler.RetrieveCallStackInfo(&callStack))
		m_callStack.SetWindowText(callStack.c_str());
	else
		m_callStack.SetWindowText("Couldn't retrieve the call stack.");
}

void CCrashHandlerLicensingDlg::ShowHelpAndExit()
{
	string helpMessage = "Usage: CrashHandler.exe [arguments]\n\n Arguments are the following:\n\n"
		+ CrashHandler::kBuildFolderArgumentKey + "=[build folder]: Define the build folder\n"
		+ CrashHandler::kLogFileNameArgumentKey + "=[log file name]: Define the logfile this application will use\n"
		+ CrashHandler::kLogFileNameArgumentKey + "=[error log file name]: Define the error.log name the application will use";
	AfxMessageBox(helpMessage.c_str());

	// Terminates the program.
	EndDialog(IDCANCEL);
}


void CCrashHandlerLicensingDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CCrashHandlerLicensingDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CCrashHandlerLicensingDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CCrashHandlerLicensingDlg::OnBnClickedSendToCrytek()
{
	OnOK();

	// Reports the issue to jira.
	CString id, password, description;
	m_userId.GetWindowText(id);
	m_password.GetWindowText(password);
	m_description.GetWindowText(description);
	FILE* errorLog;
	fopen_s(&errorLog, "soapError.log", "wt");
	if (true == crashHandler.ReportIssue(id.GetString(), password.GetString(), description.GetString(), errorLog))
		AfxMessageBox("Crash reported successfully");
	else
		AfxMessageBox("Crash report failed!");
	fclose(errorLog);
}

void CCrashHandlerLicensingDlg::OnEnChangeInputControls()
{
	// 'Send to Crytek' button is enabled only when id, password and description are all filled.
	if (m_userId.GetWindowTextLength() &&
		m_password.GetWindowTextLength() &&
		m_description.GetWindowTextLength())
		m_sendToCrytek.EnableWindow();
	else
		m_sendToCrytek.EnableWindow(FALSE);
}

