#include "stdafx.h"
#include "JiraSoapClientWrapper.h"

#include "jirasoapservice_v2SoapBinding.nsmap"
#include "Utils.h"


JiraSoapClientWrapper::JiraSoapClientWrapper(const string& id, const string& password)
: m_id(id), m_password(password), m_errorLog(stderr), m_loginToken(NULL)
{
	Login();
}

JiraSoapClientWrapper::~JiraSoapClientWrapper()
{
	Logout();
	soap_destroy(&m_soap);
	soap_end(&m_soap);
	soap_done(&m_soap);
}

bool JiraSoapClientWrapper::Login()
{
	auto_ptr<char> id(new char[m_id.size()+1]);
	auto_ptr<char> password(new char[m_password.size()+1]);
	strcpy_s(id.get(), m_id.size()+1, m_id.c_str());
	strcpy_s(password.get(), m_password.size()+1, m_password.c_str());
	soap_init(&m_soap);
	soap_call_ns4__login(&m_soap, NULL, NULL, id.get(), password.get(), m_loginToken);
	if (m_soap.error)
	{
		soap_print_fault(&m_soap, m_errorLog);
		return false;
	}
	return true;
}

bool JiraSoapClientWrapper::Logout()
{
	bool bResult;
	soap_call_ns4__logout(&m_soap, NULL, NULL, m_loginToken, bResult);
	if (m_soap.error)
	{
		soap_print_fault(&m_soap, m_errorLog);
		return false;
	}
	return bResult;
}

void JiraSoapClientWrapper::SetErrorLog(FILE* fp)
{
	m_errorLog = fp;
	if (NULL == m_errorLog)
		m_errorLog = stderr;
}

bool JiraSoapClientWrapper::CreateIssue(const string& project, 
										const string& summary,
										const string& type,
										const string& description,
										string* createdIssueKey)
{
	auto_ptr<char> projectBuf(new char[project.size()+1]);
	auto_ptr<char> summaryBuf(new char[summary.size()+1]);
	auto_ptr<char> typeBuf(new char[type.size()+1]);
	auto_ptr<char> descriptionBuf(new char[description.size()+1]);
	strcpy_s(projectBuf.get(), project.size()+1, project.c_str());
	strcpy_s(summaryBuf.get(), summary.size()+1, summary.c_str());
	strcpy_s(typeBuf.get(), type.size()+1, type.c_str());
	strcpy_s(descriptionBuf.get(), description.size()+1, description.c_str());

	ns2__RemoteIssue issue;
	issue.project = projectBuf.get();
	issue.summary = summaryBuf.get();
	issue.type = typeBuf.get();
	issue.description = descriptionBuf.get();

	ns4__createIssueResponse response;
	soap_call_ns4__createIssue(&m_soap, NULL, NULL, m_loginToken, &issue, response);
	if (m_soap.error)
	{
		soap_print_fault(&m_soap, m_errorLog);
		return false;
	}

	if (NULL != createdIssueKey)
		*createdIssueKey = response._createIssueReturn->key;
	return true;
}

bool JiraSoapClientWrapper::AddAttachmentsToIssue(const string& issueKey, IssueAttachments* attachments)
{
	bool bResult;
	auto_ptr<char> issueKeyBuf(new char[issueKey.size()+1]);
	strcpy_s(issueKeyBuf.get(), issueKey.size()+1, issueKey.c_str());
	soap_call_ns4__addAttachmentsToIssue(&m_soap, NULL, NULL, m_loginToken, issueKeyBuf.get(), attachments->GetFileNamesParam(), attachments->GetFileContentsParam(), bResult);
	if (m_soap.error)
	{
		soap_print_fault(&m_soap, m_errorLog);
		return false;
	}
	return bResult;
}


////////////////////////////////////////////////////////////////
IssueAttachments::IssueAttachments()
{

}

IssueAttachments::~IssueAttachments()
{

}

void IssueAttachments::Clear()
{
	m_names = ArrayOf_USCORExsd_USCOREstring();
	m_contents = ArrayOf_USCORExsd_USCOREbase64Binary();
	m_namesBuf.clear();
	m_namesPtrArray.clear();
	m_contentsBuf.clear();
	m_struct_1.clear();
}

bool IssueAttachments::Add(const string& path, const string& filename)
{
	FILE* fp;
	string filePath = Utils::ConcatenatePathAndFile(path, filename);
	fopen_s(&fp, filePath.c_str(), "rb");
	if (NULL == fp)
		return false;

	long fileSize = Utils::GetFileSize(fp);
	m_contentsBuf.push_back(tr1::shared_ptr<char>(new char[fileSize]));
	char *contentBuf = m_contentsBuf.back().get();
	fread_s(contentBuf, fileSize, fileSize, 1, fp);
	fclose(fp);

	m_struct_1.push_back(_Struct_1());
	m_struct_1.back().__ptr = contentBuf;
	m_struct_1.back().__size = fileSize;
	m_contents.__ptr = &m_struct_1[0];
	++m_contents.__size;

	m_namesBuf.push_back(tr1::shared_ptr<char>(new char[filename.size()+1]));
	char *nameBuf = m_namesBuf.back().get();
	strcpy_s(nameBuf, filename.size()+1, filename.c_str());
	m_namesPtrArray.push_back(nameBuf);
	m_names.__ptr = (char**)&m_namesPtrArray[0];
	++m_names.__size;
	return true;
}
