#pragma once
#include "soapH.h"


class IssueAttachments;

class JiraSoapClientWrapper
{
public:
	JiraSoapClientWrapper(const string& id, const string& password);
	~JiraSoapClientWrapper();

	void SetErrorLog(FILE* errorLog);
	bool CreateIssue(const string& project, const string& summary, const string& type, const string& description, string* createdIssueKey);
	bool AddAttachmentsToIssue(const string& issueKey, IssueAttachments* attachments);

private:
	bool Login();
	bool Logout();

private:
	struct soap m_soap;
	char *m_loginToken;

	string m_id;
	string m_password;

	FILE* m_errorLog;

	DISALLOW_COPY_AND_ASSIGN(JiraSoapClientWrapper);
};


class IssueAttachments
{
public:
	IssueAttachments();
	~IssueAttachments();

	void Clear();
	bool Add(const string& path, const string& filename);
	ArrayOf_USCORExsd_USCOREstring* GetFileNamesParam()	{ return &m_names;}
	ArrayOf_USCORExsd_USCOREbase64Binary* GetFileContentsParam() { return &m_contents;}

private:
	ArrayOf_USCORExsd_USCOREstring m_names;
	ArrayOf_USCORExsd_USCOREbase64Binary m_contents;
	vector<_Struct_1> m_struct_1;
	vector<char*> m_namesPtrArray;
	vector<tr1::shared_ptr<char> > m_namesBuf;
	vector<tr1::shared_ptr<char> > m_contentsBuf;

	DISALLOW_COPY_AND_ASSIGN(IssueAttachments);
};