#include "stdafx.h"
#include "Utils.h"

#include <sys/stat.h>


namespace Utils {

void SplitStringByDelimiters(const string& src, const string& delimiters, vector<string>* tokens)
{
	if (NULL == tokens)
		return;

	tokens->clear();
	string::size_type lastPos = src.find_first_not_of(delimiters, 0);
	string::size_type pos = src.find_first_of(delimiters, lastPos);
	while (string::npos != pos || string::npos != lastPos)
	{
		tokens->push_back(src.substr(lastPos, pos - lastPos));
		lastPos = src.find_first_not_of(delimiters, pos);
		pos = src.find_first_of(delimiters, lastPos);
	}
}

string FindFirstStringSurroundedBy(const string& text, const string& surrounder, size_t& startPos)
{
	size_t sp = text.find_first_of(surrounder, startPos);
	if (sp == string::npos)
		return string();

	size_t ep;
	ep = text.find_first_of(surrounder, sp+1);
	if (ep == string::npos)
		return string();

	startPos = ep+1;
	return text.substr(sp+1, ep-sp-1);
}

string FindFirstArgumentKeyStartWithDash(const string& text, size_t& startPos)
{
	size_t sp = text.find_first_of('-', startPos);
	if (sp == string::npos)
		return string();

	size_t ep;
	ep = text.find_first_of('=', sp+1);
	if (ep == string::npos)
		return string();

	startPos = ep+1;
	return text.substr(sp+1, ep-sp-1);
}

void MakeArgumentKeyValueMap(const string& commandLine, map<string, string>* out)
{
	if (NULL == out)
		return;

	out->clear();
	size_t sp =0;
	string argKey, argValue;
	FindFirstStringSurroundedBy(commandLine, "\"", sp);
	while(true)
	{
		argKey = FindFirstArgumentKeyStartWithDash(commandLine, sp);
		argValue = FindFirstStringSurroundedBy(commandLine, "\"", sp);
		if (argKey.empty() || argValue.empty())
			break;
		out->insert(make_pair(argKey, argValue));
	}
}

bool ReadFileToString(const string& filePath, string* out)
{
	FILE* fp;
	fopen_s(&fp, filePath.c_str(), "rb");
	if (NULL == fp)
		return false;

	long fileSize = GetFileSize(fp);
	auto_ptr<char> buf(new char[fileSize]);
	fread_s(buf.get(), fileSize, fileSize, 1, fp);
	fclose(fp);

	out->assign(buf.get(), fileSize);
	return true;
}

string ConcatenatePathAndFile(const string& path, const string& file)
{
	string result(path);
	if (path.size()-1 != path.find_last_of("\\/"))
		result.append("/");
	result.append(file);
	return result;
}

long GetFileSize(FILE *fp)
{
	if (NULL == fp)
		return 0;

	struct stat stBuf;
	if(fstat(fp->_file, &stBuf) == -1)
		return 0;
	return stBuf.st_size;
}

}  // namespace Utils