/* soapC.cpp
   Generated by gSOAP 2.7.15 from jira.h
   Copyright(C) 2000-2009, Robert van Engelen, Genivia Inc. All Rights Reserved.
   This part of the software is released under one of the following licenses:
   GPL, the gSOAP public license, or Genivia's license for commercial use.
*/

#if defined(__BORLANDC__)
#pragma option push -w-8060
#pragma option push -w-8004
#endif

#include "stdafx.h"
#include "soapH.h"

SOAP_SOURCE_STAMP("@(#) soapC.cpp ver 2.7.15 2010-03-26 14:09:28 GMT")


#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_serializeheader(struct soap *soap)
{
	if (soap->header)
		soap_serialize_SOAP_ENV__Header(soap, soap->header);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putheader(struct soap *soap)
{
	if (soap->header)
	{	soap->part = SOAP_IN_HEADER;
		if (soap_out_SOAP_ENV__Header(soap, "SOAP-ENV:Header", 0, soap->header, NULL))
			return soap->error;
		soap->part = SOAP_END_HEADER;
	}
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getheader(struct soap *soap)
{
	soap->part = SOAP_IN_HEADER;
	soap->header = soap_in_SOAP_ENV__Header(soap, "SOAP-ENV:Header", NULL, NULL);
	soap->part = SOAP_END_HEADER;
	return soap->header == NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_header(struct soap *soap)
{
	if (!soap->header)
	{	soap->header = soap_new_SOAP_ENV__Header(soap, -1);
		soap_default_SOAP_ENV__Header(soap, soap->header);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_fault(struct soap *soap)
{
	if (!soap->fault)
	{	soap->fault = soap_new_SOAP_ENV__Fault(soap, -1);
		if (!soap->fault)
			return;
		soap_default_SOAP_ENV__Fault(soap, soap->fault);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Code)
	{	soap->fault->SOAP_ENV__Code = soap_new_SOAP_ENV__Code(soap, -1);
		soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code);
	}
	if (soap->version == 2 && !soap->fault->SOAP_ENV__Reason)
	{	soap->fault->SOAP_ENV__Reason = soap_new_SOAP_ENV__Reason(soap, -1);
		soap_default_SOAP_ENV__Reason(soap, soap->fault->SOAP_ENV__Reason);
	}
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serializefault(struct soap *soap)
{
	soap_fault(soap);
	if (soap->fault)
		soap_serialize_SOAP_ENV__Fault(soap, soap->fault);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_putfault(struct soap *soap)
{
	if (soap->fault)
		return soap_put_SOAP_ENV__Fault(soap, soap->fault, "SOAP-ENV:Fault", NULL);
	return SOAP_OK;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_getfault(struct soap *soap)
{
	return (soap->fault = soap_get_SOAP_ENV__Fault(soap, NULL, "SOAP-ENV:Fault", NULL)) == NULL;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Value;
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultsubcode(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
	{	if (!soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode)
		{	soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode = soap_new_SOAP_ENV__Code(soap, -1);
			soap_default_SOAP_ENV__Code(soap, soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode);
		}
		return (const char**)&soap->fault->SOAP_ENV__Code->SOAP_ENV__Subcode->SOAP_ENV__Value;
	}
	return (const char**)&soap->fault->faultcode;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultstring(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 2)
		return (const char**)&soap->fault->SOAP_ENV__Reason->SOAP_ENV__Text;
	return (const char**)&soap->fault->faultstring;
}

SOAP_FMAC3 const char ** SOAP_FMAC4 soap_faultdetail(struct soap *soap)
{
	soap_fault(soap);
	if (soap->version == 1)
	{	if (!soap->fault->detail)
		{	soap->fault->detail = (struct SOAP_ENV__Detail*)soap_malloc(soap, sizeof(struct SOAP_ENV__Detail));
			soap_default_SOAP_ENV__Detail(soap, soap->fault->detail);
		}
		return (const char**)&soap->fault->detail->__any;
	}
	if (!soap->fault->SOAP_ENV__Detail)
	{	soap->fault->SOAP_ENV__Detail = soap_new_SOAP_ENV__Detail(soap, -1);
		soap_default_SOAP_ENV__Detail(soap, soap->fault->SOAP_ENV__Detail);
	}
	return (const char**)&soap->fault->SOAP_ENV__Detail->__any;
}

#endif

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_getindependent(struct soap *soap)
{
	int t;
	for (;;)
		if (!soap_getelement(soap, &t))
			if (soap->error || soap_ignore_element(soap))
				break;
	if (soap->error == SOAP_NO_TAG || soap->error == SOAP_EOF)
		soap->error = SOAP_OK;
	return soap->error;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void * SOAP_FMAC4 soap_getelement(struct soap *soap, int *type)
{
	if (soap_peek_element(soap))
		return NULL;
	if (!*soap->id || !(*type = soap_lookup_type(soap, soap->id)))
		*type = soap_lookup_type(soap, soap->href);
	switch (*type)
	{
	case SOAP_TYPE_byte:
		return soap_in_byte(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_in_int(soap, NULL, NULL, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_in_LONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_time:
		return soap_in_time(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE_bool:
		return soap_in_bool(soap, NULL, NULL, "xsd:boolean");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteProject(soap, NULL, NULL, "ns2:RemoteProject");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteIssue(soap, NULL, NULL, "ns2:RemoteIssue");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission:
		return soap_in_ArrayOf_USCOREtns1_USCORERemotePermission(soap, NULL, NULL, "ns2:RemotePermission");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme:
		return soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, NULL, NULL, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteAvatar(soap, NULL, NULL, "ns2:RemoteAvatar");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, NULL, NULL, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteWorklog(soap, NULL, NULL, "ns2:RemoteWorklog");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteAttachment(soap, NULL, NULL, "ns2:RemoteAttachment");
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary:
		return soap_in_ArrayOf_USCORExsd_USCOREbase64Binary(soap, NULL, NULL, "xsd:byte[]");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, NULL, NULL, "ns2:RemoteFieldValue");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteFilter(soap, NULL, NULL, "ns2:RemoteFilter");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteComment(soap, NULL, NULL, "ns2:RemoteComment");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteField(soap, NULL, NULL, "ns2:RemoteField");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteScheme(soap, NULL, NULL, "ns2:RemoteScheme");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, NULL, NULL, "ns2:RemoteRoleActor");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, NULL, NULL, "ns2:RemoteProjectRole");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteStatus(soap, NULL, NULL, "ns2:RemoteStatus");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteResolution(soap, NULL, NULL, "ns2:RemoteResolution");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority:
		return soap_in_ArrayOf_USCOREtns1_USCORERemotePriority(soap, NULL, NULL, "ns2:RemotePriority");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping:
		return soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, NULL, NULL, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteEntity(soap, NULL, NULL, "ns2:RemoteEntity");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteIssueType(soap, NULL, NULL, "ns2:RemoteIssueType");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, NULL, NULL, "ns2:RemoteNamedObject");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, NULL, NULL, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring:
		return soap_in_ArrayOf_USCORExsd_USCOREstring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteVersion(soap, NULL, NULL, "ns2:RemoteVersion");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteComponent(soap, NULL, NULL, "ns2:RemoteComponent");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser:
		return soap_in_ArrayOf_USCOREtns1_USCORERemoteUser(soap, NULL, NULL, "ns2:RemoteUser");
	case SOAP_TYPE_ns3__RemotePermissionException:
		return soap_in_ns3__RemotePermissionException(soap, NULL, NULL, "ns3:RemotePermissionException");
	case SOAP_TYPE_ns3__RemoteValidationException:
		return soap_in_ns3__RemoteValidationException(soap, NULL, NULL, "ns3:RemoteValidationException");
	case SOAP_TYPE_ns3__RemoteAuthenticationException:
		return soap_in_ns3__RemoteAuthenticationException(soap, NULL, NULL, "ns3:RemoteAuthenticationException");
	case SOAP_TYPE_ns3__RemoteException:
		return soap_in_ns3__RemoteException(soap, NULL, NULL, "ns3:RemoteException");
	case SOAP_TYPE_ns2__RemoteAvatar:
		return soap_in_ns2__RemoteAvatar(soap, NULL, NULL, "ns2:RemoteAvatar");
	case SOAP_TYPE_ns2__RemoteWorklog:
		return soap_in_ns2__RemoteWorklog(soap, NULL, NULL, "ns2:RemoteWorklog");
	case SOAP_TYPE_ns2__RemoteAttachment:
		return soap_in_ns2__RemoteAttachment(soap, NULL, NULL, "ns2:RemoteAttachment");
	case SOAP_TYPE_ns2__RemoteSecurityLevel:
		return soap_in_ns2__RemoteSecurityLevel(soap, NULL, NULL, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_ns2__RemoteFieldValue:
		return soap_in_ns2__RemoteFieldValue(soap, NULL, NULL, "ns2:RemoteFieldValue");
	case SOAP_TYPE_ns2__RemoteFilter:
		return soap_in_ns2__RemoteFilter(soap, NULL, NULL, "ns2:RemoteFilter");
	case SOAP_TYPE_ns2__RemoteField:
		return soap_in_ns2__RemoteField(soap, NULL, NULL, "ns2:RemoteField");
	case SOAP_TYPE_ns2__RemoteProjectRoleActors:
		return soap_in_ns2__RemoteProjectRoleActors(soap, NULL, NULL, "ns2:RemoteProjectRoleActors");
	case SOAP_TYPE_ns2__RemoteRoleActors:
		return soap_in_ns2__RemoteRoleActors(soap, NULL, NULL, "ns2:RemoteRoleActors");
	case SOAP_TYPE_ns2__RemoteRoleActor:
		return soap_in_ns2__RemoteRoleActor(soap, NULL, NULL, "ns2:RemoteRoleActor");
	case SOAP_TYPE_ns2__RemoteProjectRole:
		return soap_in_ns2__RemoteProjectRole(soap, NULL, NULL, "ns2:RemoteProjectRole");
	case SOAP_TYPE_ns2__RemoteStatus:
		return soap_in_ns2__RemoteStatus(soap, NULL, NULL, "ns2:RemoteStatus");
	case SOAP_TYPE_ns2__RemoteResolution:
		return soap_in_ns2__RemoteResolution(soap, NULL, NULL, "ns2:RemoteResolution");
	case SOAP_TYPE_ns2__RemotePriority:
		return soap_in_ns2__RemotePriority(soap, NULL, NULL, "ns2:RemotePriority");
	case SOAP_TYPE_ns2__RemoteProject:
		return soap_in_ns2__RemoteProject(soap, NULL, NULL, "ns2:RemoteProject");
	case SOAP_TYPE_ns2__RemotePermissionScheme:
		return soap_in_ns2__RemotePermissionScheme(soap, NULL, NULL, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_ns2__RemotePermissionMapping:
		return soap_in_ns2__RemotePermissionMapping(soap, NULL, NULL, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_ns2__RemotePermission:
		return soap_in_ns2__RemotePermission(soap, NULL, NULL, "ns2:RemotePermission");
	case SOAP_TYPE_ns2__RemoteScheme:
		return soap_in_ns2__RemoteScheme(soap, NULL, NULL, "ns2:RemoteScheme");
	case SOAP_TYPE_ns2__RemoteConfiguration:
		return soap_in_ns2__RemoteConfiguration(soap, NULL, NULL, "ns2:RemoteConfiguration");
	case SOAP_TYPE_ns2__RemoteIssueType:
		return soap_in_ns2__RemoteIssueType(soap, NULL, NULL, "ns2:RemoteIssueType");
	case SOAP_TYPE_ns2__AbstractRemoteConstant:
		return soap_in_ns2__AbstractRemoteConstant(soap, NULL, NULL, "ns2:AbstractRemoteConstant");
	case SOAP_TYPE_ns2__RemoteNamedObject:
		return soap_in_ns2__RemoteNamedObject(soap, NULL, NULL, "ns2:RemoteNamedObject");
	case SOAP_TYPE_ns2__RemoteIssue:
		return soap_in_ns2__RemoteIssue(soap, NULL, NULL, "ns2:RemoteIssue");
	case SOAP_TYPE_ns2__RemoteCustomFieldValue:
		return soap_in_ns2__RemoteCustomFieldValue(soap, NULL, NULL, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_ns2__RemoteVersion:
		return soap_in_ns2__RemoteVersion(soap, NULL, NULL, "ns2:RemoteVersion");
	case SOAP_TYPE_ns2__RemoteComponent:
		return soap_in_ns2__RemoteComponent(soap, NULL, NULL, "ns2:RemoteComponent");
	case SOAP_TYPE_ns2__AbstractNamedRemoteEntity:
		return soap_in_ns2__AbstractNamedRemoteEntity(soap, NULL, NULL, "ns2:AbstractNamedRemoteEntity");
	case SOAP_TYPE_ns2__AbstractRemoteEntity:
		return soap_in_ns2__AbstractRemoteEntity(soap, NULL, NULL, "ns2:AbstractRemoteEntity");
	case SOAP_TYPE_ns2__RemoteGroup:
		return soap_in_ns2__RemoteGroup(soap, NULL, NULL, "ns2:RemoteGroup");
	case SOAP_TYPE_ns2__RemoteUser:
		return soap_in_ns2__RemoteUser(soap, NULL, NULL, "ns2:RemoteUser");
	case SOAP_TYPE_ns2__RemoteEntity:
		return soap_in_ns2__RemoteEntity(soap, NULL, NULL, "ns2:RemoteEntity");
	case SOAP_TYPE_ns2__RemoteServerInfo:
		return soap_in_ns2__RemoteServerInfo(soap, NULL, NULL, "ns2:RemoteServerInfo");
	case SOAP_TYPE_ns2__RemoteTimeInfo:
		return soap_in_ns2__RemoteTimeInfo(soap, NULL, NULL, "ns2:RemoteTimeInfo");
	case SOAP_TYPE_ns2__RemoteComment:
		return soap_in_ns2__RemoteComment(soap, NULL, NULL, "ns2:RemoteComment");
	case SOAP_TYPE_ns4__setNewProjectAvatar:
		return soap_in_ns4__setNewProjectAvatar(soap, NULL, NULL, "ns4:setNewProjectAvatar");
	case SOAP_TYPE_ns4__setNewProjectAvatarResponse:
		return soap_in_ns4__setNewProjectAvatarResponse(soap, NULL, NULL, "ns4:setNewProjectAvatarResponse");
	case SOAP_TYPE_ns4__getProjectsNoSchemes:
		return soap_in_ns4__getProjectsNoSchemes(soap, NULL, NULL, "ns4:getProjectsNoSchemes");
	case SOAP_TYPE_ns4__getProjectsNoSchemesResponse:
		return soap_in_ns4__getProjectsNoSchemesResponse(soap, NULL, NULL, "ns4:getProjectsNoSchemesResponse");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit:
		return soap_in_ns4__getIssuesFromTextSearchWithLimit(soap, NULL, NULL, "ns4:getIssuesFromTextSearchWithLimit");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse:
		return soap_in_ns4__getIssuesFromTextSearchWithLimitResponse(soap, NULL, NULL, "ns4:getIssuesFromTextSearchWithLimitResponse");
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimit:
		return soap_in_ns4__getIssuesFromFilterWithLimit(soap, NULL, NULL, "ns4:getIssuesFromFilterWithLimit");
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse:
		return soap_in_ns4__getIssuesFromFilterWithLimitResponse(soap, NULL, NULL, "ns4:getIssuesFromFilterWithLimitResponse");
	case SOAP_TYPE_ns4__getIssuesFromFilter:
		return soap_in_ns4__getIssuesFromFilter(soap, NULL, NULL, "ns4:getIssuesFromFilter");
	case SOAP_TYPE_ns4__getIssuesFromFilterResponse:
		return soap_in_ns4__getIssuesFromFilterResponse(soap, NULL, NULL, "ns4:getIssuesFromFilterResponse");
	case SOAP_TYPE_ns4__addVersion:
		return soap_in_ns4__addVersion(soap, NULL, NULL, "ns4:addVersion");
	case SOAP_TYPE_ns4__addVersionResponse:
		return soap_in_ns4__addVersionResponse(soap, NULL, NULL, "ns4:addVersionResponse");
	case SOAP_TYPE_ns4__getSecuritySchemes:
		return soap_in_ns4__getSecuritySchemes(soap, NULL, NULL, "ns4:getSecuritySchemes");
	case SOAP_TYPE_ns4__getSecuritySchemesResponse:
		return soap_in_ns4__getSecuritySchemesResponse(soap, NULL, NULL, "ns4:getSecuritySchemesResponse");
	case SOAP_TYPE_ns4__createProjectFromObject:
		return soap_in_ns4__createProjectFromObject(soap, NULL, NULL, "ns4:createProjectFromObject");
	case SOAP_TYPE_ns4__createProjectFromObjectResponse:
		return soap_in_ns4__createProjectFromObjectResponse(soap, NULL, NULL, "ns4:createProjectFromObjectResponse");
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue:
		return soap_in_ns4__addBase64EncodedAttachmentsToIssue(soap, NULL, NULL, "ns4:addBase64EncodedAttachmentsToIssue");
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse:
		return soap_in_ns4__addBase64EncodedAttachmentsToIssueResponse(soap, NULL, NULL, "ns4:addBase64EncodedAttachmentsToIssueResponse");
	case SOAP_TYPE_ns4__getSavedFilters:
		return soap_in_ns4__getSavedFilters(soap, NULL, NULL, "ns4:getSavedFilters");
	case SOAP_TYPE_ns4__getSavedFiltersResponse:
		return soap_in_ns4__getSavedFiltersResponse(soap, NULL, NULL, "ns4:getSavedFiltersResponse");
	case SOAP_TYPE_ns4__refreshCustomFields:
		return soap_in_ns4__refreshCustomFields(soap, NULL, NULL, "ns4:refreshCustomFields");
	case SOAP_TYPE_ns4__refreshCustomFieldsResponse:
		return soap_in_ns4__refreshCustomFieldsResponse(soap, NULL, NULL, "ns4:refreshCustomFieldsResponse");
	case SOAP_TYPE_ns4__deleteGroup:
		return soap_in_ns4__deleteGroup(soap, NULL, NULL, "ns4:deleteGroup");
	case SOAP_TYPE_ns4__deleteGroupResponse:
		return soap_in_ns4__deleteGroupResponse(soap, NULL, NULL, "ns4:deleteGroupResponse");
	case SOAP_TYPE_ns4__updateGroup:
		return soap_in_ns4__updateGroup(soap, NULL, NULL, "ns4:updateGroup");
	case SOAP_TYPE_ns4__updateGroupResponse:
		return soap_in_ns4__updateGroupResponse(soap, NULL, NULL, "ns4:updateGroupResponse");
	case SOAP_TYPE_ns4__deleteUser:
		return soap_in_ns4__deleteUser(soap, NULL, NULL, "ns4:deleteUser");
	case SOAP_TYPE_ns4__deleteUserResponse:
		return soap_in_ns4__deleteUserResponse(soap, NULL, NULL, "ns4:deleteUserResponse");
	case SOAP_TYPE_ns4__getIssuesFromJqlSearch:
		return soap_in_ns4__getIssuesFromJqlSearch(soap, NULL, NULL, "ns4:getIssuesFromJqlSearch");
	case SOAP_TYPE_ns4__getIssuesFromJqlSearchResponse:
		return soap_in_ns4__getIssuesFromJqlSearchResponse(soap, NULL, NULL, "ns4:getIssuesFromJqlSearchResponse");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProject:
		return soap_in_ns4__getIssuesFromTextSearchWithProject(soap, NULL, NULL, "ns4:getIssuesFromTextSearchWithProject");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProjectResponse:
		return soap_in_ns4__getIssuesFromTextSearchWithProjectResponse(soap, NULL, NULL, "ns4:getIssuesFromTextSearchWithProjectResponse");
	case SOAP_TYPE_ns4__getIssuesFromTextSearch:
		return soap_in_ns4__getIssuesFromTextSearch(soap, NULL, NULL, "ns4:getIssuesFromTextSearch");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchResponse:
		return soap_in_ns4__getIssuesFromTextSearchResponse(soap, NULL, NULL, "ns4:getIssuesFromTextSearchResponse");
	case SOAP_TYPE_ns4__getIssueCountForFilter:
		return soap_in_ns4__getIssueCountForFilter(soap, NULL, NULL, "ns4:getIssueCountForFilter");
	case SOAP_TYPE_ns4__getIssueCountForFilterResponse:
		return soap_in_ns4__getIssueCountForFilterResponse(soap, NULL, NULL, "ns4:getIssueCountForFilterResponse");
	case SOAP_TYPE_ns4__deletePermissionScheme:
		return soap_in_ns4__deletePermissionScheme(soap, NULL, NULL, "ns4:deletePermissionScheme");
	case SOAP_TYPE_ns4__deletePermissionSchemeResponse:
		return soap_in_ns4__deletePermissionSchemeResponse(soap, NULL, NULL, "ns4:deletePermissionSchemeResponse");
	case SOAP_TYPE_ns4__deletePermissionFrom:
		return soap_in_ns4__deletePermissionFrom(soap, NULL, NULL, "ns4:deletePermissionFrom");
	case SOAP_TYPE_ns4__deletePermissionFromResponse:
		return soap_in_ns4__deletePermissionFromResponse(soap, NULL, NULL, "ns4:deletePermissionFromResponse");
	case SOAP_TYPE_ns4__addPermissionTo:
		return soap_in_ns4__addPermissionTo(soap, NULL, NULL, "ns4:addPermissionTo");
	case SOAP_TYPE_ns4__addPermissionToResponse:
		return soap_in_ns4__addPermissionToResponse(soap, NULL, NULL, "ns4:addPermissionToResponse");
	case SOAP_TYPE_ns4__createPermissionScheme:
		return soap_in_ns4__createPermissionScheme(soap, NULL, NULL, "ns4:createPermissionScheme");
	case SOAP_TYPE_ns4__createPermissionSchemeResponse:
		return soap_in_ns4__createPermissionSchemeResponse(soap, NULL, NULL, "ns4:createPermissionSchemeResponse");
	case SOAP_TYPE_ns4__getAllPermissions:
		return soap_in_ns4__getAllPermissions(soap, NULL, NULL, "ns4:getAllPermissions");
	case SOAP_TYPE_ns4__getAllPermissionsResponse:
		return soap_in_ns4__getAllPermissionsResponse(soap, NULL, NULL, "ns4:getAllPermissionsResponse");
	case SOAP_TYPE_ns4__getPermissionSchemes:
		return soap_in_ns4__getPermissionSchemes(soap, NULL, NULL, "ns4:getPermissionSchemes");
	case SOAP_TYPE_ns4__getPermissionSchemesResponse:
		return soap_in_ns4__getPermissionSchemesResponse(soap, NULL, NULL, "ns4:getPermissionSchemesResponse");
	case SOAP_TYPE_ns4__getNotificationSchemes:
		return soap_in_ns4__getNotificationSchemes(soap, NULL, NULL, "ns4:getNotificationSchemes");
	case SOAP_TYPE_ns4__getNotificationSchemesResponse:
		return soap_in_ns4__getNotificationSchemesResponse(soap, NULL, NULL, "ns4:getNotificationSchemesResponse");
	case SOAP_TYPE_ns4__deleteProjectAvatar:
		return soap_in_ns4__deleteProjectAvatar(soap, NULL, NULL, "ns4:deleteProjectAvatar");
	case SOAP_TYPE_ns4__deleteProjectAvatarResponse:
		return soap_in_ns4__deleteProjectAvatarResponse(soap, NULL, NULL, "ns4:deleteProjectAvatarResponse");
	case SOAP_TYPE_ns4__getProjectAvatar:
		return soap_in_ns4__getProjectAvatar(soap, NULL, NULL, "ns4:getProjectAvatar");
	case SOAP_TYPE_ns4__getProjectAvatarResponse:
		return soap_in_ns4__getProjectAvatarResponse(soap, NULL, NULL, "ns4:getProjectAvatarResponse");
	case SOAP_TYPE_ns4__setProjectAvatar:
		return soap_in_ns4__setProjectAvatar(soap, NULL, NULL, "ns4:setProjectAvatar");
	case SOAP_TYPE_ns4__setProjectAvatarResponse:
		return soap_in_ns4__setProjectAvatarResponse(soap, NULL, NULL, "ns4:setProjectAvatarResponse");
	case SOAP_TYPE_ns4__getProjectAvatars:
		return soap_in_ns4__getProjectAvatars(soap, NULL, NULL, "ns4:getProjectAvatars");
	case SOAP_TYPE_ns4__getProjectAvatarsResponse:
		return soap_in_ns4__getProjectAvatarsResponse(soap, NULL, NULL, "ns4:getProjectAvatarsResponse");
	case SOAP_TYPE_ns4__getSecurityLevels:
		return soap_in_ns4__getSecurityLevels(soap, NULL, NULL, "ns4:getSecurityLevels");
	case SOAP_TYPE_ns4__getSecurityLevelsResponse:
		return soap_in_ns4__getSecurityLevelsResponse(soap, NULL, NULL, "ns4:getSecurityLevelsResponse");
	case SOAP_TYPE_ns4__getProjectWithSchemesById:
		return soap_in_ns4__getProjectWithSchemesById(soap, NULL, NULL, "ns4:getProjectWithSchemesById");
	case SOAP_TYPE_ns4__getProjectWithSchemesByIdResponse:
		return soap_in_ns4__getProjectWithSchemesByIdResponse(soap, NULL, NULL, "ns4:getProjectWithSchemesByIdResponse");
	case SOAP_TYPE_ns4__logout:
		return soap_in_ns4__logout(soap, NULL, NULL, "ns4:logout");
	case SOAP_TYPE_ns4__logoutResponse:
		return soap_in_ns4__logoutResponse(soap, NULL, NULL, "ns4:logoutResponse");
	case SOAP_TYPE_ns4__getResolutionDateById:
		return soap_in_ns4__getResolutionDateById(soap, NULL, NULL, "ns4:getResolutionDateById");
	case SOAP_TYPE_ns4__getResolutionDateByIdResponse:
		return soap_in_ns4__getResolutionDateByIdResponse(soap, NULL, NULL, "ns4:getResolutionDateByIdResponse");
	case SOAP_TYPE_ns4__getResolutionDateByKey:
		return soap_in_ns4__getResolutionDateByKey(soap, NULL, NULL, "ns4:getResolutionDateByKey");
	case SOAP_TYPE_ns4__getResolutionDateByKeyResponse:
		return soap_in_ns4__getResolutionDateByKeyResponse(soap, NULL, NULL, "ns4:getResolutionDateByKeyResponse");
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklog:
		return soap_in_ns4__hasPermissionToUpdateWorklog(soap, NULL, NULL, "ns4:hasPermissionToUpdateWorklog");
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklogResponse:
		return soap_in_ns4__hasPermissionToUpdateWorklogResponse(soap, NULL, NULL, "ns4:hasPermissionToUpdateWorklogResponse");
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklog:
		return soap_in_ns4__hasPermissionToDeleteWorklog(soap, NULL, NULL, "ns4:hasPermissionToDeleteWorklog");
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklogResponse:
		return soap_in_ns4__hasPermissionToDeleteWorklogResponse(soap, NULL, NULL, "ns4:hasPermissionToDeleteWorklogResponse");
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklog:
		return soap_in_ns4__hasPermissionToCreateWorklog(soap, NULL, NULL, "ns4:hasPermissionToCreateWorklog");
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklogResponse:
		return soap_in_ns4__hasPermissionToCreateWorklogResponse(soap, NULL, NULL, "ns4:hasPermissionToCreateWorklogResponse");
	case SOAP_TYPE_ns4__getWorklogs:
		return soap_in_ns4__getWorklogs(soap, NULL, NULL, "ns4:getWorklogs");
	case SOAP_TYPE_ns4__getWorklogsResponse:
		return soap_in_ns4__getWorklogsResponse(soap, NULL, NULL, "ns4:getWorklogsResponse");
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimate:
		return soap_in_ns4__updateWorklogAndRetainRemainingEstimate(soap, NULL, NULL, "ns4:updateWorklogAndRetainRemainingEstimate");
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimateResponse:
		return soap_in_ns4__updateWorklogAndRetainRemainingEstimateResponse(soap, NULL, NULL, "ns4:updateWorklogAndRetainRemainingEstimateResponse");
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimate:
		return soap_in_ns4__updateWorklogAndAutoAdjustRemainingEstimate(soap, NULL, NULL, "ns4:updateWorklogAndAutoAdjustRemainingEstimate");
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse:
		return soap_in_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse(soap, NULL, NULL, "ns4:updateWorklogAndAutoAdjustRemainingEstimateResponse");
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimate:
		return soap_in_ns4__updateWorklogWithNewRemainingEstimate(soap, NULL, NULL, "ns4:updateWorklogWithNewRemainingEstimate");
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimateResponse:
		return soap_in_ns4__updateWorklogWithNewRemainingEstimateResponse(soap, NULL, NULL, "ns4:updateWorklogWithNewRemainingEstimateResponse");
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimate:
		return soap_in_ns4__deleteWorklogAndRetainRemainingEstimate(soap, NULL, NULL, "ns4:deleteWorklogAndRetainRemainingEstimate");
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimateResponse:
		return soap_in_ns4__deleteWorklogAndRetainRemainingEstimateResponse(soap, NULL, NULL, "ns4:deleteWorklogAndRetainRemainingEstimateResponse");
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimate:
		return soap_in_ns4__deleteWorklogAndAutoAdjustRemainingEstimate(soap, NULL, NULL, "ns4:deleteWorklogAndAutoAdjustRemainingEstimate");
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse:
		return soap_in_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse(soap, NULL, NULL, "ns4:deleteWorklogAndAutoAdjustRemainingEstimateResponse");
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimate:
		return soap_in_ns4__deleteWorklogWithNewRemainingEstimate(soap, NULL, NULL, "ns4:deleteWorklogWithNewRemainingEstimate");
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimateResponse:
		return soap_in_ns4__deleteWorklogWithNewRemainingEstimateResponse(soap, NULL, NULL, "ns4:deleteWorklogWithNewRemainingEstimateResponse");
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimate:
		return soap_in_ns4__addWorklogAndRetainRemainingEstimate(soap, NULL, NULL, "ns4:addWorklogAndRetainRemainingEstimate");
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimateResponse:
		return soap_in_ns4__addWorklogAndRetainRemainingEstimateResponse(soap, NULL, NULL, "ns4:addWorklogAndRetainRemainingEstimateResponse");
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimate:
		return soap_in_ns4__addWorklogAndAutoAdjustRemainingEstimate(soap, NULL, NULL, "ns4:addWorklogAndAutoAdjustRemainingEstimate");
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse:
		return soap_in_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse(soap, NULL, NULL, "ns4:addWorklogAndAutoAdjustRemainingEstimateResponse");
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimate:
		return soap_in_ns4__addWorklogWithNewRemainingEstimate(soap, NULL, NULL, "ns4:addWorklogWithNewRemainingEstimate");
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimateResponse:
		return soap_in_ns4__addWorklogWithNewRemainingEstimateResponse(soap, NULL, NULL, "ns4:addWorklogWithNewRemainingEstimateResponse");
	case SOAP_TYPE_ns4__getIssueById:
		return soap_in_ns4__getIssueById(soap, NULL, NULL, "ns4:getIssueById");
	case SOAP_TYPE_ns4__getIssueByIdResponse:
		return soap_in_ns4__getIssueByIdResponse(soap, NULL, NULL, "ns4:getIssueByIdResponse");
	case SOAP_TYPE_ns4__progressWorkflowAction:
		return soap_in_ns4__progressWorkflowAction(soap, NULL, NULL, "ns4:progressWorkflowAction");
	case SOAP_TYPE_ns4__progressWorkflowActionResponse:
		return soap_in_ns4__progressWorkflowActionResponse(soap, NULL, NULL, "ns4:progressWorkflowActionResponse");
	case SOAP_TYPE_ns4__getFieldsForAction:
		return soap_in_ns4__getFieldsForAction(soap, NULL, NULL, "ns4:getFieldsForAction");
	case SOAP_TYPE_ns4__getFieldsForActionResponse:
		return soap_in_ns4__getFieldsForActionResponse(soap, NULL, NULL, "ns4:getFieldsForActionResponse");
	case SOAP_TYPE_ns4__editComment:
		return soap_in_ns4__editComment(soap, NULL, NULL, "ns4:editComment");
	case SOAP_TYPE_ns4__editCommentResponse:
		return soap_in_ns4__editCommentResponse(soap, NULL, NULL, "ns4:editCommentResponse");
	case SOAP_TYPE_ns4__hasPermissionToEditComment:
		return soap_in_ns4__hasPermissionToEditComment(soap, NULL, NULL, "ns4:hasPermissionToEditComment");
	case SOAP_TYPE_ns4__hasPermissionToEditCommentResponse:
		return soap_in_ns4__hasPermissionToEditCommentResponse(soap, NULL, NULL, "ns4:hasPermissionToEditCommentResponse");
	case SOAP_TYPE_ns4__deleteIssue:
		return soap_in_ns4__deleteIssue(soap, NULL, NULL, "ns4:deleteIssue");
	case SOAP_TYPE_ns4__deleteIssueResponse:
		return soap_in_ns4__deleteIssueResponse(soap, NULL, NULL, "ns4:deleteIssueResponse");
	case SOAP_TYPE_ns4__getAttachmentsFromIssue:
		return soap_in_ns4__getAttachmentsFromIssue(soap, NULL, NULL, "ns4:getAttachmentsFromIssue");
	case SOAP_TYPE_ns4__getAttachmentsFromIssueResponse:
		return soap_in_ns4__getAttachmentsFromIssueResponse(soap, NULL, NULL, "ns4:getAttachmentsFromIssueResponse");
	case SOAP_TYPE_ns4__addAttachmentsToIssue:
		return soap_in_ns4__addAttachmentsToIssue(soap, NULL, NULL, "ns4:addAttachmentsToIssue");
	case SOAP_TYPE_ns4__addAttachmentsToIssueResponse:
		return soap_in_ns4__addAttachmentsToIssueResponse(soap, NULL, NULL, "ns4:addAttachmentsToIssueResponse");
	case SOAP_TYPE_ns4__createIssueWithSecurityLevel:
		return soap_in_ns4__createIssueWithSecurityLevel(soap, NULL, NULL, "ns4:createIssueWithSecurityLevel");
	case SOAP_TYPE_ns4__createIssueWithSecurityLevelResponse:
		return soap_in_ns4__createIssueWithSecurityLevelResponse(soap, NULL, NULL, "ns4:createIssueWithSecurityLevelResponse");
	case SOAP_TYPE_ns4__addComment:
		return soap_in_ns4__addComment(soap, NULL, NULL, "ns4:addComment");
	case SOAP_TYPE_ns4__addCommentResponse:
		return soap_in_ns4__addCommentResponse(soap, NULL, NULL, "ns4:addCommentResponse");
	case SOAP_TYPE_ns4__getSecurityLevel:
		return soap_in_ns4__getSecurityLevel(soap, NULL, NULL, "ns4:getSecurityLevel");
	case SOAP_TYPE_ns4__getSecurityLevelResponse:
		return soap_in_ns4__getSecurityLevelResponse(soap, NULL, NULL, "ns4:getSecurityLevelResponse");
	case SOAP_TYPE_ns4__removeUserFromGroup:
		return soap_in_ns4__removeUserFromGroup(soap, NULL, NULL, "ns4:removeUserFromGroup");
	case SOAP_TYPE_ns4__removeUserFromGroupResponse:
		return soap_in_ns4__removeUserFromGroupResponse(soap, NULL, NULL, "ns4:removeUserFromGroupResponse");
	case SOAP_TYPE_ns4__addUserToGroup:
		return soap_in_ns4__addUserToGroup(soap, NULL, NULL, "ns4:addUserToGroup");
	case SOAP_TYPE_ns4__addUserToGroupResponse:
		return soap_in_ns4__addUserToGroupResponse(soap, NULL, NULL, "ns4:addUserToGroupResponse");
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProject:
		return soap_in_ns4__getSubTaskIssueTypesForProject(soap, NULL, NULL, "ns4:getSubTaskIssueTypesForProject");
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProjectResponse:
		return soap_in_ns4__getSubTaskIssueTypesForProjectResponse(soap, NULL, NULL, "ns4:getSubTaskIssueTypesForProjectResponse");
	case SOAP_TYPE_ns4__getIssueTypesForProject:
		return soap_in_ns4__getIssueTypesForProject(soap, NULL, NULL, "ns4:getIssueTypesForProject");
	case SOAP_TYPE_ns4__getIssueTypesForProjectResponse:
		return soap_in_ns4__getIssueTypesForProjectResponse(soap, NULL, NULL, "ns4:getIssueTypesForProjectResponse");
	case SOAP_TYPE_ns4__getFieldsForEdit:
		return soap_in_ns4__getFieldsForEdit(soap, NULL, NULL, "ns4:getFieldsForEdit");
	case SOAP_TYPE_ns4__getFieldsForEditResponse:
		return soap_in_ns4__getFieldsForEditResponse(soap, NULL, NULL, "ns4:getFieldsForEditResponse");
	case SOAP_TYPE_ns4__updateIssue:
		return soap_in_ns4__updateIssue(soap, NULL, NULL, "ns4:updateIssue");
	case SOAP_TYPE_ns4__updateIssueResponse:
		return soap_in_ns4__updateIssueResponse(soap, NULL, NULL, "ns4:updateIssueResponse");
	case SOAP_TYPE_ns4__archiveVersion:
		return soap_in_ns4__archiveVersion(soap, NULL, NULL, "ns4:archiveVersion");
	case SOAP_TYPE_ns4__archiveVersionResponse:
		return soap_in_ns4__archiveVersionResponse(soap, NULL, NULL, "ns4:archiveVersionResponse");
	case SOAP_TYPE_ns4__releaseVersion:
		return soap_in_ns4__releaseVersion(soap, NULL, NULL, "ns4:releaseVersion");
	case SOAP_TYPE_ns4__releaseVersionResponse:
		return soap_in_ns4__releaseVersionResponse(soap, NULL, NULL, "ns4:releaseVersionResponse");
	case SOAP_TYPE_ns4__getFavouriteFilters:
		return soap_in_ns4__getFavouriteFilters(soap, NULL, NULL, "ns4:getFavouriteFilters");
	case SOAP_TYPE_ns4__getFavouriteFiltersResponse:
		return soap_in_ns4__getFavouriteFiltersResponse(soap, NULL, NULL, "ns4:getFavouriteFiltersResponse");
	case SOAP_TYPE_ns4__getComments:
		return soap_in_ns4__getComments(soap, NULL, NULL, "ns4:getComments");
	case SOAP_TYPE_ns4__getCommentsResponse:
		return soap_in_ns4__getCommentsResponse(soap, NULL, NULL, "ns4:getCommentsResponse");
	case SOAP_TYPE_ns4__getCustomFields:
		return soap_in_ns4__getCustomFields(soap, NULL, NULL, "ns4:getCustomFields");
	case SOAP_TYPE_ns4__getCustomFieldsResponse:
		return soap_in_ns4__getCustomFieldsResponse(soap, NULL, NULL, "ns4:getCustomFieldsResponse");
	case SOAP_TYPE_ns4__getVersions:
		return soap_in_ns4__getVersions(soap, NULL, NULL, "ns4:getVersions");
	case SOAP_TYPE_ns4__getVersionsResponse:
		return soap_in_ns4__getVersionsResponse(soap, NULL, NULL, "ns4:getVersionsResponse");
	case SOAP_TYPE_ns4__getProjectById:
		return soap_in_ns4__getProjectById(soap, NULL, NULL, "ns4:getProjectById");
	case SOAP_TYPE_ns4__getProjectByIdResponse:
		return soap_in_ns4__getProjectByIdResponse(soap, NULL, NULL, "ns4:getProjectByIdResponse");
	case SOAP_TYPE_ns4__deleteProject:
		return soap_in_ns4__deleteProject(soap, NULL, NULL, "ns4:deleteProject");
	case SOAP_TYPE_ns4__deleteProjectResponse:
		return soap_in_ns4__deleteProjectResponse(soap, NULL, NULL, "ns4:deleteProjectResponse");
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemes:
		return soap_in_ns4__getAssociatedPermissionSchemes(soap, NULL, NULL, "ns4:getAssociatedPermissionSchemes");
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemesResponse:
		return soap_in_ns4__getAssociatedPermissionSchemesResponse(soap, NULL, NULL, "ns4:getAssociatedPermissionSchemesResponse");
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemes:
		return soap_in_ns4__getAssociatedNotificationSchemes(soap, NULL, NULL, "ns4:getAssociatedNotificationSchemes");
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemesResponse:
		return soap_in_ns4__getAssociatedNotificationSchemesResponse(soap, NULL, NULL, "ns4:getAssociatedNotificationSchemesResponse");
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRole:
		return soap_in_ns4__removeDefaultActorsFromProjectRole(soap, NULL, NULL, "ns4:removeDefaultActorsFromProjectRole");
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRoleResponse:
		return soap_in_ns4__removeDefaultActorsFromProjectRoleResponse(soap, NULL, NULL, "ns4:removeDefaultActorsFromProjectRoleResponse");
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRole:
		return soap_in_ns4__addDefaultActorsToProjectRole(soap, NULL, NULL, "ns4:addDefaultActorsToProjectRole");
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRoleResponse:
		return soap_in_ns4__addDefaultActorsToProjectRoleResponse(soap, NULL, NULL, "ns4:addDefaultActorsToProjectRoleResponse");
	case SOAP_TYPE_ns4__removeActorsFromProjectRole:
		return soap_in_ns4__removeActorsFromProjectRole(soap, NULL, NULL, "ns4:removeActorsFromProjectRole");
	case SOAP_TYPE_ns4__removeActorsFromProjectRoleResponse:
		return soap_in_ns4__removeActorsFromProjectRoleResponse(soap, NULL, NULL, "ns4:removeActorsFromProjectRoleResponse");
	case SOAP_TYPE_ns4__addActorsToProjectRole:
		return soap_in_ns4__addActorsToProjectRole(soap, NULL, NULL, "ns4:addActorsToProjectRole");
	case SOAP_TYPE_ns4__addActorsToProjectRoleResponse:
		return soap_in_ns4__addActorsToProjectRoleResponse(soap, NULL, NULL, "ns4:addActorsToProjectRoleResponse");
	case SOAP_TYPE_ns4__isProjectRoleNameUnique:
		return soap_in_ns4__isProjectRoleNameUnique(soap, NULL, NULL, "ns4:isProjectRoleNameUnique");
	case SOAP_TYPE_ns4__isProjectRoleNameUniqueResponse:
		return soap_in_ns4__isProjectRoleNameUniqueResponse(soap, NULL, NULL, "ns4:isProjectRoleNameUniqueResponse");
	case SOAP_TYPE_ns4__createProjectRole:
		return soap_in_ns4__createProjectRole(soap, NULL, NULL, "ns4:createProjectRole");
	case SOAP_TYPE_ns4__createProjectRoleResponse:
		return soap_in_ns4__createProjectRoleResponse(soap, NULL, NULL, "ns4:createProjectRoleResponse");
	case SOAP_TYPE_ns4__updateProjectRole:
		return soap_in_ns4__updateProjectRole(soap, NULL, NULL, "ns4:updateProjectRole");
	case SOAP_TYPE_ns4__updateProjectRoleResponse:
		return soap_in_ns4__updateProjectRoleResponse(soap, NULL, NULL, "ns4:updateProjectRoleResponse");
	case SOAP_TYPE_ns4__deleteProjectRole:
		return soap_in_ns4__deleteProjectRole(soap, NULL, NULL, "ns4:deleteProjectRole");
	case SOAP_TYPE_ns4__deleteProjectRoleResponse:
		return soap_in_ns4__deleteProjectRoleResponse(soap, NULL, NULL, "ns4:deleteProjectRoleResponse");
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndType:
		return soap_in_ns4__removeAllRoleActorsByNameAndType(soap, NULL, NULL, "ns4:removeAllRoleActorsByNameAndType");
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndTypeResponse:
		return soap_in_ns4__removeAllRoleActorsByNameAndTypeResponse(soap, NULL, NULL, "ns4:removeAllRoleActorsByNameAndTypeResponse");
	case SOAP_TYPE_ns4__getDefaultRoleActors:
		return soap_in_ns4__getDefaultRoleActors(soap, NULL, NULL, "ns4:getDefaultRoleActors");
	case SOAP_TYPE_ns4__getDefaultRoleActorsResponse:
		return soap_in_ns4__getDefaultRoleActorsResponse(soap, NULL, NULL, "ns4:getDefaultRoleActorsResponse");
	case SOAP_TYPE_ns4__getProjectRoleActors:
		return soap_in_ns4__getProjectRoleActors(soap, NULL, NULL, "ns4:getProjectRoleActors");
	case SOAP_TYPE_ns4__getProjectRoleActorsResponse:
		return soap_in_ns4__getProjectRoleActorsResponse(soap, NULL, NULL, "ns4:getProjectRoleActorsResponse");
	case SOAP_TYPE_ns4__getProjectRole:
		return soap_in_ns4__getProjectRole(soap, NULL, NULL, "ns4:getProjectRole");
	case SOAP_TYPE_ns4__getProjectRoleResponse:
		return soap_in_ns4__getProjectRoleResponse(soap, NULL, NULL, "ns4:getProjectRoleResponse");
	case SOAP_TYPE_ns4__getProjectRoles:
		return soap_in_ns4__getProjectRoles(soap, NULL, NULL, "ns4:getProjectRoles");
	case SOAP_TYPE_ns4__getProjectRolesResponse:
		return soap_in_ns4__getProjectRolesResponse(soap, NULL, NULL, "ns4:getProjectRolesResponse");
	case SOAP_TYPE_ns4__getStatuses:
		return soap_in_ns4__getStatuses(soap, NULL, NULL, "ns4:getStatuses");
	case SOAP_TYPE_ns4__getStatusesResponse:
		return soap_in_ns4__getStatusesResponse(soap, NULL, NULL, "ns4:getStatusesResponse");
	case SOAP_TYPE_ns4__getIssueTypes:
		return soap_in_ns4__getIssueTypes(soap, NULL, NULL, "ns4:getIssueTypes");
	case SOAP_TYPE_ns4__getIssueTypesResponse:
		return soap_in_ns4__getIssueTypesResponse(soap, NULL, NULL, "ns4:getIssueTypesResponse");
	case SOAP_TYPE_ns4__getResolutions:
		return soap_in_ns4__getResolutions(soap, NULL, NULL, "ns4:getResolutions");
	case SOAP_TYPE_ns4__getResolutionsResponse:
		return soap_in_ns4__getResolutionsResponse(soap, NULL, NULL, "ns4:getResolutionsResponse");
	case SOAP_TYPE_ns4__getPriorities:
		return soap_in_ns4__getPriorities(soap, NULL, NULL, "ns4:getPriorities");
	case SOAP_TYPE_ns4__getPrioritiesResponse:
		return soap_in_ns4__getPrioritiesResponse(soap, NULL, NULL, "ns4:getPrioritiesResponse");
	case SOAP_TYPE_ns4__removeAllRoleActorsByProject:
		return soap_in_ns4__removeAllRoleActorsByProject(soap, NULL, NULL, "ns4:removeAllRoleActorsByProject");
	case SOAP_TYPE_ns4__removeAllRoleActorsByProjectResponse:
		return soap_in_ns4__removeAllRoleActorsByProjectResponse(soap, NULL, NULL, "ns4:removeAllRoleActorsByProjectResponse");
	case SOAP_TYPE_ns4__getProjectByKey:
		return soap_in_ns4__getProjectByKey(soap, NULL, NULL, "ns4:getProjectByKey");
	case SOAP_TYPE_ns4__getProjectByKeyResponse:
		return soap_in_ns4__getProjectByKeyResponse(soap, NULL, NULL, "ns4:getProjectByKeyResponse");
	case SOAP_TYPE_ns4__updateProject:
		return soap_in_ns4__updateProject(soap, NULL, NULL, "ns4:updateProject");
	case SOAP_TYPE_ns4__updateProjectResponse:
		return soap_in_ns4__updateProjectResponse(soap, NULL, NULL, "ns4:updateProjectResponse");
	case SOAP_TYPE_ns4__createProject:
		return soap_in_ns4__createProject(soap, NULL, NULL, "ns4:createProject");
	case SOAP_TYPE_ns4__createProjectResponse:
		return soap_in_ns4__createProjectResponse(soap, NULL, NULL, "ns4:createProjectResponse");
	case SOAP_TYPE_ns4__getConfiguration:
		return soap_in_ns4__getConfiguration(soap, NULL, NULL, "ns4:getConfiguration");
	case SOAP_TYPE_ns4__getConfigurationResponse:
		return soap_in_ns4__getConfigurationResponse(soap, NULL, NULL, "ns4:getConfigurationResponse");
	case SOAP_TYPE_ns4__getSubTaskIssueTypes:
		return soap_in_ns4__getSubTaskIssueTypes(soap, NULL, NULL, "ns4:getSubTaskIssueTypes");
	case SOAP_TYPE_ns4__getSubTaskIssueTypesResponse:
		return soap_in_ns4__getSubTaskIssueTypesResponse(soap, NULL, NULL, "ns4:getSubTaskIssueTypesResponse");
	case SOAP_TYPE_ns4__getAvailableActions:
		return soap_in_ns4__getAvailableActions(soap, NULL, NULL, "ns4:getAvailableActions");
	case SOAP_TYPE_ns4__getAvailableActionsResponse:
		return soap_in_ns4__getAvailableActionsResponse(soap, NULL, NULL, "ns4:getAvailableActionsResponse");
	case SOAP_TYPE_ns4__createIssue:
		return soap_in_ns4__createIssue(soap, NULL, NULL, "ns4:createIssue");
	case SOAP_TYPE_ns4__createIssueResponse:
		return soap_in_ns4__createIssueResponse(soap, NULL, NULL, "ns4:createIssueResponse");
	case SOAP_TYPE_ns4__getIssue:
		return soap_in_ns4__getIssue(soap, NULL, NULL, "ns4:getIssue");
	case SOAP_TYPE_ns4__getIssueResponse:
		return soap_in_ns4__getIssueResponse(soap, NULL, NULL, "ns4:getIssueResponse");
	case SOAP_TYPE_ns4__createUser:
		return soap_in_ns4__createUser(soap, NULL, NULL, "ns4:createUser");
	case SOAP_TYPE_ns4__createUserResponse:
		return soap_in_ns4__createUserResponse(soap, NULL, NULL, "ns4:createUserResponse");
	case SOAP_TYPE_ns4__getComponents:
		return soap_in_ns4__getComponents(soap, NULL, NULL, "ns4:getComponents");
	case SOAP_TYPE_ns4__getComponentsResponse:
		return soap_in_ns4__getComponentsResponse(soap, NULL, NULL, "ns4:getComponentsResponse");
	case SOAP_TYPE_ns4__getUser:
		return soap_in_ns4__getUser(soap, NULL, NULL, "ns4:getUser");
	case SOAP_TYPE_ns4__getUserResponse:
		return soap_in_ns4__getUserResponse(soap, NULL, NULL, "ns4:getUserResponse");
	case SOAP_TYPE_ns4__login:
		return soap_in_ns4__login(soap, NULL, NULL, "ns4:login");
	case SOAP_TYPE_ns4__loginResponse:
		return soap_in_ns4__loginResponse(soap, NULL, NULL, "ns4:loginResponse");
	case SOAP_TYPE_ns4__getGroup:
		return soap_in_ns4__getGroup(soap, NULL, NULL, "ns4:getGroup");
	case SOAP_TYPE_ns4__getGroupResponse:
		return soap_in_ns4__getGroupResponse(soap, NULL, NULL, "ns4:getGroupResponse");
	case SOAP_TYPE_ns4__createGroup:
		return soap_in_ns4__createGroup(soap, NULL, NULL, "ns4:createGroup");
	case SOAP_TYPE_ns4__createGroupResponse:
		return soap_in_ns4__createGroupResponse(soap, NULL, NULL, "ns4:createGroupResponse");
	case SOAP_TYPE_ns4__getServerInfo:
		return soap_in_ns4__getServerInfo(soap, NULL, NULL, "ns4:getServerInfo");
	case SOAP_TYPE_ns4__getServerInfoResponse:
		return soap_in_ns4__getServerInfoResponse(soap, NULL, NULL, "ns4:getServerInfoResponse");
	case SOAP_TYPE_ns4__getComment:
		return soap_in_ns4__getComment(soap, NULL, NULL, "ns4:getComment");
	case SOAP_TYPE_ns4__getCommentResponse:
		return soap_in_ns4__getCommentResponse(soap, NULL, NULL, "ns4:getCommentResponse");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteProject:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteProject(soap, NULL, NULL, "ns2:RemoteProject");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteIssue:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, NULL, NULL, "ns2:RemoteIssue");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePermission:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemotePermission(soap, NULL, NULL, "ns2:RemotePermission");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePermissionScheme:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, NULL, NULL, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteAvatar:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteAvatar(soap, NULL, NULL, "ns2:RemoteAvatar");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteSecurityLevel:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, NULL, NULL, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteWorklog:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteWorklog(soap, NULL, NULL, "ns2:RemoteWorklog");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteAttachment:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteAttachment(soap, NULL, NULL, "ns2:RemoteAttachment");
	case SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREbase64Binary:
		return soap_in_PointerToArrayOf_USCORExsd_USCOREbase64Binary(soap, NULL, NULL, "xsd:byte[]");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteFieldValue:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, NULL, NULL, "ns2:RemoteFieldValue");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteFilter:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteFilter(soap, NULL, NULL, "ns2:RemoteFilter");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteComment:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteComment(soap, NULL, NULL, "ns2:RemoteComment");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteField:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteField(soap, NULL, NULL, "ns2:RemoteField");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteScheme:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteScheme(soap, NULL, NULL, "ns2:RemoteScheme");
	case SOAP_TYPE_PointerTons2__RemoteRoleActors:
		return soap_in_PointerTons2__RemoteRoleActors(soap, NULL, NULL, "ns2:RemoteRoleActors");
	case SOAP_TYPE_PointerTons2__RemoteProjectRoleActors:
		return soap_in_PointerTons2__RemoteProjectRoleActors(soap, NULL, NULL, "ns2:RemoteProjectRoleActors");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteProjectRole:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, NULL, NULL, "ns2:RemoteProjectRole");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteStatus:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteStatus(soap, NULL, NULL, "ns2:RemoteStatus");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteResolution:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteResolution(soap, NULL, NULL, "ns2:RemoteResolution");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePriority:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemotePriority(soap, NULL, NULL, "ns2:RemotePriority");
	case SOAP_TYPE_PointerTons2__RemoteConfiguration:
		return soap_in_PointerTons2__RemoteConfiguration(soap, NULL, NULL, "ns2:RemoteConfiguration");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteIssueType:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteIssueType(soap, NULL, NULL, "ns2:RemoteIssueType");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteNamedObject:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, NULL, NULL, "ns2:RemoteNamedObject");
	case SOAP_TYPE_PointerTons2__RemoteGroup:
		return soap_in_PointerTons2__RemoteGroup(soap, NULL, NULL, "ns2:RemoteGroup");
	case SOAP_TYPE_PointerTons2__RemoteServerInfo:
		return soap_in_PointerTons2__RemoteServerInfo(soap, NULL, NULL, "ns2:RemoteServerInfo");
	case SOAP_TYPE_PointerTo_ns1__RemoteValidationException:
		return soap_in_PointerTo_ns1__RemoteValidationException(soap, NULL, NULL, "ns1:RemoteValidationException");
	case SOAP_TYPE_PointerTo_ns1__RemotePermissionException:
		return soap_in_PointerTo_ns1__RemotePermissionException(soap, NULL, NULL, "ns1:RemotePermissionException");
	case SOAP_TYPE_PointerTo_ns1__RemoteException:
		return soap_in_PointerTo_ns1__RemoteException(soap, NULL, NULL, "ns1:RemoteException");
	case SOAP_TYPE_PointerTo_ns1__RemoteAuthenticationException:
		return soap_in_PointerTo_ns1__RemoteAuthenticationException(soap, NULL, NULL, "ns1:RemoteAuthenticationException");
	case SOAP_TYPE_PointerTons3__RemoteValidationException:
		return soap_in_PointerTons3__RemoteValidationException(soap, NULL, NULL, "ns3:RemoteValidationException");
	case SOAP_TYPE_PointerTons3__RemotePermissionException:
		return soap_in_PointerTons3__RemotePermissionException(soap, NULL, NULL, "ns3:RemotePermissionException");
	case SOAP_TYPE_PointerTons3__RemoteException:
		return soap_in_PointerTons3__RemoteException(soap, NULL, NULL, "ns3:RemoteException");
	case SOAP_TYPE_PointerTons3__RemoteAuthenticationException:
		return soap_in_PointerTons3__RemoteAuthenticationException(soap, NULL, NULL, "ns3:RemoteAuthenticationException");
	case SOAP_TYPE_PointerToPointerTons2__RemoteProject:
		return soap_in_PointerToPointerTons2__RemoteProject(soap, NULL, NULL, "ns2:RemoteProject");
	case SOAP_TYPE_PointerToPointerTons2__RemoteIssue:
		return soap_in_PointerToPointerTons2__RemoteIssue(soap, NULL, NULL, "ns2:RemoteIssue");
	case SOAP_TYPE_PointerTons2__RemoteIssue:
		return soap_in_PointerTons2__RemoteIssue(soap, NULL, NULL, "ns2:RemoteIssue");
	case SOAP_TYPE_PointerToPointerTons2__RemotePermission:
		return soap_in_PointerToPointerTons2__RemotePermission(soap, NULL, NULL, "ns2:RemotePermission");
	case SOAP_TYPE_PointerToPointerTons2__RemotePermissionScheme:
		return soap_in_PointerToPointerTons2__RemotePermissionScheme(soap, NULL, NULL, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_PointerTons2__RemotePermissionScheme:
		return soap_in_PointerTons2__RemotePermissionScheme(soap, NULL, NULL, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_PointerToPointerTons2__RemoteAvatar:
		return soap_in_PointerToPointerTons2__RemoteAvatar(soap, NULL, NULL, "ns2:RemoteAvatar");
	case SOAP_TYPE_PointerTons2__RemoteAvatar:
		return soap_in_PointerTons2__RemoteAvatar(soap, NULL, NULL, "ns2:RemoteAvatar");
	case SOAP_TYPE_PointerToPointerTons2__RemoteSecurityLevel:
		return soap_in_PointerToPointerTons2__RemoteSecurityLevel(soap, NULL, NULL, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_PointerTons2__RemoteSecurityLevel:
		return soap_in_PointerTons2__RemoteSecurityLevel(soap, NULL, NULL, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_PointerToPointerTons2__RemoteWorklog:
		return soap_in_PointerToPointerTons2__RemoteWorklog(soap, NULL, NULL, "ns2:RemoteWorklog");
	case SOAP_TYPE_PointerTons2__RemoteWorklog:
		return soap_in_PointerTons2__RemoteWorklog(soap, NULL, NULL, "ns2:RemoteWorklog");
	case SOAP_TYPE_PointerToPointerTons2__RemoteAttachment:
		return soap_in_PointerToPointerTons2__RemoteAttachment(soap, NULL, NULL, "ns2:RemoteAttachment");
	case SOAP_TYPE_PointerTons2__RemoteAttachment:
		return soap_in_PointerTons2__RemoteAttachment(soap, NULL, NULL, "ns2:RemoteAttachment");
	case SOAP_TYPE_PointerTo_Struct_1:
		return soap_in_PointerTo_Struct_1(soap, NULL, NULL, "xsd:byte");
	case SOAP_TYPE_PointerToPointerTons2__RemoteFieldValue:
		return soap_in_PointerToPointerTons2__RemoteFieldValue(soap, NULL, NULL, "ns2:RemoteFieldValue");
	case SOAP_TYPE_PointerTons2__RemoteFieldValue:
		return soap_in_PointerTons2__RemoteFieldValue(soap, NULL, NULL, "ns2:RemoteFieldValue");
	case SOAP_TYPE_PointerToPointerTons2__RemoteFilter:
		return soap_in_PointerToPointerTons2__RemoteFilter(soap, NULL, NULL, "ns2:RemoteFilter");
	case SOAP_TYPE_PointerTons2__RemoteFilter:
		return soap_in_PointerTons2__RemoteFilter(soap, NULL, NULL, "ns2:RemoteFilter");
	case SOAP_TYPE_PointerToPointerTons2__RemoteComment:
		return soap_in_PointerToPointerTons2__RemoteComment(soap, NULL, NULL, "ns2:RemoteComment");
	case SOAP_TYPE_PointerTons2__RemoteComment:
		return soap_in_PointerTons2__RemoteComment(soap, NULL, NULL, "ns2:RemoteComment");
	case SOAP_TYPE_PointerToPointerTons2__RemoteField:
		return soap_in_PointerToPointerTons2__RemoteField(soap, NULL, NULL, "ns2:RemoteField");
	case SOAP_TYPE_PointerTons2__RemoteField:
		return soap_in_PointerTons2__RemoteField(soap, NULL, NULL, "ns2:RemoteField");
	case SOAP_TYPE_PointerToPointerTons2__RemoteScheme:
		return soap_in_PointerToPointerTons2__RemoteScheme(soap, NULL, NULL, "ns2:RemoteScheme");
	case SOAP_TYPE_PointerTons2__RemoteScheme:
		return soap_in_PointerTons2__RemoteScheme(soap, NULL, NULL, "ns2:RemoteScheme");
	case SOAP_TYPE_PointerToPointerTons2__RemoteRoleActor:
		return soap_in_PointerToPointerTons2__RemoteRoleActor(soap, NULL, NULL, "ns2:RemoteRoleActor");
	case SOAP_TYPE_PointerTons2__RemoteRoleActor:
		return soap_in_PointerTons2__RemoteRoleActor(soap, NULL, NULL, "ns2:RemoteRoleActor");
	case SOAP_TYPE_PointerToPointerTons2__RemoteProjectRole:
		return soap_in_PointerToPointerTons2__RemoteProjectRole(soap, NULL, NULL, "ns2:RemoteProjectRole");
	case SOAP_TYPE_PointerToPointerTons2__RemoteStatus:
		return soap_in_PointerToPointerTons2__RemoteStatus(soap, NULL, NULL, "ns2:RemoteStatus");
	case SOAP_TYPE_PointerTons2__RemoteStatus:
		return soap_in_PointerTons2__RemoteStatus(soap, NULL, NULL, "ns2:RemoteStatus");
	case SOAP_TYPE_PointerToPointerTons2__RemoteResolution:
		return soap_in_PointerToPointerTons2__RemoteResolution(soap, NULL, NULL, "ns2:RemoteResolution");
	case SOAP_TYPE_PointerTons2__RemoteResolution:
		return soap_in_PointerTons2__RemoteResolution(soap, NULL, NULL, "ns2:RemoteResolution");
	case SOAP_TYPE_PointerToPointerTons2__RemotePriority:
		return soap_in_PointerToPointerTons2__RemotePriority(soap, NULL, NULL, "ns2:RemotePriority");
	case SOAP_TYPE_PointerTons2__RemotePriority:
		return soap_in_PointerTons2__RemotePriority(soap, NULL, NULL, "ns2:RemotePriority");
	case SOAP_TYPE_PointerToPointerTons2__RemotePermissionMapping:
		return soap_in_PointerToPointerTons2__RemotePermissionMapping(soap, NULL, NULL, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_PointerTons2__RemotePermissionMapping:
		return soap_in_PointerTons2__RemotePermissionMapping(soap, NULL, NULL, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_PointerToPointerTons2__RemoteEntity:
		return soap_in_PointerToPointerTons2__RemoteEntity(soap, NULL, NULL, "ns2:RemoteEntity");
	case SOAP_TYPE_PointerTons2__RemoteEntity:
		return soap_in_PointerTons2__RemoteEntity(soap, NULL, NULL, "ns2:RemoteEntity");
	case SOAP_TYPE_PointerToPointerTons2__RemoteIssueType:
		return soap_in_PointerToPointerTons2__RemoteIssueType(soap, NULL, NULL, "ns2:RemoteIssueType");
	case SOAP_TYPE_PointerTons2__RemoteIssueType:
		return soap_in_PointerTons2__RemoteIssueType(soap, NULL, NULL, "ns2:RemoteIssueType");
	case SOAP_TYPE_PointerToPointerTons2__RemoteNamedObject:
		return soap_in_PointerToPointerTons2__RemoteNamedObject(soap, NULL, NULL, "ns2:RemoteNamedObject");
	case SOAP_TYPE_PointerTons2__RemoteNamedObject:
		return soap_in_PointerTons2__RemoteNamedObject(soap, NULL, NULL, "ns2:RemoteNamedObject");
	case SOAP_TYPE_PointerToPointerTons2__RemoteCustomFieldValue:
		return soap_in_PointerToPointerTons2__RemoteCustomFieldValue(soap, NULL, NULL, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_PointerTons2__RemoteCustomFieldValue:
		return soap_in_PointerTons2__RemoteCustomFieldValue(soap, NULL, NULL, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_PointerTostring:
		return soap_in_PointerTostring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerToPointerTons2__RemoteVersion:
		return soap_in_PointerToPointerTons2__RemoteVersion(soap, NULL, NULL, "ns2:RemoteVersion");
	case SOAP_TYPE_PointerTons2__RemoteVersion:
		return soap_in_PointerTons2__RemoteVersion(soap, NULL, NULL, "ns2:RemoteVersion");
	case SOAP_TYPE_PointerToPointerTons2__RemoteComponent:
		return soap_in_PointerToPointerTons2__RemoteComponent(soap, NULL, NULL, "ns2:RemoteComponent");
	case SOAP_TYPE_PointerTons2__RemoteComponent:
		return soap_in_PointerTons2__RemoteComponent(soap, NULL, NULL, "ns2:RemoteComponent");
	case SOAP_TYPE_PointerToPointerTons2__RemoteUser:
		return soap_in_PointerToPointerTons2__RemoteUser(soap, NULL, NULL, "ns2:RemoteUser");
	case SOAP_TYPE_PointerTons2__RemoteUser:
		return soap_in_PointerTons2__RemoteUser(soap, NULL, NULL, "ns2:RemoteUser");
	case SOAP_TYPE_PointerTons2__RemoteProject:
		return soap_in_PointerTons2__RemoteProject(soap, NULL, NULL, "ns2:RemoteProject");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePermissionMapping:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, NULL, NULL, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteCustomFieldValue:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, NULL, NULL, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteComponent:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteComponent(soap, NULL, NULL, "ns2:RemoteComponent");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteVersion:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteVersion(soap, NULL, NULL, "ns2:RemoteVersion");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, NULL, NULL, "ns2:RemoteRoleActor");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteUser:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, NULL, NULL, "ns2:RemoteUser");
	case SOAP_TYPE_PointerTons2__RemoteProjectRole:
		return soap_in_PointerTons2__RemoteProjectRole(soap, NULL, NULL, "ns2:RemoteProjectRole");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteEntity:
		return soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteEntity(soap, NULL, NULL, "ns2:RemoteEntity");
	case SOAP_TYPE_PointerTons2__RemotePermission:
		return soap_in_PointerTons2__RemotePermission(soap, NULL, NULL, "ns2:RemotePermission");
	case SOAP_TYPE_PointerToLONG64:
		return soap_in_PointerToLONG64(soap, NULL, NULL, "xsd:long");
	case SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREstring:
		return soap_in_PointerToArrayOf_USCORExsd_USCOREstring(soap, NULL, NULL, "xsd:string");
	case SOAP_TYPE_PointerTons2__RemoteTimeInfo:
		return soap_in_PointerTons2__RemoteTimeInfo(soap, NULL, NULL, "ns2:RemoteTimeInfo");
	case SOAP_TYPE_PointerTotime:
		return soap_in_PointerTotime(soap, NULL, NULL, "xsd:dateTime");
	case SOAP_TYPE__QName:
	{	char **s;
		s = soap_in__QName(soap, NULL, NULL, "xsd:QName");
		return s ? *s : NULL;
	}
	case SOAP_TYPE_string:
	{	char **s;
		s = soap_in_string(soap, NULL, NULL, "xsd:string");
		return s ? *s : NULL;
	}
	default:
	{	const char *t = soap->type;
		if (!*t)
			t = soap->tag;
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteProject"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteProject(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteIssue"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteIssue(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemotePermission"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission;
			return soap_in_ArrayOf_USCOREtns1_USCORERemotePermission(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemotePermissionScheme"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme;
			return soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteAvatar"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteAvatar(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteSecurityLevel"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteWorklog"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteWorklog(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteAttachment"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteAttachment(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:byte[]"))
		{	*type = SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary;
			return soap_in_ArrayOf_USCORExsd_USCOREbase64Binary(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteFieldValue"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteFilter"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteFilter(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteComment"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteComment(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteField"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteField(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteScheme"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteScheme(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteRoleActor"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteProjectRole"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteStatus"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteStatus(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteResolution"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteResolution(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemotePriority"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority;
			return soap_in_ArrayOf_USCOREtns1_USCORERemotePriority(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemotePermissionMapping"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping;
			return soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteEntity"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteEntity(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteIssueType"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteIssueType(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteNamedObject"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteCustomFieldValue"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:string"))
		{	*type = SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring;
			return soap_in_ArrayOf_USCORExsd_USCOREstring(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteVersion"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteVersion(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteComponent"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteComponent(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "ns2:RemoteUser"))
		{	*type = SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser;
			return soap_in_ArrayOf_USCOREtns1_USCORERemoteUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:RemotePermissionException"))
		{	*type = SOAP_TYPE_ns3__RemotePermissionException;
			return soap_in_ns3__RemotePermissionException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:RemoteValidationException"))
		{	*type = SOAP_TYPE_ns3__RemoteValidationException;
			return soap_in_ns3__RemoteValidationException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:RemoteAuthenticationException"))
		{	*type = SOAP_TYPE_ns3__RemoteAuthenticationException;
			return soap_in_ns3__RemoteAuthenticationException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns3:RemoteException"))
		{	*type = SOAP_TYPE_ns3__RemoteException;
			return soap_in_ns3__RemoteException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteAvatar"))
		{	*type = SOAP_TYPE_ns2__RemoteAvatar;
			return soap_in_ns2__RemoteAvatar(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteWorklog"))
		{	*type = SOAP_TYPE_ns2__RemoteWorklog;
			return soap_in_ns2__RemoteWorklog(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteAttachment"))
		{	*type = SOAP_TYPE_ns2__RemoteAttachment;
			return soap_in_ns2__RemoteAttachment(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteSecurityLevel"))
		{	*type = SOAP_TYPE_ns2__RemoteSecurityLevel;
			return soap_in_ns2__RemoteSecurityLevel(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteFieldValue"))
		{	*type = SOAP_TYPE_ns2__RemoteFieldValue;
			return soap_in_ns2__RemoteFieldValue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteFilter"))
		{	*type = SOAP_TYPE_ns2__RemoteFilter;
			return soap_in_ns2__RemoteFilter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteField"))
		{	*type = SOAP_TYPE_ns2__RemoteField;
			return soap_in_ns2__RemoteField(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteProjectRoleActors"))
		{	*type = SOAP_TYPE_ns2__RemoteProjectRoleActors;
			return soap_in_ns2__RemoteProjectRoleActors(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteRoleActors"))
		{	*type = SOAP_TYPE_ns2__RemoteRoleActors;
			return soap_in_ns2__RemoteRoleActors(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteRoleActor"))
		{	*type = SOAP_TYPE_ns2__RemoteRoleActor;
			return soap_in_ns2__RemoteRoleActor(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteProjectRole"))
		{	*type = SOAP_TYPE_ns2__RemoteProjectRole;
			return soap_in_ns2__RemoteProjectRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteStatus"))
		{	*type = SOAP_TYPE_ns2__RemoteStatus;
			return soap_in_ns2__RemoteStatus(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteResolution"))
		{	*type = SOAP_TYPE_ns2__RemoteResolution;
			return soap_in_ns2__RemoteResolution(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemotePriority"))
		{	*type = SOAP_TYPE_ns2__RemotePriority;
			return soap_in_ns2__RemotePriority(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteProject"))
		{	*type = SOAP_TYPE_ns2__RemoteProject;
			return soap_in_ns2__RemoteProject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemotePermissionScheme"))
		{	*type = SOAP_TYPE_ns2__RemotePermissionScheme;
			return soap_in_ns2__RemotePermissionScheme(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemotePermissionMapping"))
		{	*type = SOAP_TYPE_ns2__RemotePermissionMapping;
			return soap_in_ns2__RemotePermissionMapping(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemotePermission"))
		{	*type = SOAP_TYPE_ns2__RemotePermission;
			return soap_in_ns2__RemotePermission(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteScheme"))
		{	*type = SOAP_TYPE_ns2__RemoteScheme;
			return soap_in_ns2__RemoteScheme(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteConfiguration"))
		{	*type = SOAP_TYPE_ns2__RemoteConfiguration;
			return soap_in_ns2__RemoteConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteIssueType"))
		{	*type = SOAP_TYPE_ns2__RemoteIssueType;
			return soap_in_ns2__RemoteIssueType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:AbstractRemoteConstant"))
		{	*type = SOAP_TYPE_ns2__AbstractRemoteConstant;
			return soap_in_ns2__AbstractRemoteConstant(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteNamedObject"))
		{	*type = SOAP_TYPE_ns2__RemoteNamedObject;
			return soap_in_ns2__RemoteNamedObject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteIssue"))
		{	*type = SOAP_TYPE_ns2__RemoteIssue;
			return soap_in_ns2__RemoteIssue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteCustomFieldValue"))
		{	*type = SOAP_TYPE_ns2__RemoteCustomFieldValue;
			return soap_in_ns2__RemoteCustomFieldValue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteVersion"))
		{	*type = SOAP_TYPE_ns2__RemoteVersion;
			return soap_in_ns2__RemoteVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteComponent"))
		{	*type = SOAP_TYPE_ns2__RemoteComponent;
			return soap_in_ns2__RemoteComponent(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:AbstractNamedRemoteEntity"))
		{	*type = SOAP_TYPE_ns2__AbstractNamedRemoteEntity;
			return soap_in_ns2__AbstractNamedRemoteEntity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:AbstractRemoteEntity"))
		{	*type = SOAP_TYPE_ns2__AbstractRemoteEntity;
			return soap_in_ns2__AbstractRemoteEntity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteGroup"))
		{	*type = SOAP_TYPE_ns2__RemoteGroup;
			return soap_in_ns2__RemoteGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteUser"))
		{	*type = SOAP_TYPE_ns2__RemoteUser;
			return soap_in_ns2__RemoteUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteEntity"))
		{	*type = SOAP_TYPE_ns2__RemoteEntity;
			return soap_in_ns2__RemoteEntity(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteServerInfo"))
		{	*type = SOAP_TYPE_ns2__RemoteServerInfo;
			return soap_in_ns2__RemoteServerInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteTimeInfo"))
		{	*type = SOAP_TYPE_ns2__RemoteTimeInfo;
			return soap_in_ns2__RemoteTimeInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns2:RemoteComment"))
		{	*type = SOAP_TYPE_ns2__RemoteComment;
			return soap_in_ns2__RemoteComment(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:byte"))
		{	*type = SOAP_TYPE_byte;
			return soap_in_byte(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:int"))
		{	*type = SOAP_TYPE_int;
			return soap_in_int(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:long"))
		{	*type = SOAP_TYPE_LONG64;
			return soap_in_LONG64(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:dateTime"))
		{	*type = SOAP_TYPE_time;
			return soap_in_time(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:boolean"))
		{	*type = SOAP_TYPE_bool;
			return soap_in_bool(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:setNewProjectAvatar"))
		{	*type = SOAP_TYPE_ns4__setNewProjectAvatar;
			return soap_in_ns4__setNewProjectAvatar(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:setNewProjectAvatarResponse"))
		{	*type = SOAP_TYPE_ns4__setNewProjectAvatarResponse;
			return soap_in_ns4__setNewProjectAvatarResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectsNoSchemes"))
		{	*type = SOAP_TYPE_ns4__getProjectsNoSchemes;
			return soap_in_ns4__getProjectsNoSchemes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectsNoSchemesResponse"))
		{	*type = SOAP_TYPE_ns4__getProjectsNoSchemesResponse;
			return soap_in_ns4__getProjectsNoSchemesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromTextSearchWithLimit"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit;
			return soap_in_ns4__getIssuesFromTextSearchWithLimit(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromTextSearchWithLimitResponse"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse;
			return soap_in_ns4__getIssuesFromTextSearchWithLimitResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromFilterWithLimit"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromFilterWithLimit;
			return soap_in_ns4__getIssuesFromFilterWithLimit(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromFilterWithLimitResponse"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse;
			return soap_in_ns4__getIssuesFromFilterWithLimitResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromFilter"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromFilter;
			return soap_in_ns4__getIssuesFromFilter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromFilterResponse"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromFilterResponse;
			return soap_in_ns4__getIssuesFromFilterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addVersion"))
		{	*type = SOAP_TYPE_ns4__addVersion;
			return soap_in_ns4__addVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addVersionResponse"))
		{	*type = SOAP_TYPE_ns4__addVersionResponse;
			return soap_in_ns4__addVersionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSecuritySchemes"))
		{	*type = SOAP_TYPE_ns4__getSecuritySchemes;
			return soap_in_ns4__getSecuritySchemes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSecuritySchemesResponse"))
		{	*type = SOAP_TYPE_ns4__getSecuritySchemesResponse;
			return soap_in_ns4__getSecuritySchemesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createProjectFromObject"))
		{	*type = SOAP_TYPE_ns4__createProjectFromObject;
			return soap_in_ns4__createProjectFromObject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createProjectFromObjectResponse"))
		{	*type = SOAP_TYPE_ns4__createProjectFromObjectResponse;
			return soap_in_ns4__createProjectFromObjectResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addBase64EncodedAttachmentsToIssue"))
		{	*type = SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue;
			return soap_in_ns4__addBase64EncodedAttachmentsToIssue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addBase64EncodedAttachmentsToIssueResponse"))
		{	*type = SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse;
			return soap_in_ns4__addBase64EncodedAttachmentsToIssueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSavedFilters"))
		{	*type = SOAP_TYPE_ns4__getSavedFilters;
			return soap_in_ns4__getSavedFilters(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSavedFiltersResponse"))
		{	*type = SOAP_TYPE_ns4__getSavedFiltersResponse;
			return soap_in_ns4__getSavedFiltersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:refreshCustomFields"))
		{	*type = SOAP_TYPE_ns4__refreshCustomFields;
			return soap_in_ns4__refreshCustomFields(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:refreshCustomFieldsResponse"))
		{	*type = SOAP_TYPE_ns4__refreshCustomFieldsResponse;
			return soap_in_ns4__refreshCustomFieldsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteGroup"))
		{	*type = SOAP_TYPE_ns4__deleteGroup;
			return soap_in_ns4__deleteGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteGroupResponse"))
		{	*type = SOAP_TYPE_ns4__deleteGroupResponse;
			return soap_in_ns4__deleteGroupResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateGroup"))
		{	*type = SOAP_TYPE_ns4__updateGroup;
			return soap_in_ns4__updateGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateGroupResponse"))
		{	*type = SOAP_TYPE_ns4__updateGroupResponse;
			return soap_in_ns4__updateGroupResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteUser"))
		{	*type = SOAP_TYPE_ns4__deleteUser;
			return soap_in_ns4__deleteUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteUserResponse"))
		{	*type = SOAP_TYPE_ns4__deleteUserResponse;
			return soap_in_ns4__deleteUserResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromJqlSearch"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromJqlSearch;
			return soap_in_ns4__getIssuesFromJqlSearch(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromJqlSearchResponse"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromJqlSearchResponse;
			return soap_in_ns4__getIssuesFromJqlSearchResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromTextSearchWithProject"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromTextSearchWithProject;
			return soap_in_ns4__getIssuesFromTextSearchWithProject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromTextSearchWithProjectResponse"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromTextSearchWithProjectResponse;
			return soap_in_ns4__getIssuesFromTextSearchWithProjectResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromTextSearch"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromTextSearch;
			return soap_in_ns4__getIssuesFromTextSearch(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssuesFromTextSearchResponse"))
		{	*type = SOAP_TYPE_ns4__getIssuesFromTextSearchResponse;
			return soap_in_ns4__getIssuesFromTextSearchResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssueCountForFilter"))
		{	*type = SOAP_TYPE_ns4__getIssueCountForFilter;
			return soap_in_ns4__getIssueCountForFilter(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssueCountForFilterResponse"))
		{	*type = SOAP_TYPE_ns4__getIssueCountForFilterResponse;
			return soap_in_ns4__getIssueCountForFilterResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deletePermissionScheme"))
		{	*type = SOAP_TYPE_ns4__deletePermissionScheme;
			return soap_in_ns4__deletePermissionScheme(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deletePermissionSchemeResponse"))
		{	*type = SOAP_TYPE_ns4__deletePermissionSchemeResponse;
			return soap_in_ns4__deletePermissionSchemeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deletePermissionFrom"))
		{	*type = SOAP_TYPE_ns4__deletePermissionFrom;
			return soap_in_ns4__deletePermissionFrom(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deletePermissionFromResponse"))
		{	*type = SOAP_TYPE_ns4__deletePermissionFromResponse;
			return soap_in_ns4__deletePermissionFromResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addPermissionTo"))
		{	*type = SOAP_TYPE_ns4__addPermissionTo;
			return soap_in_ns4__addPermissionTo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addPermissionToResponse"))
		{	*type = SOAP_TYPE_ns4__addPermissionToResponse;
			return soap_in_ns4__addPermissionToResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createPermissionScheme"))
		{	*type = SOAP_TYPE_ns4__createPermissionScheme;
			return soap_in_ns4__createPermissionScheme(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createPermissionSchemeResponse"))
		{	*type = SOAP_TYPE_ns4__createPermissionSchemeResponse;
			return soap_in_ns4__createPermissionSchemeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAllPermissions"))
		{	*type = SOAP_TYPE_ns4__getAllPermissions;
			return soap_in_ns4__getAllPermissions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAllPermissionsResponse"))
		{	*type = SOAP_TYPE_ns4__getAllPermissionsResponse;
			return soap_in_ns4__getAllPermissionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getPermissionSchemes"))
		{	*type = SOAP_TYPE_ns4__getPermissionSchemes;
			return soap_in_ns4__getPermissionSchemes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getPermissionSchemesResponse"))
		{	*type = SOAP_TYPE_ns4__getPermissionSchemesResponse;
			return soap_in_ns4__getPermissionSchemesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getNotificationSchemes"))
		{	*type = SOAP_TYPE_ns4__getNotificationSchemes;
			return soap_in_ns4__getNotificationSchemes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getNotificationSchemesResponse"))
		{	*type = SOAP_TYPE_ns4__getNotificationSchemesResponse;
			return soap_in_ns4__getNotificationSchemesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteProjectAvatar"))
		{	*type = SOAP_TYPE_ns4__deleteProjectAvatar;
			return soap_in_ns4__deleteProjectAvatar(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteProjectAvatarResponse"))
		{	*type = SOAP_TYPE_ns4__deleteProjectAvatarResponse;
			return soap_in_ns4__deleteProjectAvatarResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectAvatar"))
		{	*type = SOAP_TYPE_ns4__getProjectAvatar;
			return soap_in_ns4__getProjectAvatar(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectAvatarResponse"))
		{	*type = SOAP_TYPE_ns4__getProjectAvatarResponse;
			return soap_in_ns4__getProjectAvatarResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:setProjectAvatar"))
		{	*type = SOAP_TYPE_ns4__setProjectAvatar;
			return soap_in_ns4__setProjectAvatar(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:setProjectAvatarResponse"))
		{	*type = SOAP_TYPE_ns4__setProjectAvatarResponse;
			return soap_in_ns4__setProjectAvatarResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectAvatars"))
		{	*type = SOAP_TYPE_ns4__getProjectAvatars;
			return soap_in_ns4__getProjectAvatars(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectAvatarsResponse"))
		{	*type = SOAP_TYPE_ns4__getProjectAvatarsResponse;
			return soap_in_ns4__getProjectAvatarsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSecurityLevels"))
		{	*type = SOAP_TYPE_ns4__getSecurityLevels;
			return soap_in_ns4__getSecurityLevels(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSecurityLevelsResponse"))
		{	*type = SOAP_TYPE_ns4__getSecurityLevelsResponse;
			return soap_in_ns4__getSecurityLevelsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectWithSchemesById"))
		{	*type = SOAP_TYPE_ns4__getProjectWithSchemesById;
			return soap_in_ns4__getProjectWithSchemesById(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectWithSchemesByIdResponse"))
		{	*type = SOAP_TYPE_ns4__getProjectWithSchemesByIdResponse;
			return soap_in_ns4__getProjectWithSchemesByIdResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:logout"))
		{	*type = SOAP_TYPE_ns4__logout;
			return soap_in_ns4__logout(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:logoutResponse"))
		{	*type = SOAP_TYPE_ns4__logoutResponse;
			return soap_in_ns4__logoutResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getResolutionDateById"))
		{	*type = SOAP_TYPE_ns4__getResolutionDateById;
			return soap_in_ns4__getResolutionDateById(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getResolutionDateByIdResponse"))
		{	*type = SOAP_TYPE_ns4__getResolutionDateByIdResponse;
			return soap_in_ns4__getResolutionDateByIdResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getResolutionDateByKey"))
		{	*type = SOAP_TYPE_ns4__getResolutionDateByKey;
			return soap_in_ns4__getResolutionDateByKey(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getResolutionDateByKeyResponse"))
		{	*type = SOAP_TYPE_ns4__getResolutionDateByKeyResponse;
			return soap_in_ns4__getResolutionDateByKeyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:hasPermissionToUpdateWorklog"))
		{	*type = SOAP_TYPE_ns4__hasPermissionToUpdateWorklog;
			return soap_in_ns4__hasPermissionToUpdateWorklog(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:hasPermissionToUpdateWorklogResponse"))
		{	*type = SOAP_TYPE_ns4__hasPermissionToUpdateWorklogResponse;
			return soap_in_ns4__hasPermissionToUpdateWorklogResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:hasPermissionToDeleteWorklog"))
		{	*type = SOAP_TYPE_ns4__hasPermissionToDeleteWorklog;
			return soap_in_ns4__hasPermissionToDeleteWorklog(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:hasPermissionToDeleteWorklogResponse"))
		{	*type = SOAP_TYPE_ns4__hasPermissionToDeleteWorklogResponse;
			return soap_in_ns4__hasPermissionToDeleteWorklogResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:hasPermissionToCreateWorklog"))
		{	*type = SOAP_TYPE_ns4__hasPermissionToCreateWorklog;
			return soap_in_ns4__hasPermissionToCreateWorklog(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:hasPermissionToCreateWorklogResponse"))
		{	*type = SOAP_TYPE_ns4__hasPermissionToCreateWorklogResponse;
			return soap_in_ns4__hasPermissionToCreateWorklogResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getWorklogs"))
		{	*type = SOAP_TYPE_ns4__getWorklogs;
			return soap_in_ns4__getWorklogs(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getWorklogsResponse"))
		{	*type = SOAP_TYPE_ns4__getWorklogsResponse;
			return soap_in_ns4__getWorklogsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateWorklogAndRetainRemainingEstimate"))
		{	*type = SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimate;
			return soap_in_ns4__updateWorklogAndRetainRemainingEstimate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateWorklogAndRetainRemainingEstimateResponse"))
		{	*type = SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimateResponse;
			return soap_in_ns4__updateWorklogAndRetainRemainingEstimateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateWorklogAndAutoAdjustRemainingEstimate"))
		{	*type = SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimate;
			return soap_in_ns4__updateWorklogAndAutoAdjustRemainingEstimate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateWorklogAndAutoAdjustRemainingEstimateResponse"))
		{	*type = SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse;
			return soap_in_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateWorklogWithNewRemainingEstimate"))
		{	*type = SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimate;
			return soap_in_ns4__updateWorklogWithNewRemainingEstimate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateWorklogWithNewRemainingEstimateResponse"))
		{	*type = SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimateResponse;
			return soap_in_ns4__updateWorklogWithNewRemainingEstimateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteWorklogAndRetainRemainingEstimate"))
		{	*type = SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimate;
			return soap_in_ns4__deleteWorklogAndRetainRemainingEstimate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteWorklogAndRetainRemainingEstimateResponse"))
		{	*type = SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimateResponse;
			return soap_in_ns4__deleteWorklogAndRetainRemainingEstimateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteWorklogAndAutoAdjustRemainingEstimate"))
		{	*type = SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimate;
			return soap_in_ns4__deleteWorklogAndAutoAdjustRemainingEstimate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteWorklogAndAutoAdjustRemainingEstimateResponse"))
		{	*type = SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse;
			return soap_in_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteWorklogWithNewRemainingEstimate"))
		{	*type = SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimate;
			return soap_in_ns4__deleteWorklogWithNewRemainingEstimate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteWorklogWithNewRemainingEstimateResponse"))
		{	*type = SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimateResponse;
			return soap_in_ns4__deleteWorklogWithNewRemainingEstimateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addWorklogAndRetainRemainingEstimate"))
		{	*type = SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimate;
			return soap_in_ns4__addWorklogAndRetainRemainingEstimate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addWorklogAndRetainRemainingEstimateResponse"))
		{	*type = SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimateResponse;
			return soap_in_ns4__addWorklogAndRetainRemainingEstimateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addWorklogAndAutoAdjustRemainingEstimate"))
		{	*type = SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimate;
			return soap_in_ns4__addWorklogAndAutoAdjustRemainingEstimate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addWorklogAndAutoAdjustRemainingEstimateResponse"))
		{	*type = SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse;
			return soap_in_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addWorklogWithNewRemainingEstimate"))
		{	*type = SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimate;
			return soap_in_ns4__addWorklogWithNewRemainingEstimate(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addWorklogWithNewRemainingEstimateResponse"))
		{	*type = SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimateResponse;
			return soap_in_ns4__addWorklogWithNewRemainingEstimateResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssueById"))
		{	*type = SOAP_TYPE_ns4__getIssueById;
			return soap_in_ns4__getIssueById(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssueByIdResponse"))
		{	*type = SOAP_TYPE_ns4__getIssueByIdResponse;
			return soap_in_ns4__getIssueByIdResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:progressWorkflowAction"))
		{	*type = SOAP_TYPE_ns4__progressWorkflowAction;
			return soap_in_ns4__progressWorkflowAction(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:progressWorkflowActionResponse"))
		{	*type = SOAP_TYPE_ns4__progressWorkflowActionResponse;
			return soap_in_ns4__progressWorkflowActionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getFieldsForAction"))
		{	*type = SOAP_TYPE_ns4__getFieldsForAction;
			return soap_in_ns4__getFieldsForAction(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getFieldsForActionResponse"))
		{	*type = SOAP_TYPE_ns4__getFieldsForActionResponse;
			return soap_in_ns4__getFieldsForActionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:editComment"))
		{	*type = SOAP_TYPE_ns4__editComment;
			return soap_in_ns4__editComment(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:editCommentResponse"))
		{	*type = SOAP_TYPE_ns4__editCommentResponse;
			return soap_in_ns4__editCommentResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:hasPermissionToEditComment"))
		{	*type = SOAP_TYPE_ns4__hasPermissionToEditComment;
			return soap_in_ns4__hasPermissionToEditComment(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:hasPermissionToEditCommentResponse"))
		{	*type = SOAP_TYPE_ns4__hasPermissionToEditCommentResponse;
			return soap_in_ns4__hasPermissionToEditCommentResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteIssue"))
		{	*type = SOAP_TYPE_ns4__deleteIssue;
			return soap_in_ns4__deleteIssue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteIssueResponse"))
		{	*type = SOAP_TYPE_ns4__deleteIssueResponse;
			return soap_in_ns4__deleteIssueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAttachmentsFromIssue"))
		{	*type = SOAP_TYPE_ns4__getAttachmentsFromIssue;
			return soap_in_ns4__getAttachmentsFromIssue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAttachmentsFromIssueResponse"))
		{	*type = SOAP_TYPE_ns4__getAttachmentsFromIssueResponse;
			return soap_in_ns4__getAttachmentsFromIssueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addAttachmentsToIssue"))
		{	*type = SOAP_TYPE_ns4__addAttachmentsToIssue;
			return soap_in_ns4__addAttachmentsToIssue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addAttachmentsToIssueResponse"))
		{	*type = SOAP_TYPE_ns4__addAttachmentsToIssueResponse;
			return soap_in_ns4__addAttachmentsToIssueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createIssueWithSecurityLevel"))
		{	*type = SOAP_TYPE_ns4__createIssueWithSecurityLevel;
			return soap_in_ns4__createIssueWithSecurityLevel(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createIssueWithSecurityLevelResponse"))
		{	*type = SOAP_TYPE_ns4__createIssueWithSecurityLevelResponse;
			return soap_in_ns4__createIssueWithSecurityLevelResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addComment"))
		{	*type = SOAP_TYPE_ns4__addComment;
			return soap_in_ns4__addComment(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addCommentResponse"))
		{	*type = SOAP_TYPE_ns4__addCommentResponse;
			return soap_in_ns4__addCommentResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSecurityLevel"))
		{	*type = SOAP_TYPE_ns4__getSecurityLevel;
			return soap_in_ns4__getSecurityLevel(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSecurityLevelResponse"))
		{	*type = SOAP_TYPE_ns4__getSecurityLevelResponse;
			return soap_in_ns4__getSecurityLevelResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeUserFromGroup"))
		{	*type = SOAP_TYPE_ns4__removeUserFromGroup;
			return soap_in_ns4__removeUserFromGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeUserFromGroupResponse"))
		{	*type = SOAP_TYPE_ns4__removeUserFromGroupResponse;
			return soap_in_ns4__removeUserFromGroupResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addUserToGroup"))
		{	*type = SOAP_TYPE_ns4__addUserToGroup;
			return soap_in_ns4__addUserToGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addUserToGroupResponse"))
		{	*type = SOAP_TYPE_ns4__addUserToGroupResponse;
			return soap_in_ns4__addUserToGroupResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSubTaskIssueTypesForProject"))
		{	*type = SOAP_TYPE_ns4__getSubTaskIssueTypesForProject;
			return soap_in_ns4__getSubTaskIssueTypesForProject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSubTaskIssueTypesForProjectResponse"))
		{	*type = SOAP_TYPE_ns4__getSubTaskIssueTypesForProjectResponse;
			return soap_in_ns4__getSubTaskIssueTypesForProjectResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssueTypesForProject"))
		{	*type = SOAP_TYPE_ns4__getIssueTypesForProject;
			return soap_in_ns4__getIssueTypesForProject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssueTypesForProjectResponse"))
		{	*type = SOAP_TYPE_ns4__getIssueTypesForProjectResponse;
			return soap_in_ns4__getIssueTypesForProjectResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getFieldsForEdit"))
		{	*type = SOAP_TYPE_ns4__getFieldsForEdit;
			return soap_in_ns4__getFieldsForEdit(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getFieldsForEditResponse"))
		{	*type = SOAP_TYPE_ns4__getFieldsForEditResponse;
			return soap_in_ns4__getFieldsForEditResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateIssue"))
		{	*type = SOAP_TYPE_ns4__updateIssue;
			return soap_in_ns4__updateIssue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateIssueResponse"))
		{	*type = SOAP_TYPE_ns4__updateIssueResponse;
			return soap_in_ns4__updateIssueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:archiveVersion"))
		{	*type = SOAP_TYPE_ns4__archiveVersion;
			return soap_in_ns4__archiveVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:archiveVersionResponse"))
		{	*type = SOAP_TYPE_ns4__archiveVersionResponse;
			return soap_in_ns4__archiveVersionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:releaseVersion"))
		{	*type = SOAP_TYPE_ns4__releaseVersion;
			return soap_in_ns4__releaseVersion(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:releaseVersionResponse"))
		{	*type = SOAP_TYPE_ns4__releaseVersionResponse;
			return soap_in_ns4__releaseVersionResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getFavouriteFilters"))
		{	*type = SOAP_TYPE_ns4__getFavouriteFilters;
			return soap_in_ns4__getFavouriteFilters(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getFavouriteFiltersResponse"))
		{	*type = SOAP_TYPE_ns4__getFavouriteFiltersResponse;
			return soap_in_ns4__getFavouriteFiltersResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getComments"))
		{	*type = SOAP_TYPE_ns4__getComments;
			return soap_in_ns4__getComments(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getCommentsResponse"))
		{	*type = SOAP_TYPE_ns4__getCommentsResponse;
			return soap_in_ns4__getCommentsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getCustomFields"))
		{	*type = SOAP_TYPE_ns4__getCustomFields;
			return soap_in_ns4__getCustomFields(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getCustomFieldsResponse"))
		{	*type = SOAP_TYPE_ns4__getCustomFieldsResponse;
			return soap_in_ns4__getCustomFieldsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getVersions"))
		{	*type = SOAP_TYPE_ns4__getVersions;
			return soap_in_ns4__getVersions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getVersionsResponse"))
		{	*type = SOAP_TYPE_ns4__getVersionsResponse;
			return soap_in_ns4__getVersionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectById"))
		{	*type = SOAP_TYPE_ns4__getProjectById;
			return soap_in_ns4__getProjectById(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectByIdResponse"))
		{	*type = SOAP_TYPE_ns4__getProjectByIdResponse;
			return soap_in_ns4__getProjectByIdResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteProject"))
		{	*type = SOAP_TYPE_ns4__deleteProject;
			return soap_in_ns4__deleteProject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteProjectResponse"))
		{	*type = SOAP_TYPE_ns4__deleteProjectResponse;
			return soap_in_ns4__deleteProjectResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAssociatedPermissionSchemes"))
		{	*type = SOAP_TYPE_ns4__getAssociatedPermissionSchemes;
			return soap_in_ns4__getAssociatedPermissionSchemes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAssociatedPermissionSchemesResponse"))
		{	*type = SOAP_TYPE_ns4__getAssociatedPermissionSchemesResponse;
			return soap_in_ns4__getAssociatedPermissionSchemesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAssociatedNotificationSchemes"))
		{	*type = SOAP_TYPE_ns4__getAssociatedNotificationSchemes;
			return soap_in_ns4__getAssociatedNotificationSchemes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAssociatedNotificationSchemesResponse"))
		{	*type = SOAP_TYPE_ns4__getAssociatedNotificationSchemesResponse;
			return soap_in_ns4__getAssociatedNotificationSchemesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeDefaultActorsFromProjectRole"))
		{	*type = SOAP_TYPE_ns4__removeDefaultActorsFromProjectRole;
			return soap_in_ns4__removeDefaultActorsFromProjectRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeDefaultActorsFromProjectRoleResponse"))
		{	*type = SOAP_TYPE_ns4__removeDefaultActorsFromProjectRoleResponse;
			return soap_in_ns4__removeDefaultActorsFromProjectRoleResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addDefaultActorsToProjectRole"))
		{	*type = SOAP_TYPE_ns4__addDefaultActorsToProjectRole;
			return soap_in_ns4__addDefaultActorsToProjectRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addDefaultActorsToProjectRoleResponse"))
		{	*type = SOAP_TYPE_ns4__addDefaultActorsToProjectRoleResponse;
			return soap_in_ns4__addDefaultActorsToProjectRoleResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeActorsFromProjectRole"))
		{	*type = SOAP_TYPE_ns4__removeActorsFromProjectRole;
			return soap_in_ns4__removeActorsFromProjectRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeActorsFromProjectRoleResponse"))
		{	*type = SOAP_TYPE_ns4__removeActorsFromProjectRoleResponse;
			return soap_in_ns4__removeActorsFromProjectRoleResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addActorsToProjectRole"))
		{	*type = SOAP_TYPE_ns4__addActorsToProjectRole;
			return soap_in_ns4__addActorsToProjectRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:addActorsToProjectRoleResponse"))
		{	*type = SOAP_TYPE_ns4__addActorsToProjectRoleResponse;
			return soap_in_ns4__addActorsToProjectRoleResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:isProjectRoleNameUnique"))
		{	*type = SOAP_TYPE_ns4__isProjectRoleNameUnique;
			return soap_in_ns4__isProjectRoleNameUnique(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:isProjectRoleNameUniqueResponse"))
		{	*type = SOAP_TYPE_ns4__isProjectRoleNameUniqueResponse;
			return soap_in_ns4__isProjectRoleNameUniqueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createProjectRole"))
		{	*type = SOAP_TYPE_ns4__createProjectRole;
			return soap_in_ns4__createProjectRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createProjectRoleResponse"))
		{	*type = SOAP_TYPE_ns4__createProjectRoleResponse;
			return soap_in_ns4__createProjectRoleResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateProjectRole"))
		{	*type = SOAP_TYPE_ns4__updateProjectRole;
			return soap_in_ns4__updateProjectRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateProjectRoleResponse"))
		{	*type = SOAP_TYPE_ns4__updateProjectRoleResponse;
			return soap_in_ns4__updateProjectRoleResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteProjectRole"))
		{	*type = SOAP_TYPE_ns4__deleteProjectRole;
			return soap_in_ns4__deleteProjectRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:deleteProjectRoleResponse"))
		{	*type = SOAP_TYPE_ns4__deleteProjectRoleResponse;
			return soap_in_ns4__deleteProjectRoleResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeAllRoleActorsByNameAndType"))
		{	*type = SOAP_TYPE_ns4__removeAllRoleActorsByNameAndType;
			return soap_in_ns4__removeAllRoleActorsByNameAndType(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeAllRoleActorsByNameAndTypeResponse"))
		{	*type = SOAP_TYPE_ns4__removeAllRoleActorsByNameAndTypeResponse;
			return soap_in_ns4__removeAllRoleActorsByNameAndTypeResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getDefaultRoleActors"))
		{	*type = SOAP_TYPE_ns4__getDefaultRoleActors;
			return soap_in_ns4__getDefaultRoleActors(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getDefaultRoleActorsResponse"))
		{	*type = SOAP_TYPE_ns4__getDefaultRoleActorsResponse;
			return soap_in_ns4__getDefaultRoleActorsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectRoleActors"))
		{	*type = SOAP_TYPE_ns4__getProjectRoleActors;
			return soap_in_ns4__getProjectRoleActors(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectRoleActorsResponse"))
		{	*type = SOAP_TYPE_ns4__getProjectRoleActorsResponse;
			return soap_in_ns4__getProjectRoleActorsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectRole"))
		{	*type = SOAP_TYPE_ns4__getProjectRole;
			return soap_in_ns4__getProjectRole(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectRoleResponse"))
		{	*type = SOAP_TYPE_ns4__getProjectRoleResponse;
			return soap_in_ns4__getProjectRoleResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectRoles"))
		{	*type = SOAP_TYPE_ns4__getProjectRoles;
			return soap_in_ns4__getProjectRoles(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectRolesResponse"))
		{	*type = SOAP_TYPE_ns4__getProjectRolesResponse;
			return soap_in_ns4__getProjectRolesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getStatuses"))
		{	*type = SOAP_TYPE_ns4__getStatuses;
			return soap_in_ns4__getStatuses(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getStatusesResponse"))
		{	*type = SOAP_TYPE_ns4__getStatusesResponse;
			return soap_in_ns4__getStatusesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssueTypes"))
		{	*type = SOAP_TYPE_ns4__getIssueTypes;
			return soap_in_ns4__getIssueTypes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssueTypesResponse"))
		{	*type = SOAP_TYPE_ns4__getIssueTypesResponse;
			return soap_in_ns4__getIssueTypesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getResolutions"))
		{	*type = SOAP_TYPE_ns4__getResolutions;
			return soap_in_ns4__getResolutions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getResolutionsResponse"))
		{	*type = SOAP_TYPE_ns4__getResolutionsResponse;
			return soap_in_ns4__getResolutionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getPriorities"))
		{	*type = SOAP_TYPE_ns4__getPriorities;
			return soap_in_ns4__getPriorities(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getPrioritiesResponse"))
		{	*type = SOAP_TYPE_ns4__getPrioritiesResponse;
			return soap_in_ns4__getPrioritiesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeAllRoleActorsByProject"))
		{	*type = SOAP_TYPE_ns4__removeAllRoleActorsByProject;
			return soap_in_ns4__removeAllRoleActorsByProject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:removeAllRoleActorsByProjectResponse"))
		{	*type = SOAP_TYPE_ns4__removeAllRoleActorsByProjectResponse;
			return soap_in_ns4__removeAllRoleActorsByProjectResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectByKey"))
		{	*type = SOAP_TYPE_ns4__getProjectByKey;
			return soap_in_ns4__getProjectByKey(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getProjectByKeyResponse"))
		{	*type = SOAP_TYPE_ns4__getProjectByKeyResponse;
			return soap_in_ns4__getProjectByKeyResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateProject"))
		{	*type = SOAP_TYPE_ns4__updateProject;
			return soap_in_ns4__updateProject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:updateProjectResponse"))
		{	*type = SOAP_TYPE_ns4__updateProjectResponse;
			return soap_in_ns4__updateProjectResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createProject"))
		{	*type = SOAP_TYPE_ns4__createProject;
			return soap_in_ns4__createProject(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createProjectResponse"))
		{	*type = SOAP_TYPE_ns4__createProjectResponse;
			return soap_in_ns4__createProjectResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getConfiguration"))
		{	*type = SOAP_TYPE_ns4__getConfiguration;
			return soap_in_ns4__getConfiguration(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getConfigurationResponse"))
		{	*type = SOAP_TYPE_ns4__getConfigurationResponse;
			return soap_in_ns4__getConfigurationResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSubTaskIssueTypes"))
		{	*type = SOAP_TYPE_ns4__getSubTaskIssueTypes;
			return soap_in_ns4__getSubTaskIssueTypes(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getSubTaskIssueTypesResponse"))
		{	*type = SOAP_TYPE_ns4__getSubTaskIssueTypesResponse;
			return soap_in_ns4__getSubTaskIssueTypesResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAvailableActions"))
		{	*type = SOAP_TYPE_ns4__getAvailableActions;
			return soap_in_ns4__getAvailableActions(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getAvailableActionsResponse"))
		{	*type = SOAP_TYPE_ns4__getAvailableActionsResponse;
			return soap_in_ns4__getAvailableActionsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createIssue"))
		{	*type = SOAP_TYPE_ns4__createIssue;
			return soap_in_ns4__createIssue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createIssueResponse"))
		{	*type = SOAP_TYPE_ns4__createIssueResponse;
			return soap_in_ns4__createIssueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssue"))
		{	*type = SOAP_TYPE_ns4__getIssue;
			return soap_in_ns4__getIssue(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getIssueResponse"))
		{	*type = SOAP_TYPE_ns4__getIssueResponse;
			return soap_in_ns4__getIssueResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createUser"))
		{	*type = SOAP_TYPE_ns4__createUser;
			return soap_in_ns4__createUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createUserResponse"))
		{	*type = SOAP_TYPE_ns4__createUserResponse;
			return soap_in_ns4__createUserResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getComponents"))
		{	*type = SOAP_TYPE_ns4__getComponents;
			return soap_in_ns4__getComponents(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getComponentsResponse"))
		{	*type = SOAP_TYPE_ns4__getComponentsResponse;
			return soap_in_ns4__getComponentsResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getUser"))
		{	*type = SOAP_TYPE_ns4__getUser;
			return soap_in_ns4__getUser(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getUserResponse"))
		{	*type = SOAP_TYPE_ns4__getUserResponse;
			return soap_in_ns4__getUserResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:login"))
		{	*type = SOAP_TYPE_ns4__login;
			return soap_in_ns4__login(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:loginResponse"))
		{	*type = SOAP_TYPE_ns4__loginResponse;
			return soap_in_ns4__loginResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getGroup"))
		{	*type = SOAP_TYPE_ns4__getGroup;
			return soap_in_ns4__getGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getGroupResponse"))
		{	*type = SOAP_TYPE_ns4__getGroupResponse;
			return soap_in_ns4__getGroupResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createGroup"))
		{	*type = SOAP_TYPE_ns4__createGroup;
			return soap_in_ns4__createGroup(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:createGroupResponse"))
		{	*type = SOAP_TYPE_ns4__createGroupResponse;
			return soap_in_ns4__createGroupResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getServerInfo"))
		{	*type = SOAP_TYPE_ns4__getServerInfo;
			return soap_in_ns4__getServerInfo(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getServerInfoResponse"))
		{	*type = SOAP_TYPE_ns4__getServerInfoResponse;
			return soap_in_ns4__getServerInfoResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getComment"))
		{	*type = SOAP_TYPE_ns4__getComment;
			return soap_in_ns4__getComment(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns4:getCommentResponse"))
		{	*type = SOAP_TYPE_ns4__getCommentResponse;
			return soap_in_ns4__getCommentResponse(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "xsd:QName"))
		{	char **s;
			*type = SOAP_TYPE__QName;
			s = soap_in__QName(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		if (!soap_match_tag(soap, t, "xsd:string"))
		{	char **s;
			*type = SOAP_TYPE_string;
			s = soap_in_string(soap, NULL, NULL, NULL);
			return s ? *s : NULL;
		}
		t = soap->tag;
		if (!soap_match_tag(soap, t, "ns1:RemoteValidationException"))
		{	*type = SOAP_TYPE__ns1__RemoteValidationException;
			return soap_in__ns1__RemoteValidationException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:RemotePermissionException"))
		{	*type = SOAP_TYPE__ns1__RemotePermissionException;
			return soap_in__ns1__RemotePermissionException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:RemoteException"))
		{	*type = SOAP_TYPE__ns1__RemoteException;
			return soap_in__ns1__RemoteException(soap, NULL, NULL, NULL);
		}
		if (!soap_match_tag(soap, t, "ns1:RemoteAuthenticationException"))
		{	*type = SOAP_TYPE__ns1__RemoteAuthenticationException;
			return soap_in__ns1__RemoteAuthenticationException(soap, NULL, NULL, NULL);
		}
		if (*soap->arrayType && !soap_match_array(soap, "xsd:byte"))
		{	*type = SOAP_TYPE__Struct_1;
			return soap_in__Struct_1(soap, NULL, NULL, NULL);
		}
	}
	}
	soap->error = SOAP_TAG_MISMATCH;
	return NULL;
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 int SOAP_FMAC4 soap_ignore_element(struct soap *soap)
{
	if (!soap_peek_element(soap))
	{	int t;
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Unexpected element '%s' in input (level=%u, %d)\n", soap->tag, soap->level, soap->body));
		if (soap->mustUnderstand && !soap->other)
			return soap->error = SOAP_MUSTUNDERSTAND;
		if (((soap->mode & SOAP_XML_STRICT) && soap->part != SOAP_IN_HEADER) || !soap_match_tag(soap, soap->tag, "SOAP-ENV:"))
		{	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "REJECTING element '%s'\n", soap->tag));
			return soap->error = SOAP_TAG_MISMATCH;
		}
		if (!*soap->id || !soap_getelement(soap, &t))
		{	soap->peeked = 0;
			if (soap->fignore)
				soap->error = soap->fignore(soap, soap->tag);
			else
				soap->error = SOAP_OK;
			DBGLOG(TEST, if (!soap->error) SOAP_MESSAGE(fdebug, "IGNORING element '%s'\n", soap->tag));
			if (!soap->error && soap->body)
			{	soap->level++;
				while (!soap_ignore_element(soap))
					;
				if (soap->error == SOAP_NO_TAG)
					soap->error = soap_element_end_in(soap, NULL);
			}
		}
	}
	return soap->error;
}

#ifndef WITH_NOIDREF
SOAP_FMAC3 int SOAP_FMAC4 soap_putindependent(struct soap *soap)
{
	int i;
	struct soap_plist *pp;
	if (soap->version == 1 && soap->encodingStyle && !(soap->mode & (SOAP_XML_TREE | SOAP_XML_GRAPH)))
		for (i = 0; i < SOAP_PTRHASH; i++)
			for (pp = soap->pht[i]; pp; pp = pp->next)
				if (pp->mark1 == 2 || pp->mark2 == 2)
					if (soap_putelement(soap, pp->ptr, "id", pp->id, pp->type))
						return soap->error;
	return SOAP_OK;
}
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 int SOAP_FMAC4 soap_putelement(struct soap *soap, const void *ptr, const char *tag, int id, int type)
{
	switch (type)
	{
	case SOAP_TYPE_byte:
		return soap_out_byte(soap, tag, id, (const char *)ptr, "xsd:byte");
	case SOAP_TYPE_int:
		return soap_out_int(soap, tag, id, (const int *)ptr, "xsd:int");
	case SOAP_TYPE_LONG64:
		return soap_out_LONG64(soap, tag, id, (const LONG64 *)ptr, "xsd:long");
	case SOAP_TYPE_time:
		return soap_out_time(soap, tag, id, (const time_t *)ptr, "xsd:dateTime");
	case SOAP_TYPE_bool:
		return soap_out_bool(soap, tag, id, (const bool *)ptr, "xsd:boolean");
	case SOAP_TYPE__ns1__RemoteValidationException:
		return ((_ns1__RemoteValidationException *)ptr)->soap_out(soap, "ns1:RemoteValidationException", id, NULL);
	case SOAP_TYPE__ns1__RemotePermissionException:
		return ((_ns1__RemotePermissionException *)ptr)->soap_out(soap, "ns1:RemotePermissionException", id, NULL);
	case SOAP_TYPE__ns1__RemoteException:
		return ((_ns1__RemoteException *)ptr)->soap_out(soap, "ns1:RemoteException", id, NULL);
	case SOAP_TYPE__ns1__RemoteAuthenticationException:
		return ((_ns1__RemoteAuthenticationException *)ptr)->soap_out(soap, "ns1:RemoteAuthenticationException", id, NULL);
	case SOAP_TYPE__Struct_1:
		return ((_Struct_1 *)ptr)->soap_out(soap, "ArrayOfstring", id, NULL);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject:
		return ((ArrayOf_USCOREtns1_USCORERemoteProject *)ptr)->soap_out(soap, tag, id, "ns2:RemoteProject");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue:
		return ((ArrayOf_USCOREtns1_USCORERemoteIssue *)ptr)->soap_out(soap, tag, id, "ns2:RemoteIssue");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission:
		return ((ArrayOf_USCOREtns1_USCORERemotePermission *)ptr)->soap_out(soap, tag, id, "ns2:RemotePermission");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme:
		return ((ArrayOf_USCOREtns1_USCORERemotePermissionScheme *)ptr)->soap_out(soap, tag, id, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar:
		return ((ArrayOf_USCOREtns1_USCORERemoteAvatar *)ptr)->soap_out(soap, tag, id, "ns2:RemoteAvatar");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel:
		return ((ArrayOf_USCOREtns1_USCORERemoteSecurityLevel *)ptr)->soap_out(soap, tag, id, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog:
		return ((ArrayOf_USCOREtns1_USCORERemoteWorklog *)ptr)->soap_out(soap, tag, id, "ns2:RemoteWorklog");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment:
		return ((ArrayOf_USCOREtns1_USCORERemoteAttachment *)ptr)->soap_out(soap, tag, id, "ns2:RemoteAttachment");
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary:
		return ((ArrayOf_USCORExsd_USCOREbase64Binary *)ptr)->soap_out(soap, tag, id, "xsd:byte[]");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue:
		return ((ArrayOf_USCOREtns1_USCORERemoteFieldValue *)ptr)->soap_out(soap, tag, id, "ns2:RemoteFieldValue");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter:
		return ((ArrayOf_USCOREtns1_USCORERemoteFilter *)ptr)->soap_out(soap, tag, id, "ns2:RemoteFilter");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment:
		return ((ArrayOf_USCOREtns1_USCORERemoteComment *)ptr)->soap_out(soap, tag, id, "ns2:RemoteComment");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField:
		return ((ArrayOf_USCOREtns1_USCORERemoteField *)ptr)->soap_out(soap, tag, id, "ns2:RemoteField");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme:
		return ((ArrayOf_USCOREtns1_USCORERemoteScheme *)ptr)->soap_out(soap, tag, id, "ns2:RemoteScheme");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor:
		return ((ArrayOf_USCOREtns1_USCORERemoteRoleActor *)ptr)->soap_out(soap, tag, id, "ns2:RemoteRoleActor");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole:
		return ((ArrayOf_USCOREtns1_USCORERemoteProjectRole *)ptr)->soap_out(soap, tag, id, "ns2:RemoteProjectRole");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus:
		return ((ArrayOf_USCOREtns1_USCORERemoteStatus *)ptr)->soap_out(soap, tag, id, "ns2:RemoteStatus");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution:
		return ((ArrayOf_USCOREtns1_USCORERemoteResolution *)ptr)->soap_out(soap, tag, id, "ns2:RemoteResolution");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority:
		return ((ArrayOf_USCOREtns1_USCORERemotePriority *)ptr)->soap_out(soap, tag, id, "ns2:RemotePriority");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping:
		return ((ArrayOf_USCOREtns1_USCORERemotePermissionMapping *)ptr)->soap_out(soap, tag, id, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity:
		return ((ArrayOf_USCOREtns1_USCORERemoteEntity *)ptr)->soap_out(soap, tag, id, "ns2:RemoteEntity");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType:
		return ((ArrayOf_USCOREtns1_USCORERemoteIssueType *)ptr)->soap_out(soap, tag, id, "ns2:RemoteIssueType");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject:
		return ((ArrayOf_USCOREtns1_USCORERemoteNamedObject *)ptr)->soap_out(soap, tag, id, "ns2:RemoteNamedObject");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue:
		return ((ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue *)ptr)->soap_out(soap, tag, id, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring:
		return ((ArrayOf_USCORExsd_USCOREstring *)ptr)->soap_out(soap, tag, id, "xsd:string");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion:
		return ((ArrayOf_USCOREtns1_USCORERemoteVersion *)ptr)->soap_out(soap, tag, id, "ns2:RemoteVersion");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent:
		return ((ArrayOf_USCOREtns1_USCORERemoteComponent *)ptr)->soap_out(soap, tag, id, "ns2:RemoteComponent");
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser:
		return ((ArrayOf_USCOREtns1_USCORERemoteUser *)ptr)->soap_out(soap, tag, id, "ns2:RemoteUser");
	case SOAP_TYPE_ns3__RemotePermissionException:
		return ((ns3__RemotePermissionException *)ptr)->soap_out(soap, tag, id, "ns3:RemotePermissionException");
	case SOAP_TYPE_ns3__RemoteValidationException:
		return ((ns3__RemoteValidationException *)ptr)->soap_out(soap, tag, id, "ns3:RemoteValidationException");
	case SOAP_TYPE_ns3__RemoteAuthenticationException:
		return ((ns3__RemoteAuthenticationException *)ptr)->soap_out(soap, tag, id, "ns3:RemoteAuthenticationException");
	case SOAP_TYPE_ns3__RemoteException:
		return ((ns3__RemoteException *)ptr)->soap_out(soap, tag, id, "ns3:RemoteException");
	case SOAP_TYPE_ns2__RemoteAvatar:
		return ((ns2__RemoteAvatar *)ptr)->soap_out(soap, tag, id, "ns2:RemoteAvatar");
	case SOAP_TYPE_ns2__RemoteWorklog:
		return ((ns2__RemoteWorklog *)ptr)->soap_out(soap, tag, id, "ns2:RemoteWorklog");
	case SOAP_TYPE_ns2__RemoteAttachment:
		return ((ns2__RemoteAttachment *)ptr)->soap_out(soap, tag, id, "ns2:RemoteAttachment");
	case SOAP_TYPE_ns2__RemoteSecurityLevel:
		return ((ns2__RemoteSecurityLevel *)ptr)->soap_out(soap, tag, id, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_ns2__RemoteFieldValue:
		return ((ns2__RemoteFieldValue *)ptr)->soap_out(soap, tag, id, "ns2:RemoteFieldValue");
	case SOAP_TYPE_ns2__RemoteFilter:
		return ((ns2__RemoteFilter *)ptr)->soap_out(soap, tag, id, "ns2:RemoteFilter");
	case SOAP_TYPE_ns2__RemoteField:
		return ((ns2__RemoteField *)ptr)->soap_out(soap, tag, id, "ns2:RemoteField");
	case SOAP_TYPE_ns2__RemoteProjectRoleActors:
		return ((ns2__RemoteProjectRoleActors *)ptr)->soap_out(soap, tag, id, "ns2:RemoteProjectRoleActors");
	case SOAP_TYPE_ns2__RemoteRoleActors:
		return ((ns2__RemoteRoleActors *)ptr)->soap_out(soap, tag, id, "ns2:RemoteRoleActors");
	case SOAP_TYPE_ns2__RemoteRoleActor:
		return ((ns2__RemoteRoleActor *)ptr)->soap_out(soap, tag, id, "ns2:RemoteRoleActor");
	case SOAP_TYPE_ns2__RemoteProjectRole:
		return ((ns2__RemoteProjectRole *)ptr)->soap_out(soap, tag, id, "ns2:RemoteProjectRole");
	case SOAP_TYPE_ns2__RemoteStatus:
		return ((ns2__RemoteStatus *)ptr)->soap_out(soap, tag, id, "ns2:RemoteStatus");
	case SOAP_TYPE_ns2__RemoteResolution:
		return ((ns2__RemoteResolution *)ptr)->soap_out(soap, tag, id, "ns2:RemoteResolution");
	case SOAP_TYPE_ns2__RemotePriority:
		return ((ns2__RemotePriority *)ptr)->soap_out(soap, tag, id, "ns2:RemotePriority");
	case SOAP_TYPE_ns2__RemoteProject:
		return ((ns2__RemoteProject *)ptr)->soap_out(soap, tag, id, "ns2:RemoteProject");
	case SOAP_TYPE_ns2__RemotePermissionScheme:
		return ((ns2__RemotePermissionScheme *)ptr)->soap_out(soap, tag, id, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_ns2__RemotePermissionMapping:
		return ((ns2__RemotePermissionMapping *)ptr)->soap_out(soap, tag, id, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_ns2__RemotePermission:
		return ((ns2__RemotePermission *)ptr)->soap_out(soap, tag, id, "ns2:RemotePermission");
	case SOAP_TYPE_ns2__RemoteScheme:
		return ((ns2__RemoteScheme *)ptr)->soap_out(soap, tag, id, "ns2:RemoteScheme");
	case SOAP_TYPE_ns2__RemoteConfiguration:
		return ((ns2__RemoteConfiguration *)ptr)->soap_out(soap, tag, id, "ns2:RemoteConfiguration");
	case SOAP_TYPE_ns2__RemoteIssueType:
		return ((ns2__RemoteIssueType *)ptr)->soap_out(soap, tag, id, "ns2:RemoteIssueType");
	case SOAP_TYPE_ns2__AbstractRemoteConstant:
		return ((ns2__AbstractRemoteConstant *)ptr)->soap_out(soap, tag, id, "ns2:AbstractRemoteConstant");
	case SOAP_TYPE_ns2__RemoteNamedObject:
		return ((ns2__RemoteNamedObject *)ptr)->soap_out(soap, tag, id, "ns2:RemoteNamedObject");
	case SOAP_TYPE_ns2__RemoteIssue:
		return ((ns2__RemoteIssue *)ptr)->soap_out(soap, tag, id, "ns2:RemoteIssue");
	case SOAP_TYPE_ns2__RemoteCustomFieldValue:
		return ((ns2__RemoteCustomFieldValue *)ptr)->soap_out(soap, tag, id, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_ns2__RemoteVersion:
		return ((ns2__RemoteVersion *)ptr)->soap_out(soap, tag, id, "ns2:RemoteVersion");
	case SOAP_TYPE_ns2__RemoteComponent:
		return ((ns2__RemoteComponent *)ptr)->soap_out(soap, tag, id, "ns2:RemoteComponent");
	case SOAP_TYPE_ns2__AbstractNamedRemoteEntity:
		return ((ns2__AbstractNamedRemoteEntity *)ptr)->soap_out(soap, tag, id, "ns2:AbstractNamedRemoteEntity");
	case SOAP_TYPE_ns2__AbstractRemoteEntity:
		return ((ns2__AbstractRemoteEntity *)ptr)->soap_out(soap, tag, id, "ns2:AbstractRemoteEntity");
	case SOAP_TYPE_ns2__RemoteGroup:
		return ((ns2__RemoteGroup *)ptr)->soap_out(soap, tag, id, "ns2:RemoteGroup");
	case SOAP_TYPE_ns2__RemoteUser:
		return ((ns2__RemoteUser *)ptr)->soap_out(soap, tag, id, "ns2:RemoteUser");
	case SOAP_TYPE_ns2__RemoteEntity:
		return ((ns2__RemoteEntity *)ptr)->soap_out(soap, tag, id, "ns2:RemoteEntity");
	case SOAP_TYPE_ns2__RemoteServerInfo:
		return ((ns2__RemoteServerInfo *)ptr)->soap_out(soap, tag, id, "ns2:RemoteServerInfo");
	case SOAP_TYPE_ns2__RemoteTimeInfo:
		return ((ns2__RemoteTimeInfo *)ptr)->soap_out(soap, tag, id, "ns2:RemoteTimeInfo");
	case SOAP_TYPE_ns2__RemoteComment:
		return ((ns2__RemoteComment *)ptr)->soap_out(soap, tag, id, "ns2:RemoteComment");
	case SOAP_TYPE_ns4__setNewProjectAvatar:
		return soap_out_ns4__setNewProjectAvatar(soap, tag, id, (const struct ns4__setNewProjectAvatar *)ptr, "ns4:setNewProjectAvatar");
	case SOAP_TYPE_ns4__setNewProjectAvatarResponse:
		return soap_out_ns4__setNewProjectAvatarResponse(soap, tag, id, (const struct ns4__setNewProjectAvatarResponse *)ptr, "ns4:setNewProjectAvatarResponse");
	case SOAP_TYPE_ns4__getProjectsNoSchemes:
		return soap_out_ns4__getProjectsNoSchemes(soap, tag, id, (const struct ns4__getProjectsNoSchemes *)ptr, "ns4:getProjectsNoSchemes");
	case SOAP_TYPE_ns4__getProjectsNoSchemesResponse:
		return soap_out_ns4__getProjectsNoSchemesResponse(soap, tag, id, (const struct ns4__getProjectsNoSchemesResponse *)ptr, "ns4:getProjectsNoSchemesResponse");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit:
		return soap_out_ns4__getIssuesFromTextSearchWithLimit(soap, tag, id, (const struct ns4__getIssuesFromTextSearchWithLimit *)ptr, "ns4:getIssuesFromTextSearchWithLimit");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse:
		return soap_out_ns4__getIssuesFromTextSearchWithLimitResponse(soap, tag, id, (const struct ns4__getIssuesFromTextSearchWithLimitResponse *)ptr, "ns4:getIssuesFromTextSearchWithLimitResponse");
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimit:
		return soap_out_ns4__getIssuesFromFilterWithLimit(soap, tag, id, (const struct ns4__getIssuesFromFilterWithLimit *)ptr, "ns4:getIssuesFromFilterWithLimit");
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse:
		return soap_out_ns4__getIssuesFromFilterWithLimitResponse(soap, tag, id, (const struct ns4__getIssuesFromFilterWithLimitResponse *)ptr, "ns4:getIssuesFromFilterWithLimitResponse");
	case SOAP_TYPE_ns4__getIssuesFromFilter:
		return soap_out_ns4__getIssuesFromFilter(soap, tag, id, (const struct ns4__getIssuesFromFilter *)ptr, "ns4:getIssuesFromFilter");
	case SOAP_TYPE_ns4__getIssuesFromFilterResponse:
		return soap_out_ns4__getIssuesFromFilterResponse(soap, tag, id, (const struct ns4__getIssuesFromFilterResponse *)ptr, "ns4:getIssuesFromFilterResponse");
	case SOAP_TYPE_ns4__addVersion:
		return soap_out_ns4__addVersion(soap, tag, id, (const struct ns4__addVersion *)ptr, "ns4:addVersion");
	case SOAP_TYPE_ns4__addVersionResponse:
		return soap_out_ns4__addVersionResponse(soap, tag, id, (const struct ns4__addVersionResponse *)ptr, "ns4:addVersionResponse");
	case SOAP_TYPE_ns4__getSecuritySchemes:
		return soap_out_ns4__getSecuritySchemes(soap, tag, id, (const struct ns4__getSecuritySchemes *)ptr, "ns4:getSecuritySchemes");
	case SOAP_TYPE_ns4__getSecuritySchemesResponse:
		return soap_out_ns4__getSecuritySchemesResponse(soap, tag, id, (const struct ns4__getSecuritySchemesResponse *)ptr, "ns4:getSecuritySchemesResponse");
	case SOAP_TYPE_ns4__createProjectFromObject:
		return soap_out_ns4__createProjectFromObject(soap, tag, id, (const struct ns4__createProjectFromObject *)ptr, "ns4:createProjectFromObject");
	case SOAP_TYPE_ns4__createProjectFromObjectResponse:
		return soap_out_ns4__createProjectFromObjectResponse(soap, tag, id, (const struct ns4__createProjectFromObjectResponse *)ptr, "ns4:createProjectFromObjectResponse");
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue:
		return soap_out_ns4__addBase64EncodedAttachmentsToIssue(soap, tag, id, (const struct ns4__addBase64EncodedAttachmentsToIssue *)ptr, "ns4:addBase64EncodedAttachmentsToIssue");
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse:
		return soap_out_ns4__addBase64EncodedAttachmentsToIssueResponse(soap, tag, id, (const struct ns4__addBase64EncodedAttachmentsToIssueResponse *)ptr, "ns4:addBase64EncodedAttachmentsToIssueResponse");
	case SOAP_TYPE_ns4__getSavedFilters:
		return soap_out_ns4__getSavedFilters(soap, tag, id, (const struct ns4__getSavedFilters *)ptr, "ns4:getSavedFilters");
	case SOAP_TYPE_ns4__getSavedFiltersResponse:
		return soap_out_ns4__getSavedFiltersResponse(soap, tag, id, (const struct ns4__getSavedFiltersResponse *)ptr, "ns4:getSavedFiltersResponse");
	case SOAP_TYPE_ns4__refreshCustomFields:
		return soap_out_ns4__refreshCustomFields(soap, tag, id, (const struct ns4__refreshCustomFields *)ptr, "ns4:refreshCustomFields");
	case SOAP_TYPE_ns4__refreshCustomFieldsResponse:
		return soap_out_ns4__refreshCustomFieldsResponse(soap, tag, id, (const struct ns4__refreshCustomFieldsResponse *)ptr, "ns4:refreshCustomFieldsResponse");
	case SOAP_TYPE_ns4__deleteGroup:
		return soap_out_ns4__deleteGroup(soap, tag, id, (const struct ns4__deleteGroup *)ptr, "ns4:deleteGroup");
	case SOAP_TYPE_ns4__deleteGroupResponse:
		return soap_out_ns4__deleteGroupResponse(soap, tag, id, (const struct ns4__deleteGroupResponse *)ptr, "ns4:deleteGroupResponse");
	case SOAP_TYPE_ns4__updateGroup:
		return soap_out_ns4__updateGroup(soap, tag, id, (const struct ns4__updateGroup *)ptr, "ns4:updateGroup");
	case SOAP_TYPE_ns4__updateGroupResponse:
		return soap_out_ns4__updateGroupResponse(soap, tag, id, (const struct ns4__updateGroupResponse *)ptr, "ns4:updateGroupResponse");
	case SOAP_TYPE_ns4__deleteUser:
		return soap_out_ns4__deleteUser(soap, tag, id, (const struct ns4__deleteUser *)ptr, "ns4:deleteUser");
	case SOAP_TYPE_ns4__deleteUserResponse:
		return soap_out_ns4__deleteUserResponse(soap, tag, id, (const struct ns4__deleteUserResponse *)ptr, "ns4:deleteUserResponse");
	case SOAP_TYPE_ns4__getIssuesFromJqlSearch:
		return soap_out_ns4__getIssuesFromJqlSearch(soap, tag, id, (const struct ns4__getIssuesFromJqlSearch *)ptr, "ns4:getIssuesFromJqlSearch");
	case SOAP_TYPE_ns4__getIssuesFromJqlSearchResponse:
		return soap_out_ns4__getIssuesFromJqlSearchResponse(soap, tag, id, (const struct ns4__getIssuesFromJqlSearchResponse *)ptr, "ns4:getIssuesFromJqlSearchResponse");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProject:
		return soap_out_ns4__getIssuesFromTextSearchWithProject(soap, tag, id, (const struct ns4__getIssuesFromTextSearchWithProject *)ptr, "ns4:getIssuesFromTextSearchWithProject");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProjectResponse:
		return soap_out_ns4__getIssuesFromTextSearchWithProjectResponse(soap, tag, id, (const struct ns4__getIssuesFromTextSearchWithProjectResponse *)ptr, "ns4:getIssuesFromTextSearchWithProjectResponse");
	case SOAP_TYPE_ns4__getIssuesFromTextSearch:
		return soap_out_ns4__getIssuesFromTextSearch(soap, tag, id, (const struct ns4__getIssuesFromTextSearch *)ptr, "ns4:getIssuesFromTextSearch");
	case SOAP_TYPE_ns4__getIssuesFromTextSearchResponse:
		return soap_out_ns4__getIssuesFromTextSearchResponse(soap, tag, id, (const struct ns4__getIssuesFromTextSearchResponse *)ptr, "ns4:getIssuesFromTextSearchResponse");
	case SOAP_TYPE_ns4__getIssueCountForFilter:
		return soap_out_ns4__getIssueCountForFilter(soap, tag, id, (const struct ns4__getIssueCountForFilter *)ptr, "ns4:getIssueCountForFilter");
	case SOAP_TYPE_ns4__getIssueCountForFilterResponse:
		return soap_out_ns4__getIssueCountForFilterResponse(soap, tag, id, (const struct ns4__getIssueCountForFilterResponse *)ptr, "ns4:getIssueCountForFilterResponse");
	case SOAP_TYPE_ns4__deletePermissionScheme:
		return soap_out_ns4__deletePermissionScheme(soap, tag, id, (const struct ns4__deletePermissionScheme *)ptr, "ns4:deletePermissionScheme");
	case SOAP_TYPE_ns4__deletePermissionSchemeResponse:
		return soap_out_ns4__deletePermissionSchemeResponse(soap, tag, id, (const struct ns4__deletePermissionSchemeResponse *)ptr, "ns4:deletePermissionSchemeResponse");
	case SOAP_TYPE_ns4__deletePermissionFrom:
		return soap_out_ns4__deletePermissionFrom(soap, tag, id, (const struct ns4__deletePermissionFrom *)ptr, "ns4:deletePermissionFrom");
	case SOAP_TYPE_ns4__deletePermissionFromResponse:
		return soap_out_ns4__deletePermissionFromResponse(soap, tag, id, (const struct ns4__deletePermissionFromResponse *)ptr, "ns4:deletePermissionFromResponse");
	case SOAP_TYPE_ns4__addPermissionTo:
		return soap_out_ns4__addPermissionTo(soap, tag, id, (const struct ns4__addPermissionTo *)ptr, "ns4:addPermissionTo");
	case SOAP_TYPE_ns4__addPermissionToResponse:
		return soap_out_ns4__addPermissionToResponse(soap, tag, id, (const struct ns4__addPermissionToResponse *)ptr, "ns4:addPermissionToResponse");
	case SOAP_TYPE_ns4__createPermissionScheme:
		return soap_out_ns4__createPermissionScheme(soap, tag, id, (const struct ns4__createPermissionScheme *)ptr, "ns4:createPermissionScheme");
	case SOAP_TYPE_ns4__createPermissionSchemeResponse:
		return soap_out_ns4__createPermissionSchemeResponse(soap, tag, id, (const struct ns4__createPermissionSchemeResponse *)ptr, "ns4:createPermissionSchemeResponse");
	case SOAP_TYPE_ns4__getAllPermissions:
		return soap_out_ns4__getAllPermissions(soap, tag, id, (const struct ns4__getAllPermissions *)ptr, "ns4:getAllPermissions");
	case SOAP_TYPE_ns4__getAllPermissionsResponse:
		return soap_out_ns4__getAllPermissionsResponse(soap, tag, id, (const struct ns4__getAllPermissionsResponse *)ptr, "ns4:getAllPermissionsResponse");
	case SOAP_TYPE_ns4__getPermissionSchemes:
		return soap_out_ns4__getPermissionSchemes(soap, tag, id, (const struct ns4__getPermissionSchemes *)ptr, "ns4:getPermissionSchemes");
	case SOAP_TYPE_ns4__getPermissionSchemesResponse:
		return soap_out_ns4__getPermissionSchemesResponse(soap, tag, id, (const struct ns4__getPermissionSchemesResponse *)ptr, "ns4:getPermissionSchemesResponse");
	case SOAP_TYPE_ns4__getNotificationSchemes:
		return soap_out_ns4__getNotificationSchemes(soap, tag, id, (const struct ns4__getNotificationSchemes *)ptr, "ns4:getNotificationSchemes");
	case SOAP_TYPE_ns4__getNotificationSchemesResponse:
		return soap_out_ns4__getNotificationSchemesResponse(soap, tag, id, (const struct ns4__getNotificationSchemesResponse *)ptr, "ns4:getNotificationSchemesResponse");
	case SOAP_TYPE_ns4__deleteProjectAvatar:
		return soap_out_ns4__deleteProjectAvatar(soap, tag, id, (const struct ns4__deleteProjectAvatar *)ptr, "ns4:deleteProjectAvatar");
	case SOAP_TYPE_ns4__deleteProjectAvatarResponse:
		return soap_out_ns4__deleteProjectAvatarResponse(soap, tag, id, (const struct ns4__deleteProjectAvatarResponse *)ptr, "ns4:deleteProjectAvatarResponse");
	case SOAP_TYPE_ns4__getProjectAvatar:
		return soap_out_ns4__getProjectAvatar(soap, tag, id, (const struct ns4__getProjectAvatar *)ptr, "ns4:getProjectAvatar");
	case SOAP_TYPE_ns4__getProjectAvatarResponse:
		return soap_out_ns4__getProjectAvatarResponse(soap, tag, id, (const struct ns4__getProjectAvatarResponse *)ptr, "ns4:getProjectAvatarResponse");
	case SOAP_TYPE_ns4__setProjectAvatar:
		return soap_out_ns4__setProjectAvatar(soap, tag, id, (const struct ns4__setProjectAvatar *)ptr, "ns4:setProjectAvatar");
	case SOAP_TYPE_ns4__setProjectAvatarResponse:
		return soap_out_ns4__setProjectAvatarResponse(soap, tag, id, (const struct ns4__setProjectAvatarResponse *)ptr, "ns4:setProjectAvatarResponse");
	case SOAP_TYPE_ns4__getProjectAvatars:
		return soap_out_ns4__getProjectAvatars(soap, tag, id, (const struct ns4__getProjectAvatars *)ptr, "ns4:getProjectAvatars");
	case SOAP_TYPE_ns4__getProjectAvatarsResponse:
		return soap_out_ns4__getProjectAvatarsResponse(soap, tag, id, (const struct ns4__getProjectAvatarsResponse *)ptr, "ns4:getProjectAvatarsResponse");
	case SOAP_TYPE_ns4__getSecurityLevels:
		return soap_out_ns4__getSecurityLevels(soap, tag, id, (const struct ns4__getSecurityLevels *)ptr, "ns4:getSecurityLevels");
	case SOAP_TYPE_ns4__getSecurityLevelsResponse:
		return soap_out_ns4__getSecurityLevelsResponse(soap, tag, id, (const struct ns4__getSecurityLevelsResponse *)ptr, "ns4:getSecurityLevelsResponse");
	case SOAP_TYPE_ns4__getProjectWithSchemesById:
		return soap_out_ns4__getProjectWithSchemesById(soap, tag, id, (const struct ns4__getProjectWithSchemesById *)ptr, "ns4:getProjectWithSchemesById");
	case SOAP_TYPE_ns4__getProjectWithSchemesByIdResponse:
		return soap_out_ns4__getProjectWithSchemesByIdResponse(soap, tag, id, (const struct ns4__getProjectWithSchemesByIdResponse *)ptr, "ns4:getProjectWithSchemesByIdResponse");
	case SOAP_TYPE_ns4__logout:
		return soap_out_ns4__logout(soap, tag, id, (const struct ns4__logout *)ptr, "ns4:logout");
	case SOAP_TYPE_ns4__logoutResponse:
		return soap_out_ns4__logoutResponse(soap, tag, id, (const struct ns4__logoutResponse *)ptr, "ns4:logoutResponse");
	case SOAP_TYPE_ns4__getResolutionDateById:
		return soap_out_ns4__getResolutionDateById(soap, tag, id, (const struct ns4__getResolutionDateById *)ptr, "ns4:getResolutionDateById");
	case SOAP_TYPE_ns4__getResolutionDateByIdResponse:
		return soap_out_ns4__getResolutionDateByIdResponse(soap, tag, id, (const struct ns4__getResolutionDateByIdResponse *)ptr, "ns4:getResolutionDateByIdResponse");
	case SOAP_TYPE_ns4__getResolutionDateByKey:
		return soap_out_ns4__getResolutionDateByKey(soap, tag, id, (const struct ns4__getResolutionDateByKey *)ptr, "ns4:getResolutionDateByKey");
	case SOAP_TYPE_ns4__getResolutionDateByKeyResponse:
		return soap_out_ns4__getResolutionDateByKeyResponse(soap, tag, id, (const struct ns4__getResolutionDateByKeyResponse *)ptr, "ns4:getResolutionDateByKeyResponse");
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklog:
		return soap_out_ns4__hasPermissionToUpdateWorklog(soap, tag, id, (const struct ns4__hasPermissionToUpdateWorklog *)ptr, "ns4:hasPermissionToUpdateWorklog");
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklogResponse:
		return soap_out_ns4__hasPermissionToUpdateWorklogResponse(soap, tag, id, (const struct ns4__hasPermissionToUpdateWorklogResponse *)ptr, "ns4:hasPermissionToUpdateWorklogResponse");
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklog:
		return soap_out_ns4__hasPermissionToDeleteWorklog(soap, tag, id, (const struct ns4__hasPermissionToDeleteWorklog *)ptr, "ns4:hasPermissionToDeleteWorklog");
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklogResponse:
		return soap_out_ns4__hasPermissionToDeleteWorklogResponse(soap, tag, id, (const struct ns4__hasPermissionToDeleteWorklogResponse *)ptr, "ns4:hasPermissionToDeleteWorklogResponse");
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklog:
		return soap_out_ns4__hasPermissionToCreateWorklog(soap, tag, id, (const struct ns4__hasPermissionToCreateWorklog *)ptr, "ns4:hasPermissionToCreateWorklog");
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklogResponse:
		return soap_out_ns4__hasPermissionToCreateWorklogResponse(soap, tag, id, (const struct ns4__hasPermissionToCreateWorklogResponse *)ptr, "ns4:hasPermissionToCreateWorklogResponse");
	case SOAP_TYPE_ns4__getWorklogs:
		return soap_out_ns4__getWorklogs(soap, tag, id, (const struct ns4__getWorklogs *)ptr, "ns4:getWorklogs");
	case SOAP_TYPE_ns4__getWorklogsResponse:
		return soap_out_ns4__getWorklogsResponse(soap, tag, id, (const struct ns4__getWorklogsResponse *)ptr, "ns4:getWorklogsResponse");
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimate:
		return soap_out_ns4__updateWorklogAndRetainRemainingEstimate(soap, tag, id, (const struct ns4__updateWorklogAndRetainRemainingEstimate *)ptr, "ns4:updateWorklogAndRetainRemainingEstimate");
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimateResponse:
		return soap_out_ns4__updateWorklogAndRetainRemainingEstimateResponse(soap, tag, id, (const struct ns4__updateWorklogAndRetainRemainingEstimateResponse *)ptr, "ns4:updateWorklogAndRetainRemainingEstimateResponse");
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimate:
		return soap_out_ns4__updateWorklogAndAutoAdjustRemainingEstimate(soap, tag, id, (const struct ns4__updateWorklogAndAutoAdjustRemainingEstimate *)ptr, "ns4:updateWorklogAndAutoAdjustRemainingEstimate");
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse:
		return soap_out_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse(soap, tag, id, (const struct ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse *)ptr, "ns4:updateWorklogAndAutoAdjustRemainingEstimateResponse");
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimate:
		return soap_out_ns4__updateWorklogWithNewRemainingEstimate(soap, tag, id, (const struct ns4__updateWorklogWithNewRemainingEstimate *)ptr, "ns4:updateWorklogWithNewRemainingEstimate");
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimateResponse:
		return soap_out_ns4__updateWorklogWithNewRemainingEstimateResponse(soap, tag, id, (const struct ns4__updateWorklogWithNewRemainingEstimateResponse *)ptr, "ns4:updateWorklogWithNewRemainingEstimateResponse");
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimate:
		return soap_out_ns4__deleteWorklogAndRetainRemainingEstimate(soap, tag, id, (const struct ns4__deleteWorklogAndRetainRemainingEstimate *)ptr, "ns4:deleteWorklogAndRetainRemainingEstimate");
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimateResponse:
		return soap_out_ns4__deleteWorklogAndRetainRemainingEstimateResponse(soap, tag, id, (const struct ns4__deleteWorklogAndRetainRemainingEstimateResponse *)ptr, "ns4:deleteWorklogAndRetainRemainingEstimateResponse");
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimate:
		return soap_out_ns4__deleteWorklogAndAutoAdjustRemainingEstimate(soap, tag, id, (const struct ns4__deleteWorklogAndAutoAdjustRemainingEstimate *)ptr, "ns4:deleteWorklogAndAutoAdjustRemainingEstimate");
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse:
		return soap_out_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse(soap, tag, id, (const struct ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse *)ptr, "ns4:deleteWorklogAndAutoAdjustRemainingEstimateResponse");
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimate:
		return soap_out_ns4__deleteWorklogWithNewRemainingEstimate(soap, tag, id, (const struct ns4__deleteWorklogWithNewRemainingEstimate *)ptr, "ns4:deleteWorklogWithNewRemainingEstimate");
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimateResponse:
		return soap_out_ns4__deleteWorklogWithNewRemainingEstimateResponse(soap, tag, id, (const struct ns4__deleteWorklogWithNewRemainingEstimateResponse *)ptr, "ns4:deleteWorklogWithNewRemainingEstimateResponse");
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimate:
		return soap_out_ns4__addWorklogAndRetainRemainingEstimate(soap, tag, id, (const struct ns4__addWorklogAndRetainRemainingEstimate *)ptr, "ns4:addWorklogAndRetainRemainingEstimate");
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimateResponse:
		return soap_out_ns4__addWorklogAndRetainRemainingEstimateResponse(soap, tag, id, (const struct ns4__addWorklogAndRetainRemainingEstimateResponse *)ptr, "ns4:addWorklogAndRetainRemainingEstimateResponse");
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimate:
		return soap_out_ns4__addWorklogAndAutoAdjustRemainingEstimate(soap, tag, id, (const struct ns4__addWorklogAndAutoAdjustRemainingEstimate *)ptr, "ns4:addWorklogAndAutoAdjustRemainingEstimate");
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse:
		return soap_out_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse(soap, tag, id, (const struct ns4__addWorklogAndAutoAdjustRemainingEstimateResponse *)ptr, "ns4:addWorklogAndAutoAdjustRemainingEstimateResponse");
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimate:
		return soap_out_ns4__addWorklogWithNewRemainingEstimate(soap, tag, id, (const struct ns4__addWorklogWithNewRemainingEstimate *)ptr, "ns4:addWorklogWithNewRemainingEstimate");
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimateResponse:
		return soap_out_ns4__addWorklogWithNewRemainingEstimateResponse(soap, tag, id, (const struct ns4__addWorklogWithNewRemainingEstimateResponse *)ptr, "ns4:addWorklogWithNewRemainingEstimateResponse");
	case SOAP_TYPE_ns4__getIssueById:
		return soap_out_ns4__getIssueById(soap, tag, id, (const struct ns4__getIssueById *)ptr, "ns4:getIssueById");
	case SOAP_TYPE_ns4__getIssueByIdResponse:
		return soap_out_ns4__getIssueByIdResponse(soap, tag, id, (const struct ns4__getIssueByIdResponse *)ptr, "ns4:getIssueByIdResponse");
	case SOAP_TYPE_ns4__progressWorkflowAction:
		return soap_out_ns4__progressWorkflowAction(soap, tag, id, (const struct ns4__progressWorkflowAction *)ptr, "ns4:progressWorkflowAction");
	case SOAP_TYPE_ns4__progressWorkflowActionResponse:
		return soap_out_ns4__progressWorkflowActionResponse(soap, tag, id, (const struct ns4__progressWorkflowActionResponse *)ptr, "ns4:progressWorkflowActionResponse");
	case SOAP_TYPE_ns4__getFieldsForAction:
		return soap_out_ns4__getFieldsForAction(soap, tag, id, (const struct ns4__getFieldsForAction *)ptr, "ns4:getFieldsForAction");
	case SOAP_TYPE_ns4__getFieldsForActionResponse:
		return soap_out_ns4__getFieldsForActionResponse(soap, tag, id, (const struct ns4__getFieldsForActionResponse *)ptr, "ns4:getFieldsForActionResponse");
	case SOAP_TYPE_ns4__editComment:
		return soap_out_ns4__editComment(soap, tag, id, (const struct ns4__editComment *)ptr, "ns4:editComment");
	case SOAP_TYPE_ns4__editCommentResponse:
		return soap_out_ns4__editCommentResponse(soap, tag, id, (const struct ns4__editCommentResponse *)ptr, "ns4:editCommentResponse");
	case SOAP_TYPE_ns4__hasPermissionToEditComment:
		return soap_out_ns4__hasPermissionToEditComment(soap, tag, id, (const struct ns4__hasPermissionToEditComment *)ptr, "ns4:hasPermissionToEditComment");
	case SOAP_TYPE_ns4__hasPermissionToEditCommentResponse:
		return soap_out_ns4__hasPermissionToEditCommentResponse(soap, tag, id, (const struct ns4__hasPermissionToEditCommentResponse *)ptr, "ns4:hasPermissionToEditCommentResponse");
	case SOAP_TYPE_ns4__deleteIssue:
		return soap_out_ns4__deleteIssue(soap, tag, id, (const struct ns4__deleteIssue *)ptr, "ns4:deleteIssue");
	case SOAP_TYPE_ns4__deleteIssueResponse:
		return soap_out_ns4__deleteIssueResponse(soap, tag, id, (const struct ns4__deleteIssueResponse *)ptr, "ns4:deleteIssueResponse");
	case SOAP_TYPE_ns4__getAttachmentsFromIssue:
		return soap_out_ns4__getAttachmentsFromIssue(soap, tag, id, (const struct ns4__getAttachmentsFromIssue *)ptr, "ns4:getAttachmentsFromIssue");
	case SOAP_TYPE_ns4__getAttachmentsFromIssueResponse:
		return soap_out_ns4__getAttachmentsFromIssueResponse(soap, tag, id, (const struct ns4__getAttachmentsFromIssueResponse *)ptr, "ns4:getAttachmentsFromIssueResponse");
	case SOAP_TYPE_ns4__addAttachmentsToIssue:
		return soap_out_ns4__addAttachmentsToIssue(soap, tag, id, (const struct ns4__addAttachmentsToIssue *)ptr, "ns4:addAttachmentsToIssue");
	case SOAP_TYPE_ns4__addAttachmentsToIssueResponse:
		return soap_out_ns4__addAttachmentsToIssueResponse(soap, tag, id, (const struct ns4__addAttachmentsToIssueResponse *)ptr, "ns4:addAttachmentsToIssueResponse");
	case SOAP_TYPE_ns4__createIssueWithSecurityLevel:
		return soap_out_ns4__createIssueWithSecurityLevel(soap, tag, id, (const struct ns4__createIssueWithSecurityLevel *)ptr, "ns4:createIssueWithSecurityLevel");
	case SOAP_TYPE_ns4__createIssueWithSecurityLevelResponse:
		return soap_out_ns4__createIssueWithSecurityLevelResponse(soap, tag, id, (const struct ns4__createIssueWithSecurityLevelResponse *)ptr, "ns4:createIssueWithSecurityLevelResponse");
	case SOAP_TYPE_ns4__addComment:
		return soap_out_ns4__addComment(soap, tag, id, (const struct ns4__addComment *)ptr, "ns4:addComment");
	case SOAP_TYPE_ns4__addCommentResponse:
		return soap_out_ns4__addCommentResponse(soap, tag, id, (const struct ns4__addCommentResponse *)ptr, "ns4:addCommentResponse");
	case SOAP_TYPE_ns4__getSecurityLevel:
		return soap_out_ns4__getSecurityLevel(soap, tag, id, (const struct ns4__getSecurityLevel *)ptr, "ns4:getSecurityLevel");
	case SOAP_TYPE_ns4__getSecurityLevelResponse:
		return soap_out_ns4__getSecurityLevelResponse(soap, tag, id, (const struct ns4__getSecurityLevelResponse *)ptr, "ns4:getSecurityLevelResponse");
	case SOAP_TYPE_ns4__removeUserFromGroup:
		return soap_out_ns4__removeUserFromGroup(soap, tag, id, (const struct ns4__removeUserFromGroup *)ptr, "ns4:removeUserFromGroup");
	case SOAP_TYPE_ns4__removeUserFromGroupResponse:
		return soap_out_ns4__removeUserFromGroupResponse(soap, tag, id, (const struct ns4__removeUserFromGroupResponse *)ptr, "ns4:removeUserFromGroupResponse");
	case SOAP_TYPE_ns4__addUserToGroup:
		return soap_out_ns4__addUserToGroup(soap, tag, id, (const struct ns4__addUserToGroup *)ptr, "ns4:addUserToGroup");
	case SOAP_TYPE_ns4__addUserToGroupResponse:
		return soap_out_ns4__addUserToGroupResponse(soap, tag, id, (const struct ns4__addUserToGroupResponse *)ptr, "ns4:addUserToGroupResponse");
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProject:
		return soap_out_ns4__getSubTaskIssueTypesForProject(soap, tag, id, (const struct ns4__getSubTaskIssueTypesForProject *)ptr, "ns4:getSubTaskIssueTypesForProject");
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProjectResponse:
		return soap_out_ns4__getSubTaskIssueTypesForProjectResponse(soap, tag, id, (const struct ns4__getSubTaskIssueTypesForProjectResponse *)ptr, "ns4:getSubTaskIssueTypesForProjectResponse");
	case SOAP_TYPE_ns4__getIssueTypesForProject:
		return soap_out_ns4__getIssueTypesForProject(soap, tag, id, (const struct ns4__getIssueTypesForProject *)ptr, "ns4:getIssueTypesForProject");
	case SOAP_TYPE_ns4__getIssueTypesForProjectResponse:
		return soap_out_ns4__getIssueTypesForProjectResponse(soap, tag, id, (const struct ns4__getIssueTypesForProjectResponse *)ptr, "ns4:getIssueTypesForProjectResponse");
	case SOAP_TYPE_ns4__getFieldsForEdit:
		return soap_out_ns4__getFieldsForEdit(soap, tag, id, (const struct ns4__getFieldsForEdit *)ptr, "ns4:getFieldsForEdit");
	case SOAP_TYPE_ns4__getFieldsForEditResponse:
		return soap_out_ns4__getFieldsForEditResponse(soap, tag, id, (const struct ns4__getFieldsForEditResponse *)ptr, "ns4:getFieldsForEditResponse");
	case SOAP_TYPE_ns4__updateIssue:
		return soap_out_ns4__updateIssue(soap, tag, id, (const struct ns4__updateIssue *)ptr, "ns4:updateIssue");
	case SOAP_TYPE_ns4__updateIssueResponse:
		return soap_out_ns4__updateIssueResponse(soap, tag, id, (const struct ns4__updateIssueResponse *)ptr, "ns4:updateIssueResponse");
	case SOAP_TYPE_ns4__archiveVersion:
		return soap_out_ns4__archiveVersion(soap, tag, id, (const struct ns4__archiveVersion *)ptr, "ns4:archiveVersion");
	case SOAP_TYPE_ns4__archiveVersionResponse:
		return soap_out_ns4__archiveVersionResponse(soap, tag, id, (const struct ns4__archiveVersionResponse *)ptr, "ns4:archiveVersionResponse");
	case SOAP_TYPE_ns4__releaseVersion:
		return soap_out_ns4__releaseVersion(soap, tag, id, (const struct ns4__releaseVersion *)ptr, "ns4:releaseVersion");
	case SOAP_TYPE_ns4__releaseVersionResponse:
		return soap_out_ns4__releaseVersionResponse(soap, tag, id, (const struct ns4__releaseVersionResponse *)ptr, "ns4:releaseVersionResponse");
	case SOAP_TYPE_ns4__getFavouriteFilters:
		return soap_out_ns4__getFavouriteFilters(soap, tag, id, (const struct ns4__getFavouriteFilters *)ptr, "ns4:getFavouriteFilters");
	case SOAP_TYPE_ns4__getFavouriteFiltersResponse:
		return soap_out_ns4__getFavouriteFiltersResponse(soap, tag, id, (const struct ns4__getFavouriteFiltersResponse *)ptr, "ns4:getFavouriteFiltersResponse");
	case SOAP_TYPE_ns4__getComments:
		return soap_out_ns4__getComments(soap, tag, id, (const struct ns4__getComments *)ptr, "ns4:getComments");
	case SOAP_TYPE_ns4__getCommentsResponse:
		return soap_out_ns4__getCommentsResponse(soap, tag, id, (const struct ns4__getCommentsResponse *)ptr, "ns4:getCommentsResponse");
	case SOAP_TYPE_ns4__getCustomFields:
		return soap_out_ns4__getCustomFields(soap, tag, id, (const struct ns4__getCustomFields *)ptr, "ns4:getCustomFields");
	case SOAP_TYPE_ns4__getCustomFieldsResponse:
		return soap_out_ns4__getCustomFieldsResponse(soap, tag, id, (const struct ns4__getCustomFieldsResponse *)ptr, "ns4:getCustomFieldsResponse");
	case SOAP_TYPE_ns4__getVersions:
		return soap_out_ns4__getVersions(soap, tag, id, (const struct ns4__getVersions *)ptr, "ns4:getVersions");
	case SOAP_TYPE_ns4__getVersionsResponse:
		return soap_out_ns4__getVersionsResponse(soap, tag, id, (const struct ns4__getVersionsResponse *)ptr, "ns4:getVersionsResponse");
	case SOAP_TYPE_ns4__getProjectById:
		return soap_out_ns4__getProjectById(soap, tag, id, (const struct ns4__getProjectById *)ptr, "ns4:getProjectById");
	case SOAP_TYPE_ns4__getProjectByIdResponse:
		return soap_out_ns4__getProjectByIdResponse(soap, tag, id, (const struct ns4__getProjectByIdResponse *)ptr, "ns4:getProjectByIdResponse");
	case SOAP_TYPE_ns4__deleteProject:
		return soap_out_ns4__deleteProject(soap, tag, id, (const struct ns4__deleteProject *)ptr, "ns4:deleteProject");
	case SOAP_TYPE_ns4__deleteProjectResponse:
		return soap_out_ns4__deleteProjectResponse(soap, tag, id, (const struct ns4__deleteProjectResponse *)ptr, "ns4:deleteProjectResponse");
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemes:
		return soap_out_ns4__getAssociatedPermissionSchemes(soap, tag, id, (const struct ns4__getAssociatedPermissionSchemes *)ptr, "ns4:getAssociatedPermissionSchemes");
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemesResponse:
		return soap_out_ns4__getAssociatedPermissionSchemesResponse(soap, tag, id, (const struct ns4__getAssociatedPermissionSchemesResponse *)ptr, "ns4:getAssociatedPermissionSchemesResponse");
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemes:
		return soap_out_ns4__getAssociatedNotificationSchemes(soap, tag, id, (const struct ns4__getAssociatedNotificationSchemes *)ptr, "ns4:getAssociatedNotificationSchemes");
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemesResponse:
		return soap_out_ns4__getAssociatedNotificationSchemesResponse(soap, tag, id, (const struct ns4__getAssociatedNotificationSchemesResponse *)ptr, "ns4:getAssociatedNotificationSchemesResponse");
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRole:
		return soap_out_ns4__removeDefaultActorsFromProjectRole(soap, tag, id, (const struct ns4__removeDefaultActorsFromProjectRole *)ptr, "ns4:removeDefaultActorsFromProjectRole");
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRoleResponse:
		return soap_out_ns4__removeDefaultActorsFromProjectRoleResponse(soap, tag, id, (const struct ns4__removeDefaultActorsFromProjectRoleResponse *)ptr, "ns4:removeDefaultActorsFromProjectRoleResponse");
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRole:
		return soap_out_ns4__addDefaultActorsToProjectRole(soap, tag, id, (const struct ns4__addDefaultActorsToProjectRole *)ptr, "ns4:addDefaultActorsToProjectRole");
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRoleResponse:
		return soap_out_ns4__addDefaultActorsToProjectRoleResponse(soap, tag, id, (const struct ns4__addDefaultActorsToProjectRoleResponse *)ptr, "ns4:addDefaultActorsToProjectRoleResponse");
	case SOAP_TYPE_ns4__removeActorsFromProjectRole:
		return soap_out_ns4__removeActorsFromProjectRole(soap, tag, id, (const struct ns4__removeActorsFromProjectRole *)ptr, "ns4:removeActorsFromProjectRole");
	case SOAP_TYPE_ns4__removeActorsFromProjectRoleResponse:
		return soap_out_ns4__removeActorsFromProjectRoleResponse(soap, tag, id, (const struct ns4__removeActorsFromProjectRoleResponse *)ptr, "ns4:removeActorsFromProjectRoleResponse");
	case SOAP_TYPE_ns4__addActorsToProjectRole:
		return soap_out_ns4__addActorsToProjectRole(soap, tag, id, (const struct ns4__addActorsToProjectRole *)ptr, "ns4:addActorsToProjectRole");
	case SOAP_TYPE_ns4__addActorsToProjectRoleResponse:
		return soap_out_ns4__addActorsToProjectRoleResponse(soap, tag, id, (const struct ns4__addActorsToProjectRoleResponse *)ptr, "ns4:addActorsToProjectRoleResponse");
	case SOAP_TYPE_ns4__isProjectRoleNameUnique:
		return soap_out_ns4__isProjectRoleNameUnique(soap, tag, id, (const struct ns4__isProjectRoleNameUnique *)ptr, "ns4:isProjectRoleNameUnique");
	case SOAP_TYPE_ns4__isProjectRoleNameUniqueResponse:
		return soap_out_ns4__isProjectRoleNameUniqueResponse(soap, tag, id, (const struct ns4__isProjectRoleNameUniqueResponse *)ptr, "ns4:isProjectRoleNameUniqueResponse");
	case SOAP_TYPE_ns4__createProjectRole:
		return soap_out_ns4__createProjectRole(soap, tag, id, (const struct ns4__createProjectRole *)ptr, "ns4:createProjectRole");
	case SOAP_TYPE_ns4__createProjectRoleResponse:
		return soap_out_ns4__createProjectRoleResponse(soap, tag, id, (const struct ns4__createProjectRoleResponse *)ptr, "ns4:createProjectRoleResponse");
	case SOAP_TYPE_ns4__updateProjectRole:
		return soap_out_ns4__updateProjectRole(soap, tag, id, (const struct ns4__updateProjectRole *)ptr, "ns4:updateProjectRole");
	case SOAP_TYPE_ns4__updateProjectRoleResponse:
		return soap_out_ns4__updateProjectRoleResponse(soap, tag, id, (const struct ns4__updateProjectRoleResponse *)ptr, "ns4:updateProjectRoleResponse");
	case SOAP_TYPE_ns4__deleteProjectRole:
		return soap_out_ns4__deleteProjectRole(soap, tag, id, (const struct ns4__deleteProjectRole *)ptr, "ns4:deleteProjectRole");
	case SOAP_TYPE_ns4__deleteProjectRoleResponse:
		return soap_out_ns4__deleteProjectRoleResponse(soap, tag, id, (const struct ns4__deleteProjectRoleResponse *)ptr, "ns4:deleteProjectRoleResponse");
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndType:
		return soap_out_ns4__removeAllRoleActorsByNameAndType(soap, tag, id, (const struct ns4__removeAllRoleActorsByNameAndType *)ptr, "ns4:removeAllRoleActorsByNameAndType");
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndTypeResponse:
		return soap_out_ns4__removeAllRoleActorsByNameAndTypeResponse(soap, tag, id, (const struct ns4__removeAllRoleActorsByNameAndTypeResponse *)ptr, "ns4:removeAllRoleActorsByNameAndTypeResponse");
	case SOAP_TYPE_ns4__getDefaultRoleActors:
		return soap_out_ns4__getDefaultRoleActors(soap, tag, id, (const struct ns4__getDefaultRoleActors *)ptr, "ns4:getDefaultRoleActors");
	case SOAP_TYPE_ns4__getDefaultRoleActorsResponse:
		return soap_out_ns4__getDefaultRoleActorsResponse(soap, tag, id, (const struct ns4__getDefaultRoleActorsResponse *)ptr, "ns4:getDefaultRoleActorsResponse");
	case SOAP_TYPE_ns4__getProjectRoleActors:
		return soap_out_ns4__getProjectRoleActors(soap, tag, id, (const struct ns4__getProjectRoleActors *)ptr, "ns4:getProjectRoleActors");
	case SOAP_TYPE_ns4__getProjectRoleActorsResponse:
		return soap_out_ns4__getProjectRoleActorsResponse(soap, tag, id, (const struct ns4__getProjectRoleActorsResponse *)ptr, "ns4:getProjectRoleActorsResponse");
	case SOAP_TYPE_ns4__getProjectRole:
		return soap_out_ns4__getProjectRole(soap, tag, id, (const struct ns4__getProjectRole *)ptr, "ns4:getProjectRole");
	case SOAP_TYPE_ns4__getProjectRoleResponse:
		return soap_out_ns4__getProjectRoleResponse(soap, tag, id, (const struct ns4__getProjectRoleResponse *)ptr, "ns4:getProjectRoleResponse");
	case SOAP_TYPE_ns4__getProjectRoles:
		return soap_out_ns4__getProjectRoles(soap, tag, id, (const struct ns4__getProjectRoles *)ptr, "ns4:getProjectRoles");
	case SOAP_TYPE_ns4__getProjectRolesResponse:
		return soap_out_ns4__getProjectRolesResponse(soap, tag, id, (const struct ns4__getProjectRolesResponse *)ptr, "ns4:getProjectRolesResponse");
	case SOAP_TYPE_ns4__getStatuses:
		return soap_out_ns4__getStatuses(soap, tag, id, (const struct ns4__getStatuses *)ptr, "ns4:getStatuses");
	case SOAP_TYPE_ns4__getStatusesResponse:
		return soap_out_ns4__getStatusesResponse(soap, tag, id, (const struct ns4__getStatusesResponse *)ptr, "ns4:getStatusesResponse");
	case SOAP_TYPE_ns4__getIssueTypes:
		return soap_out_ns4__getIssueTypes(soap, tag, id, (const struct ns4__getIssueTypes *)ptr, "ns4:getIssueTypes");
	case SOAP_TYPE_ns4__getIssueTypesResponse:
		return soap_out_ns4__getIssueTypesResponse(soap, tag, id, (const struct ns4__getIssueTypesResponse *)ptr, "ns4:getIssueTypesResponse");
	case SOAP_TYPE_ns4__getResolutions:
		return soap_out_ns4__getResolutions(soap, tag, id, (const struct ns4__getResolutions *)ptr, "ns4:getResolutions");
	case SOAP_TYPE_ns4__getResolutionsResponse:
		return soap_out_ns4__getResolutionsResponse(soap, tag, id, (const struct ns4__getResolutionsResponse *)ptr, "ns4:getResolutionsResponse");
	case SOAP_TYPE_ns4__getPriorities:
		return soap_out_ns4__getPriorities(soap, tag, id, (const struct ns4__getPriorities *)ptr, "ns4:getPriorities");
	case SOAP_TYPE_ns4__getPrioritiesResponse:
		return soap_out_ns4__getPrioritiesResponse(soap, tag, id, (const struct ns4__getPrioritiesResponse *)ptr, "ns4:getPrioritiesResponse");
	case SOAP_TYPE_ns4__removeAllRoleActorsByProject:
		return soap_out_ns4__removeAllRoleActorsByProject(soap, tag, id, (const struct ns4__removeAllRoleActorsByProject *)ptr, "ns4:removeAllRoleActorsByProject");
	case SOAP_TYPE_ns4__removeAllRoleActorsByProjectResponse:
		return soap_out_ns4__removeAllRoleActorsByProjectResponse(soap, tag, id, (const struct ns4__removeAllRoleActorsByProjectResponse *)ptr, "ns4:removeAllRoleActorsByProjectResponse");
	case SOAP_TYPE_ns4__getProjectByKey:
		return soap_out_ns4__getProjectByKey(soap, tag, id, (const struct ns4__getProjectByKey *)ptr, "ns4:getProjectByKey");
	case SOAP_TYPE_ns4__getProjectByKeyResponse:
		return soap_out_ns4__getProjectByKeyResponse(soap, tag, id, (const struct ns4__getProjectByKeyResponse *)ptr, "ns4:getProjectByKeyResponse");
	case SOAP_TYPE_ns4__updateProject:
		return soap_out_ns4__updateProject(soap, tag, id, (const struct ns4__updateProject *)ptr, "ns4:updateProject");
	case SOAP_TYPE_ns4__updateProjectResponse:
		return soap_out_ns4__updateProjectResponse(soap, tag, id, (const struct ns4__updateProjectResponse *)ptr, "ns4:updateProjectResponse");
	case SOAP_TYPE_ns4__createProject:
		return soap_out_ns4__createProject(soap, tag, id, (const struct ns4__createProject *)ptr, "ns4:createProject");
	case SOAP_TYPE_ns4__createProjectResponse:
		return soap_out_ns4__createProjectResponse(soap, tag, id, (const struct ns4__createProjectResponse *)ptr, "ns4:createProjectResponse");
	case SOAP_TYPE_ns4__getConfiguration:
		return soap_out_ns4__getConfiguration(soap, tag, id, (const struct ns4__getConfiguration *)ptr, "ns4:getConfiguration");
	case SOAP_TYPE_ns4__getConfigurationResponse:
		return soap_out_ns4__getConfigurationResponse(soap, tag, id, (const struct ns4__getConfigurationResponse *)ptr, "ns4:getConfigurationResponse");
	case SOAP_TYPE_ns4__getSubTaskIssueTypes:
		return soap_out_ns4__getSubTaskIssueTypes(soap, tag, id, (const struct ns4__getSubTaskIssueTypes *)ptr, "ns4:getSubTaskIssueTypes");
	case SOAP_TYPE_ns4__getSubTaskIssueTypesResponse:
		return soap_out_ns4__getSubTaskIssueTypesResponse(soap, tag, id, (const struct ns4__getSubTaskIssueTypesResponse *)ptr, "ns4:getSubTaskIssueTypesResponse");
	case SOAP_TYPE_ns4__getAvailableActions:
		return soap_out_ns4__getAvailableActions(soap, tag, id, (const struct ns4__getAvailableActions *)ptr, "ns4:getAvailableActions");
	case SOAP_TYPE_ns4__getAvailableActionsResponse:
		return soap_out_ns4__getAvailableActionsResponse(soap, tag, id, (const struct ns4__getAvailableActionsResponse *)ptr, "ns4:getAvailableActionsResponse");
	case SOAP_TYPE_ns4__createIssue:
		return soap_out_ns4__createIssue(soap, tag, id, (const struct ns4__createIssue *)ptr, "ns4:createIssue");
	case SOAP_TYPE_ns4__createIssueResponse:
		return soap_out_ns4__createIssueResponse(soap, tag, id, (const struct ns4__createIssueResponse *)ptr, "ns4:createIssueResponse");
	case SOAP_TYPE_ns4__getIssue:
		return soap_out_ns4__getIssue(soap, tag, id, (const struct ns4__getIssue *)ptr, "ns4:getIssue");
	case SOAP_TYPE_ns4__getIssueResponse:
		return soap_out_ns4__getIssueResponse(soap, tag, id, (const struct ns4__getIssueResponse *)ptr, "ns4:getIssueResponse");
	case SOAP_TYPE_ns4__createUser:
		return soap_out_ns4__createUser(soap, tag, id, (const struct ns4__createUser *)ptr, "ns4:createUser");
	case SOAP_TYPE_ns4__createUserResponse:
		return soap_out_ns4__createUserResponse(soap, tag, id, (const struct ns4__createUserResponse *)ptr, "ns4:createUserResponse");
	case SOAP_TYPE_ns4__getComponents:
		return soap_out_ns4__getComponents(soap, tag, id, (const struct ns4__getComponents *)ptr, "ns4:getComponents");
	case SOAP_TYPE_ns4__getComponentsResponse:
		return soap_out_ns4__getComponentsResponse(soap, tag, id, (const struct ns4__getComponentsResponse *)ptr, "ns4:getComponentsResponse");
	case SOAP_TYPE_ns4__getUser:
		return soap_out_ns4__getUser(soap, tag, id, (const struct ns4__getUser *)ptr, "ns4:getUser");
	case SOAP_TYPE_ns4__getUserResponse:
		return soap_out_ns4__getUserResponse(soap, tag, id, (const struct ns4__getUserResponse *)ptr, "ns4:getUserResponse");
	case SOAP_TYPE_ns4__login:
		return soap_out_ns4__login(soap, tag, id, (const struct ns4__login *)ptr, "ns4:login");
	case SOAP_TYPE_ns4__loginResponse:
		return soap_out_ns4__loginResponse(soap, tag, id, (const struct ns4__loginResponse *)ptr, "ns4:loginResponse");
	case SOAP_TYPE_ns4__getGroup:
		return soap_out_ns4__getGroup(soap, tag, id, (const struct ns4__getGroup *)ptr, "ns4:getGroup");
	case SOAP_TYPE_ns4__getGroupResponse:
		return soap_out_ns4__getGroupResponse(soap, tag, id, (const struct ns4__getGroupResponse *)ptr, "ns4:getGroupResponse");
	case SOAP_TYPE_ns4__createGroup:
		return soap_out_ns4__createGroup(soap, tag, id, (const struct ns4__createGroup *)ptr, "ns4:createGroup");
	case SOAP_TYPE_ns4__createGroupResponse:
		return soap_out_ns4__createGroupResponse(soap, tag, id, (const struct ns4__createGroupResponse *)ptr, "ns4:createGroupResponse");
	case SOAP_TYPE_ns4__getServerInfo:
		return soap_out_ns4__getServerInfo(soap, tag, id, (const struct ns4__getServerInfo *)ptr, "ns4:getServerInfo");
	case SOAP_TYPE_ns4__getServerInfoResponse:
		return soap_out_ns4__getServerInfoResponse(soap, tag, id, (const struct ns4__getServerInfoResponse *)ptr, "ns4:getServerInfoResponse");
	case SOAP_TYPE_ns4__getComment:
		return soap_out_ns4__getComment(soap, tag, id, (const struct ns4__getComment *)ptr, "ns4:getComment");
	case SOAP_TYPE_ns4__getCommentResponse:
		return soap_out_ns4__getCommentResponse(soap, tag, id, (const struct ns4__getCommentResponse *)ptr, "ns4:getCommentResponse");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteProject:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteProject(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteProject *const*)ptr, "ns2:RemoteProject");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteIssue:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteIssue *const*)ptr, "ns2:RemoteIssue");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePermission:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemotePermission(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemotePermission *const*)ptr, "ns2:RemotePermission");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePermissionScheme:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemotePermissionScheme *const*)ptr, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteAvatar:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteAvatar(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteAvatar *const*)ptr, "ns2:RemoteAvatar");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteSecurityLevel:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteSecurityLevel *const*)ptr, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteWorklog:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteWorklog(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteWorklog *const*)ptr, "ns2:RemoteWorklog");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteAttachment:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteAttachment(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteAttachment *const*)ptr, "ns2:RemoteAttachment");
	case SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREbase64Binary:
		return soap_out_PointerToArrayOf_USCORExsd_USCOREbase64Binary(soap, tag, id, (ArrayOf_USCORExsd_USCOREbase64Binary *const*)ptr, "xsd:byte[]");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteFieldValue:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteFieldValue *const*)ptr, "ns2:RemoteFieldValue");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteFilter:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteFilter(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteFilter *const*)ptr, "ns2:RemoteFilter");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteComment:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteComment(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteComment *const*)ptr, "ns2:RemoteComment");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteField:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteField(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteField *const*)ptr, "ns2:RemoteField");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteScheme:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteScheme(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteScheme *const*)ptr, "ns2:RemoteScheme");
	case SOAP_TYPE_PointerTons2__RemoteRoleActors:
		return soap_out_PointerTons2__RemoteRoleActors(soap, tag, id, (ns2__RemoteRoleActors *const*)ptr, "ns2:RemoteRoleActors");
	case SOAP_TYPE_PointerTons2__RemoteProjectRoleActors:
		return soap_out_PointerTons2__RemoteProjectRoleActors(soap, tag, id, (ns2__RemoteProjectRoleActors *const*)ptr, "ns2:RemoteProjectRoleActors");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteProjectRole:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteProjectRole *const*)ptr, "ns2:RemoteProjectRole");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteStatus:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteStatus(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteStatus *const*)ptr, "ns2:RemoteStatus");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteResolution:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteResolution(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteResolution *const*)ptr, "ns2:RemoteResolution");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePriority:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemotePriority(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemotePriority *const*)ptr, "ns2:RemotePriority");
	case SOAP_TYPE_PointerTons2__RemoteConfiguration:
		return soap_out_PointerTons2__RemoteConfiguration(soap, tag, id, (ns2__RemoteConfiguration *const*)ptr, "ns2:RemoteConfiguration");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteIssueType:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteIssueType(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteIssueType *const*)ptr, "ns2:RemoteIssueType");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteNamedObject:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteNamedObject *const*)ptr, "ns2:RemoteNamedObject");
	case SOAP_TYPE_PointerTons2__RemoteGroup:
		return soap_out_PointerTons2__RemoteGroup(soap, tag, id, (ns2__RemoteGroup *const*)ptr, "ns2:RemoteGroup");
	case SOAP_TYPE_PointerTons2__RemoteServerInfo:
		return soap_out_PointerTons2__RemoteServerInfo(soap, tag, id, (ns2__RemoteServerInfo *const*)ptr, "ns2:RemoteServerInfo");
	case SOAP_TYPE_PointerTo_ns1__RemoteValidationException:
		return soap_out_PointerTo_ns1__RemoteValidationException(soap, tag, id, (_ns1__RemoteValidationException *const*)ptr, "ns1:RemoteValidationException");
	case SOAP_TYPE_PointerTo_ns1__RemotePermissionException:
		return soap_out_PointerTo_ns1__RemotePermissionException(soap, tag, id, (_ns1__RemotePermissionException *const*)ptr, "ns1:RemotePermissionException");
	case SOAP_TYPE_PointerTo_ns1__RemoteException:
		return soap_out_PointerTo_ns1__RemoteException(soap, tag, id, (_ns1__RemoteException *const*)ptr, "ns1:RemoteException");
	case SOAP_TYPE_PointerTo_ns1__RemoteAuthenticationException:
		return soap_out_PointerTo_ns1__RemoteAuthenticationException(soap, tag, id, (_ns1__RemoteAuthenticationException *const*)ptr, "ns1:RemoteAuthenticationException");
	case SOAP_TYPE_PointerTons3__RemoteValidationException:
		return soap_out_PointerTons3__RemoteValidationException(soap, tag, id, (ns3__RemoteValidationException *const*)ptr, "ns3:RemoteValidationException");
	case SOAP_TYPE_PointerTons3__RemotePermissionException:
		return soap_out_PointerTons3__RemotePermissionException(soap, tag, id, (ns3__RemotePermissionException *const*)ptr, "ns3:RemotePermissionException");
	case SOAP_TYPE_PointerTons3__RemoteException:
		return soap_out_PointerTons3__RemoteException(soap, tag, id, (ns3__RemoteException *const*)ptr, "ns3:RemoteException");
	case SOAP_TYPE_PointerTons3__RemoteAuthenticationException:
		return soap_out_PointerTons3__RemoteAuthenticationException(soap, tag, id, (ns3__RemoteAuthenticationException *const*)ptr, "ns3:RemoteAuthenticationException");
	case SOAP_TYPE_PointerToPointerTons2__RemoteProject:
		return soap_out_PointerToPointerTons2__RemoteProject(soap, tag, id, (ns2__RemoteProject **const*)ptr, "ns2:RemoteProject");
	case SOAP_TYPE_PointerToPointerTons2__RemoteIssue:
		return soap_out_PointerToPointerTons2__RemoteIssue(soap, tag, id, (ns2__RemoteIssue **const*)ptr, "ns2:RemoteIssue");
	case SOAP_TYPE_PointerTons2__RemoteIssue:
		return soap_out_PointerTons2__RemoteIssue(soap, tag, id, (ns2__RemoteIssue *const*)ptr, "ns2:RemoteIssue");
	case SOAP_TYPE_PointerToPointerTons2__RemotePermission:
		return soap_out_PointerToPointerTons2__RemotePermission(soap, tag, id, (ns2__RemotePermission **const*)ptr, "ns2:RemotePermission");
	case SOAP_TYPE_PointerToPointerTons2__RemotePermissionScheme:
		return soap_out_PointerToPointerTons2__RemotePermissionScheme(soap, tag, id, (ns2__RemotePermissionScheme **const*)ptr, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_PointerTons2__RemotePermissionScheme:
		return soap_out_PointerTons2__RemotePermissionScheme(soap, tag, id, (ns2__RemotePermissionScheme *const*)ptr, "ns2:RemotePermissionScheme");
	case SOAP_TYPE_PointerToPointerTons2__RemoteAvatar:
		return soap_out_PointerToPointerTons2__RemoteAvatar(soap, tag, id, (ns2__RemoteAvatar **const*)ptr, "ns2:RemoteAvatar");
	case SOAP_TYPE_PointerTons2__RemoteAvatar:
		return soap_out_PointerTons2__RemoteAvatar(soap, tag, id, (ns2__RemoteAvatar *const*)ptr, "ns2:RemoteAvatar");
	case SOAP_TYPE_PointerToPointerTons2__RemoteSecurityLevel:
		return soap_out_PointerToPointerTons2__RemoteSecurityLevel(soap, tag, id, (ns2__RemoteSecurityLevel **const*)ptr, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_PointerTons2__RemoteSecurityLevel:
		return soap_out_PointerTons2__RemoteSecurityLevel(soap, tag, id, (ns2__RemoteSecurityLevel *const*)ptr, "ns2:RemoteSecurityLevel");
	case SOAP_TYPE_PointerToPointerTons2__RemoteWorklog:
		return soap_out_PointerToPointerTons2__RemoteWorklog(soap, tag, id, (ns2__RemoteWorklog **const*)ptr, "ns2:RemoteWorklog");
	case SOAP_TYPE_PointerTons2__RemoteWorklog:
		return soap_out_PointerTons2__RemoteWorklog(soap, tag, id, (ns2__RemoteWorklog *const*)ptr, "ns2:RemoteWorklog");
	case SOAP_TYPE_PointerToPointerTons2__RemoteAttachment:
		return soap_out_PointerToPointerTons2__RemoteAttachment(soap, tag, id, (ns2__RemoteAttachment **const*)ptr, "ns2:RemoteAttachment");
	case SOAP_TYPE_PointerTons2__RemoteAttachment:
		return soap_out_PointerTons2__RemoteAttachment(soap, tag, id, (ns2__RemoteAttachment *const*)ptr, "ns2:RemoteAttachment");
	case SOAP_TYPE_PointerTo_Struct_1:
		return soap_out_PointerTo_Struct_1(soap, tag, id, (_Struct_1 *const*)ptr, "xsd:byte");
	case SOAP_TYPE_PointerToPointerTons2__RemoteFieldValue:
		return soap_out_PointerToPointerTons2__RemoteFieldValue(soap, tag, id, (ns2__RemoteFieldValue **const*)ptr, "ns2:RemoteFieldValue");
	case SOAP_TYPE_PointerTons2__RemoteFieldValue:
		return soap_out_PointerTons2__RemoteFieldValue(soap, tag, id, (ns2__RemoteFieldValue *const*)ptr, "ns2:RemoteFieldValue");
	case SOAP_TYPE_PointerToPointerTons2__RemoteFilter:
		return soap_out_PointerToPointerTons2__RemoteFilter(soap, tag, id, (ns2__RemoteFilter **const*)ptr, "ns2:RemoteFilter");
	case SOAP_TYPE_PointerTons2__RemoteFilter:
		return soap_out_PointerTons2__RemoteFilter(soap, tag, id, (ns2__RemoteFilter *const*)ptr, "ns2:RemoteFilter");
	case SOAP_TYPE_PointerToPointerTons2__RemoteComment:
		return soap_out_PointerToPointerTons2__RemoteComment(soap, tag, id, (ns2__RemoteComment **const*)ptr, "ns2:RemoteComment");
	case SOAP_TYPE_PointerTons2__RemoteComment:
		return soap_out_PointerTons2__RemoteComment(soap, tag, id, (ns2__RemoteComment *const*)ptr, "ns2:RemoteComment");
	case SOAP_TYPE_PointerToPointerTons2__RemoteField:
		return soap_out_PointerToPointerTons2__RemoteField(soap, tag, id, (ns2__RemoteField **const*)ptr, "ns2:RemoteField");
	case SOAP_TYPE_PointerTons2__RemoteField:
		return soap_out_PointerTons2__RemoteField(soap, tag, id, (ns2__RemoteField *const*)ptr, "ns2:RemoteField");
	case SOAP_TYPE_PointerToPointerTons2__RemoteScheme:
		return soap_out_PointerToPointerTons2__RemoteScheme(soap, tag, id, (ns2__RemoteScheme **const*)ptr, "ns2:RemoteScheme");
	case SOAP_TYPE_PointerTons2__RemoteScheme:
		return soap_out_PointerTons2__RemoteScheme(soap, tag, id, (ns2__RemoteScheme *const*)ptr, "ns2:RemoteScheme");
	case SOAP_TYPE_PointerToPointerTons2__RemoteRoleActor:
		return soap_out_PointerToPointerTons2__RemoteRoleActor(soap, tag, id, (ns2__RemoteRoleActor **const*)ptr, "ns2:RemoteRoleActor");
	case SOAP_TYPE_PointerTons2__RemoteRoleActor:
		return soap_out_PointerTons2__RemoteRoleActor(soap, tag, id, (ns2__RemoteRoleActor *const*)ptr, "ns2:RemoteRoleActor");
	case SOAP_TYPE_PointerToPointerTons2__RemoteProjectRole:
		return soap_out_PointerToPointerTons2__RemoteProjectRole(soap, tag, id, (ns2__RemoteProjectRole **const*)ptr, "ns2:RemoteProjectRole");
	case SOAP_TYPE_PointerToPointerTons2__RemoteStatus:
		return soap_out_PointerToPointerTons2__RemoteStatus(soap, tag, id, (ns2__RemoteStatus **const*)ptr, "ns2:RemoteStatus");
	case SOAP_TYPE_PointerTons2__RemoteStatus:
		return soap_out_PointerTons2__RemoteStatus(soap, tag, id, (ns2__RemoteStatus *const*)ptr, "ns2:RemoteStatus");
	case SOAP_TYPE_PointerToPointerTons2__RemoteResolution:
		return soap_out_PointerToPointerTons2__RemoteResolution(soap, tag, id, (ns2__RemoteResolution **const*)ptr, "ns2:RemoteResolution");
	case SOAP_TYPE_PointerTons2__RemoteResolution:
		return soap_out_PointerTons2__RemoteResolution(soap, tag, id, (ns2__RemoteResolution *const*)ptr, "ns2:RemoteResolution");
	case SOAP_TYPE_PointerToPointerTons2__RemotePriority:
		return soap_out_PointerToPointerTons2__RemotePriority(soap, tag, id, (ns2__RemotePriority **const*)ptr, "ns2:RemotePriority");
	case SOAP_TYPE_PointerTons2__RemotePriority:
		return soap_out_PointerTons2__RemotePriority(soap, tag, id, (ns2__RemotePriority *const*)ptr, "ns2:RemotePriority");
	case SOAP_TYPE_PointerToPointerTons2__RemotePermissionMapping:
		return soap_out_PointerToPointerTons2__RemotePermissionMapping(soap, tag, id, (ns2__RemotePermissionMapping **const*)ptr, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_PointerTons2__RemotePermissionMapping:
		return soap_out_PointerTons2__RemotePermissionMapping(soap, tag, id, (ns2__RemotePermissionMapping *const*)ptr, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_PointerToPointerTons2__RemoteEntity:
		return soap_out_PointerToPointerTons2__RemoteEntity(soap, tag, id, (ns2__RemoteEntity **const*)ptr, "ns2:RemoteEntity");
	case SOAP_TYPE_PointerTons2__RemoteEntity:
		return soap_out_PointerTons2__RemoteEntity(soap, tag, id, (ns2__RemoteEntity *const*)ptr, "ns2:RemoteEntity");
	case SOAP_TYPE_PointerToPointerTons2__RemoteIssueType:
		return soap_out_PointerToPointerTons2__RemoteIssueType(soap, tag, id, (ns2__RemoteIssueType **const*)ptr, "ns2:RemoteIssueType");
	case SOAP_TYPE_PointerTons2__RemoteIssueType:
		return soap_out_PointerTons2__RemoteIssueType(soap, tag, id, (ns2__RemoteIssueType *const*)ptr, "ns2:RemoteIssueType");
	case SOAP_TYPE_PointerToPointerTons2__RemoteNamedObject:
		return soap_out_PointerToPointerTons2__RemoteNamedObject(soap, tag, id, (ns2__RemoteNamedObject **const*)ptr, "ns2:RemoteNamedObject");
	case SOAP_TYPE_PointerTons2__RemoteNamedObject:
		return soap_out_PointerTons2__RemoteNamedObject(soap, tag, id, (ns2__RemoteNamedObject *const*)ptr, "ns2:RemoteNamedObject");
	case SOAP_TYPE_PointerToPointerTons2__RemoteCustomFieldValue:
		return soap_out_PointerToPointerTons2__RemoteCustomFieldValue(soap, tag, id, (ns2__RemoteCustomFieldValue **const*)ptr, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_PointerTons2__RemoteCustomFieldValue:
		return soap_out_PointerTons2__RemoteCustomFieldValue(soap, tag, id, (ns2__RemoteCustomFieldValue *const*)ptr, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_PointerTostring:
		return soap_out_PointerTostring(soap, tag, id, (char **const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerToPointerTons2__RemoteVersion:
		return soap_out_PointerToPointerTons2__RemoteVersion(soap, tag, id, (ns2__RemoteVersion **const*)ptr, "ns2:RemoteVersion");
	case SOAP_TYPE_PointerTons2__RemoteVersion:
		return soap_out_PointerTons2__RemoteVersion(soap, tag, id, (ns2__RemoteVersion *const*)ptr, "ns2:RemoteVersion");
	case SOAP_TYPE_PointerToPointerTons2__RemoteComponent:
		return soap_out_PointerToPointerTons2__RemoteComponent(soap, tag, id, (ns2__RemoteComponent **const*)ptr, "ns2:RemoteComponent");
	case SOAP_TYPE_PointerTons2__RemoteComponent:
		return soap_out_PointerTons2__RemoteComponent(soap, tag, id, (ns2__RemoteComponent *const*)ptr, "ns2:RemoteComponent");
	case SOAP_TYPE_PointerToPointerTons2__RemoteUser:
		return soap_out_PointerToPointerTons2__RemoteUser(soap, tag, id, (ns2__RemoteUser **const*)ptr, "ns2:RemoteUser");
	case SOAP_TYPE_PointerTons2__RemoteUser:
		return soap_out_PointerTons2__RemoteUser(soap, tag, id, (ns2__RemoteUser *const*)ptr, "ns2:RemoteUser");
	case SOAP_TYPE_PointerTons2__RemoteProject:
		return soap_out_PointerTons2__RemoteProject(soap, tag, id, (ns2__RemoteProject *const*)ptr, "ns2:RemoteProject");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePermissionMapping:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemotePermissionMapping *const*)ptr, "ns2:RemotePermissionMapping");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteCustomFieldValue:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue *const*)ptr, "ns2:RemoteCustomFieldValue");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteComponent:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteComponent(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteComponent *const*)ptr, "ns2:RemoteComponent");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteVersion:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteVersion(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteVersion *const*)ptr, "ns2:RemoteVersion");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteRoleActor *const*)ptr, "ns2:RemoteRoleActor");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteUser:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteUser *const*)ptr, "ns2:RemoteUser");
	case SOAP_TYPE_PointerTons2__RemoteProjectRole:
		return soap_out_PointerTons2__RemoteProjectRole(soap, tag, id, (ns2__RemoteProjectRole *const*)ptr, "ns2:RemoteProjectRole");
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteEntity:
		return soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteEntity(soap, tag, id, (ArrayOf_USCOREtns1_USCORERemoteEntity *const*)ptr, "ns2:RemoteEntity");
	case SOAP_TYPE_PointerTons2__RemotePermission:
		return soap_out_PointerTons2__RemotePermission(soap, tag, id, (ns2__RemotePermission *const*)ptr, "ns2:RemotePermission");
	case SOAP_TYPE_PointerToLONG64:
		return soap_out_PointerToLONG64(soap, tag, id, (LONG64 *const*)ptr, "xsd:long");
	case SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREstring:
		return soap_out_PointerToArrayOf_USCORExsd_USCOREstring(soap, tag, id, (ArrayOf_USCORExsd_USCOREstring *const*)ptr, "xsd:string");
	case SOAP_TYPE_PointerTons2__RemoteTimeInfo:
		return soap_out_PointerTons2__RemoteTimeInfo(soap, tag, id, (ns2__RemoteTimeInfo *const*)ptr, "ns2:RemoteTimeInfo");
	case SOAP_TYPE_PointerTotime:
		return soap_out_PointerTotime(soap, tag, id, (time_t *const*)ptr, "xsd:dateTime");
	case SOAP_TYPE__QName:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:QName");
	case SOAP_TYPE_string:
		return soap_out_string(soap, tag, id, (char*const*)&ptr, "xsd:string");
	}
	return SOAP_OK;
}

#ifdef __cplusplus
}
#endif
#endif

#ifndef WITH_NOIDREF

#ifdef __cplusplus
extern "C" {
#endif
SOAP_FMAC3 void SOAP_FMAC4 soap_markelement(struct soap *soap, const void *ptr, int type)
{
	(void)soap; (void)ptr; (void)type; /* appease -Wall -Werror */
	switch (type)
	{
	case SOAP_TYPE__ns1__RemoteValidationException:
		((_ns1__RemoteValidationException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__RemotePermissionException:
		((_ns1__RemotePermissionException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__RemoteException:
		((_ns1__RemoteException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__ns1__RemoteAuthenticationException:
		((_ns1__RemoteAuthenticationException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE__Struct_1:
		((_Struct_1 *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject:
		((ArrayOf_USCOREtns1_USCORERemoteProject *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue:
		((ArrayOf_USCOREtns1_USCORERemoteIssue *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission:
		((ArrayOf_USCOREtns1_USCORERemotePermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme:
		((ArrayOf_USCOREtns1_USCORERemotePermissionScheme *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar:
		((ArrayOf_USCOREtns1_USCORERemoteAvatar *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel:
		((ArrayOf_USCOREtns1_USCORERemoteSecurityLevel *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog:
		((ArrayOf_USCOREtns1_USCORERemoteWorklog *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment:
		((ArrayOf_USCOREtns1_USCORERemoteAttachment *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary:
		((ArrayOf_USCORExsd_USCOREbase64Binary *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue:
		((ArrayOf_USCOREtns1_USCORERemoteFieldValue *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter:
		((ArrayOf_USCOREtns1_USCORERemoteFilter *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment:
		((ArrayOf_USCOREtns1_USCORERemoteComment *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField:
		((ArrayOf_USCOREtns1_USCORERemoteField *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme:
		((ArrayOf_USCOREtns1_USCORERemoteScheme *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor:
		((ArrayOf_USCOREtns1_USCORERemoteRoleActor *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole:
		((ArrayOf_USCOREtns1_USCORERemoteProjectRole *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus:
		((ArrayOf_USCOREtns1_USCORERemoteStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution:
		((ArrayOf_USCOREtns1_USCORERemoteResolution *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority:
		((ArrayOf_USCOREtns1_USCORERemotePriority *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping:
		((ArrayOf_USCOREtns1_USCORERemotePermissionMapping *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity:
		((ArrayOf_USCOREtns1_USCORERemoteEntity *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType:
		((ArrayOf_USCOREtns1_USCORERemoteIssueType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject:
		((ArrayOf_USCOREtns1_USCORERemoteNamedObject *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue:
		((ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring:
		((ArrayOf_USCORExsd_USCOREstring *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion:
		((ArrayOf_USCOREtns1_USCORERemoteVersion *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent:
		((ArrayOf_USCOREtns1_USCORERemoteComponent *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser:
		((ArrayOf_USCOREtns1_USCORERemoteUser *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns3__RemotePermissionException:
		((ns3__RemotePermissionException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns3__RemoteValidationException:
		((ns3__RemoteValidationException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns3__RemoteAuthenticationException:
		((ns3__RemoteAuthenticationException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns3__RemoteException:
		((ns3__RemoteException *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteAvatar:
		((ns2__RemoteAvatar *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteWorklog:
		((ns2__RemoteWorklog *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteAttachment:
		((ns2__RemoteAttachment *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteSecurityLevel:
		((ns2__RemoteSecurityLevel *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteFieldValue:
		((ns2__RemoteFieldValue *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteFilter:
		((ns2__RemoteFilter *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteField:
		((ns2__RemoteField *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteProjectRoleActors:
		((ns2__RemoteProjectRoleActors *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteRoleActors:
		((ns2__RemoteRoleActors *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteRoleActor:
		((ns2__RemoteRoleActor *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteProjectRole:
		((ns2__RemoteProjectRole *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteStatus:
		((ns2__RemoteStatus *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteResolution:
		((ns2__RemoteResolution *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemotePriority:
		((ns2__RemotePriority *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteProject:
		((ns2__RemoteProject *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemotePermissionScheme:
		((ns2__RemotePermissionScheme *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemotePermissionMapping:
		((ns2__RemotePermissionMapping *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemotePermission:
		((ns2__RemotePermission *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteScheme:
		((ns2__RemoteScheme *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteConfiguration:
		((ns2__RemoteConfiguration *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteIssueType:
		((ns2__RemoteIssueType *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__AbstractRemoteConstant:
		((ns2__AbstractRemoteConstant *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteNamedObject:
		((ns2__RemoteNamedObject *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteIssue:
		((ns2__RemoteIssue *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteCustomFieldValue:
		((ns2__RemoteCustomFieldValue *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteVersion:
		((ns2__RemoteVersion *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteComponent:
		((ns2__RemoteComponent *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__AbstractNamedRemoteEntity:
		((ns2__AbstractNamedRemoteEntity *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__AbstractRemoteEntity:
		((ns2__AbstractRemoteEntity *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteGroup:
		((ns2__RemoteGroup *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteUser:
		((ns2__RemoteUser *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteEntity:
		((ns2__RemoteEntity *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteServerInfo:
		((ns2__RemoteServerInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteTimeInfo:
		((ns2__RemoteTimeInfo *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns2__RemoteComment:
		((ns2__RemoteComment *)ptr)->soap_serialize(soap);
		break;
	case SOAP_TYPE_ns4__setNewProjectAvatar:
		soap_serialize_ns4__setNewProjectAvatar(soap, (const struct ns4__setNewProjectAvatar *)ptr);
		break;
	case SOAP_TYPE_ns4__setNewProjectAvatarResponse:
		soap_serialize_ns4__setNewProjectAvatarResponse(soap, (const struct ns4__setNewProjectAvatarResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectsNoSchemes:
		soap_serialize_ns4__getProjectsNoSchemes(soap, (const struct ns4__getProjectsNoSchemes *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectsNoSchemesResponse:
		soap_serialize_ns4__getProjectsNoSchemesResponse(soap, (const struct ns4__getProjectsNoSchemesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit:
		soap_serialize_ns4__getIssuesFromTextSearchWithLimit(soap, (const struct ns4__getIssuesFromTextSearchWithLimit *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse:
		soap_serialize_ns4__getIssuesFromTextSearchWithLimitResponse(soap, (const struct ns4__getIssuesFromTextSearchWithLimitResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimit:
		soap_serialize_ns4__getIssuesFromFilterWithLimit(soap, (const struct ns4__getIssuesFromFilterWithLimit *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse:
		soap_serialize_ns4__getIssuesFromFilterWithLimitResponse(soap, (const struct ns4__getIssuesFromFilterWithLimitResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromFilter:
		soap_serialize_ns4__getIssuesFromFilter(soap, (const struct ns4__getIssuesFromFilter *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromFilterResponse:
		soap_serialize_ns4__getIssuesFromFilterResponse(soap, (const struct ns4__getIssuesFromFilterResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addVersion:
		soap_serialize_ns4__addVersion(soap, (const struct ns4__addVersion *)ptr);
		break;
	case SOAP_TYPE_ns4__addVersionResponse:
		soap_serialize_ns4__addVersionResponse(soap, (const struct ns4__addVersionResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getSecuritySchemes:
		soap_serialize_ns4__getSecuritySchemes(soap, (const struct ns4__getSecuritySchemes *)ptr);
		break;
	case SOAP_TYPE_ns4__getSecuritySchemesResponse:
		soap_serialize_ns4__getSecuritySchemesResponse(soap, (const struct ns4__getSecuritySchemesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__createProjectFromObject:
		soap_serialize_ns4__createProjectFromObject(soap, (const struct ns4__createProjectFromObject *)ptr);
		break;
	case SOAP_TYPE_ns4__createProjectFromObjectResponse:
		soap_serialize_ns4__createProjectFromObjectResponse(soap, (const struct ns4__createProjectFromObjectResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue:
		soap_serialize_ns4__addBase64EncodedAttachmentsToIssue(soap, (const struct ns4__addBase64EncodedAttachmentsToIssue *)ptr);
		break;
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse:
		soap_serialize_ns4__addBase64EncodedAttachmentsToIssueResponse(soap, (const struct ns4__addBase64EncodedAttachmentsToIssueResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getSavedFilters:
		soap_serialize_ns4__getSavedFilters(soap, (const struct ns4__getSavedFilters *)ptr);
		break;
	case SOAP_TYPE_ns4__getSavedFiltersResponse:
		soap_serialize_ns4__getSavedFiltersResponse(soap, (const struct ns4__getSavedFiltersResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__refreshCustomFields:
		soap_serialize_ns4__refreshCustomFields(soap, (const struct ns4__refreshCustomFields *)ptr);
		break;
	case SOAP_TYPE_ns4__refreshCustomFieldsResponse:
		soap_serialize_ns4__refreshCustomFieldsResponse(soap, (const struct ns4__refreshCustomFieldsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteGroup:
		soap_serialize_ns4__deleteGroup(soap, (const struct ns4__deleteGroup *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteGroupResponse:
		soap_serialize_ns4__deleteGroupResponse(soap, (const struct ns4__deleteGroupResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__updateGroup:
		soap_serialize_ns4__updateGroup(soap, (const struct ns4__updateGroup *)ptr);
		break;
	case SOAP_TYPE_ns4__updateGroupResponse:
		soap_serialize_ns4__updateGroupResponse(soap, (const struct ns4__updateGroupResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteUser:
		soap_serialize_ns4__deleteUser(soap, (const struct ns4__deleteUser *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteUserResponse:
		soap_serialize_ns4__deleteUserResponse(soap, (const struct ns4__deleteUserResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromJqlSearch:
		soap_serialize_ns4__getIssuesFromJqlSearch(soap, (const struct ns4__getIssuesFromJqlSearch *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromJqlSearchResponse:
		soap_serialize_ns4__getIssuesFromJqlSearchResponse(soap, (const struct ns4__getIssuesFromJqlSearchResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProject:
		soap_serialize_ns4__getIssuesFromTextSearchWithProject(soap, (const struct ns4__getIssuesFromTextSearchWithProject *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProjectResponse:
		soap_serialize_ns4__getIssuesFromTextSearchWithProjectResponse(soap, (const struct ns4__getIssuesFromTextSearchWithProjectResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearch:
		soap_serialize_ns4__getIssuesFromTextSearch(soap, (const struct ns4__getIssuesFromTextSearch *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchResponse:
		soap_serialize_ns4__getIssuesFromTextSearchResponse(soap, (const struct ns4__getIssuesFromTextSearchResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssueCountForFilter:
		soap_serialize_ns4__getIssueCountForFilter(soap, (const struct ns4__getIssueCountForFilter *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssueCountForFilterResponse:
		soap_serialize_ns4__getIssueCountForFilterResponse(soap, (const struct ns4__getIssueCountForFilterResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deletePermissionScheme:
		soap_serialize_ns4__deletePermissionScheme(soap, (const struct ns4__deletePermissionScheme *)ptr);
		break;
	case SOAP_TYPE_ns4__deletePermissionSchemeResponse:
		soap_serialize_ns4__deletePermissionSchemeResponse(soap, (const struct ns4__deletePermissionSchemeResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deletePermissionFrom:
		soap_serialize_ns4__deletePermissionFrom(soap, (const struct ns4__deletePermissionFrom *)ptr);
		break;
	case SOAP_TYPE_ns4__deletePermissionFromResponse:
		soap_serialize_ns4__deletePermissionFromResponse(soap, (const struct ns4__deletePermissionFromResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addPermissionTo:
		soap_serialize_ns4__addPermissionTo(soap, (const struct ns4__addPermissionTo *)ptr);
		break;
	case SOAP_TYPE_ns4__addPermissionToResponse:
		soap_serialize_ns4__addPermissionToResponse(soap, (const struct ns4__addPermissionToResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__createPermissionScheme:
		soap_serialize_ns4__createPermissionScheme(soap, (const struct ns4__createPermissionScheme *)ptr);
		break;
	case SOAP_TYPE_ns4__createPermissionSchemeResponse:
		soap_serialize_ns4__createPermissionSchemeResponse(soap, (const struct ns4__createPermissionSchemeResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getAllPermissions:
		soap_serialize_ns4__getAllPermissions(soap, (const struct ns4__getAllPermissions *)ptr);
		break;
	case SOAP_TYPE_ns4__getAllPermissionsResponse:
		soap_serialize_ns4__getAllPermissionsResponse(soap, (const struct ns4__getAllPermissionsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getPermissionSchemes:
		soap_serialize_ns4__getPermissionSchemes(soap, (const struct ns4__getPermissionSchemes *)ptr);
		break;
	case SOAP_TYPE_ns4__getPermissionSchemesResponse:
		soap_serialize_ns4__getPermissionSchemesResponse(soap, (const struct ns4__getPermissionSchemesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getNotificationSchemes:
		soap_serialize_ns4__getNotificationSchemes(soap, (const struct ns4__getNotificationSchemes *)ptr);
		break;
	case SOAP_TYPE_ns4__getNotificationSchemesResponse:
		soap_serialize_ns4__getNotificationSchemesResponse(soap, (const struct ns4__getNotificationSchemesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteProjectAvatar:
		soap_serialize_ns4__deleteProjectAvatar(soap, (const struct ns4__deleteProjectAvatar *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteProjectAvatarResponse:
		soap_serialize_ns4__deleteProjectAvatarResponse(soap, (const struct ns4__deleteProjectAvatarResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectAvatar:
		soap_serialize_ns4__getProjectAvatar(soap, (const struct ns4__getProjectAvatar *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectAvatarResponse:
		soap_serialize_ns4__getProjectAvatarResponse(soap, (const struct ns4__getProjectAvatarResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__setProjectAvatar:
		soap_serialize_ns4__setProjectAvatar(soap, (const struct ns4__setProjectAvatar *)ptr);
		break;
	case SOAP_TYPE_ns4__setProjectAvatarResponse:
		soap_serialize_ns4__setProjectAvatarResponse(soap, (const struct ns4__setProjectAvatarResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectAvatars:
		soap_serialize_ns4__getProjectAvatars(soap, (const struct ns4__getProjectAvatars *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectAvatarsResponse:
		soap_serialize_ns4__getProjectAvatarsResponse(soap, (const struct ns4__getProjectAvatarsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getSecurityLevels:
		soap_serialize_ns4__getSecurityLevels(soap, (const struct ns4__getSecurityLevels *)ptr);
		break;
	case SOAP_TYPE_ns4__getSecurityLevelsResponse:
		soap_serialize_ns4__getSecurityLevelsResponse(soap, (const struct ns4__getSecurityLevelsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectWithSchemesById:
		soap_serialize_ns4__getProjectWithSchemesById(soap, (const struct ns4__getProjectWithSchemesById *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectWithSchemesByIdResponse:
		soap_serialize_ns4__getProjectWithSchemesByIdResponse(soap, (const struct ns4__getProjectWithSchemesByIdResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__logout:
		soap_serialize_ns4__logout(soap, (const struct ns4__logout *)ptr);
		break;
	case SOAP_TYPE_ns4__logoutResponse:
		soap_serialize_ns4__logoutResponse(soap, (const struct ns4__logoutResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getResolutionDateById:
		soap_serialize_ns4__getResolutionDateById(soap, (const struct ns4__getResolutionDateById *)ptr);
		break;
	case SOAP_TYPE_ns4__getResolutionDateByIdResponse:
		soap_serialize_ns4__getResolutionDateByIdResponse(soap, (const struct ns4__getResolutionDateByIdResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getResolutionDateByKey:
		soap_serialize_ns4__getResolutionDateByKey(soap, (const struct ns4__getResolutionDateByKey *)ptr);
		break;
	case SOAP_TYPE_ns4__getResolutionDateByKeyResponse:
		soap_serialize_ns4__getResolutionDateByKeyResponse(soap, (const struct ns4__getResolutionDateByKeyResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklog:
		soap_serialize_ns4__hasPermissionToUpdateWorklog(soap, (const struct ns4__hasPermissionToUpdateWorklog *)ptr);
		break;
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklogResponse:
		soap_serialize_ns4__hasPermissionToUpdateWorklogResponse(soap, (const struct ns4__hasPermissionToUpdateWorklogResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklog:
		soap_serialize_ns4__hasPermissionToDeleteWorklog(soap, (const struct ns4__hasPermissionToDeleteWorklog *)ptr);
		break;
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklogResponse:
		soap_serialize_ns4__hasPermissionToDeleteWorklogResponse(soap, (const struct ns4__hasPermissionToDeleteWorklogResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklog:
		soap_serialize_ns4__hasPermissionToCreateWorklog(soap, (const struct ns4__hasPermissionToCreateWorklog *)ptr);
		break;
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklogResponse:
		soap_serialize_ns4__hasPermissionToCreateWorklogResponse(soap, (const struct ns4__hasPermissionToCreateWorklogResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getWorklogs:
		soap_serialize_ns4__getWorklogs(soap, (const struct ns4__getWorklogs *)ptr);
		break;
	case SOAP_TYPE_ns4__getWorklogsResponse:
		soap_serialize_ns4__getWorklogsResponse(soap, (const struct ns4__getWorklogsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimate:
		soap_serialize_ns4__updateWorklogAndRetainRemainingEstimate(soap, (const struct ns4__updateWorklogAndRetainRemainingEstimate *)ptr);
		break;
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimateResponse:
		soap_serialize_ns4__updateWorklogAndRetainRemainingEstimateResponse(soap, (const struct ns4__updateWorklogAndRetainRemainingEstimateResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimate:
		soap_serialize_ns4__updateWorklogAndAutoAdjustRemainingEstimate(soap, (const struct ns4__updateWorklogAndAutoAdjustRemainingEstimate *)ptr);
		break;
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse:
		soap_serialize_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse(soap, (const struct ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimate:
		soap_serialize_ns4__updateWorklogWithNewRemainingEstimate(soap, (const struct ns4__updateWorklogWithNewRemainingEstimate *)ptr);
		break;
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimateResponse:
		soap_serialize_ns4__updateWorklogWithNewRemainingEstimateResponse(soap, (const struct ns4__updateWorklogWithNewRemainingEstimateResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimate:
		soap_serialize_ns4__deleteWorklogAndRetainRemainingEstimate(soap, (const struct ns4__deleteWorklogAndRetainRemainingEstimate *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimateResponse:
		soap_serialize_ns4__deleteWorklogAndRetainRemainingEstimateResponse(soap, (const struct ns4__deleteWorklogAndRetainRemainingEstimateResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimate:
		soap_serialize_ns4__deleteWorklogAndAutoAdjustRemainingEstimate(soap, (const struct ns4__deleteWorklogAndAutoAdjustRemainingEstimate *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse:
		soap_serialize_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse(soap, (const struct ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimate:
		soap_serialize_ns4__deleteWorklogWithNewRemainingEstimate(soap, (const struct ns4__deleteWorklogWithNewRemainingEstimate *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimateResponse:
		soap_serialize_ns4__deleteWorklogWithNewRemainingEstimateResponse(soap, (const struct ns4__deleteWorklogWithNewRemainingEstimateResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimate:
		soap_serialize_ns4__addWorklogAndRetainRemainingEstimate(soap, (const struct ns4__addWorklogAndRetainRemainingEstimate *)ptr);
		break;
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimateResponse:
		soap_serialize_ns4__addWorklogAndRetainRemainingEstimateResponse(soap, (const struct ns4__addWorklogAndRetainRemainingEstimateResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimate:
		soap_serialize_ns4__addWorklogAndAutoAdjustRemainingEstimate(soap, (const struct ns4__addWorklogAndAutoAdjustRemainingEstimate *)ptr);
		break;
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse:
		soap_serialize_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse(soap, (const struct ns4__addWorklogAndAutoAdjustRemainingEstimateResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimate:
		soap_serialize_ns4__addWorklogWithNewRemainingEstimate(soap, (const struct ns4__addWorklogWithNewRemainingEstimate *)ptr);
		break;
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimateResponse:
		soap_serialize_ns4__addWorklogWithNewRemainingEstimateResponse(soap, (const struct ns4__addWorklogWithNewRemainingEstimateResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssueById:
		soap_serialize_ns4__getIssueById(soap, (const struct ns4__getIssueById *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssueByIdResponse:
		soap_serialize_ns4__getIssueByIdResponse(soap, (const struct ns4__getIssueByIdResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__progressWorkflowAction:
		soap_serialize_ns4__progressWorkflowAction(soap, (const struct ns4__progressWorkflowAction *)ptr);
		break;
	case SOAP_TYPE_ns4__progressWorkflowActionResponse:
		soap_serialize_ns4__progressWorkflowActionResponse(soap, (const struct ns4__progressWorkflowActionResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getFieldsForAction:
		soap_serialize_ns4__getFieldsForAction(soap, (const struct ns4__getFieldsForAction *)ptr);
		break;
	case SOAP_TYPE_ns4__getFieldsForActionResponse:
		soap_serialize_ns4__getFieldsForActionResponse(soap, (const struct ns4__getFieldsForActionResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__editComment:
		soap_serialize_ns4__editComment(soap, (const struct ns4__editComment *)ptr);
		break;
	case SOAP_TYPE_ns4__editCommentResponse:
		soap_serialize_ns4__editCommentResponse(soap, (const struct ns4__editCommentResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__hasPermissionToEditComment:
		soap_serialize_ns4__hasPermissionToEditComment(soap, (const struct ns4__hasPermissionToEditComment *)ptr);
		break;
	case SOAP_TYPE_ns4__hasPermissionToEditCommentResponse:
		soap_serialize_ns4__hasPermissionToEditCommentResponse(soap, (const struct ns4__hasPermissionToEditCommentResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteIssue:
		soap_serialize_ns4__deleteIssue(soap, (const struct ns4__deleteIssue *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteIssueResponse:
		soap_serialize_ns4__deleteIssueResponse(soap, (const struct ns4__deleteIssueResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getAttachmentsFromIssue:
		soap_serialize_ns4__getAttachmentsFromIssue(soap, (const struct ns4__getAttachmentsFromIssue *)ptr);
		break;
	case SOAP_TYPE_ns4__getAttachmentsFromIssueResponse:
		soap_serialize_ns4__getAttachmentsFromIssueResponse(soap, (const struct ns4__getAttachmentsFromIssueResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addAttachmentsToIssue:
		soap_serialize_ns4__addAttachmentsToIssue(soap, (const struct ns4__addAttachmentsToIssue *)ptr);
		break;
	case SOAP_TYPE_ns4__addAttachmentsToIssueResponse:
		soap_serialize_ns4__addAttachmentsToIssueResponse(soap, (const struct ns4__addAttachmentsToIssueResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__createIssueWithSecurityLevel:
		soap_serialize_ns4__createIssueWithSecurityLevel(soap, (const struct ns4__createIssueWithSecurityLevel *)ptr);
		break;
	case SOAP_TYPE_ns4__createIssueWithSecurityLevelResponse:
		soap_serialize_ns4__createIssueWithSecurityLevelResponse(soap, (const struct ns4__createIssueWithSecurityLevelResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addComment:
		soap_serialize_ns4__addComment(soap, (const struct ns4__addComment *)ptr);
		break;
	case SOAP_TYPE_ns4__addCommentResponse:
		soap_serialize_ns4__addCommentResponse(soap, (const struct ns4__addCommentResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getSecurityLevel:
		soap_serialize_ns4__getSecurityLevel(soap, (const struct ns4__getSecurityLevel *)ptr);
		break;
	case SOAP_TYPE_ns4__getSecurityLevelResponse:
		soap_serialize_ns4__getSecurityLevelResponse(soap, (const struct ns4__getSecurityLevelResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__removeUserFromGroup:
		soap_serialize_ns4__removeUserFromGroup(soap, (const struct ns4__removeUserFromGroup *)ptr);
		break;
	case SOAP_TYPE_ns4__removeUserFromGroupResponse:
		soap_serialize_ns4__removeUserFromGroupResponse(soap, (const struct ns4__removeUserFromGroupResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addUserToGroup:
		soap_serialize_ns4__addUserToGroup(soap, (const struct ns4__addUserToGroup *)ptr);
		break;
	case SOAP_TYPE_ns4__addUserToGroupResponse:
		soap_serialize_ns4__addUserToGroupResponse(soap, (const struct ns4__addUserToGroupResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProject:
		soap_serialize_ns4__getSubTaskIssueTypesForProject(soap, (const struct ns4__getSubTaskIssueTypesForProject *)ptr);
		break;
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProjectResponse:
		soap_serialize_ns4__getSubTaskIssueTypesForProjectResponse(soap, (const struct ns4__getSubTaskIssueTypesForProjectResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssueTypesForProject:
		soap_serialize_ns4__getIssueTypesForProject(soap, (const struct ns4__getIssueTypesForProject *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssueTypesForProjectResponse:
		soap_serialize_ns4__getIssueTypesForProjectResponse(soap, (const struct ns4__getIssueTypesForProjectResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getFieldsForEdit:
		soap_serialize_ns4__getFieldsForEdit(soap, (const struct ns4__getFieldsForEdit *)ptr);
		break;
	case SOAP_TYPE_ns4__getFieldsForEditResponse:
		soap_serialize_ns4__getFieldsForEditResponse(soap, (const struct ns4__getFieldsForEditResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__updateIssue:
		soap_serialize_ns4__updateIssue(soap, (const struct ns4__updateIssue *)ptr);
		break;
	case SOAP_TYPE_ns4__updateIssueResponse:
		soap_serialize_ns4__updateIssueResponse(soap, (const struct ns4__updateIssueResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__archiveVersion:
		soap_serialize_ns4__archiveVersion(soap, (const struct ns4__archiveVersion *)ptr);
		break;
	case SOAP_TYPE_ns4__archiveVersionResponse:
		soap_serialize_ns4__archiveVersionResponse(soap, (const struct ns4__archiveVersionResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__releaseVersion:
		soap_serialize_ns4__releaseVersion(soap, (const struct ns4__releaseVersion *)ptr);
		break;
	case SOAP_TYPE_ns4__releaseVersionResponse:
		soap_serialize_ns4__releaseVersionResponse(soap, (const struct ns4__releaseVersionResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getFavouriteFilters:
		soap_serialize_ns4__getFavouriteFilters(soap, (const struct ns4__getFavouriteFilters *)ptr);
		break;
	case SOAP_TYPE_ns4__getFavouriteFiltersResponse:
		soap_serialize_ns4__getFavouriteFiltersResponse(soap, (const struct ns4__getFavouriteFiltersResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getComments:
		soap_serialize_ns4__getComments(soap, (const struct ns4__getComments *)ptr);
		break;
	case SOAP_TYPE_ns4__getCommentsResponse:
		soap_serialize_ns4__getCommentsResponse(soap, (const struct ns4__getCommentsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getCustomFields:
		soap_serialize_ns4__getCustomFields(soap, (const struct ns4__getCustomFields *)ptr);
		break;
	case SOAP_TYPE_ns4__getCustomFieldsResponse:
		soap_serialize_ns4__getCustomFieldsResponse(soap, (const struct ns4__getCustomFieldsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getVersions:
		soap_serialize_ns4__getVersions(soap, (const struct ns4__getVersions *)ptr);
		break;
	case SOAP_TYPE_ns4__getVersionsResponse:
		soap_serialize_ns4__getVersionsResponse(soap, (const struct ns4__getVersionsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectById:
		soap_serialize_ns4__getProjectById(soap, (const struct ns4__getProjectById *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectByIdResponse:
		soap_serialize_ns4__getProjectByIdResponse(soap, (const struct ns4__getProjectByIdResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteProject:
		soap_serialize_ns4__deleteProject(soap, (const struct ns4__deleteProject *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteProjectResponse:
		soap_serialize_ns4__deleteProjectResponse(soap, (const struct ns4__deleteProjectResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemes:
		soap_serialize_ns4__getAssociatedPermissionSchemes(soap, (const struct ns4__getAssociatedPermissionSchemes *)ptr);
		break;
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemesResponse:
		soap_serialize_ns4__getAssociatedPermissionSchemesResponse(soap, (const struct ns4__getAssociatedPermissionSchemesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemes:
		soap_serialize_ns4__getAssociatedNotificationSchemes(soap, (const struct ns4__getAssociatedNotificationSchemes *)ptr);
		break;
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemesResponse:
		soap_serialize_ns4__getAssociatedNotificationSchemesResponse(soap, (const struct ns4__getAssociatedNotificationSchemesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRole:
		soap_serialize_ns4__removeDefaultActorsFromProjectRole(soap, (const struct ns4__removeDefaultActorsFromProjectRole *)ptr);
		break;
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRoleResponse:
		soap_serialize_ns4__removeDefaultActorsFromProjectRoleResponse(soap, (const struct ns4__removeDefaultActorsFromProjectRoleResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRole:
		soap_serialize_ns4__addDefaultActorsToProjectRole(soap, (const struct ns4__addDefaultActorsToProjectRole *)ptr);
		break;
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRoleResponse:
		soap_serialize_ns4__addDefaultActorsToProjectRoleResponse(soap, (const struct ns4__addDefaultActorsToProjectRoleResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__removeActorsFromProjectRole:
		soap_serialize_ns4__removeActorsFromProjectRole(soap, (const struct ns4__removeActorsFromProjectRole *)ptr);
		break;
	case SOAP_TYPE_ns4__removeActorsFromProjectRoleResponse:
		soap_serialize_ns4__removeActorsFromProjectRoleResponse(soap, (const struct ns4__removeActorsFromProjectRoleResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__addActorsToProjectRole:
		soap_serialize_ns4__addActorsToProjectRole(soap, (const struct ns4__addActorsToProjectRole *)ptr);
		break;
	case SOAP_TYPE_ns4__addActorsToProjectRoleResponse:
		soap_serialize_ns4__addActorsToProjectRoleResponse(soap, (const struct ns4__addActorsToProjectRoleResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__isProjectRoleNameUnique:
		soap_serialize_ns4__isProjectRoleNameUnique(soap, (const struct ns4__isProjectRoleNameUnique *)ptr);
		break;
	case SOAP_TYPE_ns4__isProjectRoleNameUniqueResponse:
		soap_serialize_ns4__isProjectRoleNameUniqueResponse(soap, (const struct ns4__isProjectRoleNameUniqueResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__createProjectRole:
		soap_serialize_ns4__createProjectRole(soap, (const struct ns4__createProjectRole *)ptr);
		break;
	case SOAP_TYPE_ns4__createProjectRoleResponse:
		soap_serialize_ns4__createProjectRoleResponse(soap, (const struct ns4__createProjectRoleResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__updateProjectRole:
		soap_serialize_ns4__updateProjectRole(soap, (const struct ns4__updateProjectRole *)ptr);
		break;
	case SOAP_TYPE_ns4__updateProjectRoleResponse:
		soap_serialize_ns4__updateProjectRoleResponse(soap, (const struct ns4__updateProjectRoleResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteProjectRole:
		soap_serialize_ns4__deleteProjectRole(soap, (const struct ns4__deleteProjectRole *)ptr);
		break;
	case SOAP_TYPE_ns4__deleteProjectRoleResponse:
		soap_serialize_ns4__deleteProjectRoleResponse(soap, (const struct ns4__deleteProjectRoleResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndType:
		soap_serialize_ns4__removeAllRoleActorsByNameAndType(soap, (const struct ns4__removeAllRoleActorsByNameAndType *)ptr);
		break;
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndTypeResponse:
		soap_serialize_ns4__removeAllRoleActorsByNameAndTypeResponse(soap, (const struct ns4__removeAllRoleActorsByNameAndTypeResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getDefaultRoleActors:
		soap_serialize_ns4__getDefaultRoleActors(soap, (const struct ns4__getDefaultRoleActors *)ptr);
		break;
	case SOAP_TYPE_ns4__getDefaultRoleActorsResponse:
		soap_serialize_ns4__getDefaultRoleActorsResponse(soap, (const struct ns4__getDefaultRoleActorsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectRoleActors:
		soap_serialize_ns4__getProjectRoleActors(soap, (const struct ns4__getProjectRoleActors *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectRoleActorsResponse:
		soap_serialize_ns4__getProjectRoleActorsResponse(soap, (const struct ns4__getProjectRoleActorsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectRole:
		soap_serialize_ns4__getProjectRole(soap, (const struct ns4__getProjectRole *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectRoleResponse:
		soap_serialize_ns4__getProjectRoleResponse(soap, (const struct ns4__getProjectRoleResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectRoles:
		soap_serialize_ns4__getProjectRoles(soap, (const struct ns4__getProjectRoles *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectRolesResponse:
		soap_serialize_ns4__getProjectRolesResponse(soap, (const struct ns4__getProjectRolesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getStatuses:
		soap_serialize_ns4__getStatuses(soap, (const struct ns4__getStatuses *)ptr);
		break;
	case SOAP_TYPE_ns4__getStatusesResponse:
		soap_serialize_ns4__getStatusesResponse(soap, (const struct ns4__getStatusesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssueTypes:
		soap_serialize_ns4__getIssueTypes(soap, (const struct ns4__getIssueTypes *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssueTypesResponse:
		soap_serialize_ns4__getIssueTypesResponse(soap, (const struct ns4__getIssueTypesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getResolutions:
		soap_serialize_ns4__getResolutions(soap, (const struct ns4__getResolutions *)ptr);
		break;
	case SOAP_TYPE_ns4__getResolutionsResponse:
		soap_serialize_ns4__getResolutionsResponse(soap, (const struct ns4__getResolutionsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getPriorities:
		soap_serialize_ns4__getPriorities(soap, (const struct ns4__getPriorities *)ptr);
		break;
	case SOAP_TYPE_ns4__getPrioritiesResponse:
		soap_serialize_ns4__getPrioritiesResponse(soap, (const struct ns4__getPrioritiesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__removeAllRoleActorsByProject:
		soap_serialize_ns4__removeAllRoleActorsByProject(soap, (const struct ns4__removeAllRoleActorsByProject *)ptr);
		break;
	case SOAP_TYPE_ns4__removeAllRoleActorsByProjectResponse:
		soap_serialize_ns4__removeAllRoleActorsByProjectResponse(soap, (const struct ns4__removeAllRoleActorsByProjectResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectByKey:
		soap_serialize_ns4__getProjectByKey(soap, (const struct ns4__getProjectByKey *)ptr);
		break;
	case SOAP_TYPE_ns4__getProjectByKeyResponse:
		soap_serialize_ns4__getProjectByKeyResponse(soap, (const struct ns4__getProjectByKeyResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__updateProject:
		soap_serialize_ns4__updateProject(soap, (const struct ns4__updateProject *)ptr);
		break;
	case SOAP_TYPE_ns4__updateProjectResponse:
		soap_serialize_ns4__updateProjectResponse(soap, (const struct ns4__updateProjectResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__createProject:
		soap_serialize_ns4__createProject(soap, (const struct ns4__createProject *)ptr);
		break;
	case SOAP_TYPE_ns4__createProjectResponse:
		soap_serialize_ns4__createProjectResponse(soap, (const struct ns4__createProjectResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getConfiguration:
		soap_serialize_ns4__getConfiguration(soap, (const struct ns4__getConfiguration *)ptr);
		break;
	case SOAP_TYPE_ns4__getConfigurationResponse:
		soap_serialize_ns4__getConfigurationResponse(soap, (const struct ns4__getConfigurationResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getSubTaskIssueTypes:
		soap_serialize_ns4__getSubTaskIssueTypes(soap, (const struct ns4__getSubTaskIssueTypes *)ptr);
		break;
	case SOAP_TYPE_ns4__getSubTaskIssueTypesResponse:
		soap_serialize_ns4__getSubTaskIssueTypesResponse(soap, (const struct ns4__getSubTaskIssueTypesResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getAvailableActions:
		soap_serialize_ns4__getAvailableActions(soap, (const struct ns4__getAvailableActions *)ptr);
		break;
	case SOAP_TYPE_ns4__getAvailableActionsResponse:
		soap_serialize_ns4__getAvailableActionsResponse(soap, (const struct ns4__getAvailableActionsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__createIssue:
		soap_serialize_ns4__createIssue(soap, (const struct ns4__createIssue *)ptr);
		break;
	case SOAP_TYPE_ns4__createIssueResponse:
		soap_serialize_ns4__createIssueResponse(soap, (const struct ns4__createIssueResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssue:
		soap_serialize_ns4__getIssue(soap, (const struct ns4__getIssue *)ptr);
		break;
	case SOAP_TYPE_ns4__getIssueResponse:
		soap_serialize_ns4__getIssueResponse(soap, (const struct ns4__getIssueResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__createUser:
		soap_serialize_ns4__createUser(soap, (const struct ns4__createUser *)ptr);
		break;
	case SOAP_TYPE_ns4__createUserResponse:
		soap_serialize_ns4__createUserResponse(soap, (const struct ns4__createUserResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getComponents:
		soap_serialize_ns4__getComponents(soap, (const struct ns4__getComponents *)ptr);
		break;
	case SOAP_TYPE_ns4__getComponentsResponse:
		soap_serialize_ns4__getComponentsResponse(soap, (const struct ns4__getComponentsResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getUser:
		soap_serialize_ns4__getUser(soap, (const struct ns4__getUser *)ptr);
		break;
	case SOAP_TYPE_ns4__getUserResponse:
		soap_serialize_ns4__getUserResponse(soap, (const struct ns4__getUserResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__login:
		soap_serialize_ns4__login(soap, (const struct ns4__login *)ptr);
		break;
	case SOAP_TYPE_ns4__loginResponse:
		soap_serialize_ns4__loginResponse(soap, (const struct ns4__loginResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getGroup:
		soap_serialize_ns4__getGroup(soap, (const struct ns4__getGroup *)ptr);
		break;
	case SOAP_TYPE_ns4__getGroupResponse:
		soap_serialize_ns4__getGroupResponse(soap, (const struct ns4__getGroupResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__createGroup:
		soap_serialize_ns4__createGroup(soap, (const struct ns4__createGroup *)ptr);
		break;
	case SOAP_TYPE_ns4__createGroupResponse:
		soap_serialize_ns4__createGroupResponse(soap, (const struct ns4__createGroupResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getServerInfo:
		soap_serialize_ns4__getServerInfo(soap, (const struct ns4__getServerInfo *)ptr);
		break;
	case SOAP_TYPE_ns4__getServerInfoResponse:
		soap_serialize_ns4__getServerInfoResponse(soap, (const struct ns4__getServerInfoResponse *)ptr);
		break;
	case SOAP_TYPE_ns4__getComment:
		soap_serialize_ns4__getComment(soap, (const struct ns4__getComment *)ptr);
		break;
	case SOAP_TYPE_ns4__getCommentResponse:
		soap_serialize_ns4__getCommentResponse(soap, (const struct ns4__getCommentResponse *)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteProject:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteProject(soap, (ArrayOf_USCOREtns1_USCORERemoteProject *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteIssue:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, (ArrayOf_USCOREtns1_USCORERemoteIssue *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePermission:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemotePermission(soap, (ArrayOf_USCOREtns1_USCORERemotePermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePermissionScheme:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, (ArrayOf_USCOREtns1_USCORERemotePermissionScheme *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteAvatar:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteAvatar(soap, (ArrayOf_USCOREtns1_USCORERemoteAvatar *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteSecurityLevel:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, (ArrayOf_USCOREtns1_USCORERemoteSecurityLevel *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteWorklog:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteWorklog(soap, (ArrayOf_USCOREtns1_USCORERemoteWorklog *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteAttachment:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteAttachment(soap, (ArrayOf_USCOREtns1_USCORERemoteAttachment *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREbase64Binary:
		soap_serialize_PointerToArrayOf_USCORExsd_USCOREbase64Binary(soap, (ArrayOf_USCORExsd_USCOREbase64Binary *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteFieldValue:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, (ArrayOf_USCOREtns1_USCORERemoteFieldValue *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteFilter:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteFilter(soap, (ArrayOf_USCOREtns1_USCORERemoteFilter *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteComment:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteComment(soap, (ArrayOf_USCOREtns1_USCORERemoteComment *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteField:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteField(soap, (ArrayOf_USCOREtns1_USCORERemoteField *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteScheme:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteScheme(soap, (ArrayOf_USCOREtns1_USCORERemoteScheme *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteRoleActors:
		soap_serialize_PointerTons2__RemoteRoleActors(soap, (ns2__RemoteRoleActors *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteProjectRoleActors:
		soap_serialize_PointerTons2__RemoteProjectRoleActors(soap, (ns2__RemoteProjectRoleActors *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteProjectRole:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, (ArrayOf_USCOREtns1_USCORERemoteProjectRole *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteStatus:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteStatus(soap, (ArrayOf_USCOREtns1_USCORERemoteStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteResolution:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteResolution(soap, (ArrayOf_USCOREtns1_USCORERemoteResolution *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePriority:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemotePriority(soap, (ArrayOf_USCOREtns1_USCORERemotePriority *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteConfiguration:
		soap_serialize_PointerTons2__RemoteConfiguration(soap, (ns2__RemoteConfiguration *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteIssueType:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteIssueType(soap, (ArrayOf_USCOREtns1_USCORERemoteIssueType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteNamedObject:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, (ArrayOf_USCOREtns1_USCORERemoteNamedObject *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteGroup:
		soap_serialize_PointerTons2__RemoteGroup(soap, (ns2__RemoteGroup *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteServerInfo:
		soap_serialize_PointerTons2__RemoteServerInfo(soap, (ns2__RemoteServerInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__RemoteValidationException:
		soap_serialize_PointerTo_ns1__RemoteValidationException(soap, (_ns1__RemoteValidationException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__RemotePermissionException:
		soap_serialize_PointerTo_ns1__RemotePermissionException(soap, (_ns1__RemotePermissionException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__RemoteException:
		soap_serialize_PointerTo_ns1__RemoteException(soap, (_ns1__RemoteException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_ns1__RemoteAuthenticationException:
		soap_serialize_PointerTo_ns1__RemoteAuthenticationException(soap, (_ns1__RemoteAuthenticationException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons3__RemoteValidationException:
		soap_serialize_PointerTons3__RemoteValidationException(soap, (ns3__RemoteValidationException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons3__RemotePermissionException:
		soap_serialize_PointerTons3__RemotePermissionException(soap, (ns3__RemotePermissionException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons3__RemoteException:
		soap_serialize_PointerTons3__RemoteException(soap, (ns3__RemoteException *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons3__RemoteAuthenticationException:
		soap_serialize_PointerTons3__RemoteAuthenticationException(soap, (ns3__RemoteAuthenticationException *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteProject:
		soap_serialize_PointerToPointerTons2__RemoteProject(soap, (ns2__RemoteProject **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteIssue:
		soap_serialize_PointerToPointerTons2__RemoteIssue(soap, (ns2__RemoteIssue **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteIssue:
		soap_serialize_PointerTons2__RemoteIssue(soap, (ns2__RemoteIssue *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemotePermission:
		soap_serialize_PointerToPointerTons2__RemotePermission(soap, (ns2__RemotePermission **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemotePermissionScheme:
		soap_serialize_PointerToPointerTons2__RemotePermissionScheme(soap, (ns2__RemotePermissionScheme **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemotePermissionScheme:
		soap_serialize_PointerTons2__RemotePermissionScheme(soap, (ns2__RemotePermissionScheme *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteAvatar:
		soap_serialize_PointerToPointerTons2__RemoteAvatar(soap, (ns2__RemoteAvatar **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteAvatar:
		soap_serialize_PointerTons2__RemoteAvatar(soap, (ns2__RemoteAvatar *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteSecurityLevel:
		soap_serialize_PointerToPointerTons2__RemoteSecurityLevel(soap, (ns2__RemoteSecurityLevel **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteSecurityLevel:
		soap_serialize_PointerTons2__RemoteSecurityLevel(soap, (ns2__RemoteSecurityLevel *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteWorklog:
		soap_serialize_PointerToPointerTons2__RemoteWorklog(soap, (ns2__RemoteWorklog **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteWorklog:
		soap_serialize_PointerTons2__RemoteWorklog(soap, (ns2__RemoteWorklog *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteAttachment:
		soap_serialize_PointerToPointerTons2__RemoteAttachment(soap, (ns2__RemoteAttachment **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteAttachment:
		soap_serialize_PointerTons2__RemoteAttachment(soap, (ns2__RemoteAttachment *const*)ptr);
		break;
	case SOAP_TYPE_PointerTo_Struct_1:
		soap_serialize_PointerTo_Struct_1(soap, (_Struct_1 *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteFieldValue:
		soap_serialize_PointerToPointerTons2__RemoteFieldValue(soap, (ns2__RemoteFieldValue **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteFieldValue:
		soap_serialize_PointerTons2__RemoteFieldValue(soap, (ns2__RemoteFieldValue *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteFilter:
		soap_serialize_PointerToPointerTons2__RemoteFilter(soap, (ns2__RemoteFilter **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteFilter:
		soap_serialize_PointerTons2__RemoteFilter(soap, (ns2__RemoteFilter *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteComment:
		soap_serialize_PointerToPointerTons2__RemoteComment(soap, (ns2__RemoteComment **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteComment:
		soap_serialize_PointerTons2__RemoteComment(soap, (ns2__RemoteComment *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteField:
		soap_serialize_PointerToPointerTons2__RemoteField(soap, (ns2__RemoteField **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteField:
		soap_serialize_PointerTons2__RemoteField(soap, (ns2__RemoteField *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteScheme:
		soap_serialize_PointerToPointerTons2__RemoteScheme(soap, (ns2__RemoteScheme **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteScheme:
		soap_serialize_PointerTons2__RemoteScheme(soap, (ns2__RemoteScheme *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteRoleActor:
		soap_serialize_PointerToPointerTons2__RemoteRoleActor(soap, (ns2__RemoteRoleActor **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteRoleActor:
		soap_serialize_PointerTons2__RemoteRoleActor(soap, (ns2__RemoteRoleActor *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteProjectRole:
		soap_serialize_PointerToPointerTons2__RemoteProjectRole(soap, (ns2__RemoteProjectRole **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteStatus:
		soap_serialize_PointerToPointerTons2__RemoteStatus(soap, (ns2__RemoteStatus **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteStatus:
		soap_serialize_PointerTons2__RemoteStatus(soap, (ns2__RemoteStatus *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteResolution:
		soap_serialize_PointerToPointerTons2__RemoteResolution(soap, (ns2__RemoteResolution **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteResolution:
		soap_serialize_PointerTons2__RemoteResolution(soap, (ns2__RemoteResolution *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemotePriority:
		soap_serialize_PointerToPointerTons2__RemotePriority(soap, (ns2__RemotePriority **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemotePriority:
		soap_serialize_PointerTons2__RemotePriority(soap, (ns2__RemotePriority *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemotePermissionMapping:
		soap_serialize_PointerToPointerTons2__RemotePermissionMapping(soap, (ns2__RemotePermissionMapping **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemotePermissionMapping:
		soap_serialize_PointerTons2__RemotePermissionMapping(soap, (ns2__RemotePermissionMapping *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteEntity:
		soap_serialize_PointerToPointerTons2__RemoteEntity(soap, (ns2__RemoteEntity **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteEntity:
		soap_serialize_PointerTons2__RemoteEntity(soap, (ns2__RemoteEntity *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteIssueType:
		soap_serialize_PointerToPointerTons2__RemoteIssueType(soap, (ns2__RemoteIssueType **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteIssueType:
		soap_serialize_PointerTons2__RemoteIssueType(soap, (ns2__RemoteIssueType *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteNamedObject:
		soap_serialize_PointerToPointerTons2__RemoteNamedObject(soap, (ns2__RemoteNamedObject **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteNamedObject:
		soap_serialize_PointerTons2__RemoteNamedObject(soap, (ns2__RemoteNamedObject *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteCustomFieldValue:
		soap_serialize_PointerToPointerTons2__RemoteCustomFieldValue(soap, (ns2__RemoteCustomFieldValue **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteCustomFieldValue:
		soap_serialize_PointerTons2__RemoteCustomFieldValue(soap, (ns2__RemoteCustomFieldValue *const*)ptr);
		break;
	case SOAP_TYPE_PointerTostring:
		soap_serialize_PointerTostring(soap, (char **const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteVersion:
		soap_serialize_PointerToPointerTons2__RemoteVersion(soap, (ns2__RemoteVersion **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteVersion:
		soap_serialize_PointerTons2__RemoteVersion(soap, (ns2__RemoteVersion *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteComponent:
		soap_serialize_PointerToPointerTons2__RemoteComponent(soap, (ns2__RemoteComponent **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteComponent:
		soap_serialize_PointerTons2__RemoteComponent(soap, (ns2__RemoteComponent *const*)ptr);
		break;
	case SOAP_TYPE_PointerToPointerTons2__RemoteUser:
		soap_serialize_PointerToPointerTons2__RemoteUser(soap, (ns2__RemoteUser **const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteUser:
		soap_serialize_PointerTons2__RemoteUser(soap, (ns2__RemoteUser *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteProject:
		soap_serialize_PointerTons2__RemoteProject(soap, (ns2__RemoteProject *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemotePermissionMapping:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, (ArrayOf_USCOREtns1_USCORERemotePermissionMapping *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteCustomFieldValue:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, (ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteComponent:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteComponent(soap, (ArrayOf_USCOREtns1_USCORERemoteComponent *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteVersion:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteVersion(soap, (ArrayOf_USCOREtns1_USCORERemoteVersion *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, (ArrayOf_USCOREtns1_USCORERemoteRoleActor *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteUser:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, (ArrayOf_USCOREtns1_USCORERemoteUser *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteProjectRole:
		soap_serialize_PointerTons2__RemoteProjectRole(soap, (ns2__RemoteProjectRole *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCOREtns1_USCORERemoteEntity:
		soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteEntity(soap, (ArrayOf_USCOREtns1_USCORERemoteEntity *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemotePermission:
		soap_serialize_PointerTons2__RemotePermission(soap, (ns2__RemotePermission *const*)ptr);
		break;
	case SOAP_TYPE_PointerToLONG64:
		soap_serialize_PointerToLONG64(soap, (LONG64 *const*)ptr);
		break;
	case SOAP_TYPE_PointerToArrayOf_USCORExsd_USCOREstring:
		soap_serialize_PointerToArrayOf_USCORExsd_USCOREstring(soap, (ArrayOf_USCORExsd_USCOREstring *const*)ptr);
		break;
	case SOAP_TYPE_PointerTons2__RemoteTimeInfo:
		soap_serialize_PointerTons2__RemoteTimeInfo(soap, (ns2__RemoteTimeInfo *const*)ptr);
		break;
	case SOAP_TYPE_PointerTotime:
		soap_serialize_PointerTotime(soap, (time_t *const*)ptr);
		break;
	case SOAP_TYPE__QName:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	case SOAP_TYPE_string:
		soap_serialize_string(soap, (char*const*)&ptr);
		break;
	}
}

#ifdef __cplusplus
}
#endif
#endif

SOAP_FMAC3 void * SOAP_FMAC4 soap_instantiate(struct soap *soap, int t, const char *type, const char *arrayType, size_t *n)
{
	switch (t)
	{
	case SOAP_TYPE_ns2__RemoteComment:
		return (void*)soap_instantiate_ns2__RemoteComment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteTimeInfo:
		return (void*)soap_instantiate_ns2__RemoteTimeInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteServerInfo:
		return (void*)soap_instantiate_ns2__RemoteServerInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteEntity:
		return (void*)soap_instantiate_ns2__RemoteEntity(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__AbstractRemoteEntity:
		return (void*)soap_instantiate_ns2__AbstractRemoteEntity(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteCustomFieldValue:
		return (void*)soap_instantiate_ns2__RemoteCustomFieldValue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteConfiguration:
		return (void*)soap_instantiate_ns2__RemoteConfiguration(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteScheme:
		return (void*)soap_instantiate_ns2__RemoteScheme(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemotePermission:
		return (void*)soap_instantiate_ns2__RemotePermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemotePermissionMapping:
		return (void*)soap_instantiate_ns2__RemotePermissionMapping(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteProjectRole:
		return (void*)soap_instantiate_ns2__RemoteProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteRoleActor:
		return (void*)soap_instantiate_ns2__RemoteRoleActor(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteRoleActors:
		return (void*)soap_instantiate_ns2__RemoteRoleActors(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteFieldValue:
		return (void*)soap_instantiate_ns2__RemoteFieldValue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteWorklog:
		return (void*)soap_instantiate_ns2__RemoteWorklog(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteAvatar:
		return (void*)soap_instantiate_ns2__RemoteAvatar(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns3__RemoteException:
		return (void*)soap_instantiate_ns3__RemoteException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteUser:
		return (void*)soap_instantiate_ns2__RemoteUser(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteGroup:
		return (void*)soap_instantiate_ns2__RemoteGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__AbstractNamedRemoteEntity:
		return (void*)soap_instantiate_ns2__AbstractNamedRemoteEntity(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteIssue:
		return (void*)soap_instantiate_ns2__RemoteIssue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemotePermissionScheme:
		return (void*)soap_instantiate_ns2__RemotePermissionScheme(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteProjectRoleActors:
		return (void*)soap_instantiate_ns2__RemoteProjectRoleActors(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteAttachment:
		return (void*)soap_instantiate_ns2__RemoteAttachment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns3__RemoteAuthenticationException:
		return (void*)soap_instantiate_ns3__RemoteAuthenticationException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns3__RemoteValidationException:
		return (void*)soap_instantiate_ns3__RemoteValidationException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns3__RemotePermissionException:
		return (void*)soap_instantiate_ns3__RemotePermissionException(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteUser(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteComponent(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteVersion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring:
		return (void*)soap_instantiate_ArrayOf_USCORExsd_USCOREstring(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteIssueType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteEntity(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePriority(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteResolution(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteScheme(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteField(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteComment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteFilter(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, -1, type, arrayType, n);
	case SOAP_TYPE__Struct_1:
		return (void*)soap_instantiate__Struct_1(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary:
		return (void*)soap_instantiate_ArrayOf_USCORExsd_USCOREbase64Binary(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteAttachment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteWorklog(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteAvatar(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePermission(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteIssue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject:
		return (void*)soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteProject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteComponent:
		return (void*)soap_instantiate_ns2__RemoteComponent(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteVersion:
		return (void*)soap_instantiate_ns2__RemoteVersion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteNamedObject:
		return (void*)soap_instantiate_ns2__RemoteNamedObject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__AbstractRemoteConstant:
		return (void*)soap_instantiate_ns2__AbstractRemoteConstant(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteProject:
		return (void*)soap_instantiate_ns2__RemoteProject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteField:
		return (void*)soap_instantiate_ns2__RemoteField(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteFilter:
		return (void*)soap_instantiate_ns2__RemoteFilter(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteSecurityLevel:
		return (void*)soap_instantiate_ns2__RemoteSecurityLevel(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteIssueType:
		return (void*)soap_instantiate_ns2__RemoteIssueType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemotePriority:
		return (void*)soap_instantiate_ns2__RemotePriority(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteResolution:
		return (void*)soap_instantiate_ns2__RemoteResolution(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns2__RemoteStatus:
		return (void*)soap_instantiate_ns2__RemoteStatus(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__RemoteAuthenticationException:
		return (void*)soap_instantiate__ns1__RemoteAuthenticationException(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__RemoteException:
		return (void*)soap_instantiate__ns1__RemoteException(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__RemotePermissionException:
		return (void*)soap_instantiate__ns1__RemotePermissionException(soap, -1, type, arrayType, n);
	case SOAP_TYPE__ns1__RemoteValidationException:
		return (void*)soap_instantiate__ns1__RemoteValidationException(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Detail:
		return (void*)soap_instantiate_SOAP_ENV__Detail(soap, -1, type, arrayType, n);
#endif
	case SOAP_TYPE_ns4__getCommentResponse:
		return (void*)soap_instantiate_ns4__getCommentResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getComment:
		return (void*)soap_instantiate_ns4__getComment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getServerInfoResponse:
		return (void*)soap_instantiate_ns4__getServerInfoResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getServerInfo:
		return (void*)soap_instantiate_ns4__getServerInfo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createGroupResponse:
		return (void*)soap_instantiate_ns4__createGroupResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createGroup:
		return (void*)soap_instantiate_ns4__createGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getGroupResponse:
		return (void*)soap_instantiate_ns4__getGroupResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getGroup:
		return (void*)soap_instantiate_ns4__getGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__loginResponse:
		return (void*)soap_instantiate_ns4__loginResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__login:
		return (void*)soap_instantiate_ns4__login(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getUserResponse:
		return (void*)soap_instantiate_ns4__getUserResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getUser:
		return (void*)soap_instantiate_ns4__getUser(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getComponentsResponse:
		return (void*)soap_instantiate_ns4__getComponentsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getComponents:
		return (void*)soap_instantiate_ns4__getComponents(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createUserResponse:
		return (void*)soap_instantiate_ns4__createUserResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createUser:
		return (void*)soap_instantiate_ns4__createUser(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssueResponse:
		return (void*)soap_instantiate_ns4__getIssueResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssue:
		return (void*)soap_instantiate_ns4__getIssue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createIssueResponse:
		return (void*)soap_instantiate_ns4__createIssueResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createIssue:
		return (void*)soap_instantiate_ns4__createIssue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAvailableActionsResponse:
		return (void*)soap_instantiate_ns4__getAvailableActionsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAvailableActions:
		return (void*)soap_instantiate_ns4__getAvailableActions(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSubTaskIssueTypesResponse:
		return (void*)soap_instantiate_ns4__getSubTaskIssueTypesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSubTaskIssueTypes:
		return (void*)soap_instantiate_ns4__getSubTaskIssueTypes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getConfigurationResponse:
		return (void*)soap_instantiate_ns4__getConfigurationResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getConfiguration:
		return (void*)soap_instantiate_ns4__getConfiguration(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createProjectResponse:
		return (void*)soap_instantiate_ns4__createProjectResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createProject:
		return (void*)soap_instantiate_ns4__createProject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateProjectResponse:
		return (void*)soap_instantiate_ns4__updateProjectResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateProject:
		return (void*)soap_instantiate_ns4__updateProject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectByKeyResponse:
		return (void*)soap_instantiate_ns4__getProjectByKeyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectByKey:
		return (void*)soap_instantiate_ns4__getProjectByKey(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeAllRoleActorsByProjectResponse:
		return (void*)soap_instantiate_ns4__removeAllRoleActorsByProjectResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeAllRoleActorsByProject:
		return (void*)soap_instantiate_ns4__removeAllRoleActorsByProject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getPrioritiesResponse:
		return (void*)soap_instantiate_ns4__getPrioritiesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getPriorities:
		return (void*)soap_instantiate_ns4__getPriorities(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getResolutionsResponse:
		return (void*)soap_instantiate_ns4__getResolutionsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getResolutions:
		return (void*)soap_instantiate_ns4__getResolutions(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssueTypesResponse:
		return (void*)soap_instantiate_ns4__getIssueTypesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssueTypes:
		return (void*)soap_instantiate_ns4__getIssueTypes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getStatusesResponse:
		return (void*)soap_instantiate_ns4__getStatusesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getStatuses:
		return (void*)soap_instantiate_ns4__getStatuses(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectRolesResponse:
		return (void*)soap_instantiate_ns4__getProjectRolesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectRoles:
		return (void*)soap_instantiate_ns4__getProjectRoles(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectRoleResponse:
		return (void*)soap_instantiate_ns4__getProjectRoleResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectRole:
		return (void*)soap_instantiate_ns4__getProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectRoleActorsResponse:
		return (void*)soap_instantiate_ns4__getProjectRoleActorsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectRoleActors:
		return (void*)soap_instantiate_ns4__getProjectRoleActors(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getDefaultRoleActorsResponse:
		return (void*)soap_instantiate_ns4__getDefaultRoleActorsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getDefaultRoleActors:
		return (void*)soap_instantiate_ns4__getDefaultRoleActors(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndTypeResponse:
		return (void*)soap_instantiate_ns4__removeAllRoleActorsByNameAndTypeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndType:
		return (void*)soap_instantiate_ns4__removeAllRoleActorsByNameAndType(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteProjectRoleResponse:
		return (void*)soap_instantiate_ns4__deleteProjectRoleResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteProjectRole:
		return (void*)soap_instantiate_ns4__deleteProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateProjectRoleResponse:
		return (void*)soap_instantiate_ns4__updateProjectRoleResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateProjectRole:
		return (void*)soap_instantiate_ns4__updateProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createProjectRoleResponse:
		return (void*)soap_instantiate_ns4__createProjectRoleResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createProjectRole:
		return (void*)soap_instantiate_ns4__createProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__isProjectRoleNameUniqueResponse:
		return (void*)soap_instantiate_ns4__isProjectRoleNameUniqueResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__isProjectRoleNameUnique:
		return (void*)soap_instantiate_ns4__isProjectRoleNameUnique(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addActorsToProjectRoleResponse:
		return (void*)soap_instantiate_ns4__addActorsToProjectRoleResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addActorsToProjectRole:
		return (void*)soap_instantiate_ns4__addActorsToProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeActorsFromProjectRoleResponse:
		return (void*)soap_instantiate_ns4__removeActorsFromProjectRoleResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeActorsFromProjectRole:
		return (void*)soap_instantiate_ns4__removeActorsFromProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRoleResponse:
		return (void*)soap_instantiate_ns4__addDefaultActorsToProjectRoleResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRole:
		return (void*)soap_instantiate_ns4__addDefaultActorsToProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRoleResponse:
		return (void*)soap_instantiate_ns4__removeDefaultActorsFromProjectRoleResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRole:
		return (void*)soap_instantiate_ns4__removeDefaultActorsFromProjectRole(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemesResponse:
		return (void*)soap_instantiate_ns4__getAssociatedNotificationSchemesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemes:
		return (void*)soap_instantiate_ns4__getAssociatedNotificationSchemes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemesResponse:
		return (void*)soap_instantiate_ns4__getAssociatedPermissionSchemesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemes:
		return (void*)soap_instantiate_ns4__getAssociatedPermissionSchemes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteProjectResponse:
		return (void*)soap_instantiate_ns4__deleteProjectResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteProject:
		return (void*)soap_instantiate_ns4__deleteProject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectByIdResponse:
		return (void*)soap_instantiate_ns4__getProjectByIdResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectById:
		return (void*)soap_instantiate_ns4__getProjectById(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getVersionsResponse:
		return (void*)soap_instantiate_ns4__getVersionsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getVersions:
		return (void*)soap_instantiate_ns4__getVersions(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getCustomFieldsResponse:
		return (void*)soap_instantiate_ns4__getCustomFieldsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getCustomFields:
		return (void*)soap_instantiate_ns4__getCustomFields(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getCommentsResponse:
		return (void*)soap_instantiate_ns4__getCommentsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getComments:
		return (void*)soap_instantiate_ns4__getComments(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getFavouriteFiltersResponse:
		return (void*)soap_instantiate_ns4__getFavouriteFiltersResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getFavouriteFilters:
		return (void*)soap_instantiate_ns4__getFavouriteFilters(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__releaseVersionResponse:
		return (void*)soap_instantiate_ns4__releaseVersionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__releaseVersion:
		return (void*)soap_instantiate_ns4__releaseVersion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__archiveVersionResponse:
		return (void*)soap_instantiate_ns4__archiveVersionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__archiveVersion:
		return (void*)soap_instantiate_ns4__archiveVersion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateIssueResponse:
		return (void*)soap_instantiate_ns4__updateIssueResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateIssue:
		return (void*)soap_instantiate_ns4__updateIssue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getFieldsForEditResponse:
		return (void*)soap_instantiate_ns4__getFieldsForEditResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getFieldsForEdit:
		return (void*)soap_instantiate_ns4__getFieldsForEdit(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssueTypesForProjectResponse:
		return (void*)soap_instantiate_ns4__getIssueTypesForProjectResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssueTypesForProject:
		return (void*)soap_instantiate_ns4__getIssueTypesForProject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProjectResponse:
		return (void*)soap_instantiate_ns4__getSubTaskIssueTypesForProjectResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProject:
		return (void*)soap_instantiate_ns4__getSubTaskIssueTypesForProject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addUserToGroupResponse:
		return (void*)soap_instantiate_ns4__addUserToGroupResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addUserToGroup:
		return (void*)soap_instantiate_ns4__addUserToGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeUserFromGroupResponse:
		return (void*)soap_instantiate_ns4__removeUserFromGroupResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__removeUserFromGroup:
		return (void*)soap_instantiate_ns4__removeUserFromGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSecurityLevelResponse:
		return (void*)soap_instantiate_ns4__getSecurityLevelResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSecurityLevel:
		return (void*)soap_instantiate_ns4__getSecurityLevel(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addCommentResponse:
		return (void*)soap_instantiate_ns4__addCommentResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addComment:
		return (void*)soap_instantiate_ns4__addComment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createIssueWithSecurityLevelResponse:
		return (void*)soap_instantiate_ns4__createIssueWithSecurityLevelResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createIssueWithSecurityLevel:
		return (void*)soap_instantiate_ns4__createIssueWithSecurityLevel(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addAttachmentsToIssueResponse:
		return (void*)soap_instantiate_ns4__addAttachmentsToIssueResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addAttachmentsToIssue:
		return (void*)soap_instantiate_ns4__addAttachmentsToIssue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAttachmentsFromIssueResponse:
		return (void*)soap_instantiate_ns4__getAttachmentsFromIssueResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAttachmentsFromIssue:
		return (void*)soap_instantiate_ns4__getAttachmentsFromIssue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteIssueResponse:
		return (void*)soap_instantiate_ns4__deleteIssueResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteIssue:
		return (void*)soap_instantiate_ns4__deleteIssue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__hasPermissionToEditCommentResponse:
		return (void*)soap_instantiate_ns4__hasPermissionToEditCommentResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__hasPermissionToEditComment:
		return (void*)soap_instantiate_ns4__hasPermissionToEditComment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__editCommentResponse:
		return (void*)soap_instantiate_ns4__editCommentResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__editComment:
		return (void*)soap_instantiate_ns4__editComment(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getFieldsForActionResponse:
		return (void*)soap_instantiate_ns4__getFieldsForActionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getFieldsForAction:
		return (void*)soap_instantiate_ns4__getFieldsForAction(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__progressWorkflowActionResponse:
		return (void*)soap_instantiate_ns4__progressWorkflowActionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__progressWorkflowAction:
		return (void*)soap_instantiate_ns4__progressWorkflowAction(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssueByIdResponse:
		return (void*)soap_instantiate_ns4__getIssueByIdResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssueById:
		return (void*)soap_instantiate_ns4__getIssueById(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimateResponse:
		return (void*)soap_instantiate_ns4__addWorklogWithNewRemainingEstimateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimate:
		return (void*)soap_instantiate_ns4__addWorklogWithNewRemainingEstimate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse:
		return (void*)soap_instantiate_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimate:
		return (void*)soap_instantiate_ns4__addWorklogAndAutoAdjustRemainingEstimate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimateResponse:
		return (void*)soap_instantiate_ns4__addWorklogAndRetainRemainingEstimateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimate:
		return (void*)soap_instantiate_ns4__addWorklogAndRetainRemainingEstimate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimateResponse:
		return (void*)soap_instantiate_ns4__deleteWorklogWithNewRemainingEstimateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimate:
		return (void*)soap_instantiate_ns4__deleteWorklogWithNewRemainingEstimate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse:
		return (void*)soap_instantiate_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimate:
		return (void*)soap_instantiate_ns4__deleteWorklogAndAutoAdjustRemainingEstimate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimateResponse:
		return (void*)soap_instantiate_ns4__deleteWorklogAndRetainRemainingEstimateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimate:
		return (void*)soap_instantiate_ns4__deleteWorklogAndRetainRemainingEstimate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimateResponse:
		return (void*)soap_instantiate_ns4__updateWorklogWithNewRemainingEstimateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimate:
		return (void*)soap_instantiate_ns4__updateWorklogWithNewRemainingEstimate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse:
		return (void*)soap_instantiate_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimate:
		return (void*)soap_instantiate_ns4__updateWorklogAndAutoAdjustRemainingEstimate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimateResponse:
		return (void*)soap_instantiate_ns4__updateWorklogAndRetainRemainingEstimateResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimate:
		return (void*)soap_instantiate_ns4__updateWorklogAndRetainRemainingEstimate(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getWorklogsResponse:
		return (void*)soap_instantiate_ns4__getWorklogsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getWorklogs:
		return (void*)soap_instantiate_ns4__getWorklogs(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklogResponse:
		return (void*)soap_instantiate_ns4__hasPermissionToCreateWorklogResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklog:
		return (void*)soap_instantiate_ns4__hasPermissionToCreateWorklog(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklogResponse:
		return (void*)soap_instantiate_ns4__hasPermissionToDeleteWorklogResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklog:
		return (void*)soap_instantiate_ns4__hasPermissionToDeleteWorklog(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklogResponse:
		return (void*)soap_instantiate_ns4__hasPermissionToUpdateWorklogResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklog:
		return (void*)soap_instantiate_ns4__hasPermissionToUpdateWorklog(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getResolutionDateByKeyResponse:
		return (void*)soap_instantiate_ns4__getResolutionDateByKeyResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getResolutionDateByKey:
		return (void*)soap_instantiate_ns4__getResolutionDateByKey(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getResolutionDateByIdResponse:
		return (void*)soap_instantiate_ns4__getResolutionDateByIdResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getResolutionDateById:
		return (void*)soap_instantiate_ns4__getResolutionDateById(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__logoutResponse:
		return (void*)soap_instantiate_ns4__logoutResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__logout:
		return (void*)soap_instantiate_ns4__logout(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectWithSchemesByIdResponse:
		return (void*)soap_instantiate_ns4__getProjectWithSchemesByIdResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectWithSchemesById:
		return (void*)soap_instantiate_ns4__getProjectWithSchemesById(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSecurityLevelsResponse:
		return (void*)soap_instantiate_ns4__getSecurityLevelsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSecurityLevels:
		return (void*)soap_instantiate_ns4__getSecurityLevels(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectAvatarsResponse:
		return (void*)soap_instantiate_ns4__getProjectAvatarsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectAvatars:
		return (void*)soap_instantiate_ns4__getProjectAvatars(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__setProjectAvatarResponse:
		return (void*)soap_instantiate_ns4__setProjectAvatarResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__setProjectAvatar:
		return (void*)soap_instantiate_ns4__setProjectAvatar(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectAvatarResponse:
		return (void*)soap_instantiate_ns4__getProjectAvatarResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectAvatar:
		return (void*)soap_instantiate_ns4__getProjectAvatar(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteProjectAvatarResponse:
		return (void*)soap_instantiate_ns4__deleteProjectAvatarResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteProjectAvatar:
		return (void*)soap_instantiate_ns4__deleteProjectAvatar(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getNotificationSchemesResponse:
		return (void*)soap_instantiate_ns4__getNotificationSchemesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getNotificationSchemes:
		return (void*)soap_instantiate_ns4__getNotificationSchemes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getPermissionSchemesResponse:
		return (void*)soap_instantiate_ns4__getPermissionSchemesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getPermissionSchemes:
		return (void*)soap_instantiate_ns4__getPermissionSchemes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAllPermissionsResponse:
		return (void*)soap_instantiate_ns4__getAllPermissionsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getAllPermissions:
		return (void*)soap_instantiate_ns4__getAllPermissions(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createPermissionSchemeResponse:
		return (void*)soap_instantiate_ns4__createPermissionSchemeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createPermissionScheme:
		return (void*)soap_instantiate_ns4__createPermissionScheme(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addPermissionToResponse:
		return (void*)soap_instantiate_ns4__addPermissionToResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addPermissionTo:
		return (void*)soap_instantiate_ns4__addPermissionTo(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deletePermissionFromResponse:
		return (void*)soap_instantiate_ns4__deletePermissionFromResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deletePermissionFrom:
		return (void*)soap_instantiate_ns4__deletePermissionFrom(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deletePermissionSchemeResponse:
		return (void*)soap_instantiate_ns4__deletePermissionSchemeResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deletePermissionScheme:
		return (void*)soap_instantiate_ns4__deletePermissionScheme(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssueCountForFilterResponse:
		return (void*)soap_instantiate_ns4__getIssueCountForFilterResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssueCountForFilter:
		return (void*)soap_instantiate_ns4__getIssueCountForFilter(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromTextSearchResponse:
		return (void*)soap_instantiate_ns4__getIssuesFromTextSearchResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromTextSearch:
		return (void*)soap_instantiate_ns4__getIssuesFromTextSearch(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProjectResponse:
		return (void*)soap_instantiate_ns4__getIssuesFromTextSearchWithProjectResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProject:
		return (void*)soap_instantiate_ns4__getIssuesFromTextSearchWithProject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromJqlSearchResponse:
		return (void*)soap_instantiate_ns4__getIssuesFromJqlSearchResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromJqlSearch:
		return (void*)soap_instantiate_ns4__getIssuesFromJqlSearch(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteUserResponse:
		return (void*)soap_instantiate_ns4__deleteUserResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteUser:
		return (void*)soap_instantiate_ns4__deleteUser(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateGroupResponse:
		return (void*)soap_instantiate_ns4__updateGroupResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__updateGroup:
		return (void*)soap_instantiate_ns4__updateGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteGroupResponse:
		return (void*)soap_instantiate_ns4__deleteGroupResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__deleteGroup:
		return (void*)soap_instantiate_ns4__deleteGroup(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__refreshCustomFieldsResponse:
		return (void*)soap_instantiate_ns4__refreshCustomFieldsResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__refreshCustomFields:
		return (void*)soap_instantiate_ns4__refreshCustomFields(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSavedFiltersResponse:
		return (void*)soap_instantiate_ns4__getSavedFiltersResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSavedFilters:
		return (void*)soap_instantiate_ns4__getSavedFilters(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse:
		return (void*)soap_instantiate_ns4__addBase64EncodedAttachmentsToIssueResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue:
		return (void*)soap_instantiate_ns4__addBase64EncodedAttachmentsToIssue(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createProjectFromObjectResponse:
		return (void*)soap_instantiate_ns4__createProjectFromObjectResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__createProjectFromObject:
		return (void*)soap_instantiate_ns4__createProjectFromObject(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSecuritySchemesResponse:
		return (void*)soap_instantiate_ns4__getSecuritySchemesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getSecuritySchemes:
		return (void*)soap_instantiate_ns4__getSecuritySchemes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addVersionResponse:
		return (void*)soap_instantiate_ns4__addVersionResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__addVersion:
		return (void*)soap_instantiate_ns4__addVersion(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromFilterResponse:
		return (void*)soap_instantiate_ns4__getIssuesFromFilterResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromFilter:
		return (void*)soap_instantiate_ns4__getIssuesFromFilter(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse:
		return (void*)soap_instantiate_ns4__getIssuesFromFilterWithLimitResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimit:
		return (void*)soap_instantiate_ns4__getIssuesFromFilterWithLimit(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse:
		return (void*)soap_instantiate_ns4__getIssuesFromTextSearchWithLimitResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit:
		return (void*)soap_instantiate_ns4__getIssuesFromTextSearchWithLimit(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectsNoSchemesResponse:
		return (void*)soap_instantiate_ns4__getProjectsNoSchemesResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__getProjectsNoSchemes:
		return (void*)soap_instantiate_ns4__getProjectsNoSchemes(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__setNewProjectAvatarResponse:
		return (void*)soap_instantiate_ns4__setNewProjectAvatarResponse(soap, -1, type, arrayType, n);
	case SOAP_TYPE_ns4__setNewProjectAvatar:
		return (void*)soap_instantiate_ns4__setNewProjectAvatar(soap, -1, type, arrayType, n);
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Header:
		return (void*)soap_instantiate_SOAP_ENV__Header(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Code:
		return (void*)soap_instantiate_SOAP_ENV__Code(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Reason:
		return (void*)soap_instantiate_SOAP_ENV__Reason(soap, -1, type, arrayType, n);
#endif
#ifndef WITH_NOGLOBAL
	case SOAP_TYPE_SOAP_ENV__Fault:
		return (void*)soap_instantiate_SOAP_ENV__Fault(soap, -1, type, arrayType, n);
#endif
	}
	return NULL;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_fdelete(struct soap_clist *p)
{	switch (p->type)
	{
	case SOAP_TYPE_ns2__RemoteComment:
		if (p->size < 0)
			delete (ns2__RemoteComment*)p->ptr;
		else
			delete[] (ns2__RemoteComment*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteTimeInfo:
		if (p->size < 0)
			delete (ns2__RemoteTimeInfo*)p->ptr;
		else
			delete[] (ns2__RemoteTimeInfo*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteServerInfo:
		if (p->size < 0)
			delete (ns2__RemoteServerInfo*)p->ptr;
		else
			delete[] (ns2__RemoteServerInfo*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteEntity:
		if (p->size < 0)
			delete (ns2__RemoteEntity*)p->ptr;
		else
			delete[] (ns2__RemoteEntity*)p->ptr;
		break;
	case SOAP_TYPE_ns2__AbstractRemoteEntity:
		if (p->size < 0)
			delete (ns2__AbstractRemoteEntity*)p->ptr;
		else
			delete[] (ns2__AbstractRemoteEntity*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteCustomFieldValue:
		if (p->size < 0)
			delete (ns2__RemoteCustomFieldValue*)p->ptr;
		else
			delete[] (ns2__RemoteCustomFieldValue*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteConfiguration:
		if (p->size < 0)
			delete (ns2__RemoteConfiguration*)p->ptr;
		else
			delete[] (ns2__RemoteConfiguration*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteScheme:
		if (p->size < 0)
			delete (ns2__RemoteScheme*)p->ptr;
		else
			delete[] (ns2__RemoteScheme*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemotePermission:
		if (p->size < 0)
			delete (ns2__RemotePermission*)p->ptr;
		else
			delete[] (ns2__RemotePermission*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemotePermissionMapping:
		if (p->size < 0)
			delete (ns2__RemotePermissionMapping*)p->ptr;
		else
			delete[] (ns2__RemotePermissionMapping*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteProjectRole:
		if (p->size < 0)
			delete (ns2__RemoteProjectRole*)p->ptr;
		else
			delete[] (ns2__RemoteProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteRoleActor:
		if (p->size < 0)
			delete (ns2__RemoteRoleActor*)p->ptr;
		else
			delete[] (ns2__RemoteRoleActor*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteRoleActors:
		if (p->size < 0)
			delete (ns2__RemoteRoleActors*)p->ptr;
		else
			delete[] (ns2__RemoteRoleActors*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteFieldValue:
		if (p->size < 0)
			delete (ns2__RemoteFieldValue*)p->ptr;
		else
			delete[] (ns2__RemoteFieldValue*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteWorklog:
		if (p->size < 0)
			delete (ns2__RemoteWorklog*)p->ptr;
		else
			delete[] (ns2__RemoteWorklog*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteAvatar:
		if (p->size < 0)
			delete (ns2__RemoteAvatar*)p->ptr;
		else
			delete[] (ns2__RemoteAvatar*)p->ptr;
		break;
	case SOAP_TYPE_ns3__RemoteException:
		if (p->size < 0)
			delete (ns3__RemoteException*)p->ptr;
		else
			delete[] (ns3__RemoteException*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteUser:
		if (p->size < 0)
			delete (ns2__RemoteUser*)p->ptr;
		else
			delete[] (ns2__RemoteUser*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteGroup:
		if (p->size < 0)
			delete (ns2__RemoteGroup*)p->ptr;
		else
			delete[] (ns2__RemoteGroup*)p->ptr;
		break;
	case SOAP_TYPE_ns2__AbstractNamedRemoteEntity:
		if (p->size < 0)
			delete (ns2__AbstractNamedRemoteEntity*)p->ptr;
		else
			delete[] (ns2__AbstractNamedRemoteEntity*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteIssue:
		if (p->size < 0)
			delete (ns2__RemoteIssue*)p->ptr;
		else
			delete[] (ns2__RemoteIssue*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemotePermissionScheme:
		if (p->size < 0)
			delete (ns2__RemotePermissionScheme*)p->ptr;
		else
			delete[] (ns2__RemotePermissionScheme*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteProjectRoleActors:
		if (p->size < 0)
			delete (ns2__RemoteProjectRoleActors*)p->ptr;
		else
			delete[] (ns2__RemoteProjectRoleActors*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteAttachment:
		if (p->size < 0)
			delete (ns2__RemoteAttachment*)p->ptr;
		else
			delete[] (ns2__RemoteAttachment*)p->ptr;
		break;
	case SOAP_TYPE_ns3__RemoteAuthenticationException:
		if (p->size < 0)
			delete (ns3__RemoteAuthenticationException*)p->ptr;
		else
			delete[] (ns3__RemoteAuthenticationException*)p->ptr;
		break;
	case SOAP_TYPE_ns3__RemoteValidationException:
		if (p->size < 0)
			delete (ns3__RemoteValidationException*)p->ptr;
		else
			delete[] (ns3__RemoteValidationException*)p->ptr;
		break;
	case SOAP_TYPE_ns3__RemotePermissionException:
		if (p->size < 0)
			delete (ns3__RemotePermissionException*)p->ptr;
		else
			delete[] (ns3__RemotePermissionException*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteUser*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteUser*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteComponent*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteComponent*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteVersion*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteVersion*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring:
		if (p->size < 0)
			delete (ArrayOf_USCORExsd_USCOREstring*)p->ptr;
		else
			delete[] (ArrayOf_USCORExsd_USCOREstring*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteNamedObject*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteNamedObject*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteIssueType*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteIssueType*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteEntity*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteEntity*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemotePermissionMapping*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemotePermissionMapping*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemotePriority*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemotePriority*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteResolution*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteResolution*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteStatus*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteStatus*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteProjectRole*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteRoleActor*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteRoleActor*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteScheme*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteScheme*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteField*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteField*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteComment*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteComment*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteFilter*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteFilter*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteFieldValue*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteFieldValue*)p->ptr;
		break;
	case SOAP_TYPE__Struct_1:
		if (p->size < 0)
			delete (_Struct_1*)p->ptr;
		else
			delete[] (_Struct_1*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary:
		if (p->size < 0)
			delete (ArrayOf_USCORExsd_USCOREbase64Binary*)p->ptr;
		else
			delete[] (ArrayOf_USCORExsd_USCOREbase64Binary*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteAttachment*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteAttachment*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteWorklog*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteWorklog*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteSecurityLevel*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteSecurityLevel*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteAvatar*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteAvatar*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemotePermissionScheme*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemotePermissionScheme*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemotePermission*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemotePermission*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteIssue*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteIssue*)p->ptr;
		break;
	case SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject:
		if (p->size < 0)
			delete (ArrayOf_USCOREtns1_USCORERemoteProject*)p->ptr;
		else
			delete[] (ArrayOf_USCOREtns1_USCORERemoteProject*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteComponent:
		if (p->size < 0)
			delete (ns2__RemoteComponent*)p->ptr;
		else
			delete[] (ns2__RemoteComponent*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteVersion:
		if (p->size < 0)
			delete (ns2__RemoteVersion*)p->ptr;
		else
			delete[] (ns2__RemoteVersion*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteNamedObject:
		if (p->size < 0)
			delete (ns2__RemoteNamedObject*)p->ptr;
		else
			delete[] (ns2__RemoteNamedObject*)p->ptr;
		break;
	case SOAP_TYPE_ns2__AbstractRemoteConstant:
		if (p->size < 0)
			delete (ns2__AbstractRemoteConstant*)p->ptr;
		else
			delete[] (ns2__AbstractRemoteConstant*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteProject:
		if (p->size < 0)
			delete (ns2__RemoteProject*)p->ptr;
		else
			delete[] (ns2__RemoteProject*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteField:
		if (p->size < 0)
			delete (ns2__RemoteField*)p->ptr;
		else
			delete[] (ns2__RemoteField*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteFilter:
		if (p->size < 0)
			delete (ns2__RemoteFilter*)p->ptr;
		else
			delete[] (ns2__RemoteFilter*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteSecurityLevel:
		if (p->size < 0)
			delete (ns2__RemoteSecurityLevel*)p->ptr;
		else
			delete[] (ns2__RemoteSecurityLevel*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteIssueType:
		if (p->size < 0)
			delete (ns2__RemoteIssueType*)p->ptr;
		else
			delete[] (ns2__RemoteIssueType*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemotePriority:
		if (p->size < 0)
			delete (ns2__RemotePriority*)p->ptr;
		else
			delete[] (ns2__RemotePriority*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteResolution:
		if (p->size < 0)
			delete (ns2__RemoteResolution*)p->ptr;
		else
			delete[] (ns2__RemoteResolution*)p->ptr;
		break;
	case SOAP_TYPE_ns2__RemoteStatus:
		if (p->size < 0)
			delete (ns2__RemoteStatus*)p->ptr;
		else
			delete[] (ns2__RemoteStatus*)p->ptr;
		break;
	case SOAP_TYPE__ns1__RemoteAuthenticationException:
		if (p->size < 0)
			delete (_ns1__RemoteAuthenticationException*)p->ptr;
		else
			delete[] (_ns1__RemoteAuthenticationException*)p->ptr;
		break;
	case SOAP_TYPE__ns1__RemoteException:
		if (p->size < 0)
			delete (_ns1__RemoteException*)p->ptr;
		else
			delete[] (_ns1__RemoteException*)p->ptr;
		break;
	case SOAP_TYPE__ns1__RemotePermissionException:
		if (p->size < 0)
			delete (_ns1__RemotePermissionException*)p->ptr;
		else
			delete[] (_ns1__RemotePermissionException*)p->ptr;
		break;
	case SOAP_TYPE__ns1__RemoteValidationException:
		if (p->size < 0)
			delete (_ns1__RemoteValidationException*)p->ptr;
		else
			delete[] (_ns1__RemoteValidationException*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Detail:
		if (p->size < 0)
			delete (struct SOAP_ENV__Detail*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Detail*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getCommentResponse:
		if (p->size < 0)
			delete (struct ns4__getCommentResponse*)p->ptr;
		else
			delete[] (struct ns4__getCommentResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getComment:
		if (p->size < 0)
			delete (struct ns4__getComment*)p->ptr;
		else
			delete[] (struct ns4__getComment*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getServerInfoResponse:
		if (p->size < 0)
			delete (struct ns4__getServerInfoResponse*)p->ptr;
		else
			delete[] (struct ns4__getServerInfoResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getServerInfo:
		if (p->size < 0)
			delete (struct ns4__getServerInfo*)p->ptr;
		else
			delete[] (struct ns4__getServerInfo*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createGroupResponse:
		if (p->size < 0)
			delete (struct ns4__createGroupResponse*)p->ptr;
		else
			delete[] (struct ns4__createGroupResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createGroup:
		if (p->size < 0)
			delete (struct ns4__createGroup*)p->ptr;
		else
			delete[] (struct ns4__createGroup*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getGroupResponse:
		if (p->size < 0)
			delete (struct ns4__getGroupResponse*)p->ptr;
		else
			delete[] (struct ns4__getGroupResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getGroup:
		if (p->size < 0)
			delete (struct ns4__getGroup*)p->ptr;
		else
			delete[] (struct ns4__getGroup*)p->ptr;
		break;
	case SOAP_TYPE_ns4__loginResponse:
		if (p->size < 0)
			delete (struct ns4__loginResponse*)p->ptr;
		else
			delete[] (struct ns4__loginResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__login:
		if (p->size < 0)
			delete (struct ns4__login*)p->ptr;
		else
			delete[] (struct ns4__login*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getUserResponse:
		if (p->size < 0)
			delete (struct ns4__getUserResponse*)p->ptr;
		else
			delete[] (struct ns4__getUserResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getUser:
		if (p->size < 0)
			delete (struct ns4__getUser*)p->ptr;
		else
			delete[] (struct ns4__getUser*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getComponentsResponse:
		if (p->size < 0)
			delete (struct ns4__getComponentsResponse*)p->ptr;
		else
			delete[] (struct ns4__getComponentsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getComponents:
		if (p->size < 0)
			delete (struct ns4__getComponents*)p->ptr;
		else
			delete[] (struct ns4__getComponents*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createUserResponse:
		if (p->size < 0)
			delete (struct ns4__createUserResponse*)p->ptr;
		else
			delete[] (struct ns4__createUserResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createUser:
		if (p->size < 0)
			delete (struct ns4__createUser*)p->ptr;
		else
			delete[] (struct ns4__createUser*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssueResponse:
		if (p->size < 0)
			delete (struct ns4__getIssueResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssueResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssue:
		if (p->size < 0)
			delete (struct ns4__getIssue*)p->ptr;
		else
			delete[] (struct ns4__getIssue*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createIssueResponse:
		if (p->size < 0)
			delete (struct ns4__createIssueResponse*)p->ptr;
		else
			delete[] (struct ns4__createIssueResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createIssue:
		if (p->size < 0)
			delete (struct ns4__createIssue*)p->ptr;
		else
			delete[] (struct ns4__createIssue*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAvailableActionsResponse:
		if (p->size < 0)
			delete (struct ns4__getAvailableActionsResponse*)p->ptr;
		else
			delete[] (struct ns4__getAvailableActionsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAvailableActions:
		if (p->size < 0)
			delete (struct ns4__getAvailableActions*)p->ptr;
		else
			delete[] (struct ns4__getAvailableActions*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSubTaskIssueTypesResponse:
		if (p->size < 0)
			delete (struct ns4__getSubTaskIssueTypesResponse*)p->ptr;
		else
			delete[] (struct ns4__getSubTaskIssueTypesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSubTaskIssueTypes:
		if (p->size < 0)
			delete (struct ns4__getSubTaskIssueTypes*)p->ptr;
		else
			delete[] (struct ns4__getSubTaskIssueTypes*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getConfigurationResponse:
		if (p->size < 0)
			delete (struct ns4__getConfigurationResponse*)p->ptr;
		else
			delete[] (struct ns4__getConfigurationResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getConfiguration:
		if (p->size < 0)
			delete (struct ns4__getConfiguration*)p->ptr;
		else
			delete[] (struct ns4__getConfiguration*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createProjectResponse:
		if (p->size < 0)
			delete (struct ns4__createProjectResponse*)p->ptr;
		else
			delete[] (struct ns4__createProjectResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createProject:
		if (p->size < 0)
			delete (struct ns4__createProject*)p->ptr;
		else
			delete[] (struct ns4__createProject*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateProjectResponse:
		if (p->size < 0)
			delete (struct ns4__updateProjectResponse*)p->ptr;
		else
			delete[] (struct ns4__updateProjectResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateProject:
		if (p->size < 0)
			delete (struct ns4__updateProject*)p->ptr;
		else
			delete[] (struct ns4__updateProject*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectByKeyResponse:
		if (p->size < 0)
			delete (struct ns4__getProjectByKeyResponse*)p->ptr;
		else
			delete[] (struct ns4__getProjectByKeyResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectByKey:
		if (p->size < 0)
			delete (struct ns4__getProjectByKey*)p->ptr;
		else
			delete[] (struct ns4__getProjectByKey*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeAllRoleActorsByProjectResponse:
		if (p->size < 0)
			delete (struct ns4__removeAllRoleActorsByProjectResponse*)p->ptr;
		else
			delete[] (struct ns4__removeAllRoleActorsByProjectResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeAllRoleActorsByProject:
		if (p->size < 0)
			delete (struct ns4__removeAllRoleActorsByProject*)p->ptr;
		else
			delete[] (struct ns4__removeAllRoleActorsByProject*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getPrioritiesResponse:
		if (p->size < 0)
			delete (struct ns4__getPrioritiesResponse*)p->ptr;
		else
			delete[] (struct ns4__getPrioritiesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getPriorities:
		if (p->size < 0)
			delete (struct ns4__getPriorities*)p->ptr;
		else
			delete[] (struct ns4__getPriorities*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getResolutionsResponse:
		if (p->size < 0)
			delete (struct ns4__getResolutionsResponse*)p->ptr;
		else
			delete[] (struct ns4__getResolutionsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getResolutions:
		if (p->size < 0)
			delete (struct ns4__getResolutions*)p->ptr;
		else
			delete[] (struct ns4__getResolutions*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssueTypesResponse:
		if (p->size < 0)
			delete (struct ns4__getIssueTypesResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssueTypesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssueTypes:
		if (p->size < 0)
			delete (struct ns4__getIssueTypes*)p->ptr;
		else
			delete[] (struct ns4__getIssueTypes*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getStatusesResponse:
		if (p->size < 0)
			delete (struct ns4__getStatusesResponse*)p->ptr;
		else
			delete[] (struct ns4__getStatusesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getStatuses:
		if (p->size < 0)
			delete (struct ns4__getStatuses*)p->ptr;
		else
			delete[] (struct ns4__getStatuses*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectRolesResponse:
		if (p->size < 0)
			delete (struct ns4__getProjectRolesResponse*)p->ptr;
		else
			delete[] (struct ns4__getProjectRolesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectRoles:
		if (p->size < 0)
			delete (struct ns4__getProjectRoles*)p->ptr;
		else
			delete[] (struct ns4__getProjectRoles*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectRoleResponse:
		if (p->size < 0)
			delete (struct ns4__getProjectRoleResponse*)p->ptr;
		else
			delete[] (struct ns4__getProjectRoleResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectRole:
		if (p->size < 0)
			delete (struct ns4__getProjectRole*)p->ptr;
		else
			delete[] (struct ns4__getProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectRoleActorsResponse:
		if (p->size < 0)
			delete (struct ns4__getProjectRoleActorsResponse*)p->ptr;
		else
			delete[] (struct ns4__getProjectRoleActorsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectRoleActors:
		if (p->size < 0)
			delete (struct ns4__getProjectRoleActors*)p->ptr;
		else
			delete[] (struct ns4__getProjectRoleActors*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getDefaultRoleActorsResponse:
		if (p->size < 0)
			delete (struct ns4__getDefaultRoleActorsResponse*)p->ptr;
		else
			delete[] (struct ns4__getDefaultRoleActorsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getDefaultRoleActors:
		if (p->size < 0)
			delete (struct ns4__getDefaultRoleActors*)p->ptr;
		else
			delete[] (struct ns4__getDefaultRoleActors*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndTypeResponse:
		if (p->size < 0)
			delete (struct ns4__removeAllRoleActorsByNameAndTypeResponse*)p->ptr;
		else
			delete[] (struct ns4__removeAllRoleActorsByNameAndTypeResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeAllRoleActorsByNameAndType:
		if (p->size < 0)
			delete (struct ns4__removeAllRoleActorsByNameAndType*)p->ptr;
		else
			delete[] (struct ns4__removeAllRoleActorsByNameAndType*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteProjectRoleResponse:
		if (p->size < 0)
			delete (struct ns4__deleteProjectRoleResponse*)p->ptr;
		else
			delete[] (struct ns4__deleteProjectRoleResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteProjectRole:
		if (p->size < 0)
			delete (struct ns4__deleteProjectRole*)p->ptr;
		else
			delete[] (struct ns4__deleteProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateProjectRoleResponse:
		if (p->size < 0)
			delete (struct ns4__updateProjectRoleResponse*)p->ptr;
		else
			delete[] (struct ns4__updateProjectRoleResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateProjectRole:
		if (p->size < 0)
			delete (struct ns4__updateProjectRole*)p->ptr;
		else
			delete[] (struct ns4__updateProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createProjectRoleResponse:
		if (p->size < 0)
			delete (struct ns4__createProjectRoleResponse*)p->ptr;
		else
			delete[] (struct ns4__createProjectRoleResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createProjectRole:
		if (p->size < 0)
			delete (struct ns4__createProjectRole*)p->ptr;
		else
			delete[] (struct ns4__createProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ns4__isProjectRoleNameUniqueResponse:
		if (p->size < 0)
			delete (struct ns4__isProjectRoleNameUniqueResponse*)p->ptr;
		else
			delete[] (struct ns4__isProjectRoleNameUniqueResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__isProjectRoleNameUnique:
		if (p->size < 0)
			delete (struct ns4__isProjectRoleNameUnique*)p->ptr;
		else
			delete[] (struct ns4__isProjectRoleNameUnique*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addActorsToProjectRoleResponse:
		if (p->size < 0)
			delete (struct ns4__addActorsToProjectRoleResponse*)p->ptr;
		else
			delete[] (struct ns4__addActorsToProjectRoleResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addActorsToProjectRole:
		if (p->size < 0)
			delete (struct ns4__addActorsToProjectRole*)p->ptr;
		else
			delete[] (struct ns4__addActorsToProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeActorsFromProjectRoleResponse:
		if (p->size < 0)
			delete (struct ns4__removeActorsFromProjectRoleResponse*)p->ptr;
		else
			delete[] (struct ns4__removeActorsFromProjectRoleResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeActorsFromProjectRole:
		if (p->size < 0)
			delete (struct ns4__removeActorsFromProjectRole*)p->ptr;
		else
			delete[] (struct ns4__removeActorsFromProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRoleResponse:
		if (p->size < 0)
			delete (struct ns4__addDefaultActorsToProjectRoleResponse*)p->ptr;
		else
			delete[] (struct ns4__addDefaultActorsToProjectRoleResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addDefaultActorsToProjectRole:
		if (p->size < 0)
			delete (struct ns4__addDefaultActorsToProjectRole*)p->ptr;
		else
			delete[] (struct ns4__addDefaultActorsToProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRoleResponse:
		if (p->size < 0)
			delete (struct ns4__removeDefaultActorsFromProjectRoleResponse*)p->ptr;
		else
			delete[] (struct ns4__removeDefaultActorsFromProjectRoleResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeDefaultActorsFromProjectRole:
		if (p->size < 0)
			delete (struct ns4__removeDefaultActorsFromProjectRole*)p->ptr;
		else
			delete[] (struct ns4__removeDefaultActorsFromProjectRole*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemesResponse:
		if (p->size < 0)
			delete (struct ns4__getAssociatedNotificationSchemesResponse*)p->ptr;
		else
			delete[] (struct ns4__getAssociatedNotificationSchemesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAssociatedNotificationSchemes:
		if (p->size < 0)
			delete (struct ns4__getAssociatedNotificationSchemes*)p->ptr;
		else
			delete[] (struct ns4__getAssociatedNotificationSchemes*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemesResponse:
		if (p->size < 0)
			delete (struct ns4__getAssociatedPermissionSchemesResponse*)p->ptr;
		else
			delete[] (struct ns4__getAssociatedPermissionSchemesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAssociatedPermissionSchemes:
		if (p->size < 0)
			delete (struct ns4__getAssociatedPermissionSchemes*)p->ptr;
		else
			delete[] (struct ns4__getAssociatedPermissionSchemes*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteProjectResponse:
		if (p->size < 0)
			delete (struct ns4__deleteProjectResponse*)p->ptr;
		else
			delete[] (struct ns4__deleteProjectResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteProject:
		if (p->size < 0)
			delete (struct ns4__deleteProject*)p->ptr;
		else
			delete[] (struct ns4__deleteProject*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectByIdResponse:
		if (p->size < 0)
			delete (struct ns4__getProjectByIdResponse*)p->ptr;
		else
			delete[] (struct ns4__getProjectByIdResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectById:
		if (p->size < 0)
			delete (struct ns4__getProjectById*)p->ptr;
		else
			delete[] (struct ns4__getProjectById*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getVersionsResponse:
		if (p->size < 0)
			delete (struct ns4__getVersionsResponse*)p->ptr;
		else
			delete[] (struct ns4__getVersionsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getVersions:
		if (p->size < 0)
			delete (struct ns4__getVersions*)p->ptr;
		else
			delete[] (struct ns4__getVersions*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getCustomFieldsResponse:
		if (p->size < 0)
			delete (struct ns4__getCustomFieldsResponse*)p->ptr;
		else
			delete[] (struct ns4__getCustomFieldsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getCustomFields:
		if (p->size < 0)
			delete (struct ns4__getCustomFields*)p->ptr;
		else
			delete[] (struct ns4__getCustomFields*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getCommentsResponse:
		if (p->size < 0)
			delete (struct ns4__getCommentsResponse*)p->ptr;
		else
			delete[] (struct ns4__getCommentsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getComments:
		if (p->size < 0)
			delete (struct ns4__getComments*)p->ptr;
		else
			delete[] (struct ns4__getComments*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getFavouriteFiltersResponse:
		if (p->size < 0)
			delete (struct ns4__getFavouriteFiltersResponse*)p->ptr;
		else
			delete[] (struct ns4__getFavouriteFiltersResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getFavouriteFilters:
		if (p->size < 0)
			delete (struct ns4__getFavouriteFilters*)p->ptr;
		else
			delete[] (struct ns4__getFavouriteFilters*)p->ptr;
		break;
	case SOAP_TYPE_ns4__releaseVersionResponse:
		if (p->size < 0)
			delete (struct ns4__releaseVersionResponse*)p->ptr;
		else
			delete[] (struct ns4__releaseVersionResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__releaseVersion:
		if (p->size < 0)
			delete (struct ns4__releaseVersion*)p->ptr;
		else
			delete[] (struct ns4__releaseVersion*)p->ptr;
		break;
	case SOAP_TYPE_ns4__archiveVersionResponse:
		if (p->size < 0)
			delete (struct ns4__archiveVersionResponse*)p->ptr;
		else
			delete[] (struct ns4__archiveVersionResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__archiveVersion:
		if (p->size < 0)
			delete (struct ns4__archiveVersion*)p->ptr;
		else
			delete[] (struct ns4__archiveVersion*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateIssueResponse:
		if (p->size < 0)
			delete (struct ns4__updateIssueResponse*)p->ptr;
		else
			delete[] (struct ns4__updateIssueResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateIssue:
		if (p->size < 0)
			delete (struct ns4__updateIssue*)p->ptr;
		else
			delete[] (struct ns4__updateIssue*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getFieldsForEditResponse:
		if (p->size < 0)
			delete (struct ns4__getFieldsForEditResponse*)p->ptr;
		else
			delete[] (struct ns4__getFieldsForEditResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getFieldsForEdit:
		if (p->size < 0)
			delete (struct ns4__getFieldsForEdit*)p->ptr;
		else
			delete[] (struct ns4__getFieldsForEdit*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssueTypesForProjectResponse:
		if (p->size < 0)
			delete (struct ns4__getIssueTypesForProjectResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssueTypesForProjectResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssueTypesForProject:
		if (p->size < 0)
			delete (struct ns4__getIssueTypesForProject*)p->ptr;
		else
			delete[] (struct ns4__getIssueTypesForProject*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProjectResponse:
		if (p->size < 0)
			delete (struct ns4__getSubTaskIssueTypesForProjectResponse*)p->ptr;
		else
			delete[] (struct ns4__getSubTaskIssueTypesForProjectResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSubTaskIssueTypesForProject:
		if (p->size < 0)
			delete (struct ns4__getSubTaskIssueTypesForProject*)p->ptr;
		else
			delete[] (struct ns4__getSubTaskIssueTypesForProject*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addUserToGroupResponse:
		if (p->size < 0)
			delete (struct ns4__addUserToGroupResponse*)p->ptr;
		else
			delete[] (struct ns4__addUserToGroupResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addUserToGroup:
		if (p->size < 0)
			delete (struct ns4__addUserToGroup*)p->ptr;
		else
			delete[] (struct ns4__addUserToGroup*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeUserFromGroupResponse:
		if (p->size < 0)
			delete (struct ns4__removeUserFromGroupResponse*)p->ptr;
		else
			delete[] (struct ns4__removeUserFromGroupResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__removeUserFromGroup:
		if (p->size < 0)
			delete (struct ns4__removeUserFromGroup*)p->ptr;
		else
			delete[] (struct ns4__removeUserFromGroup*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSecurityLevelResponse:
		if (p->size < 0)
			delete (struct ns4__getSecurityLevelResponse*)p->ptr;
		else
			delete[] (struct ns4__getSecurityLevelResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSecurityLevel:
		if (p->size < 0)
			delete (struct ns4__getSecurityLevel*)p->ptr;
		else
			delete[] (struct ns4__getSecurityLevel*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addCommentResponse:
		if (p->size < 0)
			delete (struct ns4__addCommentResponse*)p->ptr;
		else
			delete[] (struct ns4__addCommentResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addComment:
		if (p->size < 0)
			delete (struct ns4__addComment*)p->ptr;
		else
			delete[] (struct ns4__addComment*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createIssueWithSecurityLevelResponse:
		if (p->size < 0)
			delete (struct ns4__createIssueWithSecurityLevelResponse*)p->ptr;
		else
			delete[] (struct ns4__createIssueWithSecurityLevelResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createIssueWithSecurityLevel:
		if (p->size < 0)
			delete (struct ns4__createIssueWithSecurityLevel*)p->ptr;
		else
			delete[] (struct ns4__createIssueWithSecurityLevel*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addAttachmentsToIssueResponse:
		if (p->size < 0)
			delete (struct ns4__addAttachmentsToIssueResponse*)p->ptr;
		else
			delete[] (struct ns4__addAttachmentsToIssueResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addAttachmentsToIssue:
		if (p->size < 0)
			delete (struct ns4__addAttachmentsToIssue*)p->ptr;
		else
			delete[] (struct ns4__addAttachmentsToIssue*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAttachmentsFromIssueResponse:
		if (p->size < 0)
			delete (struct ns4__getAttachmentsFromIssueResponse*)p->ptr;
		else
			delete[] (struct ns4__getAttachmentsFromIssueResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAttachmentsFromIssue:
		if (p->size < 0)
			delete (struct ns4__getAttachmentsFromIssue*)p->ptr;
		else
			delete[] (struct ns4__getAttachmentsFromIssue*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteIssueResponse:
		if (p->size < 0)
			delete (struct ns4__deleteIssueResponse*)p->ptr;
		else
			delete[] (struct ns4__deleteIssueResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteIssue:
		if (p->size < 0)
			delete (struct ns4__deleteIssue*)p->ptr;
		else
			delete[] (struct ns4__deleteIssue*)p->ptr;
		break;
	case SOAP_TYPE_ns4__hasPermissionToEditCommentResponse:
		if (p->size < 0)
			delete (struct ns4__hasPermissionToEditCommentResponse*)p->ptr;
		else
			delete[] (struct ns4__hasPermissionToEditCommentResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__hasPermissionToEditComment:
		if (p->size < 0)
			delete (struct ns4__hasPermissionToEditComment*)p->ptr;
		else
			delete[] (struct ns4__hasPermissionToEditComment*)p->ptr;
		break;
	case SOAP_TYPE_ns4__editCommentResponse:
		if (p->size < 0)
			delete (struct ns4__editCommentResponse*)p->ptr;
		else
			delete[] (struct ns4__editCommentResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__editComment:
		if (p->size < 0)
			delete (struct ns4__editComment*)p->ptr;
		else
			delete[] (struct ns4__editComment*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getFieldsForActionResponse:
		if (p->size < 0)
			delete (struct ns4__getFieldsForActionResponse*)p->ptr;
		else
			delete[] (struct ns4__getFieldsForActionResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getFieldsForAction:
		if (p->size < 0)
			delete (struct ns4__getFieldsForAction*)p->ptr;
		else
			delete[] (struct ns4__getFieldsForAction*)p->ptr;
		break;
	case SOAP_TYPE_ns4__progressWorkflowActionResponse:
		if (p->size < 0)
			delete (struct ns4__progressWorkflowActionResponse*)p->ptr;
		else
			delete[] (struct ns4__progressWorkflowActionResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__progressWorkflowAction:
		if (p->size < 0)
			delete (struct ns4__progressWorkflowAction*)p->ptr;
		else
			delete[] (struct ns4__progressWorkflowAction*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssueByIdResponse:
		if (p->size < 0)
			delete (struct ns4__getIssueByIdResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssueByIdResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssueById:
		if (p->size < 0)
			delete (struct ns4__getIssueById*)p->ptr;
		else
			delete[] (struct ns4__getIssueById*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimateResponse:
		if (p->size < 0)
			delete (struct ns4__addWorklogWithNewRemainingEstimateResponse*)p->ptr;
		else
			delete[] (struct ns4__addWorklogWithNewRemainingEstimateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addWorklogWithNewRemainingEstimate:
		if (p->size < 0)
			delete (struct ns4__addWorklogWithNewRemainingEstimate*)p->ptr;
		else
			delete[] (struct ns4__addWorklogWithNewRemainingEstimate*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimateResponse:
		if (p->size < 0)
			delete (struct ns4__addWorklogAndAutoAdjustRemainingEstimateResponse*)p->ptr;
		else
			delete[] (struct ns4__addWorklogAndAutoAdjustRemainingEstimateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addWorklogAndAutoAdjustRemainingEstimate:
		if (p->size < 0)
			delete (struct ns4__addWorklogAndAutoAdjustRemainingEstimate*)p->ptr;
		else
			delete[] (struct ns4__addWorklogAndAutoAdjustRemainingEstimate*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimateResponse:
		if (p->size < 0)
			delete (struct ns4__addWorklogAndRetainRemainingEstimateResponse*)p->ptr;
		else
			delete[] (struct ns4__addWorklogAndRetainRemainingEstimateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addWorklogAndRetainRemainingEstimate:
		if (p->size < 0)
			delete (struct ns4__addWorklogAndRetainRemainingEstimate*)p->ptr;
		else
			delete[] (struct ns4__addWorklogAndRetainRemainingEstimate*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimateResponse:
		if (p->size < 0)
			delete (struct ns4__deleteWorklogWithNewRemainingEstimateResponse*)p->ptr;
		else
			delete[] (struct ns4__deleteWorklogWithNewRemainingEstimateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteWorklogWithNewRemainingEstimate:
		if (p->size < 0)
			delete (struct ns4__deleteWorklogWithNewRemainingEstimate*)p->ptr;
		else
			delete[] (struct ns4__deleteWorklogWithNewRemainingEstimate*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse:
		if (p->size < 0)
			delete (struct ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse*)p->ptr;
		else
			delete[] (struct ns4__deleteWorklogAndAutoAdjustRemainingEstimateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteWorklogAndAutoAdjustRemainingEstimate:
		if (p->size < 0)
			delete (struct ns4__deleteWorklogAndAutoAdjustRemainingEstimate*)p->ptr;
		else
			delete[] (struct ns4__deleteWorklogAndAutoAdjustRemainingEstimate*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimateResponse:
		if (p->size < 0)
			delete (struct ns4__deleteWorklogAndRetainRemainingEstimateResponse*)p->ptr;
		else
			delete[] (struct ns4__deleteWorklogAndRetainRemainingEstimateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteWorklogAndRetainRemainingEstimate:
		if (p->size < 0)
			delete (struct ns4__deleteWorklogAndRetainRemainingEstimate*)p->ptr;
		else
			delete[] (struct ns4__deleteWorklogAndRetainRemainingEstimate*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimateResponse:
		if (p->size < 0)
			delete (struct ns4__updateWorklogWithNewRemainingEstimateResponse*)p->ptr;
		else
			delete[] (struct ns4__updateWorklogWithNewRemainingEstimateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateWorklogWithNewRemainingEstimate:
		if (p->size < 0)
			delete (struct ns4__updateWorklogWithNewRemainingEstimate*)p->ptr;
		else
			delete[] (struct ns4__updateWorklogWithNewRemainingEstimate*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse:
		if (p->size < 0)
			delete (struct ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse*)p->ptr;
		else
			delete[] (struct ns4__updateWorklogAndAutoAdjustRemainingEstimateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateWorklogAndAutoAdjustRemainingEstimate:
		if (p->size < 0)
			delete (struct ns4__updateWorklogAndAutoAdjustRemainingEstimate*)p->ptr;
		else
			delete[] (struct ns4__updateWorklogAndAutoAdjustRemainingEstimate*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimateResponse:
		if (p->size < 0)
			delete (struct ns4__updateWorklogAndRetainRemainingEstimateResponse*)p->ptr;
		else
			delete[] (struct ns4__updateWorklogAndRetainRemainingEstimateResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateWorklogAndRetainRemainingEstimate:
		if (p->size < 0)
			delete (struct ns4__updateWorklogAndRetainRemainingEstimate*)p->ptr;
		else
			delete[] (struct ns4__updateWorklogAndRetainRemainingEstimate*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getWorklogsResponse:
		if (p->size < 0)
			delete (struct ns4__getWorklogsResponse*)p->ptr;
		else
			delete[] (struct ns4__getWorklogsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getWorklogs:
		if (p->size < 0)
			delete (struct ns4__getWorklogs*)p->ptr;
		else
			delete[] (struct ns4__getWorklogs*)p->ptr;
		break;
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklogResponse:
		if (p->size < 0)
			delete (struct ns4__hasPermissionToCreateWorklogResponse*)p->ptr;
		else
			delete[] (struct ns4__hasPermissionToCreateWorklogResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__hasPermissionToCreateWorklog:
		if (p->size < 0)
			delete (struct ns4__hasPermissionToCreateWorklog*)p->ptr;
		else
			delete[] (struct ns4__hasPermissionToCreateWorklog*)p->ptr;
		break;
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklogResponse:
		if (p->size < 0)
			delete (struct ns4__hasPermissionToDeleteWorklogResponse*)p->ptr;
		else
			delete[] (struct ns4__hasPermissionToDeleteWorklogResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__hasPermissionToDeleteWorklog:
		if (p->size < 0)
			delete (struct ns4__hasPermissionToDeleteWorklog*)p->ptr;
		else
			delete[] (struct ns4__hasPermissionToDeleteWorklog*)p->ptr;
		break;
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklogResponse:
		if (p->size < 0)
			delete (struct ns4__hasPermissionToUpdateWorklogResponse*)p->ptr;
		else
			delete[] (struct ns4__hasPermissionToUpdateWorklogResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__hasPermissionToUpdateWorklog:
		if (p->size < 0)
			delete (struct ns4__hasPermissionToUpdateWorklog*)p->ptr;
		else
			delete[] (struct ns4__hasPermissionToUpdateWorklog*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getResolutionDateByKeyResponse:
		if (p->size < 0)
			delete (struct ns4__getResolutionDateByKeyResponse*)p->ptr;
		else
			delete[] (struct ns4__getResolutionDateByKeyResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getResolutionDateByKey:
		if (p->size < 0)
			delete (struct ns4__getResolutionDateByKey*)p->ptr;
		else
			delete[] (struct ns4__getResolutionDateByKey*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getResolutionDateByIdResponse:
		if (p->size < 0)
			delete (struct ns4__getResolutionDateByIdResponse*)p->ptr;
		else
			delete[] (struct ns4__getResolutionDateByIdResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getResolutionDateById:
		if (p->size < 0)
			delete (struct ns4__getResolutionDateById*)p->ptr;
		else
			delete[] (struct ns4__getResolutionDateById*)p->ptr;
		break;
	case SOAP_TYPE_ns4__logoutResponse:
		if (p->size < 0)
			delete (struct ns4__logoutResponse*)p->ptr;
		else
			delete[] (struct ns4__logoutResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__logout:
		if (p->size < 0)
			delete (struct ns4__logout*)p->ptr;
		else
			delete[] (struct ns4__logout*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectWithSchemesByIdResponse:
		if (p->size < 0)
			delete (struct ns4__getProjectWithSchemesByIdResponse*)p->ptr;
		else
			delete[] (struct ns4__getProjectWithSchemesByIdResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectWithSchemesById:
		if (p->size < 0)
			delete (struct ns4__getProjectWithSchemesById*)p->ptr;
		else
			delete[] (struct ns4__getProjectWithSchemesById*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSecurityLevelsResponse:
		if (p->size < 0)
			delete (struct ns4__getSecurityLevelsResponse*)p->ptr;
		else
			delete[] (struct ns4__getSecurityLevelsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSecurityLevels:
		if (p->size < 0)
			delete (struct ns4__getSecurityLevels*)p->ptr;
		else
			delete[] (struct ns4__getSecurityLevels*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectAvatarsResponse:
		if (p->size < 0)
			delete (struct ns4__getProjectAvatarsResponse*)p->ptr;
		else
			delete[] (struct ns4__getProjectAvatarsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectAvatars:
		if (p->size < 0)
			delete (struct ns4__getProjectAvatars*)p->ptr;
		else
			delete[] (struct ns4__getProjectAvatars*)p->ptr;
		break;
	case SOAP_TYPE_ns4__setProjectAvatarResponse:
		if (p->size < 0)
			delete (struct ns4__setProjectAvatarResponse*)p->ptr;
		else
			delete[] (struct ns4__setProjectAvatarResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__setProjectAvatar:
		if (p->size < 0)
			delete (struct ns4__setProjectAvatar*)p->ptr;
		else
			delete[] (struct ns4__setProjectAvatar*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectAvatarResponse:
		if (p->size < 0)
			delete (struct ns4__getProjectAvatarResponse*)p->ptr;
		else
			delete[] (struct ns4__getProjectAvatarResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectAvatar:
		if (p->size < 0)
			delete (struct ns4__getProjectAvatar*)p->ptr;
		else
			delete[] (struct ns4__getProjectAvatar*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteProjectAvatarResponse:
		if (p->size < 0)
			delete (struct ns4__deleteProjectAvatarResponse*)p->ptr;
		else
			delete[] (struct ns4__deleteProjectAvatarResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteProjectAvatar:
		if (p->size < 0)
			delete (struct ns4__deleteProjectAvatar*)p->ptr;
		else
			delete[] (struct ns4__deleteProjectAvatar*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getNotificationSchemesResponse:
		if (p->size < 0)
			delete (struct ns4__getNotificationSchemesResponse*)p->ptr;
		else
			delete[] (struct ns4__getNotificationSchemesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getNotificationSchemes:
		if (p->size < 0)
			delete (struct ns4__getNotificationSchemes*)p->ptr;
		else
			delete[] (struct ns4__getNotificationSchemes*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getPermissionSchemesResponse:
		if (p->size < 0)
			delete (struct ns4__getPermissionSchemesResponse*)p->ptr;
		else
			delete[] (struct ns4__getPermissionSchemesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getPermissionSchemes:
		if (p->size < 0)
			delete (struct ns4__getPermissionSchemes*)p->ptr;
		else
			delete[] (struct ns4__getPermissionSchemes*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAllPermissionsResponse:
		if (p->size < 0)
			delete (struct ns4__getAllPermissionsResponse*)p->ptr;
		else
			delete[] (struct ns4__getAllPermissionsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getAllPermissions:
		if (p->size < 0)
			delete (struct ns4__getAllPermissions*)p->ptr;
		else
			delete[] (struct ns4__getAllPermissions*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createPermissionSchemeResponse:
		if (p->size < 0)
			delete (struct ns4__createPermissionSchemeResponse*)p->ptr;
		else
			delete[] (struct ns4__createPermissionSchemeResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createPermissionScheme:
		if (p->size < 0)
			delete (struct ns4__createPermissionScheme*)p->ptr;
		else
			delete[] (struct ns4__createPermissionScheme*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addPermissionToResponse:
		if (p->size < 0)
			delete (struct ns4__addPermissionToResponse*)p->ptr;
		else
			delete[] (struct ns4__addPermissionToResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addPermissionTo:
		if (p->size < 0)
			delete (struct ns4__addPermissionTo*)p->ptr;
		else
			delete[] (struct ns4__addPermissionTo*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deletePermissionFromResponse:
		if (p->size < 0)
			delete (struct ns4__deletePermissionFromResponse*)p->ptr;
		else
			delete[] (struct ns4__deletePermissionFromResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deletePermissionFrom:
		if (p->size < 0)
			delete (struct ns4__deletePermissionFrom*)p->ptr;
		else
			delete[] (struct ns4__deletePermissionFrom*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deletePermissionSchemeResponse:
		if (p->size < 0)
			delete (struct ns4__deletePermissionSchemeResponse*)p->ptr;
		else
			delete[] (struct ns4__deletePermissionSchemeResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deletePermissionScheme:
		if (p->size < 0)
			delete (struct ns4__deletePermissionScheme*)p->ptr;
		else
			delete[] (struct ns4__deletePermissionScheme*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssueCountForFilterResponse:
		if (p->size < 0)
			delete (struct ns4__getIssueCountForFilterResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssueCountForFilterResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssueCountForFilter:
		if (p->size < 0)
			delete (struct ns4__getIssueCountForFilter*)p->ptr;
		else
			delete[] (struct ns4__getIssueCountForFilter*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchResponse:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromTextSearchResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromTextSearchResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearch:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromTextSearch*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromTextSearch*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProjectResponse:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromTextSearchWithProjectResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromTextSearchWithProjectResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithProject:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromTextSearchWithProject*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromTextSearchWithProject*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromJqlSearchResponse:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromJqlSearchResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromJqlSearchResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromJqlSearch:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromJqlSearch*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromJqlSearch*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteUserResponse:
		if (p->size < 0)
			delete (struct ns4__deleteUserResponse*)p->ptr;
		else
			delete[] (struct ns4__deleteUserResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteUser:
		if (p->size < 0)
			delete (struct ns4__deleteUser*)p->ptr;
		else
			delete[] (struct ns4__deleteUser*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateGroupResponse:
		if (p->size < 0)
			delete (struct ns4__updateGroupResponse*)p->ptr;
		else
			delete[] (struct ns4__updateGroupResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__updateGroup:
		if (p->size < 0)
			delete (struct ns4__updateGroup*)p->ptr;
		else
			delete[] (struct ns4__updateGroup*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteGroupResponse:
		if (p->size < 0)
			delete (struct ns4__deleteGroupResponse*)p->ptr;
		else
			delete[] (struct ns4__deleteGroupResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__deleteGroup:
		if (p->size < 0)
			delete (struct ns4__deleteGroup*)p->ptr;
		else
			delete[] (struct ns4__deleteGroup*)p->ptr;
		break;
	case SOAP_TYPE_ns4__refreshCustomFieldsResponse:
		if (p->size < 0)
			delete (struct ns4__refreshCustomFieldsResponse*)p->ptr;
		else
			delete[] (struct ns4__refreshCustomFieldsResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__refreshCustomFields:
		if (p->size < 0)
			delete (struct ns4__refreshCustomFields*)p->ptr;
		else
			delete[] (struct ns4__refreshCustomFields*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSavedFiltersResponse:
		if (p->size < 0)
			delete (struct ns4__getSavedFiltersResponse*)p->ptr;
		else
			delete[] (struct ns4__getSavedFiltersResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSavedFilters:
		if (p->size < 0)
			delete (struct ns4__getSavedFilters*)p->ptr;
		else
			delete[] (struct ns4__getSavedFilters*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse:
		if (p->size < 0)
			delete (struct ns4__addBase64EncodedAttachmentsToIssueResponse*)p->ptr;
		else
			delete[] (struct ns4__addBase64EncodedAttachmentsToIssueResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue:
		if (p->size < 0)
			delete (struct ns4__addBase64EncodedAttachmentsToIssue*)p->ptr;
		else
			delete[] (struct ns4__addBase64EncodedAttachmentsToIssue*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createProjectFromObjectResponse:
		if (p->size < 0)
			delete (struct ns4__createProjectFromObjectResponse*)p->ptr;
		else
			delete[] (struct ns4__createProjectFromObjectResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__createProjectFromObject:
		if (p->size < 0)
			delete (struct ns4__createProjectFromObject*)p->ptr;
		else
			delete[] (struct ns4__createProjectFromObject*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSecuritySchemesResponse:
		if (p->size < 0)
			delete (struct ns4__getSecuritySchemesResponse*)p->ptr;
		else
			delete[] (struct ns4__getSecuritySchemesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getSecuritySchemes:
		if (p->size < 0)
			delete (struct ns4__getSecuritySchemes*)p->ptr;
		else
			delete[] (struct ns4__getSecuritySchemes*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addVersionResponse:
		if (p->size < 0)
			delete (struct ns4__addVersionResponse*)p->ptr;
		else
			delete[] (struct ns4__addVersionResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__addVersion:
		if (p->size < 0)
			delete (struct ns4__addVersion*)p->ptr;
		else
			delete[] (struct ns4__addVersion*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromFilterResponse:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromFilterResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromFilterResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromFilter:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromFilter*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromFilter*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromFilterWithLimitResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromFilterWithLimitResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromFilterWithLimit:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromFilterWithLimit*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromFilterWithLimit*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromTextSearchWithLimitResponse*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromTextSearchWithLimitResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit:
		if (p->size < 0)
			delete (struct ns4__getIssuesFromTextSearchWithLimit*)p->ptr;
		else
			delete[] (struct ns4__getIssuesFromTextSearchWithLimit*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectsNoSchemesResponse:
		if (p->size < 0)
			delete (struct ns4__getProjectsNoSchemesResponse*)p->ptr;
		else
			delete[] (struct ns4__getProjectsNoSchemesResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__getProjectsNoSchemes:
		if (p->size < 0)
			delete (struct ns4__getProjectsNoSchemes*)p->ptr;
		else
			delete[] (struct ns4__getProjectsNoSchemes*)p->ptr;
		break;
	case SOAP_TYPE_ns4__setNewProjectAvatarResponse:
		if (p->size < 0)
			delete (struct ns4__setNewProjectAvatarResponse*)p->ptr;
		else
			delete[] (struct ns4__setNewProjectAvatarResponse*)p->ptr;
		break;
	case SOAP_TYPE_ns4__setNewProjectAvatar:
		if (p->size < 0)
			delete (struct ns4__setNewProjectAvatar*)p->ptr;
		else
			delete[] (struct ns4__setNewProjectAvatar*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Header:
		if (p->size < 0)
			delete (struct SOAP_ENV__Header*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Header*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Code:
		if (p->size < 0)
			delete (struct SOAP_ENV__Code*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Code*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Reason:
		if (p->size < 0)
			delete (struct SOAP_ENV__Reason*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Reason*)p->ptr;
		break;
	case SOAP_TYPE_SOAP_ENV__Fault:
		if (p->size < 0)
			delete (struct SOAP_ENV__Fault*)p->ptr;
		else
			delete[] (struct SOAP_ENV__Fault*)p->ptr;
		break;
	default:	return SOAP_ERR;
	}
	return SOAP_OK;
}

SOAP_FMAC3 void* SOAP_FMAC4 soap_class_id_enter(struct soap *soap, const char *id, void *p, int t, size_t n, const char *type, const char *arrayType)
{	return soap_id_enter(soap, id, p, t, n, 0, type, arrayType, soap_instantiate);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_byte(struct soap *soap, char *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_byte
	*a = SOAP_DEFAULT_byte;
#else
	*a = (char)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_byte(struct soap *soap, const char *tag, int id, const char *a, const char *type)
{
	return soap_outbyte(soap, tag, id, a, type, SOAP_TYPE_byte);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_in_byte(struct soap *soap, const char *tag, char *a, const char *type)
{	char *p;
	p = soap_inbyte(soap, tag, a, type, SOAP_TYPE_byte);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_byte(struct soap *soap, const char *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_byte);
	if (soap_out_byte(soap, tag?tag:"byte", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 char * SOAP_FMAC4 soap_get_byte(struct soap *soap, char *p, const char *tag, const char *type)
{
	if ((p = soap_in_byte(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_int(struct soap *soap, int *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_int
	*a = SOAP_DEFAULT_int;
#else
	*a = (int)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_int(struct soap *soap, const char *tag, int id, const int *a, const char *type)
{
	return soap_outint(soap, tag, id, a, type, SOAP_TYPE_int);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_in_int(struct soap *soap, const char *tag, int *a, const char *type)
{	int *p;
	p = soap_inint(soap, tag, a, type, SOAP_TYPE_int);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_int(struct soap *soap, const int *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_int);
	if (soap_out_int(soap, tag?tag:"int", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 int * SOAP_FMAC4 soap_get_int(struct soap *soap, int *p, const char *tag, const char *type)
{
	if ((p = soap_in_int(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_LONG64(struct soap *soap, LONG64 *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_LONG64
	*a = SOAP_DEFAULT_LONG64;
#else
	*a = (LONG64)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_LONG64(struct soap *soap, const char *tag, int id, const LONG64 *a, const char *type)
{
	return soap_outLONG64(soap, tag, id, a, type, SOAP_TYPE_LONG64);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_in_LONG64(struct soap *soap, const char *tag, LONG64 *a, const char *type)
{	LONG64 *p;
	p = soap_inLONG64(soap, tag, a, type, SOAP_TYPE_LONG64);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_LONG64(struct soap *soap, const LONG64 *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_LONG64);
	if (soap_out_LONG64(soap, tag?tag:"long", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 LONG64 * SOAP_FMAC4 soap_get_LONG64(struct soap *soap, LONG64 *p, const char *tag, const char *type)
{
	if ((p = soap_in_LONG64(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_time(struct soap *soap, time_t *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_time
	*a = SOAP_DEFAULT_time;
#else
	*a = (time_t)0;
#endif
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_time(struct soap *soap, const char *tag, int id, const time_t *a, const char *type)
{
	return soap_outdateTime(soap, tag, id, a, type, SOAP_TYPE_time);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_in_time(struct soap *soap, const char *tag, time_t *a, const char *type)
{	time_t *p;
	p = soap_indateTime(soap, tag, a, type, SOAP_TYPE_time);
	return p;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_time(struct soap *soap, const time_t *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_time);
	if (soap_out_time(soap, tag?tag:"dateTime", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 time_t * SOAP_FMAC4 soap_get_time(struct soap *soap, time_t *p, const char *tag, const char *type)
{
	if ((p = soap_in_time(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_bool(struct soap *soap, bool *a)
{	(void)soap; /* appease -Wall -Werror */
#ifdef SOAP_DEFAULT_bool
	*a = SOAP_DEFAULT_bool;
#else
	*a = (bool)0;
#endif
}

static const struct soap_code_map soap_codes_bool[] =
{	{ (long)false, "false" },
	{ (long)true, "true" },
	{ 0, NULL }
};

SOAP_FMAC3S const char* SOAP_FMAC4S soap_bool2s(struct soap *soap, bool n)
{	(void)soap; /* appease -Wall -Werror */
return soap_code_str(soap_codes_bool, n!=0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_bool(struct soap *soap, const char *tag, int id, const bool *a, const char *type)
{	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_bool), type) || soap_send(soap, soap_bool2s(soap, *a)))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3S int SOAP_FMAC4S soap_s2bool(struct soap *soap, const char *s, bool *a)
{
	const struct soap_code_map *map;
	if (!s)
		return soap->error;
	map = soap_code(soap_codes_bool, s);
	if (map)
		*a = (bool)(map->code != 0);
	else
	{	long n;
		if (soap_s2long(soap, s, &n) || n < 0 || n > 1)
			return soap->error = SOAP_TYPE;
		*a = (bool)(n != 0);
	}
	return SOAP_OK;
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_in_bool(struct soap *soap, const char *tag, bool *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	if (*soap->type && soap_match_tag(soap, soap->type, type) && soap_match_tag(soap, soap->type, ":boolean"))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (bool *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_bool, sizeof(bool), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	if (soap->body && !*soap->href)
	{	if (!a || soap_s2bool(soap, soap_value(soap), a) || soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (bool *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_bool, 0, sizeof(bool), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_bool(struct soap *soap, const bool *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_bool);
	if (soap_out_bool(soap, tag?tag:"boolean", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 bool * SOAP_FMAC4 soap_get_bool(struct soap *soap, bool *p, const char *tag, const char *type)
{
	if ((p = soap_in_bool(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

void _ns1__RemoteValidationException::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__RemoteValidationException::fault = NULL;
	/* transient soap skipped */
}

void _ns1__RemoteValidationException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons3__RemoteValidationException(soap, &this->_ns1__RemoteValidationException::fault);
	/* transient soap skipped */
}

int _ns1__RemoteValidationException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__RemoteValidationException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__RemoteValidationException(struct soap *soap, const char *tag, int id, const _ns1__RemoteValidationException *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__RemoteValidationException), type))
		return soap->error;
	if (soap_out_PointerTons3__RemoteValidationException(soap, "fault", -1, &(a->_ns1__RemoteValidationException::fault), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__RemoteValidationException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__RemoteValidationException(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__RemoteValidationException * SOAP_FMAC4 soap_in__ns1__RemoteValidationException(struct soap *soap, const char *tag, _ns1__RemoteValidationException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__RemoteValidationException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__RemoteValidationException, sizeof(_ns1__RemoteValidationException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__RemoteValidationException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__RemoteValidationException *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_fault1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons3__RemoteValidationException(soap, "fault", &(a->_ns1__RemoteValidationException::fault), "ns3:RemoteValidationException"))
				{	soap_flag_fault1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__RemoteValidationException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__RemoteValidationException, 0, sizeof(_ns1__RemoteValidationException), 0, soap_copy__ns1__RemoteValidationException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__RemoteValidationException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__RemoteValidationException);
	if (this->soap_out(soap, tag?tag:"ns1:RemoteValidationException", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__RemoteValidationException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__RemoteValidationException(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__RemoteValidationException * SOAP_FMAC4 soap_get__ns1__RemoteValidationException(struct soap *soap, _ns1__RemoteValidationException *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__RemoteValidationException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__RemoteValidationException * SOAP_FMAC2 soap_instantiate__ns1__RemoteValidationException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__RemoteValidationException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__RemoteValidationException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (_ns1__RemoteValidationException);
		if (size)
			*size = sizeof(_ns1__RemoteValidationException);
		((_ns1__RemoteValidationException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (_ns1__RemoteValidationException[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__RemoteValidationException);
		for (int i = 0; i < n; i++)
			((_ns1__RemoteValidationException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__RemoteValidationException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__RemoteValidationException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__RemoteValidationException %p -> %p\n", q, p));
	*(_ns1__RemoteValidationException*)p = *(_ns1__RemoteValidationException*)q;
}

void _ns1__RemotePermissionException::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__RemotePermissionException::fault = NULL;
	/* transient soap skipped */
}

void _ns1__RemotePermissionException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons3__RemotePermissionException(soap, &this->_ns1__RemotePermissionException::fault);
	/* transient soap skipped */
}

int _ns1__RemotePermissionException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__RemotePermissionException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__RemotePermissionException(struct soap *soap, const char *tag, int id, const _ns1__RemotePermissionException *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__RemotePermissionException), type))
		return soap->error;
	if (soap_out_PointerTons3__RemotePermissionException(soap, "fault", -1, &(a->_ns1__RemotePermissionException::fault), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__RemotePermissionException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__RemotePermissionException(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__RemotePermissionException * SOAP_FMAC4 soap_in__ns1__RemotePermissionException(struct soap *soap, const char *tag, _ns1__RemotePermissionException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__RemotePermissionException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__RemotePermissionException, sizeof(_ns1__RemotePermissionException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__RemotePermissionException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__RemotePermissionException *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_fault1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons3__RemotePermissionException(soap, "fault", &(a->_ns1__RemotePermissionException::fault), "ns3:RemotePermissionException"))
				{	soap_flag_fault1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__RemotePermissionException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__RemotePermissionException, 0, sizeof(_ns1__RemotePermissionException), 0, soap_copy__ns1__RemotePermissionException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__RemotePermissionException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__RemotePermissionException);
	if (this->soap_out(soap, tag?tag:"ns1:RemotePermissionException", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__RemotePermissionException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__RemotePermissionException(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__RemotePermissionException * SOAP_FMAC4 soap_get__ns1__RemotePermissionException(struct soap *soap, _ns1__RemotePermissionException *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__RemotePermissionException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__RemotePermissionException * SOAP_FMAC2 soap_instantiate__ns1__RemotePermissionException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__RemotePermissionException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__RemotePermissionException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (_ns1__RemotePermissionException);
		if (size)
			*size = sizeof(_ns1__RemotePermissionException);
		((_ns1__RemotePermissionException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (_ns1__RemotePermissionException[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__RemotePermissionException);
		for (int i = 0; i < n; i++)
			((_ns1__RemotePermissionException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__RemotePermissionException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__RemotePermissionException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__RemotePermissionException %p -> %p\n", q, p));
	*(_ns1__RemotePermissionException*)p = *(_ns1__RemotePermissionException*)q;
}

void _ns1__RemoteException::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__RemoteException::fault = NULL;
	/* transient soap skipped */
}

void _ns1__RemoteException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons3__RemoteException(soap, &this->_ns1__RemoteException::fault);
	/* transient soap skipped */
}

int _ns1__RemoteException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__RemoteException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__RemoteException(struct soap *soap, const char *tag, int id, const _ns1__RemoteException *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__RemoteException), type))
		return soap->error;
	if (soap_out_PointerTons3__RemoteException(soap, "fault", -1, &(a->_ns1__RemoteException::fault), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__RemoteException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__RemoteException(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__RemoteException * SOAP_FMAC4 soap_in__ns1__RemoteException(struct soap *soap, const char *tag, _ns1__RemoteException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__RemoteException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__RemoteException, sizeof(_ns1__RemoteException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__RemoteException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__RemoteException *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_fault1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons3__RemoteException(soap, "fault", &(a->_ns1__RemoteException::fault), "ns3:RemoteException"))
				{	soap_flag_fault1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__RemoteException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__RemoteException, 0, sizeof(_ns1__RemoteException), 0, soap_copy__ns1__RemoteException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__RemoteException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__RemoteException);
	if (this->soap_out(soap, tag?tag:"ns1:RemoteException", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__RemoteException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__RemoteException(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__RemoteException * SOAP_FMAC4 soap_get__ns1__RemoteException(struct soap *soap, _ns1__RemoteException *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__RemoteException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__RemoteException * SOAP_FMAC2 soap_instantiate__ns1__RemoteException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__RemoteException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__RemoteException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (_ns1__RemoteException);
		if (size)
			*size = sizeof(_ns1__RemoteException);
		((_ns1__RemoteException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (_ns1__RemoteException[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__RemoteException);
		for (int i = 0; i < n; i++)
			((_ns1__RemoteException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__RemoteException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__RemoteException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__RemoteException %p -> %p\n", q, p));
	*(_ns1__RemoteException*)p = *(_ns1__RemoteException*)q;
}

void _ns1__RemoteAuthenticationException::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->_ns1__RemoteAuthenticationException::fault = NULL;
	/* transient soap skipped */
}

void _ns1__RemoteAuthenticationException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons3__RemoteAuthenticationException(soap, &this->_ns1__RemoteAuthenticationException::fault);
	/* transient soap skipped */
}

int _ns1__RemoteAuthenticationException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out__ns1__RemoteAuthenticationException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__ns1__RemoteAuthenticationException(struct soap *soap, const char *tag, int id, const _ns1__RemoteAuthenticationException *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE__ns1__RemoteAuthenticationException), type))
		return soap->error;
	if (soap_out_PointerTons3__RemoteAuthenticationException(soap, "fault", -1, &(a->_ns1__RemoteAuthenticationException::fault), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *_ns1__RemoteAuthenticationException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__ns1__RemoteAuthenticationException(soap, tag, this, type);
}

SOAP_FMAC3 _ns1__RemoteAuthenticationException * SOAP_FMAC4 soap_in__ns1__RemoteAuthenticationException(struct soap *soap, const char *tag, _ns1__RemoteAuthenticationException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (_ns1__RemoteAuthenticationException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__ns1__RemoteAuthenticationException, sizeof(_ns1__RemoteAuthenticationException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE__ns1__RemoteAuthenticationException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (_ns1__RemoteAuthenticationException *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_fault1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_fault1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons3__RemoteAuthenticationException(soap, "fault", &(a->_ns1__RemoteAuthenticationException::fault), "ns3:RemoteAuthenticationException"))
				{	soap_flag_fault1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_ns1__RemoteAuthenticationException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__ns1__RemoteAuthenticationException, 0, sizeof(_ns1__RemoteAuthenticationException), 0, soap_copy__ns1__RemoteAuthenticationException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _ns1__RemoteAuthenticationException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE__ns1__RemoteAuthenticationException);
	if (this->soap_out(soap, tag?tag:"ns1:RemoteAuthenticationException", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_ns1__RemoteAuthenticationException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__ns1__RemoteAuthenticationException(soap, this, tag, type);
}

SOAP_FMAC3 _ns1__RemoteAuthenticationException * SOAP_FMAC4 soap_get__ns1__RemoteAuthenticationException(struct soap *soap, _ns1__RemoteAuthenticationException *p, const char *tag, const char *type)
{
	if ((p = soap_in__ns1__RemoteAuthenticationException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _ns1__RemoteAuthenticationException * SOAP_FMAC2 soap_instantiate__ns1__RemoteAuthenticationException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__ns1__RemoteAuthenticationException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__ns1__RemoteAuthenticationException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (_ns1__RemoteAuthenticationException);
		if (size)
			*size = sizeof(_ns1__RemoteAuthenticationException);
		((_ns1__RemoteAuthenticationException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (_ns1__RemoteAuthenticationException[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_ns1__RemoteAuthenticationException);
		for (int i = 0; i < n; i++)
			((_ns1__RemoteAuthenticationException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_ns1__RemoteAuthenticationException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__ns1__RemoteAuthenticationException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _ns1__RemoteAuthenticationException %p -> %p\n", q, p));
	*(_ns1__RemoteAuthenticationException*)p = *(_ns1__RemoteAuthenticationException*)q;
}

void _Struct_1::soap_default(struct soap *soap)
{
	(void)soap; /* appease -Wall -Werror */
	this->__size = 0;
	this->__ptr = NULL;
}

void _Struct_1::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE__Struct_1))
		for (int i = 0; i < this->__size; i++)
		{	soap_embedded(soap, this->__ptr + i, SOAP_TYPE_byte);
		}
}

int _Struct_1::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out__Struct_1(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out__Struct_1(struct soap *soap, const char *tag, int id, const _Struct_1 *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "xsd:byte", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE__Struct_1);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_byte(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *_Struct_1::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in__Struct_1(soap, tag, this, type);
}

SOAP_FMAC3 _Struct_1 * SOAP_FMAC4 soap_in__Struct_1(struct soap *soap, const char *tag, _Struct_1 *a, const char *type)
{	int i, j;
	char *p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (_Struct_1 *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE__Struct_1, sizeof(_Struct_1), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (char *)soap_malloc(soap, sizeof(char) * a->__size);
			for (i = 0; i < a->__size; i++)
				soap_default_byte(soap, a->__ptr+i);
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_byte(soap, NULL, a->__ptr + i, "xsd:byte"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (char *)soap_push_block(soap, NULL, sizeof(char));
				if (!p)
					return NULL;
				soap_default_byte(soap, p);
				if (!soap_in_byte(soap, NULL, p, "xsd:byte"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (char *)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (_Struct_1 *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE__Struct_1, 0, sizeof(_Struct_1), 0, soap_copy__Struct_1);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int _Struct_1::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE__Struct_1);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *_Struct_1::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get__Struct_1(soap, this, tag, type);
}

SOAP_FMAC3 _Struct_1 * SOAP_FMAC4 soap_get__Struct_1(struct soap *soap, _Struct_1 *p, const char *tag, const char *type)
{
	if ((p = soap_in__Struct_1(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 _Struct_1 * SOAP_FMAC2 soap_instantiate__Struct_1(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate__Struct_1(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE__Struct_1, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (_Struct_1);
		if (size)
			*size = sizeof(_Struct_1);
	}
	else
	{	cp->ptr = (void*)new (_Struct_1[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(_Struct_1);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (_Struct_1*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy__Struct_1(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying _Struct_1 %p -> %p\n", q, p));
	*(_Struct_1*)p = *(_Struct_1*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteProject::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteProject::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteProject(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteProject::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteProject(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteProject(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteProject *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteProject", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteProject(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteProject::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteProject(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteProject * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteProject(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteProject *a, const char *type)
{	int i, j;
	ns2__RemoteProject **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteProject *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject, sizeof(ArrayOf_USCOREtns1_USCORERemoteProject), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteProject **)soap_malloc(soap, sizeof(ns2__RemoteProject *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteProject(soap, NULL, a->__ptr + i, "ns2:RemoteProject"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteProject **)soap_push_block(soap, NULL, sizeof(ns2__RemoteProject *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteProject(soap, NULL, p, "ns2:RemoteProject"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteProject **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteProject *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteProject), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteProject);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteProject::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteProject::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteProject(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteProject * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteProject(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteProject *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteProject(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteProject * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteProject(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteProject(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProject, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteProject);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteProject);
		((ArrayOf_USCOREtns1_USCORERemoteProject*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteProject[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteProject);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteProject*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteProject*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteProject(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteProject %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteProject*)p = *(ArrayOf_USCOREtns1_USCORERemoteProject*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteIssue::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteIssue::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteIssue(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteIssue::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteIssue(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteIssue(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteIssue *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteIssue", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteIssue(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteIssue::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteIssue(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteIssue * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteIssue(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteIssue *a, const char *type)
{	int i, j;
	ns2__RemoteIssue **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteIssue *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue, sizeof(ArrayOf_USCOREtns1_USCORERemoteIssue), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteIssue **)soap_malloc(soap, sizeof(ns2__RemoteIssue *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteIssue(soap, NULL, a->__ptr + i, "ns2:RemoteIssue"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteIssue **)soap_push_block(soap, NULL, sizeof(ns2__RemoteIssue *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteIssue(soap, NULL, p, "ns2:RemoteIssue"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteIssue **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteIssue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteIssue), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteIssue);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteIssue::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteIssue::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteIssue(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteIssue * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteIssue(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteIssue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteIssue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteIssue * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteIssue(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteIssue(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssue, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteIssue);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteIssue);
		((ArrayOf_USCOREtns1_USCORERemoteIssue*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteIssue[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteIssue);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteIssue*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteIssue*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteIssue(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteIssue %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteIssue*)p = *(ArrayOf_USCOREtns1_USCORERemoteIssue*)q;
}

void ArrayOf_USCOREtns1_USCORERemotePermission::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemotePermission::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemotePermission(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemotePermission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemotePermission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemotePermission(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemotePermission *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemotePermission", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemotePermission(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemotePermission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemotePermission(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemotePermission * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemotePermission(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemotePermission *a, const char *type)
{	int i, j;
	ns2__RemotePermission **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemotePermission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission, sizeof(ArrayOf_USCOREtns1_USCORERemotePermission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemotePermission **)soap_malloc(soap, sizeof(ns2__RemotePermission *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemotePermission(soap, NULL, a->__ptr + i, "ns2:RemotePermission"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemotePermission **)soap_push_block(soap, NULL, sizeof(ns2__RemotePermission *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemotePermission(soap, NULL, p, "ns2:RemotePermission"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemotePermission **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemotePermission *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission, 0, sizeof(ArrayOf_USCOREtns1_USCORERemotePermission), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemotePermission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemotePermission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemotePermission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemotePermission(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemotePermission * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemotePermission(struct soap *soap, ArrayOf_USCOREtns1_USCORERemotePermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemotePermission(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemotePermission * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemotePermission);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemotePermission);
		((ArrayOf_USCOREtns1_USCORERemotePermission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemotePermission[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemotePermission);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemotePermission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemotePermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemotePermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemotePermission %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemotePermission*)p = *(ArrayOf_USCOREtns1_USCORERemotePermission*)q;
}

void ArrayOf_USCOREtns1_USCORERemotePermissionScheme::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemotePermissionScheme::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemotePermissionScheme(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemotePermissionScheme::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemotePermissionScheme *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemotePermissionScheme", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemotePermissionScheme(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemotePermissionScheme::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemotePermissionScheme * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemotePermissionScheme *a, const char *type)
{	int i, j;
	ns2__RemotePermissionScheme **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemotePermissionScheme *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme, sizeof(ArrayOf_USCOREtns1_USCORERemotePermissionScheme), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemotePermissionScheme **)soap_malloc(soap, sizeof(ns2__RemotePermissionScheme *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemotePermissionScheme(soap, NULL, a->__ptr + i, "ns2:RemotePermissionScheme"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemotePermissionScheme **)soap_push_block(soap, NULL, sizeof(ns2__RemotePermissionScheme *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemotePermissionScheme(soap, NULL, p, "ns2:RemotePermissionScheme"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemotePermissionScheme **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemotePermissionScheme *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme, 0, sizeof(ArrayOf_USCOREtns1_USCORERemotePermissionScheme), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemotePermissionScheme);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemotePermissionScheme::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemotePermissionScheme::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemotePermissionScheme * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(struct soap *soap, ArrayOf_USCOREtns1_USCORERemotePermissionScheme *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemotePermissionScheme * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionScheme, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemotePermissionScheme);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemotePermissionScheme);
		((ArrayOf_USCOREtns1_USCORERemotePermissionScheme*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemotePermissionScheme[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemotePermissionScheme);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemotePermissionScheme*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemotePermissionScheme*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemotePermissionScheme(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemotePermissionScheme %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemotePermissionScheme*)p = *(ArrayOf_USCOREtns1_USCORERemotePermissionScheme*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteAvatar::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteAvatar::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteAvatar(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteAvatar::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteAvatar(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteAvatar(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteAvatar *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteAvatar", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteAvatar(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteAvatar::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteAvatar(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteAvatar * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteAvatar(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteAvatar *a, const char *type)
{	int i, j;
	ns2__RemoteAvatar **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteAvatar *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar, sizeof(ArrayOf_USCOREtns1_USCORERemoteAvatar), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteAvatar **)soap_malloc(soap, sizeof(ns2__RemoteAvatar *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteAvatar(soap, NULL, a->__ptr + i, "ns2:RemoteAvatar"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteAvatar **)soap_push_block(soap, NULL, sizeof(ns2__RemoteAvatar *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteAvatar(soap, NULL, p, "ns2:RemoteAvatar"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteAvatar **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteAvatar *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteAvatar), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteAvatar);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteAvatar::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteAvatar::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteAvatar(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteAvatar * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteAvatar(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteAvatar *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteAvatar(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteAvatar * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteAvatar(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteAvatar(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAvatar, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteAvatar);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteAvatar);
		((ArrayOf_USCOREtns1_USCORERemoteAvatar*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteAvatar[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteAvatar);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteAvatar*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteAvatar*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteAvatar(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteAvatar %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteAvatar*)p = *(ArrayOf_USCOREtns1_USCORERemoteAvatar*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteSecurityLevel::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteSecurityLevel::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteSecurityLevel(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteSecurityLevel::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteSecurityLevel *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteSecurityLevel", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteSecurityLevel(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteSecurityLevel::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteSecurityLevel * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteSecurityLevel *a, const char *type)
{	int i, j;
	ns2__RemoteSecurityLevel **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteSecurityLevel *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel, sizeof(ArrayOf_USCOREtns1_USCORERemoteSecurityLevel), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteSecurityLevel **)soap_malloc(soap, sizeof(ns2__RemoteSecurityLevel *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteSecurityLevel(soap, NULL, a->__ptr + i, "ns2:RemoteSecurityLevel"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteSecurityLevel **)soap_push_block(soap, NULL, sizeof(ns2__RemoteSecurityLevel *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteSecurityLevel(soap, NULL, p, "ns2:RemoteSecurityLevel"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteSecurityLevel **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteSecurityLevel *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteSecurityLevel), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteSecurityLevel::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteSecurityLevel::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteSecurityLevel * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteSecurityLevel *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteSecurityLevel * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteSecurityLevel);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteSecurityLevel);
		((ArrayOf_USCOREtns1_USCORERemoteSecurityLevel*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteSecurityLevel[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteSecurityLevel);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteSecurityLevel*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteSecurityLevel*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteSecurityLevel(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteSecurityLevel %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteSecurityLevel*)p = *(ArrayOf_USCOREtns1_USCORERemoteSecurityLevel*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteWorklog::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteWorklog::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteWorklog(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteWorklog::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteWorklog(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteWorklog(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteWorklog *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteWorklog", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteWorklog(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteWorklog::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteWorklog(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteWorklog * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteWorklog(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteWorklog *a, const char *type)
{	int i, j;
	ns2__RemoteWorklog **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteWorklog *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog, sizeof(ArrayOf_USCOREtns1_USCORERemoteWorklog), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteWorklog **)soap_malloc(soap, sizeof(ns2__RemoteWorklog *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteWorklog(soap, NULL, a->__ptr + i, "ns2:RemoteWorklog"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteWorklog **)soap_push_block(soap, NULL, sizeof(ns2__RemoteWorklog *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteWorklog(soap, NULL, p, "ns2:RemoteWorklog"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteWorklog **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteWorklog *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteWorklog), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteWorklog);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteWorklog::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteWorklog::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteWorklog(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteWorklog * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteWorklog(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteWorklog *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteWorklog(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteWorklog * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteWorklog(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteWorklog(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteWorklog, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteWorklog);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteWorklog);
		((ArrayOf_USCOREtns1_USCORERemoteWorklog*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteWorklog[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteWorklog);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteWorklog*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteWorklog*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteWorklog(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteWorklog %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteWorklog*)p = *(ArrayOf_USCOREtns1_USCORERemoteWorklog*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteAttachment::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteAttachment::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteAttachment(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteAttachment::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteAttachment(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteAttachment(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteAttachment *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteAttachment", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteAttachment(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteAttachment::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteAttachment(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteAttachment * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteAttachment(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteAttachment *a, const char *type)
{	int i, j;
	ns2__RemoteAttachment **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteAttachment *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment, sizeof(ArrayOf_USCOREtns1_USCORERemoteAttachment), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteAttachment **)soap_malloc(soap, sizeof(ns2__RemoteAttachment *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteAttachment(soap, NULL, a->__ptr + i, "ns2:RemoteAttachment"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteAttachment **)soap_push_block(soap, NULL, sizeof(ns2__RemoteAttachment *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteAttachment(soap, NULL, p, "ns2:RemoteAttachment"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteAttachment **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteAttachment *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteAttachment), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteAttachment);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteAttachment::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteAttachment::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteAttachment(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteAttachment * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteAttachment(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteAttachment *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteAttachment(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteAttachment * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteAttachment(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteAttachment(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteAttachment, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteAttachment);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteAttachment);
		((ArrayOf_USCOREtns1_USCORERemoteAttachment*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteAttachment[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteAttachment);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteAttachment*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteAttachment*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteAttachment(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteAttachment %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteAttachment*)p = *(ArrayOf_USCOREtns1_USCORERemoteAttachment*)q;
}

void ArrayOf_USCORExsd_USCOREbase64Binary::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCORExsd_USCOREbase64Binary::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary))
		for (int i = 0; i < this->__size; i++)
		{	soap_embedded(soap, this->__ptr + i, SOAP_TYPE__Struct_1);
			this->__ptr[i].soap_serialize(soap);
		}
}

int ArrayOf_USCORExsd_USCOREbase64Binary::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCORExsd_USCOREbase64Binary(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCORExsd_USCOREbase64Binary(struct soap *soap, const char *tag, int id, const ArrayOf_USCORExsd_USCOREbase64Binary *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "xsd:byte[]", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		a->__ptr[i].soap_out(soap, "item", -1, "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCORExsd_USCOREbase64Binary::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCORExsd_USCOREbase64Binary(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCORExsd_USCOREbase64Binary * SOAP_FMAC4 soap_in_ArrayOf_USCORExsd_USCOREbase64Binary(struct soap *soap, const char *tag, ArrayOf_USCORExsd_USCOREbase64Binary *a, const char *type)
{	int i, j;
	_Struct_1 *p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCORExsd_USCOREbase64Binary *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary, sizeof(ArrayOf_USCORExsd_USCOREbase64Binary), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = soap_new__Struct_1(soap, a->__size);
			for (i = 0; i < a->__size; i++)
				(a->__ptr+i)->_Struct_1::soap_default(soap);
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in__Struct_1(soap, NULL, a->__ptr + i, "xsd:byte"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	_Struct_1 q;
			if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (_Struct_1 *)soap_push_block(soap, NULL, sizeof(_Struct_1));
				if (!p)
					return NULL;
				memcpy(p, &q, sizeof(_Struct_1));
				p->soap_default(soap);
				if (!soap_in__Struct_1(soap, NULL, p, "xsd:byte"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			if (soap->blist->size)
				a->__ptr = soap_new__Struct_1(soap, soap->blist->size/sizeof(_Struct_1));
			else
				a->__ptr = NULL;
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCORExsd_USCOREbase64Binary *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary, 0, sizeof(ArrayOf_USCORExsd_USCOREbase64Binary), 0, soap_copy_ArrayOf_USCORExsd_USCOREbase64Binary);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCORExsd_USCOREbase64Binary::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCORExsd_USCOREbase64Binary::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCORExsd_USCOREbase64Binary(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCORExsd_USCOREbase64Binary * SOAP_FMAC4 soap_get_ArrayOf_USCORExsd_USCOREbase64Binary(struct soap *soap, ArrayOf_USCORExsd_USCOREbase64Binary *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCORExsd_USCOREbase64Binary(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCORExsd_USCOREbase64Binary * SOAP_FMAC2 soap_instantiate_ArrayOf_USCORExsd_USCOREbase64Binary(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCORExsd_USCOREbase64Binary(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCORExsd_USCOREbase64Binary, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCORExsd_USCOREbase64Binary);
		if (size)
			*size = sizeof(ArrayOf_USCORExsd_USCOREbase64Binary);
		((ArrayOf_USCORExsd_USCOREbase64Binary*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCORExsd_USCOREbase64Binary[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCORExsd_USCOREbase64Binary);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCORExsd_USCOREbase64Binary*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCORExsd_USCOREbase64Binary*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCORExsd_USCOREbase64Binary(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCORExsd_USCOREbase64Binary %p -> %p\n", q, p));
	*(ArrayOf_USCORExsd_USCOREbase64Binary*)p = *(ArrayOf_USCORExsd_USCOREbase64Binary*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteFieldValue::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteFieldValue::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteFieldValue(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteFieldValue::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteFieldValue(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteFieldValue *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteFieldValue", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteFieldValue(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteFieldValue::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteFieldValue * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteFieldValue(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteFieldValue *a, const char *type)
{	int i, j;
	ns2__RemoteFieldValue **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteFieldValue *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue, sizeof(ArrayOf_USCOREtns1_USCORERemoteFieldValue), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteFieldValue **)soap_malloc(soap, sizeof(ns2__RemoteFieldValue *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteFieldValue(soap, NULL, a->__ptr + i, "ns2:RemoteFieldValue"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteFieldValue **)soap_push_block(soap, NULL, sizeof(ns2__RemoteFieldValue *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteFieldValue(soap, NULL, p, "ns2:RemoteFieldValue"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteFieldValue **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteFieldValue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteFieldValue), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteFieldValue);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteFieldValue::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteFieldValue::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteFieldValue * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteFieldValue(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteFieldValue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteFieldValue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteFieldValue * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteFieldValue(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteFieldValue(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFieldValue, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteFieldValue);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteFieldValue);
		((ArrayOf_USCOREtns1_USCORERemoteFieldValue*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteFieldValue[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteFieldValue);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteFieldValue*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteFieldValue*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteFieldValue(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteFieldValue %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteFieldValue*)p = *(ArrayOf_USCOREtns1_USCORERemoteFieldValue*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteFilter::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteFilter::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteFilter(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteFilter::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteFilter(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteFilter(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteFilter *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteFilter", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteFilter(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteFilter::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteFilter(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteFilter * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteFilter(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteFilter *a, const char *type)
{	int i, j;
	ns2__RemoteFilter **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteFilter *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter, sizeof(ArrayOf_USCOREtns1_USCORERemoteFilter), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteFilter **)soap_malloc(soap, sizeof(ns2__RemoteFilter *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteFilter(soap, NULL, a->__ptr + i, "ns2:RemoteFilter"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteFilter **)soap_push_block(soap, NULL, sizeof(ns2__RemoteFilter *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteFilter(soap, NULL, p, "ns2:RemoteFilter"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteFilter **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteFilter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteFilter), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteFilter);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteFilter::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteFilter::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteFilter(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteFilter * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteFilter(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteFilter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteFilter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteFilter * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteFilter(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteFilter(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteFilter, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteFilter);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteFilter);
		((ArrayOf_USCOREtns1_USCORERemoteFilter*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteFilter[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteFilter);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteFilter*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteFilter*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteFilter(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteFilter %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteFilter*)p = *(ArrayOf_USCOREtns1_USCORERemoteFilter*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteComment::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteComment::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteComment(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteComment::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteComment(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteComment(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteComment *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteComment", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteComment(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteComment::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteComment(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteComment * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteComment(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteComment *a, const char *type)
{	int i, j;
	ns2__RemoteComment **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteComment *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment, sizeof(ArrayOf_USCOREtns1_USCORERemoteComment), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteComment **)soap_malloc(soap, sizeof(ns2__RemoteComment *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteComment(soap, NULL, a->__ptr + i, "ns2:RemoteComment"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteComment **)soap_push_block(soap, NULL, sizeof(ns2__RemoteComment *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteComment(soap, NULL, p, "ns2:RemoteComment"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteComment **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteComment *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteComment), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteComment);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteComment::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteComment::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteComment(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteComment * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteComment(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteComment *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteComment(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteComment * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteComment(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteComment(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComment, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteComment);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteComment);
		((ArrayOf_USCOREtns1_USCORERemoteComment*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteComment[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteComment);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteComment*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteComment*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteComment(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteComment %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteComment*)p = *(ArrayOf_USCOREtns1_USCORERemoteComment*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteField::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteField::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteField(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteField::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteField(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteField(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteField *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteField", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteField(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteField::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteField(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteField * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteField(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteField *a, const char *type)
{	int i, j;
	ns2__RemoteField **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteField *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField, sizeof(ArrayOf_USCOREtns1_USCORERemoteField), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteField **)soap_malloc(soap, sizeof(ns2__RemoteField *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteField(soap, NULL, a->__ptr + i, "ns2:RemoteField"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteField **)soap_push_block(soap, NULL, sizeof(ns2__RemoteField *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteField(soap, NULL, p, "ns2:RemoteField"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteField **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteField *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteField), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteField);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteField::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteField::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteField(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteField * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteField(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteField *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteField * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteField(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteField(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteField, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteField);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteField);
		((ArrayOf_USCOREtns1_USCORERemoteField*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteField[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteField);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteField*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteField*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteField(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteField %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteField*)p = *(ArrayOf_USCOREtns1_USCORERemoteField*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteScheme::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteScheme::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteScheme(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteScheme::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteScheme(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteScheme(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteScheme *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteScheme", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteScheme(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteScheme::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteScheme(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteScheme * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteScheme(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteScheme *a, const char *type)
{	int i, j;
	ns2__RemoteScheme **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteScheme *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme, sizeof(ArrayOf_USCOREtns1_USCORERemoteScheme), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteScheme **)soap_malloc(soap, sizeof(ns2__RemoteScheme *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteScheme(soap, NULL, a->__ptr + i, "ns2:RemoteScheme"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteScheme **)soap_push_block(soap, NULL, sizeof(ns2__RemoteScheme *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteScheme(soap, NULL, p, "ns2:RemoteScheme"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteScheme **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteScheme *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteScheme), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteScheme);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteScheme::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteScheme::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteScheme(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteScheme * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteScheme(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteScheme *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteScheme(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteScheme * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteScheme(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteScheme(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteScheme, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteScheme);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteScheme);
		((ArrayOf_USCOREtns1_USCORERemoteScheme*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteScheme[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteScheme);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteScheme*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteScheme*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteScheme(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteScheme %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteScheme*)p = *(ArrayOf_USCOREtns1_USCORERemoteScheme*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteRoleActor::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteRoleActor::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteRoleActor(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteRoleActor::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteRoleActor(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteRoleActor *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteRoleActor", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteRoleActor(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteRoleActor::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteRoleActor * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteRoleActor(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteRoleActor *a, const char *type)
{	int i, j;
	ns2__RemoteRoleActor **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteRoleActor *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor, sizeof(ArrayOf_USCOREtns1_USCORERemoteRoleActor), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteRoleActor **)soap_malloc(soap, sizeof(ns2__RemoteRoleActor *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteRoleActor(soap, NULL, a->__ptr + i, "ns2:RemoteRoleActor"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteRoleActor **)soap_push_block(soap, NULL, sizeof(ns2__RemoteRoleActor *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteRoleActor(soap, NULL, p, "ns2:RemoteRoleActor"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteRoleActor **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteRoleActor *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteRoleActor), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteRoleActor);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteRoleActor::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteRoleActor::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteRoleActor * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteRoleActor(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteRoleActor *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteRoleActor * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteRoleActor(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteRoleActor(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteRoleActor, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteRoleActor);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteRoleActor);
		((ArrayOf_USCOREtns1_USCORERemoteRoleActor*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteRoleActor[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteRoleActor);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteRoleActor*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteRoleActor*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteRoleActor(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteRoleActor %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteRoleActor*)p = *(ArrayOf_USCOREtns1_USCORERemoteRoleActor*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteProjectRole::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteProjectRole::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteProjectRole(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteProjectRole::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteProjectRole(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteProjectRole *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteProjectRole", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteProjectRole(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteProjectRole::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteProjectRole * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteProjectRole(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteProjectRole *a, const char *type)
{	int i, j;
	ns2__RemoteProjectRole **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteProjectRole *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole, sizeof(ArrayOf_USCOREtns1_USCORERemoteProjectRole), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteProjectRole **)soap_malloc(soap, sizeof(ns2__RemoteProjectRole *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteProjectRole(soap, NULL, a->__ptr + i, "ns2:RemoteProjectRole"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteProjectRole **)soap_push_block(soap, NULL, sizeof(ns2__RemoteProjectRole *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteProjectRole(soap, NULL, p, "ns2:RemoteProjectRole"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteProjectRole **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteProjectRole *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteProjectRole), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteProjectRole);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteProjectRole::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteProjectRole::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteProjectRole * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteProjectRole(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteProjectRole *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteProjectRole(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteProjectRole * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteProjectRole(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteProjectRole(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteProjectRole, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteProjectRole);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteProjectRole);
		((ArrayOf_USCOREtns1_USCORERemoteProjectRole*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteProjectRole[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteProjectRole);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteProjectRole*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteProjectRole*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteProjectRole(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteProjectRole %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteProjectRole*)p = *(ArrayOf_USCOREtns1_USCORERemoteProjectRole*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteStatus::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteStatus(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteStatus(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteStatus *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteStatus", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteStatus(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteStatus(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteStatus * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteStatus(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteStatus *a, const char *type)
{	int i, j;
	ns2__RemoteStatus **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus, sizeof(ArrayOf_USCOREtns1_USCORERemoteStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteStatus **)soap_malloc(soap, sizeof(ns2__RemoteStatus *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteStatus(soap, NULL, a->__ptr + i, "ns2:RemoteStatus"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteStatus **)soap_push_block(soap, NULL, sizeof(ns2__RemoteStatus *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteStatus(soap, NULL, p, "ns2:RemoteStatus"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteStatus **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteStatus), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteStatus(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteStatus * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteStatus(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteStatus * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteStatus);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteStatus);
		((ArrayOf_USCOREtns1_USCORERemoteStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteStatus[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteStatus);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteStatus %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteStatus*)p = *(ArrayOf_USCOREtns1_USCORERemoteStatus*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteResolution::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteResolution::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteResolution(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteResolution::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteResolution(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteResolution(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteResolution *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteResolution", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteResolution(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteResolution::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteResolution(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteResolution * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteResolution(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteResolution *a, const char *type)
{	int i, j;
	ns2__RemoteResolution **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteResolution *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution, sizeof(ArrayOf_USCOREtns1_USCORERemoteResolution), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteResolution **)soap_malloc(soap, sizeof(ns2__RemoteResolution *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteResolution(soap, NULL, a->__ptr + i, "ns2:RemoteResolution"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteResolution **)soap_push_block(soap, NULL, sizeof(ns2__RemoteResolution *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteResolution(soap, NULL, p, "ns2:RemoteResolution"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteResolution **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteResolution *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteResolution), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteResolution);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteResolution::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteResolution::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteResolution(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteResolution * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteResolution(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteResolution *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteResolution(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteResolution * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteResolution(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteResolution(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteResolution, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteResolution);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteResolution);
		((ArrayOf_USCOREtns1_USCORERemoteResolution*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteResolution[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteResolution);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteResolution*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteResolution*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteResolution(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteResolution %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteResolution*)p = *(ArrayOf_USCOREtns1_USCORERemoteResolution*)q;
}

void ArrayOf_USCOREtns1_USCORERemotePriority::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemotePriority::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemotePriority(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemotePriority::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemotePriority(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemotePriority(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemotePriority *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemotePriority", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemotePriority(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemotePriority::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemotePriority(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemotePriority * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemotePriority(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemotePriority *a, const char *type)
{	int i, j;
	ns2__RemotePriority **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemotePriority *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority, sizeof(ArrayOf_USCOREtns1_USCORERemotePriority), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemotePriority **)soap_malloc(soap, sizeof(ns2__RemotePriority *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemotePriority(soap, NULL, a->__ptr + i, "ns2:RemotePriority"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemotePriority **)soap_push_block(soap, NULL, sizeof(ns2__RemotePriority *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemotePriority(soap, NULL, p, "ns2:RemotePriority"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemotePriority **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemotePriority *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority, 0, sizeof(ArrayOf_USCOREtns1_USCORERemotePriority), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemotePriority);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemotePriority::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemotePriority::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemotePriority(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemotePriority * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemotePriority(struct soap *soap, ArrayOf_USCOREtns1_USCORERemotePriority *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemotePriority(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemotePriority * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePriority(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePriority(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePriority, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemotePriority);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemotePriority);
		((ArrayOf_USCOREtns1_USCORERemotePriority*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemotePriority[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemotePriority);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemotePriority*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemotePriority*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemotePriority(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemotePriority %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemotePriority*)p = *(ArrayOf_USCOREtns1_USCORERemotePriority*)q;
}

void ArrayOf_USCOREtns1_USCORERemotePermissionMapping::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemotePermissionMapping::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemotePermissionMapping(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemotePermissionMapping::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemotePermissionMapping *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemotePermissionMapping", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemotePermissionMapping(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemotePermissionMapping::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemotePermissionMapping * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemotePermissionMapping *a, const char *type)
{	int i, j;
	ns2__RemotePermissionMapping **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemotePermissionMapping *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping, sizeof(ArrayOf_USCOREtns1_USCORERemotePermissionMapping), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemotePermissionMapping **)soap_malloc(soap, sizeof(ns2__RemotePermissionMapping *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemotePermissionMapping(soap, NULL, a->__ptr + i, "ns2:RemotePermissionMapping"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemotePermissionMapping **)soap_push_block(soap, NULL, sizeof(ns2__RemotePermissionMapping *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemotePermissionMapping(soap, NULL, p, "ns2:RemotePermissionMapping"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemotePermissionMapping **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemotePermissionMapping *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping, 0, sizeof(ArrayOf_USCOREtns1_USCORERemotePermissionMapping), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemotePermissionMapping);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemotePermissionMapping::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemotePermissionMapping::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemotePermissionMapping * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(struct soap *soap, ArrayOf_USCOREtns1_USCORERemotePermissionMapping *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemotePermissionMapping * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemotePermissionMapping, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemotePermissionMapping);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemotePermissionMapping);
		((ArrayOf_USCOREtns1_USCORERemotePermissionMapping*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemotePermissionMapping[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemotePermissionMapping);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemotePermissionMapping*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemotePermissionMapping*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemotePermissionMapping(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemotePermissionMapping %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemotePermissionMapping*)p = *(ArrayOf_USCOREtns1_USCORERemotePermissionMapping*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteEntity::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteEntity::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteEntity(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteEntity::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteEntity(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteEntity(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteEntity *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteEntity", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteEntity(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteEntity::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteEntity(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteEntity * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteEntity(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteEntity *a, const char *type)
{	int i, j;
	ns2__RemoteEntity **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteEntity *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity, sizeof(ArrayOf_USCOREtns1_USCORERemoteEntity), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteEntity **)soap_malloc(soap, sizeof(ns2__RemoteEntity *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteEntity(soap, NULL, a->__ptr + i, "ns2:RemoteEntity"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteEntity **)soap_push_block(soap, NULL, sizeof(ns2__RemoteEntity *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteEntity(soap, NULL, p, "ns2:RemoteEntity"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteEntity **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteEntity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteEntity), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteEntity);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteEntity::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteEntity::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteEntity(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteEntity * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteEntity(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteEntity *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteEntity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteEntity * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteEntity(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteEntity(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteEntity, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteEntity);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteEntity);
		((ArrayOf_USCOREtns1_USCORERemoteEntity*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteEntity[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteEntity);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteEntity*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteEntity*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteEntity(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteEntity %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteEntity*)p = *(ArrayOf_USCOREtns1_USCORERemoteEntity*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteIssueType::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteIssueType::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteIssueType(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteIssueType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteIssueType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteIssueType(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteIssueType *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteIssueType", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteIssueType(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteIssueType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteIssueType(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteIssueType * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteIssueType(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteIssueType *a, const char *type)
{	int i, j;
	ns2__RemoteIssueType **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteIssueType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType, sizeof(ArrayOf_USCOREtns1_USCORERemoteIssueType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteIssueType **)soap_malloc(soap, sizeof(ns2__RemoteIssueType *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteIssueType(soap, NULL, a->__ptr + i, "ns2:RemoteIssueType"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteIssueType **)soap_push_block(soap, NULL, sizeof(ns2__RemoteIssueType *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteIssueType(soap, NULL, p, "ns2:RemoteIssueType"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteIssueType **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteIssueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteIssueType), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteIssueType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteIssueType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteIssueType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteIssueType(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteIssueType * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteIssueType(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteIssueType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteIssueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteIssueType * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteIssueType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteIssueType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteIssueType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteIssueType);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteIssueType);
		((ArrayOf_USCOREtns1_USCORERemoteIssueType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteIssueType[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteIssueType);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteIssueType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteIssueType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteIssueType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteIssueType %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteIssueType*)p = *(ArrayOf_USCOREtns1_USCORERemoteIssueType*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteNamedObject::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteNamedObject::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteNamedObject(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteNamedObject::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteNamedObject(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteNamedObject *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteNamedObject", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteNamedObject(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteNamedObject::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteNamedObject * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteNamedObject(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteNamedObject *a, const char *type)
{	int i, j;
	ns2__RemoteNamedObject **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteNamedObject *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject, sizeof(ArrayOf_USCOREtns1_USCORERemoteNamedObject), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteNamedObject **)soap_malloc(soap, sizeof(ns2__RemoteNamedObject *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteNamedObject(soap, NULL, a->__ptr + i, "ns2:RemoteNamedObject"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteNamedObject **)soap_push_block(soap, NULL, sizeof(ns2__RemoteNamedObject *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteNamedObject(soap, NULL, p, "ns2:RemoteNamedObject"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteNamedObject **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteNamedObject *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteNamedObject), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteNamedObject);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteNamedObject::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteNamedObject::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteNamedObject * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteNamedObject(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteNamedObject *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteNamedObject(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteNamedObject * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteNamedObject(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteNamedObject(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteNamedObject, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteNamedObject);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteNamedObject);
		((ArrayOf_USCOREtns1_USCORERemoteNamedObject*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteNamedObject[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteNamedObject);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteNamedObject*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteNamedObject*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteNamedObject(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteNamedObject %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteNamedObject*)p = *(ArrayOf_USCOREtns1_USCORERemoteNamedObject*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteCustomFieldValue(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteCustomFieldValue", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteCustomFieldValue(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue *a, const char *type)
{	int i, j;
	ns2__RemoteCustomFieldValue **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue, sizeof(ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteCustomFieldValue **)soap_malloc(soap, sizeof(ns2__RemoteCustomFieldValue *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteCustomFieldValue(soap, NULL, a->__ptr + i, "ns2:RemoteCustomFieldValue"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteCustomFieldValue **)soap_push_block(soap, NULL, sizeof(ns2__RemoteCustomFieldValue *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteCustomFieldValue(soap, NULL, p, "ns2:RemoteCustomFieldValue"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteCustomFieldValue **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue);
		((ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue*)p = *(ArrayOf_USCOREtns1_USCORERemoteCustomFieldValue*)q;
}

void ArrayOf_USCORExsd_USCOREstring::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCORExsd_USCOREstring::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_string(soap, this->__ptr + i);
		}
}

int ArrayOf_USCORExsd_USCOREstring::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCORExsd_USCOREstring(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCORExsd_USCOREstring(struct soap *soap, const char *tag, int id, const ArrayOf_USCORExsd_USCOREstring *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "xsd:string", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_string(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCORExsd_USCOREstring::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCORExsd_USCOREstring(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCORExsd_USCOREstring * SOAP_FMAC4 soap_in_ArrayOf_USCORExsd_USCOREstring(struct soap *soap, const char *tag, ArrayOf_USCORExsd_USCOREstring *a, const char *type)
{	int i, j;
	char **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCORExsd_USCOREstring *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring, sizeof(ArrayOf_USCORExsd_USCOREstring), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (char **)soap_malloc(soap, sizeof(char *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_string(soap, NULL, a->__ptr + i, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (char **)soap_push_block(soap, NULL, sizeof(char *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_string(soap, NULL, p, "xsd:string"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (char **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCORExsd_USCOREstring *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring, 0, sizeof(ArrayOf_USCORExsd_USCOREstring), 0, soap_copy_ArrayOf_USCORExsd_USCOREstring);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCORExsd_USCOREstring::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCORExsd_USCOREstring::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCORExsd_USCOREstring(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCORExsd_USCOREstring * SOAP_FMAC4 soap_get_ArrayOf_USCORExsd_USCOREstring(struct soap *soap, ArrayOf_USCORExsd_USCOREstring *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCORExsd_USCOREstring(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCORExsd_USCOREstring * SOAP_FMAC2 soap_instantiate_ArrayOf_USCORExsd_USCOREstring(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCORExsd_USCOREstring(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCORExsd_USCOREstring, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCORExsd_USCOREstring);
		if (size)
			*size = sizeof(ArrayOf_USCORExsd_USCOREstring);
		((ArrayOf_USCORExsd_USCOREstring*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCORExsd_USCOREstring[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCORExsd_USCOREstring);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCORExsd_USCOREstring*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCORExsd_USCOREstring*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCORExsd_USCOREstring(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCORExsd_USCOREstring %p -> %p\n", q, p));
	*(ArrayOf_USCORExsd_USCOREstring*)p = *(ArrayOf_USCORExsd_USCOREstring*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteVersion::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteVersion::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteVersion(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteVersion::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteVersion(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteVersion(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteVersion *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteVersion", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteVersion(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteVersion::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteVersion(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteVersion * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteVersion(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteVersion *a, const char *type)
{	int i, j;
	ns2__RemoteVersion **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteVersion *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion, sizeof(ArrayOf_USCOREtns1_USCORERemoteVersion), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteVersion **)soap_malloc(soap, sizeof(ns2__RemoteVersion *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteVersion(soap, NULL, a->__ptr + i, "ns2:RemoteVersion"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteVersion **)soap_push_block(soap, NULL, sizeof(ns2__RemoteVersion *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteVersion(soap, NULL, p, "ns2:RemoteVersion"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteVersion **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteVersion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteVersion), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteVersion);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteVersion::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteVersion::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteVersion(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteVersion * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteVersion(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteVersion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteVersion * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteVersion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteVersion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteVersion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteVersion);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteVersion);
		((ArrayOf_USCOREtns1_USCORERemoteVersion*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteVersion[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteVersion);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteVersion*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteVersion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteVersion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteVersion %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteVersion*)p = *(ArrayOf_USCOREtns1_USCORERemoteVersion*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteComponent::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteComponent::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteComponent(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteComponent::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteComponent(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteComponent(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteComponent *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteComponent", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteComponent(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteComponent::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteComponent(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteComponent * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteComponent(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteComponent *a, const char *type)
{	int i, j;
	ns2__RemoteComponent **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteComponent *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent, sizeof(ArrayOf_USCOREtns1_USCORERemoteComponent), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteComponent **)soap_malloc(soap, sizeof(ns2__RemoteComponent *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteComponent(soap, NULL, a->__ptr + i, "ns2:RemoteComponent"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteComponent **)soap_push_block(soap, NULL, sizeof(ns2__RemoteComponent *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteComponent(soap, NULL, p, "ns2:RemoteComponent"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteComponent **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteComponent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteComponent), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteComponent);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteComponent::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteComponent::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteComponent(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteComponent * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteComponent(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteComponent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteComponent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteComponent * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteComponent(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteComponent(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteComponent, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteComponent);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteComponent);
		((ArrayOf_USCOREtns1_USCORERemoteComponent*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteComponent[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteComponent);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteComponent*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteComponent*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteComponent(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteComponent %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteComponent*)p = *(ArrayOf_USCOREtns1_USCORERemoteComponent*)q;
}

void ArrayOf_USCOREtns1_USCORERemoteUser::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->__size = 0;
	this->__ptr = NULL;
}

void ArrayOf_USCOREtns1_USCORERemoteUser::soap_serialize(struct soap *soap) const
{
	if (this->__ptr && !soap_array_reference(soap, this, (struct soap_array*)&this->__ptr, 1, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser))
		for (int i = 0; i < this->__size; i++)
		{
			soap_serialize_PointerTons2__RemoteUser(soap, this->__ptr + i);
		}
}

int ArrayOf_USCOREtns1_USCORERemoteUser::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{	return soap_out_ArrayOf_USCOREtns1_USCORERemoteUser(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ArrayOf_USCOREtns1_USCORERemoteUser(struct soap *soap, const char *tag, int id, const ArrayOf_USCOREtns1_USCORERemoteUser *a, const char *type)
{
	int i, n = a->__size;
	char *t = a->__ptr ? soap_putsize(soap, "ns2:RemoteUser", a->__size) : NULL;
	id = soap_element_id(soap, tag, id, a, (struct soap_array*)&a->__ptr, 1, type, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser);
	if (id < 0)
		return soap->error;
	if (soap_array_begin_out(soap, tag, id, t, NULL))
		return soap->error;
	for (i = 0; i < n; i++)
	{
		soap->position = 1;
		soap->positions[0] = i;
		soap_out_PointerTons2__RemoteUser(soap, "item", -1, &a->__ptr[i], "");
	}
	soap->position = 0;
	return soap_element_end_out(soap, tag);
}

void *ArrayOf_USCOREtns1_USCORERemoteUser::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ArrayOf_USCOREtns1_USCORERemoteUser(soap, tag, this, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteUser * SOAP_FMAC4 soap_in_ArrayOf_USCOREtns1_USCORERemoteUser(struct soap *soap, const char *tag, ArrayOf_USCOREtns1_USCORERemoteUser *a, const char *type)
{	int i, j;
	ns2__RemoteUser **p;
	if (soap_element_begin_in(soap, tag, 1, NULL))
		return NULL;
	if (soap_match_array(soap, type))
	{	soap->error = SOAP_TYPE;
		return NULL;
	}
	a = (ArrayOf_USCOREtns1_USCORERemoteUser *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser, sizeof(ArrayOf_USCOREtns1_USCORERemoteUser), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
		a->soap_default(soap);
	if (soap->body && !*soap->href)
	{
		a->__size = soap_getsize(soap->arraySize, soap->arrayOffset, &j);
		if (a->__size >= 0)
		{	a->__ptr = (ns2__RemoteUser **)soap_malloc(soap, sizeof(ns2__RemoteUser *) * a->__size);
			for (i = 0; i < a->__size; i++)
				a->__ptr[i] = NULL;
			for (i = 0; i < a->__size; i++)
			{	soap_peek_element(soap);
				if (soap->position)
				{	i = soap->positions[0]-j;
					if (i < 0 || i >= a->__size)
					{	soap->error = SOAP_IOB;
						return NULL;
					}
				}
				if (!soap_in_PointerTons2__RemoteUser(soap, NULL, a->__ptr + i, "ns2:RemoteUser"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
		}
		else
		{	if (soap_new_block(soap) == NULL)
				return NULL;
			for (a->__size = 0; ; a->__size++)
			{	p = (ns2__RemoteUser **)soap_push_block(soap, NULL, sizeof(ns2__RemoteUser *));
				if (!p)
					return NULL;
				*p = NULL;
				if (!soap_in_PointerTons2__RemoteUser(soap, NULL, p, "ns2:RemoteUser"))
				{	if (soap->error != SOAP_NO_TAG)
						return NULL;
					soap->error = SOAP_OK;
					break;
				}
			}
			soap_pop_block(soap, NULL);
			a->__ptr = (ns2__RemoteUser **)soap_malloc(soap, soap->blist->size);
			soap_save_block(soap, NULL, (char*)a->__ptr, 1);
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ArrayOf_USCOREtns1_USCORERemoteUser *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser, 0, sizeof(ArrayOf_USCOREtns1_USCORERemoteUser), 0, soap_copy_ArrayOf_USCOREtns1_USCORERemoteUser);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ArrayOf_USCOREtns1_USCORERemoteUser::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, (struct soap_array*)&this->__ptr, 1, tag, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser);
	if (this->soap_out(soap, tag?tag:"SOAP-ENC:Array", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ArrayOf_USCOREtns1_USCORERemoteUser::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ArrayOf_USCOREtns1_USCORERemoteUser(soap, this, tag, type);
}

SOAP_FMAC3 ArrayOf_USCOREtns1_USCORERemoteUser * SOAP_FMAC4 soap_get_ArrayOf_USCOREtns1_USCORERemoteUser(struct soap *soap, ArrayOf_USCOREtns1_USCORERemoteUser *p, const char *tag, const char *type)
{
	if ((p = soap_in_ArrayOf_USCOREtns1_USCORERemoteUser(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ArrayOf_USCOREtns1_USCORERemoteUser * SOAP_FMAC2 soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteUser(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ArrayOf_USCOREtns1_USCORERemoteUser(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ArrayOf_USCOREtns1_USCORERemoteUser, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteUser);
		if (size)
			*size = sizeof(ArrayOf_USCOREtns1_USCORERemoteUser);
		((ArrayOf_USCOREtns1_USCORERemoteUser*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ArrayOf_USCOREtns1_USCORERemoteUser[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ArrayOf_USCOREtns1_USCORERemoteUser);
		for (int i = 0; i < n; i++)
			((ArrayOf_USCOREtns1_USCORERemoteUser*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ArrayOf_USCOREtns1_USCORERemoteUser*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ArrayOf_USCOREtns1_USCORERemoteUser(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ArrayOf_USCOREtns1_USCORERemoteUser %p -> %p\n", q, p));
	*(ArrayOf_USCOREtns1_USCORERemoteUser*)p = *(ArrayOf_USCOREtns1_USCORERemoteUser*)q;
}

void ns3__RemotePermissionException::soap_default(struct soap *soap)
{
	this->soap = soap;
	/* transient soap skipped */
}

void ns3__RemotePermissionException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns3__RemotePermissionException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns3__RemotePermissionException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__RemotePermissionException(struct soap *soap, const char *tag, int id, const ns3__RemotePermissionException *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__RemotePermissionException), "ns3:RemotePermissionException"))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns3__RemotePermissionException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns3__RemotePermissionException(soap, tag, this, type);
}

SOAP_FMAC3 ns3__RemotePermissionException * SOAP_FMAC4 soap_in_ns3__RemotePermissionException(struct soap *soap, const char *tag, ns3__RemotePermissionException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns3__RemotePermissionException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__RemotePermissionException, sizeof(ns3__RemotePermissionException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns3__RemotePermissionException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns3__RemotePermissionException *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns3__RemotePermissionException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__RemotePermissionException, 0, sizeof(ns3__RemotePermissionException), 0, soap_copy_ns3__RemotePermissionException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns3__RemotePermissionException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__RemotePermissionException);
	if (this->soap_out(soap, tag?tag:"ns3:RemotePermissionException", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns3__RemotePermissionException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns3__RemotePermissionException(soap, this, tag, type);
}

SOAP_FMAC3 ns3__RemotePermissionException * SOAP_FMAC4 soap_get_ns3__RemotePermissionException(struct soap *soap, ns3__RemotePermissionException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__RemotePermissionException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns3__RemotePermissionException * SOAP_FMAC2 soap_instantiate_ns3__RemotePermissionException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__RemotePermissionException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__RemotePermissionException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns3__RemotePermissionException);
		if (size)
			*size = sizeof(ns3__RemotePermissionException);
		((ns3__RemotePermissionException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns3__RemotePermissionException[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns3__RemotePermissionException);
		for (int i = 0; i < n; i++)
			((ns3__RemotePermissionException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns3__RemotePermissionException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__RemotePermissionException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__RemotePermissionException %p -> %p\n", q, p));
	*(ns3__RemotePermissionException*)p = *(ns3__RemotePermissionException*)q;
}

void ns3__RemoteValidationException::soap_default(struct soap *soap)
{
	this->soap = soap;
	/* transient soap skipped */
}

void ns3__RemoteValidationException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns3__RemoteValidationException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns3__RemoteValidationException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__RemoteValidationException(struct soap *soap, const char *tag, int id, const ns3__RemoteValidationException *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__RemoteValidationException), "ns3:RemoteValidationException"))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns3__RemoteValidationException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns3__RemoteValidationException(soap, tag, this, type);
}

SOAP_FMAC3 ns3__RemoteValidationException * SOAP_FMAC4 soap_in_ns3__RemoteValidationException(struct soap *soap, const char *tag, ns3__RemoteValidationException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns3__RemoteValidationException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__RemoteValidationException, sizeof(ns3__RemoteValidationException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns3__RemoteValidationException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns3__RemoteValidationException *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns3__RemoteValidationException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__RemoteValidationException, 0, sizeof(ns3__RemoteValidationException), 0, soap_copy_ns3__RemoteValidationException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns3__RemoteValidationException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__RemoteValidationException);
	if (this->soap_out(soap, tag?tag:"ns3:RemoteValidationException", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns3__RemoteValidationException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns3__RemoteValidationException(soap, this, tag, type);
}

SOAP_FMAC3 ns3__RemoteValidationException * SOAP_FMAC4 soap_get_ns3__RemoteValidationException(struct soap *soap, ns3__RemoteValidationException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__RemoteValidationException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns3__RemoteValidationException * SOAP_FMAC2 soap_instantiate_ns3__RemoteValidationException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__RemoteValidationException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__RemoteValidationException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns3__RemoteValidationException);
		if (size)
			*size = sizeof(ns3__RemoteValidationException);
		((ns3__RemoteValidationException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns3__RemoteValidationException[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns3__RemoteValidationException);
		for (int i = 0; i < n; i++)
			((ns3__RemoteValidationException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns3__RemoteValidationException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__RemoteValidationException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__RemoteValidationException %p -> %p\n", q, p));
	*(ns3__RemoteValidationException*)p = *(ns3__RemoteValidationException*)q;
}

void ns3__RemoteAuthenticationException::soap_default(struct soap *soap)
{
	this->soap = soap;
	/* transient soap skipped */
}

void ns3__RemoteAuthenticationException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns3__RemoteAuthenticationException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns3__RemoteAuthenticationException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__RemoteAuthenticationException(struct soap *soap, const char *tag, int id, const ns3__RemoteAuthenticationException *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__RemoteAuthenticationException), "ns3:RemoteAuthenticationException"))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns3__RemoteAuthenticationException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns3__RemoteAuthenticationException(soap, tag, this, type);
}

SOAP_FMAC3 ns3__RemoteAuthenticationException * SOAP_FMAC4 soap_in_ns3__RemoteAuthenticationException(struct soap *soap, const char *tag, ns3__RemoteAuthenticationException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns3__RemoteAuthenticationException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__RemoteAuthenticationException, sizeof(ns3__RemoteAuthenticationException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns3__RemoteAuthenticationException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns3__RemoteAuthenticationException *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns3__RemoteAuthenticationException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__RemoteAuthenticationException, 0, sizeof(ns3__RemoteAuthenticationException), 0, soap_copy_ns3__RemoteAuthenticationException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns3__RemoteAuthenticationException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__RemoteAuthenticationException);
	if (this->soap_out(soap, tag?tag:"ns3:RemoteAuthenticationException", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns3__RemoteAuthenticationException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns3__RemoteAuthenticationException(soap, this, tag, type);
}

SOAP_FMAC3 ns3__RemoteAuthenticationException * SOAP_FMAC4 soap_get_ns3__RemoteAuthenticationException(struct soap *soap, ns3__RemoteAuthenticationException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__RemoteAuthenticationException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns3__RemoteAuthenticationException * SOAP_FMAC2 soap_instantiate_ns3__RemoteAuthenticationException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__RemoteAuthenticationException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__RemoteAuthenticationException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns3__RemoteAuthenticationException);
		if (size)
			*size = sizeof(ns3__RemoteAuthenticationException);
		((ns3__RemoteAuthenticationException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns3__RemoteAuthenticationException[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns3__RemoteAuthenticationException);
		for (int i = 0; i < n; i++)
			((ns3__RemoteAuthenticationException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns3__RemoteAuthenticationException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__RemoteAuthenticationException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__RemoteAuthenticationException %p -> %p\n", q, p));
	*(ns3__RemoteAuthenticationException*)p = *(ns3__RemoteAuthenticationException*)q;
}

void ns3__RemoteException::soap_default(struct soap *soap)
{
	this->soap = soap;
	/* transient soap skipped */
}

void ns3__RemoteException::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns3__RemoteException::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns3__RemoteException(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns3__RemoteException(struct soap *soap, const char *tag, int id, const ns3__RemoteException *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns3__RemoteException), type))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns3__RemoteException::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns3__RemoteException(soap, tag, this, type);
}

SOAP_FMAC3 ns3__RemoteException * SOAP_FMAC4 soap_in_ns3__RemoteException(struct soap *soap, const char *tag, ns3__RemoteException *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns3__RemoteException *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns3__RemoteException, sizeof(ns3__RemoteException), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns3__RemoteException)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns3__RemoteException *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns3__RemoteException *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns3__RemoteException, 0, sizeof(ns3__RemoteException), 0, soap_copy_ns3__RemoteException);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns3__RemoteException::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns3__RemoteException);
	if (this->soap_out(soap, tag?tag:"ns3:RemoteException", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns3__RemoteException::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns3__RemoteException(soap, this, tag, type);
}

SOAP_FMAC3 ns3__RemoteException * SOAP_FMAC4 soap_get_ns3__RemoteException(struct soap *soap, ns3__RemoteException *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns3__RemoteException(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns3__RemoteException * SOAP_FMAC2 soap_instantiate_ns3__RemoteException(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns3__RemoteException(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns3__RemoteException, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "ns3:RemoteAuthenticationException"))
	{	cp->type = SOAP_TYPE_ns3__RemoteAuthenticationException;
		if (n < 0)
		{	cp->ptr = (void*)new (ns3__RemoteAuthenticationException);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns3__RemoteAuthenticationException);
			((ns3__RemoteAuthenticationException*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns3__RemoteAuthenticationException[n]);
			if (size)
				*size = n * sizeof(ns3__RemoteAuthenticationException);
			for (int i = 0; i < n; i++)
				((ns3__RemoteAuthenticationException*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns3__RemoteAuthenticationException*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns3:RemoteValidationException"))
	{	cp->type = SOAP_TYPE_ns3__RemoteValidationException;
		if (n < 0)
		{	cp->ptr = (void*)new (ns3__RemoteValidationException);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns3__RemoteValidationException);
			((ns3__RemoteValidationException*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns3__RemoteValidationException[n]);
			if (size)
				*size = n * sizeof(ns3__RemoteValidationException);
			for (int i = 0; i < n; i++)
				((ns3__RemoteValidationException*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns3__RemoteValidationException*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns3:RemotePermissionException"))
	{	cp->type = SOAP_TYPE_ns3__RemotePermissionException;
		if (n < 0)
		{	cp->ptr = (void*)new (ns3__RemotePermissionException);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns3__RemotePermissionException);
			((ns3__RemotePermissionException*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns3__RemotePermissionException[n]);
			if (size)
				*size = n * sizeof(ns3__RemotePermissionException);
			for (int i = 0; i < n; i++)
				((ns3__RemotePermissionException*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns3__RemotePermissionException*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new (ns3__RemoteException);
		if (size)
			*size = sizeof(ns3__RemoteException);
		((ns3__RemoteException*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns3__RemoteException[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns3__RemoteException);
		for (int i = 0; i < n; i++)
			((ns3__RemoteException*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns3__RemoteException*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns3__RemoteException(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns3__RemoteException %p -> %p\n", q, p));
	*(ns3__RemoteException*)p = *(ns3__RemoteException*)q;
}

void ns2__RemoteAvatar::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteAvatar::base64Data);
	soap_default_string(soap, &this->ns2__RemoteAvatar::contentType);
	soap_default_LONG64(soap, &this->ns2__RemoteAvatar::id);
	soap_default_string(soap, &this->ns2__RemoteAvatar::owner);
	soap_default_bool(soap, &this->ns2__RemoteAvatar::system);
	soap_default_string(soap, &this->ns2__RemoteAvatar::type);
	/* transient soap skipped */
}

void ns2__RemoteAvatar::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteAvatar::base64Data);
	soap_serialize_string(soap, &this->ns2__RemoteAvatar::contentType);
	soap_embedded(soap, &this->ns2__RemoteAvatar::id, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &this->ns2__RemoteAvatar::owner);
	soap_serialize_string(soap, &this->ns2__RemoteAvatar::type);
	/* transient soap skipped */
}

int ns2__RemoteAvatar::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteAvatar(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteAvatar(struct soap *soap, const char *tag, int id, const ns2__RemoteAvatar *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteAvatar), type))
		return soap->error;
	if (soap_out_string(soap, "base64Data", -1, &(a->ns2__RemoteAvatar::base64Data), ""))
		return soap->error;
	if (soap_out_string(soap, "contentType", -1, &(a->ns2__RemoteAvatar::contentType), ""))
		return soap->error;
	if (soap_out_LONG64(soap, "id", -1, &(a->ns2__RemoteAvatar::id), ""))
		return soap->error;
	if (soap_out_string(soap, "owner", -1, &(a->ns2__RemoteAvatar::owner), ""))
		return soap->error;
	if (soap_out_bool(soap, "system", -1, &(a->ns2__RemoteAvatar::system), ""))
		return soap->error;
	if (soap_out_string(soap, "type", -1, &(a->ns2__RemoteAvatar::type), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteAvatar::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteAvatar(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteAvatar * SOAP_FMAC4 soap_in_ns2__RemoteAvatar(struct soap *soap, const char *tag, ns2__RemoteAvatar *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteAvatar *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteAvatar, sizeof(ns2__RemoteAvatar), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteAvatar)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteAvatar *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_base64Data1 = 1;
	size_t soap_flag_contentType1 = 1;
	size_t soap_flag_id1 = 1;
	size_t soap_flag_owner1 = 1;
	size_t soap_flag_system1 = 1;
	size_t soap_flag_type1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_base64Data1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "base64Data", &(a->ns2__RemoteAvatar::base64Data), "xsd:string"))
				{	soap_flag_base64Data1--;
					continue;
				}
			if (soap_flag_contentType1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "contentType", &(a->ns2__RemoteAvatar::contentType), "xsd:string"))
				{	soap_flag_contentType1--;
					continue;
				}
			if (soap_flag_id1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "id", &(a->ns2__RemoteAvatar::id), "xsd:long"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_owner1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "owner", &(a->ns2__RemoteAvatar::owner), "xsd:string"))
				{	soap_flag_owner1--;
					continue;
				}
			if (soap_flag_system1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "system", &(a->ns2__RemoteAvatar::system), "xsd:boolean"))
				{	soap_flag_system1--;
					continue;
				}
			if (soap_flag_type1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "type", &(a->ns2__RemoteAvatar::type), "xsd:string"))
				{	soap_flag_type1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteAvatar *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteAvatar, 0, sizeof(ns2__RemoteAvatar), 0, soap_copy_ns2__RemoteAvatar);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_id1 > 0 || soap_flag_system1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int ns2__RemoteAvatar::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteAvatar);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteAvatar", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteAvatar::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteAvatar(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteAvatar * SOAP_FMAC4 soap_get_ns2__RemoteAvatar(struct soap *soap, ns2__RemoteAvatar *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteAvatar(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteAvatar * SOAP_FMAC2 soap_instantiate_ns2__RemoteAvatar(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteAvatar(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteAvatar, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteAvatar);
		if (size)
			*size = sizeof(ns2__RemoteAvatar);
		((ns2__RemoteAvatar*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteAvatar[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteAvatar);
		for (int i = 0; i < n; i++)
			((ns2__RemoteAvatar*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteAvatar*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteAvatar(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteAvatar %p -> %p\n", q, p));
	*(ns2__RemoteAvatar*)p = *(ns2__RemoteAvatar*)q;
}

void ns2__RemoteWorklog::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteWorklog::author);
	soap_default_string(soap, &this->ns2__RemoteWorklog::comment);
	this->ns2__RemoteWorklog::created = NULL;
	soap_default_string(soap, &this->ns2__RemoteWorklog::groupLevel);
	soap_default_string(soap, &this->ns2__RemoteWorklog::id);
	soap_default_string(soap, &this->ns2__RemoteWorklog::roleLevelId);
	this->ns2__RemoteWorklog::startDate = NULL;
	soap_default_string(soap, &this->ns2__RemoteWorklog::timeSpent);
	soap_default_LONG64(soap, &this->ns2__RemoteWorklog::timeSpentInSeconds);
	soap_default_string(soap, &this->ns2__RemoteWorklog::updateAuthor);
	this->ns2__RemoteWorklog::updated = NULL;
	/* transient soap skipped */
}

void ns2__RemoteWorklog::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteWorklog::author);
	soap_serialize_string(soap, &this->ns2__RemoteWorklog::comment);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteWorklog::created);
	soap_serialize_string(soap, &this->ns2__RemoteWorklog::groupLevel);
	soap_serialize_string(soap, &this->ns2__RemoteWorklog::id);
	soap_serialize_string(soap, &this->ns2__RemoteWorklog::roleLevelId);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteWorklog::startDate);
	soap_serialize_string(soap, &this->ns2__RemoteWorklog::timeSpent);
	soap_embedded(soap, &this->ns2__RemoteWorklog::timeSpentInSeconds, SOAP_TYPE_LONG64);
	soap_serialize_string(soap, &this->ns2__RemoteWorklog::updateAuthor);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteWorklog::updated);
	/* transient soap skipped */
}

int ns2__RemoteWorklog::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteWorklog(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteWorklog(struct soap *soap, const char *tag, int id, const ns2__RemoteWorklog *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteWorklog), type))
		return soap->error;
	if (soap_out_string(soap, "author", -1, &(a->ns2__RemoteWorklog::author), ""))
		return soap->error;
	if (soap_out_string(soap, "comment", -1, &(a->ns2__RemoteWorklog::comment), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "created", -1, &(a->ns2__RemoteWorklog::created), ""))
		return soap->error;
	if (soap_out_string(soap, "groupLevel", -1, &(a->ns2__RemoteWorklog::groupLevel), ""))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__RemoteWorklog::id), ""))
		return soap->error;
	if (soap_out_string(soap, "roleLevelId", -1, &(a->ns2__RemoteWorklog::roleLevelId), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "startDate", -1, &(a->ns2__RemoteWorklog::startDate), ""))
		return soap->error;
	if (soap_out_string(soap, "timeSpent", -1, &(a->ns2__RemoteWorklog::timeSpent), ""))
		return soap->error;
	if (soap_out_LONG64(soap, "timeSpentInSeconds", -1, &(a->ns2__RemoteWorklog::timeSpentInSeconds), ""))
		return soap->error;
	if (soap_out_string(soap, "updateAuthor", -1, &(a->ns2__RemoteWorklog::updateAuthor), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "updated", -1, &(a->ns2__RemoteWorklog::updated), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteWorklog::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteWorklog(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteWorklog * SOAP_FMAC4 soap_in_ns2__RemoteWorklog(struct soap *soap, const char *tag, ns2__RemoteWorklog *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteWorklog *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteWorklog, sizeof(ns2__RemoteWorklog), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteWorklog)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteWorklog *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_author1 = 1;
	size_t soap_flag_comment1 = 1;
	size_t soap_flag_created1 = 1;
	size_t soap_flag_groupLevel1 = 1;
	size_t soap_flag_id1 = 1;
	size_t soap_flag_roleLevelId1 = 1;
	size_t soap_flag_startDate1 = 1;
	size_t soap_flag_timeSpent1 = 1;
	size_t soap_flag_timeSpentInSeconds1 = 1;
	size_t soap_flag_updateAuthor1 = 1;
	size_t soap_flag_updated1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_author1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "author", &(a->ns2__RemoteWorklog::author), "xsd:string"))
				{	soap_flag_author1--;
					continue;
				}
			if (soap_flag_comment1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "comment", &(a->ns2__RemoteWorklog::comment), "xsd:string"))
				{	soap_flag_comment1--;
					continue;
				}
			if (soap_flag_created1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "created", &(a->ns2__RemoteWorklog::created), "xsd:dateTime"))
				{	soap_flag_created1--;
					continue;
				}
			if (soap_flag_groupLevel1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "groupLevel", &(a->ns2__RemoteWorklog::groupLevel), "xsd:string"))
				{	soap_flag_groupLevel1--;
					continue;
				}
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__RemoteWorklog::id), "xsd:string"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_roleLevelId1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "roleLevelId", &(a->ns2__RemoteWorklog::roleLevelId), "xsd:string"))
				{	soap_flag_roleLevelId1--;
					continue;
				}
			if (soap_flag_startDate1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "startDate", &(a->ns2__RemoteWorklog::startDate), "xsd:dateTime"))
				{	soap_flag_startDate1--;
					continue;
				}
			if (soap_flag_timeSpent1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "timeSpent", &(a->ns2__RemoteWorklog::timeSpent), "xsd:string"))
				{	soap_flag_timeSpent1--;
					continue;
				}
			if (soap_flag_timeSpentInSeconds1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_LONG64(soap, "timeSpentInSeconds", &(a->ns2__RemoteWorklog::timeSpentInSeconds), "xsd:long"))
				{	soap_flag_timeSpentInSeconds1--;
					continue;
				}
			if (soap_flag_updateAuthor1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "updateAuthor", &(a->ns2__RemoteWorklog::updateAuthor), "xsd:string"))
				{	soap_flag_updateAuthor1--;
					continue;
				}
			if (soap_flag_updated1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "updated", &(a->ns2__RemoteWorklog::updated), "xsd:dateTime"))
				{	soap_flag_updated1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteWorklog *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteWorklog, 0, sizeof(ns2__RemoteWorklog), 0, soap_copy_ns2__RemoteWorklog);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_timeSpentInSeconds1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int ns2__RemoteWorklog::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteWorklog);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteWorklog", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteWorklog::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteWorklog(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteWorklog * SOAP_FMAC4 soap_get_ns2__RemoteWorklog(struct soap *soap, ns2__RemoteWorklog *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteWorklog(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteWorklog * SOAP_FMAC2 soap_instantiate_ns2__RemoteWorklog(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteWorklog(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteWorklog, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteWorklog);
		if (size)
			*size = sizeof(ns2__RemoteWorklog);
		((ns2__RemoteWorklog*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteWorklog[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteWorklog);
		for (int i = 0; i < n; i++)
			((ns2__RemoteWorklog*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteWorklog*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteWorklog(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteWorklog %p -> %p\n", q, p));
	*(ns2__RemoteWorklog*)p = *(ns2__RemoteWorklog*)q;
}

void ns2__RemoteAttachment::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteAttachment::author);
	this->ns2__RemoteAttachment::created = NULL;
	soap_default_string(soap, &this->ns2__RemoteAttachment::filename);
	this->ns2__RemoteAttachment::filesize = NULL;
	soap_default_string(soap, &this->ns2__RemoteAttachment::mimetype);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteAttachment::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteAttachment::author);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteAttachment::created);
	soap_serialize_string(soap, &this->ns2__RemoteAttachment::filename);
	soap_serialize_PointerToLONG64(soap, &this->ns2__RemoteAttachment::filesize);
	soap_serialize_string(soap, &this->ns2__RemoteAttachment::mimetype);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteAttachment::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteAttachment(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteAttachment(struct soap *soap, const char *tag, int id, const ns2__RemoteAttachment *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteAttachment), "ns2:RemoteAttachment"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "author", -1, &(a->ns2__RemoteAttachment::author), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "created", -1, &(a->ns2__RemoteAttachment::created), ""))
		return soap->error;
	if (soap_out_string(soap, "filename", -1, &(a->ns2__RemoteAttachment::filename), ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "filesize", -1, &(a->ns2__RemoteAttachment::filesize), ""))
		return soap->error;
	if (soap_out_string(soap, "mimetype", -1, &(a->ns2__RemoteAttachment::mimetype), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteAttachment::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteAttachment(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteAttachment * SOAP_FMAC4 soap_in_ns2__RemoteAttachment(struct soap *soap, const char *tag, ns2__RemoteAttachment *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteAttachment *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteAttachment, sizeof(ns2__RemoteAttachment), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteAttachment)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteAttachment *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id2 = 1;
	size_t soap_flag_author1 = 1;
	size_t soap_flag_created1 = 1;
	size_t soap_flag_filename1 = 1;
	size_t soap_flag_filesize1 = 1;
	size_t soap_flag_mimetype1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id2--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_author1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "author", &(a->ns2__RemoteAttachment::author), "xsd:string"))
				{	soap_flag_author1--;
					continue;
				}
			if (soap_flag_created1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "created", &(a->ns2__RemoteAttachment::created), "xsd:dateTime"))
				{	soap_flag_created1--;
					continue;
				}
			if (soap_flag_filename1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "filename", &(a->ns2__RemoteAttachment::filename), "xsd:string"))
				{	soap_flag_filename1--;
					continue;
				}
			if (soap_flag_filesize1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "filesize", &(a->ns2__RemoteAttachment::filesize), "xsd:long"))
				{	soap_flag_filesize1--;
					continue;
				}
			if (soap_flag_mimetype1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "mimetype", &(a->ns2__RemoteAttachment::mimetype), "xsd:string"))
				{	soap_flag_mimetype1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteAttachment *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteAttachment, 0, sizeof(ns2__RemoteAttachment), 0, soap_copy_ns2__RemoteAttachment);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteAttachment::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteAttachment);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteAttachment", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteAttachment::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteAttachment(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteAttachment * SOAP_FMAC4 soap_get_ns2__RemoteAttachment(struct soap *soap, ns2__RemoteAttachment *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteAttachment(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteAttachment * SOAP_FMAC2 soap_instantiate_ns2__RemoteAttachment(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteAttachment(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteAttachment, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteAttachment);
		if (size)
			*size = sizeof(ns2__RemoteAttachment);
		((ns2__RemoteAttachment*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteAttachment[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteAttachment);
		for (int i = 0; i < n; i++)
			((ns2__RemoteAttachment*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteAttachment*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteAttachment(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteAttachment %p -> %p\n", q, p));
	*(ns2__RemoteAttachment*)p = *(ns2__RemoteAttachment*)q;
}

void ns2__RemoteSecurityLevel::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteSecurityLevel::description);
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteSecurityLevel::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteSecurityLevel::description);
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteSecurityLevel::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteSecurityLevel(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteSecurityLevel(struct soap *soap, const char *tag, int id, const ns2__RemoteSecurityLevel *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteSecurityLevel), "ns2:RemoteSecurityLevel"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__RemoteSecurityLevel::description), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteSecurityLevel::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteSecurityLevel(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteSecurityLevel * SOAP_FMAC4 soap_in_ns2__RemoteSecurityLevel(struct soap *soap, const char *tag, ns2__RemoteSecurityLevel *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteSecurityLevel *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteSecurityLevel, sizeof(ns2__RemoteSecurityLevel), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteSecurityLevel)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteSecurityLevel *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id3 = 1;
	size_t soap_flag_name2 = 1;
	size_t soap_flag_description1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id3--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name2--;
					continue;
				}
			if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__RemoteSecurityLevel::description), "xsd:string"))
				{	soap_flag_description1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteSecurityLevel *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteSecurityLevel, 0, sizeof(ns2__RemoteSecurityLevel), 0, soap_copy_ns2__RemoteSecurityLevel);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteSecurityLevel::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteSecurityLevel);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteSecurityLevel", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteSecurityLevel::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteSecurityLevel(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteSecurityLevel * SOAP_FMAC4 soap_get_ns2__RemoteSecurityLevel(struct soap *soap, ns2__RemoteSecurityLevel *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteSecurityLevel(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteSecurityLevel * SOAP_FMAC2 soap_instantiate_ns2__RemoteSecurityLevel(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteSecurityLevel(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteSecurityLevel, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteSecurityLevel);
		if (size)
			*size = sizeof(ns2__RemoteSecurityLevel);
		((ns2__RemoteSecurityLevel*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteSecurityLevel[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteSecurityLevel);
		for (int i = 0; i < n; i++)
			((ns2__RemoteSecurityLevel*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteSecurityLevel*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteSecurityLevel(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteSecurityLevel %p -> %p\n", q, p));
	*(ns2__RemoteSecurityLevel*)p = *(ns2__RemoteSecurityLevel*)q;
}

void ns2__RemoteFieldValue::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteFieldValue::id);
	this->ns2__RemoteFieldValue::values = NULL;
	/* transient soap skipped */
}

void ns2__RemoteFieldValue::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteFieldValue::id);
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREstring(soap, &this->ns2__RemoteFieldValue::values);
	/* transient soap skipped */
}

int ns2__RemoteFieldValue::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteFieldValue(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteFieldValue(struct soap *soap, const char *tag, int id, const ns2__RemoteFieldValue *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteFieldValue), type))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__RemoteFieldValue::id), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREstring(soap, "values", -1, &(a->ns2__RemoteFieldValue::values), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteFieldValue::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteFieldValue(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteFieldValue * SOAP_FMAC4 soap_in_ns2__RemoteFieldValue(struct soap *soap, const char *tag, ns2__RemoteFieldValue *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteFieldValue *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteFieldValue, sizeof(ns2__RemoteFieldValue), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteFieldValue)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteFieldValue *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id1 = 1;
	size_t soap_flag_values1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__RemoteFieldValue::id), "xsd:string"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_values1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREstring(soap, "values", &(a->ns2__RemoteFieldValue::values), "xsd:string"))
				{	soap_flag_values1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteFieldValue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteFieldValue, 0, sizeof(ns2__RemoteFieldValue), 0, soap_copy_ns2__RemoteFieldValue);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteFieldValue::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteFieldValue);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteFieldValue", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteFieldValue::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteFieldValue(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteFieldValue * SOAP_FMAC4 soap_get_ns2__RemoteFieldValue(struct soap *soap, ns2__RemoteFieldValue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteFieldValue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteFieldValue * SOAP_FMAC2 soap_instantiate_ns2__RemoteFieldValue(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteFieldValue(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteFieldValue, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteFieldValue);
		if (size)
			*size = sizeof(ns2__RemoteFieldValue);
		((ns2__RemoteFieldValue*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteFieldValue[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteFieldValue);
		for (int i = 0; i < n; i++)
			((ns2__RemoteFieldValue*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteFieldValue*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteFieldValue(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteFieldValue %p -> %p\n", q, p));
	*(ns2__RemoteFieldValue*)p = *(ns2__RemoteFieldValue*)q;
}

void ns2__RemoteFilter::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteFilter::author);
	soap_default_string(soap, &this->ns2__RemoteFilter::description);
	soap_default_string(soap, &this->ns2__RemoteFilter::project);
	soap_default_string(soap, &this->ns2__RemoteFilter::xml);
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteFilter::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteFilter::author);
	soap_serialize_string(soap, &this->ns2__RemoteFilter::description);
	soap_serialize_string(soap, &this->ns2__RemoteFilter::project);
	soap_serialize_string(soap, &this->ns2__RemoteFilter::xml);
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteFilter::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteFilter(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteFilter(struct soap *soap, const char *tag, int id, const ns2__RemoteFilter *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteFilter), "ns2:RemoteFilter"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	if (soap_out_string(soap, "author", -1, &(a->ns2__RemoteFilter::author), ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__RemoteFilter::description), ""))
		return soap->error;
	if (soap_out_string(soap, "project", -1, &(a->ns2__RemoteFilter::project), ""))
		return soap->error;
	if (soap_out_string(soap, "xml", -1, &(a->ns2__RemoteFilter::xml), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteFilter::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteFilter(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteFilter * SOAP_FMAC4 soap_in_ns2__RemoteFilter(struct soap *soap, const char *tag, ns2__RemoteFilter *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteFilter *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteFilter, sizeof(ns2__RemoteFilter), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteFilter)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteFilter *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id3 = 1;
	size_t soap_flag_name2 = 1;
	size_t soap_flag_author1 = 1;
	size_t soap_flag_description1 = 1;
	size_t soap_flag_project1 = 1;
	size_t soap_flag_xml1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id3--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name2--;
					continue;
				}
			if (soap_flag_author1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "author", &(a->ns2__RemoteFilter::author), "xsd:string"))
				{	soap_flag_author1--;
					continue;
				}
			if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__RemoteFilter::description), "xsd:string"))
				{	soap_flag_description1--;
					continue;
				}
			if (soap_flag_project1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "project", &(a->ns2__RemoteFilter::project), "xsd:string"))
				{	soap_flag_project1--;
					continue;
				}
			if (soap_flag_xml1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "xml", &(a->ns2__RemoteFilter::xml), "xsd:string"))
				{	soap_flag_xml1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteFilter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteFilter, 0, sizeof(ns2__RemoteFilter), 0, soap_copy_ns2__RemoteFilter);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteFilter::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteFilter);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteFilter", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteFilter::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteFilter(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteFilter * SOAP_FMAC4 soap_get_ns2__RemoteFilter(struct soap *soap, ns2__RemoteFilter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteFilter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteFilter * SOAP_FMAC2 soap_instantiate_ns2__RemoteFilter(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteFilter(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteFilter, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteFilter);
		if (size)
			*size = sizeof(ns2__RemoteFilter);
		((ns2__RemoteFilter*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteFilter[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteFilter);
		for (int i = 0; i < n; i++)
			((ns2__RemoteFilter*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteFilter*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteFilter(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteFilter %p -> %p\n", q, p));
	*(ns2__RemoteFilter*)p = *(ns2__RemoteFilter*)q;
}

void ns2__RemoteField::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteField::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteField::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteField(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteField(struct soap *soap, const char *tag, int id, const ns2__RemoteField *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteField), "ns2:RemoteField"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteField::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteField(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteField * SOAP_FMAC4 soap_in_ns2__RemoteField(struct soap *soap, const char *tag, ns2__RemoteField *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteField *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteField, sizeof(ns2__RemoteField), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteField)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteField *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id3 = 1;
	size_t soap_flag_name2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id3--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteField *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteField, 0, sizeof(ns2__RemoteField), 0, soap_copy_ns2__RemoteField);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteField::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteField);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteField", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteField::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteField(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteField * SOAP_FMAC4 soap_get_ns2__RemoteField(struct soap *soap, ns2__RemoteField *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteField(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteField * SOAP_FMAC2 soap_instantiate_ns2__RemoteField(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteField(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteField, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteField);
		if (size)
			*size = sizeof(ns2__RemoteField);
		((ns2__RemoteField*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteField[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteField);
		for (int i = 0; i < n; i++)
			((ns2__RemoteField*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteField*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteField(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteField %p -> %p\n", q, p));
	*(ns2__RemoteField*)p = *(ns2__RemoteField*)q;
}

void ns2__RemoteProjectRoleActors::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->ns2__RemoteProjectRoleActors::project = NULL;
	this->ns2__RemoteRoleActors::projectRole = NULL;
	this->ns2__RemoteRoleActors::roleActors = NULL;
	this->ns2__RemoteRoleActors::users = NULL;
	/* transient soap skipped */
}

void ns2__RemoteProjectRoleActors::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__RemoteProject(soap, &this->ns2__RemoteProjectRoleActors::project);
	soap_serialize_PointerTons2__RemoteProjectRole(soap, &this->ns2__RemoteRoleActors::projectRole);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, &this->ns2__RemoteRoleActors::roleActors);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, &this->ns2__RemoteRoleActors::users);
	/* transient soap skipped */
}

int ns2__RemoteProjectRoleActors::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteProjectRoleActors(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteProjectRoleActors(struct soap *soap, const char *tag, int id, const ns2__RemoteProjectRoleActors *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteProjectRoleActors), "ns2:RemoteProjectRoleActors"))
		return soap->error;
	if (soap_out_PointerTons2__RemoteProjectRole(soap, "projectRole", -1, &(a->ns2__RemoteRoleActors::projectRole), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, "roleActors", -1, &(a->ns2__RemoteRoleActors::roleActors), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, "users", -1, &(a->ns2__RemoteRoleActors::users), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_PointerTons2__RemoteProject(soap, "project", -1, &(a->ns2__RemoteProjectRoleActors::project), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteProjectRoleActors::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteProjectRoleActors(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteProjectRoleActors * SOAP_FMAC4 soap_in_ns2__RemoteProjectRoleActors(struct soap *soap, const char *tag, ns2__RemoteProjectRoleActors *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteProjectRoleActors *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteProjectRoleActors, sizeof(ns2__RemoteProjectRoleActors), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteProjectRoleActors)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteProjectRoleActors *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_projectRole2 = 1;
	size_t soap_flag_roleActors2 = 1;
	size_t soap_flag_users2 = 1;
	size_t soap_flag_project1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_projectRole2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteProjectRole(soap, "projectRole", &(a->ns2__RemoteRoleActors::projectRole), "ns2:RemoteProjectRole"))
				{	soap_flag_projectRole2--;
					continue;
				}
			if (soap_flag_roleActors2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, "roleActors", &(a->ns2__RemoteRoleActors::roleActors), "ns2:RemoteRoleActor"))
				{	soap_flag_roleActors2--;
					continue;
				}
			if (soap_flag_users2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, "users", &(a->ns2__RemoteRoleActors::users), "ns2:RemoteUser"))
				{	soap_flag_users2--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_project1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteProject(soap, "project", &(a->ns2__RemoteProjectRoleActors::project), "ns2:RemoteProject"))
				{	soap_flag_project1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteProjectRoleActors *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteProjectRoleActors, 0, sizeof(ns2__RemoteProjectRoleActors), 0, soap_copy_ns2__RemoteProjectRoleActors);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteProjectRoleActors::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteProjectRoleActors);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteProjectRoleActors", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteProjectRoleActors::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteProjectRoleActors(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteProjectRoleActors * SOAP_FMAC4 soap_get_ns2__RemoteProjectRoleActors(struct soap *soap, ns2__RemoteProjectRoleActors *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteProjectRoleActors(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteProjectRoleActors * SOAP_FMAC2 soap_instantiate_ns2__RemoteProjectRoleActors(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteProjectRoleActors(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteProjectRoleActors, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteProjectRoleActors);
		if (size)
			*size = sizeof(ns2__RemoteProjectRoleActors);
		((ns2__RemoteProjectRoleActors*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteProjectRoleActors[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteProjectRoleActors);
		for (int i = 0; i < n; i++)
			((ns2__RemoteProjectRoleActors*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteProjectRoleActors*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteProjectRoleActors(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteProjectRoleActors %p -> %p\n", q, p));
	*(ns2__RemoteProjectRoleActors*)p = *(ns2__RemoteProjectRoleActors*)q;
}

void ns2__RemoteRoleActors::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->ns2__RemoteRoleActors::projectRole = NULL;
	this->ns2__RemoteRoleActors::roleActors = NULL;
	this->ns2__RemoteRoleActors::users = NULL;
	/* transient soap skipped */
}

void ns2__RemoteRoleActors::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__RemoteProjectRole(soap, &this->ns2__RemoteRoleActors::projectRole);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, &this->ns2__RemoteRoleActors::roleActors);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, &this->ns2__RemoteRoleActors::users);
	/* transient soap skipped */
}

int ns2__RemoteRoleActors::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteRoleActors(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteRoleActors(struct soap *soap, const char *tag, int id, const ns2__RemoteRoleActors *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteRoleActors), type))
		return soap->error;
	if (soap_out_PointerTons2__RemoteProjectRole(soap, "projectRole", -1, &(a->ns2__RemoteRoleActors::projectRole), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, "roleActors", -1, &(a->ns2__RemoteRoleActors::roleActors), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, "users", -1, &(a->ns2__RemoteRoleActors::users), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteRoleActors::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteRoleActors(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteRoleActors * SOAP_FMAC4 soap_in_ns2__RemoteRoleActors(struct soap *soap, const char *tag, ns2__RemoteRoleActors *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteRoleActors *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteRoleActors, sizeof(ns2__RemoteRoleActors), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteRoleActors)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteRoleActors *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_projectRole1 = 1;
	size_t soap_flag_roleActors1 = 1;
	size_t soap_flag_users1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_projectRole1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteProjectRole(soap, "projectRole", &(a->ns2__RemoteRoleActors::projectRole), "ns2:RemoteProjectRole"))
				{	soap_flag_projectRole1--;
					continue;
				}
			if (soap_flag_roleActors1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteRoleActor(soap, "roleActors", &(a->ns2__RemoteRoleActors::roleActors), "ns2:RemoteRoleActor"))
				{	soap_flag_roleActors1--;
					continue;
				}
			if (soap_flag_users1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, "users", &(a->ns2__RemoteRoleActors::users), "ns2:RemoteUser"))
				{	soap_flag_users1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteRoleActors *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteRoleActors, 0, sizeof(ns2__RemoteRoleActors), 0, soap_copy_ns2__RemoteRoleActors);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteRoleActors::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteRoleActors);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteRoleActors", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteRoleActors::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteRoleActors(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteRoleActors * SOAP_FMAC4 soap_get_ns2__RemoteRoleActors(struct soap *soap, ns2__RemoteRoleActors *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteRoleActors(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteRoleActors * SOAP_FMAC2 soap_instantiate_ns2__RemoteRoleActors(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteRoleActors(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteRoleActors, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "ns2:RemoteProjectRoleActors"))
	{	cp->type = SOAP_TYPE_ns2__RemoteProjectRoleActors;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteProjectRoleActors);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteProjectRoleActors);
			((ns2__RemoteProjectRoleActors*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteProjectRoleActors[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteProjectRoleActors);
			for (int i = 0; i < n; i++)
				((ns2__RemoteProjectRoleActors*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteProjectRoleActors*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteRoleActors);
		if (size)
			*size = sizeof(ns2__RemoteRoleActors);
		((ns2__RemoteRoleActors*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteRoleActors[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteRoleActors);
		for (int i = 0; i < n; i++)
			((ns2__RemoteRoleActors*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteRoleActors*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteRoleActors(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteRoleActors %p -> %p\n", q, p));
	*(ns2__RemoteRoleActors*)p = *(ns2__RemoteRoleActors*)q;
}

void ns2__RemoteRoleActor::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteRoleActor::descriptor);
	soap_default_string(soap, &this->ns2__RemoteRoleActor::parameter);
	this->ns2__RemoteRoleActor::projectRole = NULL;
	soap_default_string(soap, &this->ns2__RemoteRoleActor::type);
	this->ns2__RemoteRoleActor::users = NULL;
	/* transient soap skipped */
}

void ns2__RemoteRoleActor::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteRoleActor::descriptor);
	soap_serialize_string(soap, &this->ns2__RemoteRoleActor::parameter);
	soap_serialize_PointerTons2__RemoteProjectRole(soap, &this->ns2__RemoteRoleActor::projectRole);
	soap_serialize_string(soap, &this->ns2__RemoteRoleActor::type);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, &this->ns2__RemoteRoleActor::users);
	/* transient soap skipped */
}

int ns2__RemoteRoleActor::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteRoleActor(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteRoleActor(struct soap *soap, const char *tag, int id, const ns2__RemoteRoleActor *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteRoleActor), type))
		return soap->error;
	if (soap_out_string(soap, "descriptor", -1, &(a->ns2__RemoteRoleActor::descriptor), ""))
		return soap->error;
	if (soap_out_string(soap, "parameter", -1, &(a->ns2__RemoteRoleActor::parameter), ""))
		return soap->error;
	if (soap_out_PointerTons2__RemoteProjectRole(soap, "projectRole", -1, &(a->ns2__RemoteRoleActor::projectRole), ""))
		return soap->error;
	if (soap_out_string(soap, "type", -1, &(a->ns2__RemoteRoleActor::type), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, "users", -1, &(a->ns2__RemoteRoleActor::users), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteRoleActor::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteRoleActor(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteRoleActor * SOAP_FMAC4 soap_in_ns2__RemoteRoleActor(struct soap *soap, const char *tag, ns2__RemoteRoleActor *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteRoleActor *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteRoleActor, sizeof(ns2__RemoteRoleActor), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteRoleActor)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteRoleActor *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_descriptor1 = 1;
	size_t soap_flag_parameter1 = 1;
	size_t soap_flag_projectRole1 = 1;
	size_t soap_flag_type1 = 1;
	size_t soap_flag_users1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_descriptor1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "descriptor", &(a->ns2__RemoteRoleActor::descriptor), "xsd:string"))
				{	soap_flag_descriptor1--;
					continue;
				}
			if (soap_flag_parameter1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "parameter", &(a->ns2__RemoteRoleActor::parameter), "xsd:string"))
				{	soap_flag_parameter1--;
					continue;
				}
			if (soap_flag_projectRole1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteProjectRole(soap, "projectRole", &(a->ns2__RemoteRoleActor::projectRole), "ns2:RemoteProjectRole"))
				{	soap_flag_projectRole1--;
					continue;
				}
			if (soap_flag_type1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "type", &(a->ns2__RemoteRoleActor::type), "xsd:string"))
				{	soap_flag_type1--;
					continue;
				}
			if (soap_flag_users1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, "users", &(a->ns2__RemoteRoleActor::users), "ns2:RemoteUser"))
				{	soap_flag_users1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteRoleActor *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteRoleActor, 0, sizeof(ns2__RemoteRoleActor), 0, soap_copy_ns2__RemoteRoleActor);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteRoleActor::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteRoleActor);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteRoleActor", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteRoleActor::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteRoleActor(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteRoleActor * SOAP_FMAC4 soap_get_ns2__RemoteRoleActor(struct soap *soap, ns2__RemoteRoleActor *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteRoleActor(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteRoleActor * SOAP_FMAC2 soap_instantiate_ns2__RemoteRoleActor(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteRoleActor(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteRoleActor, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteRoleActor);
		if (size)
			*size = sizeof(ns2__RemoteRoleActor);
		((ns2__RemoteRoleActor*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteRoleActor[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteRoleActor);
		for (int i = 0; i < n; i++)
			((ns2__RemoteRoleActor*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteRoleActor*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteRoleActor(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteRoleActor %p -> %p\n", q, p));
	*(ns2__RemoteRoleActor*)p = *(ns2__RemoteRoleActor*)q;
}

void ns2__RemoteProjectRole::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteProjectRole::description);
	this->ns2__RemoteProjectRole::id = NULL;
	soap_default_string(soap, &this->ns2__RemoteProjectRole::name);
	/* transient soap skipped */
}

void ns2__RemoteProjectRole::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteProjectRole::description);
	soap_serialize_PointerToLONG64(soap, &this->ns2__RemoteProjectRole::id);
	soap_serialize_string(soap, &this->ns2__RemoteProjectRole::name);
	/* transient soap skipped */
}

int ns2__RemoteProjectRole::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteProjectRole(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteProjectRole(struct soap *soap, const char *tag, int id, const ns2__RemoteProjectRole *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteProjectRole), type))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__RemoteProjectRole::description), ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &(a->ns2__RemoteProjectRole::id), ""))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &(a->ns2__RemoteProjectRole::name), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteProjectRole::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteProjectRole(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteProjectRole * SOAP_FMAC4 soap_in_ns2__RemoteProjectRole(struct soap *soap, const char *tag, ns2__RemoteProjectRole *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteProjectRole *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteProjectRole, sizeof(ns2__RemoteProjectRole), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteProjectRole)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteProjectRole *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_description1 = 1;
	size_t soap_flag_id1 = 1;
	size_t soap_flag_name1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__RemoteProjectRole::description), "xsd:string"))
				{	soap_flag_description1--;
					continue;
				}
			if (soap_flag_id1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &(a->ns2__RemoteProjectRole::id), "xsd:long"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__RemoteProjectRole::name), "xsd:string"))
				{	soap_flag_name1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteProjectRole *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteProjectRole, 0, sizeof(ns2__RemoteProjectRole), 0, soap_copy_ns2__RemoteProjectRole);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteProjectRole::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteProjectRole);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteProjectRole", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteProjectRole::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteProjectRole(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteProjectRole * SOAP_FMAC4 soap_get_ns2__RemoteProjectRole(struct soap *soap, ns2__RemoteProjectRole *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteProjectRole(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteProjectRole * SOAP_FMAC2 soap_instantiate_ns2__RemoteProjectRole(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteProjectRole(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteProjectRole, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteProjectRole);
		if (size)
			*size = sizeof(ns2__RemoteProjectRole);
		((ns2__RemoteProjectRole*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteProjectRole[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteProjectRole);
		for (int i = 0; i < n; i++)
			((ns2__RemoteProjectRole*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteProjectRole*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteProjectRole(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteProjectRole %p -> %p\n", q, p));
	*(ns2__RemoteProjectRole*)p = *(ns2__RemoteProjectRole*)q;
}

void ns2__RemoteStatus::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteStatus::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteStatus::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteStatus(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteStatus(struct soap *soap, const char *tag, int id, const ns2__RemoteStatus *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteStatus), "ns2:RemoteStatus"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__AbstractRemoteConstant::description), ""))
		return soap->error;
	if (soap_out_string(soap, "icon", -1, &(a->ns2__AbstractRemoteConstant::icon), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteStatus::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteStatus(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteStatus * SOAP_FMAC4 soap_in_ns2__RemoteStatus(struct soap *soap, const char *tag, ns2__RemoteStatus *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteStatus *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteStatus, sizeof(ns2__RemoteStatus), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteStatus)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteStatus *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id4 = 1;
	size_t soap_flag_name3 = 1;
	size_t soap_flag_description2 = 1;
	size_t soap_flag_icon2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id4 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id4--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name3--;
					continue;
				}
			if (soap_flag_description2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__AbstractRemoteConstant::description), "xsd:string"))
				{	soap_flag_description2--;
					continue;
				}
			if (soap_flag_icon2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "icon", &(a->ns2__AbstractRemoteConstant::icon), "xsd:string"))
				{	soap_flag_icon2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteStatus *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteStatus, 0, sizeof(ns2__RemoteStatus), 0, soap_copy_ns2__RemoteStatus);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteStatus::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteStatus);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteStatus", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteStatus::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteStatus(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteStatus * SOAP_FMAC4 soap_get_ns2__RemoteStatus(struct soap *soap, ns2__RemoteStatus *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteStatus(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteStatus * SOAP_FMAC2 soap_instantiate_ns2__RemoteStatus(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteStatus(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteStatus, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteStatus);
		if (size)
			*size = sizeof(ns2__RemoteStatus);
		((ns2__RemoteStatus*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteStatus[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteStatus);
		for (int i = 0; i < n; i++)
			((ns2__RemoteStatus*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteStatus*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteStatus(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteStatus %p -> %p\n", q, p));
	*(ns2__RemoteStatus*)p = *(ns2__RemoteStatus*)q;
}

void ns2__RemoteResolution::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteResolution::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteResolution::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteResolution(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteResolution(struct soap *soap, const char *tag, int id, const ns2__RemoteResolution *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteResolution), "ns2:RemoteResolution"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__AbstractRemoteConstant::description), ""))
		return soap->error;
	if (soap_out_string(soap, "icon", -1, &(a->ns2__AbstractRemoteConstant::icon), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteResolution::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteResolution(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteResolution * SOAP_FMAC4 soap_in_ns2__RemoteResolution(struct soap *soap, const char *tag, ns2__RemoteResolution *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteResolution *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteResolution, sizeof(ns2__RemoteResolution), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteResolution)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteResolution *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id4 = 1;
	size_t soap_flag_name3 = 1;
	size_t soap_flag_description2 = 1;
	size_t soap_flag_icon2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id4 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id4--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name3--;
					continue;
				}
			if (soap_flag_description2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__AbstractRemoteConstant::description), "xsd:string"))
				{	soap_flag_description2--;
					continue;
				}
			if (soap_flag_icon2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "icon", &(a->ns2__AbstractRemoteConstant::icon), "xsd:string"))
				{	soap_flag_icon2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteResolution *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteResolution, 0, sizeof(ns2__RemoteResolution), 0, soap_copy_ns2__RemoteResolution);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteResolution::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteResolution);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteResolution", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteResolution::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteResolution(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteResolution * SOAP_FMAC4 soap_get_ns2__RemoteResolution(struct soap *soap, ns2__RemoteResolution *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteResolution(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteResolution * SOAP_FMAC2 soap_instantiate_ns2__RemoteResolution(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteResolution(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteResolution, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteResolution);
		if (size)
			*size = sizeof(ns2__RemoteResolution);
		((ns2__RemoteResolution*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteResolution[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteResolution);
		for (int i = 0; i < n; i++)
			((ns2__RemoteResolution*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteResolution*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteResolution(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteResolution %p -> %p\n", q, p));
	*(ns2__RemoteResolution*)p = *(ns2__RemoteResolution*)q;
}

void ns2__RemotePriority::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemotePriority::color);
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemotePriority::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemotePriority::color);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemotePriority::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemotePriority(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemotePriority(struct soap *soap, const char *tag, int id, const ns2__RemotePriority *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemotePriority), "ns2:RemotePriority"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__AbstractRemoteConstant::description), ""))
		return soap->error;
	if (soap_out_string(soap, "icon", -1, &(a->ns2__AbstractRemoteConstant::icon), ""))
		return soap->error;
	if (soap_out_string(soap, "color", -1, &(a->ns2__RemotePriority::color), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemotePriority::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemotePriority(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemotePriority * SOAP_FMAC4 soap_in_ns2__RemotePriority(struct soap *soap, const char *tag, ns2__RemotePriority *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemotePriority *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemotePriority, sizeof(ns2__RemotePriority), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemotePriority)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemotePriority *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id4 = 1;
	size_t soap_flag_name3 = 1;
	size_t soap_flag_description2 = 1;
	size_t soap_flag_icon2 = 1;
	size_t soap_flag_color1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id4 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id4--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name3--;
					continue;
				}
			if (soap_flag_description2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__AbstractRemoteConstant::description), "xsd:string"))
				{	soap_flag_description2--;
					continue;
				}
			if (soap_flag_icon2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "icon", &(a->ns2__AbstractRemoteConstant::icon), "xsd:string"))
				{	soap_flag_icon2--;
					continue;
				}
			if (soap_flag_color1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "color", &(a->ns2__RemotePriority::color), "xsd:string"))
				{	soap_flag_color1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemotePriority *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemotePriority, 0, sizeof(ns2__RemotePriority), 0, soap_copy_ns2__RemotePriority);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemotePriority::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemotePriority);
	if (this->soap_out(soap, tag?tag:"ns2:RemotePriority", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemotePriority::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemotePriority(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemotePriority * SOAP_FMAC4 soap_get_ns2__RemotePriority(struct soap *soap, ns2__RemotePriority *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemotePriority(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemotePriority * SOAP_FMAC2 soap_instantiate_ns2__RemotePriority(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemotePriority(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemotePriority, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemotePriority);
		if (size)
			*size = sizeof(ns2__RemotePriority);
		((ns2__RemotePriority*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemotePriority[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemotePriority);
		for (int i = 0; i < n; i++)
			((ns2__RemotePriority*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemotePriority*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemotePriority(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemotePriority %p -> %p\n", q, p));
	*(ns2__RemotePriority*)p = *(ns2__RemotePriority*)q;
}

void ns2__RemoteProject::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteProject::description);
	this->ns2__RemoteProject::issueSecurityScheme = NULL;
	soap_default_string(soap, &this->ns2__RemoteProject::key);
	soap_default_string(soap, &this->ns2__RemoteProject::lead);
	this->ns2__RemoteProject::notificationScheme = NULL;
	this->ns2__RemoteProject::permissionScheme = NULL;
	soap_default_string(soap, &this->ns2__RemoteProject::projectUrl);
	soap_default_string(soap, &this->ns2__RemoteProject::url);
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteProject::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteProject::description);
	soap_serialize_PointerTons2__RemoteScheme(soap, &this->ns2__RemoteProject::issueSecurityScheme);
	soap_serialize_string(soap, &this->ns2__RemoteProject::key);
	soap_serialize_string(soap, &this->ns2__RemoteProject::lead);
	soap_serialize_PointerTons2__RemoteScheme(soap, &this->ns2__RemoteProject::notificationScheme);
	soap_serialize_PointerTons2__RemotePermissionScheme(soap, &this->ns2__RemoteProject::permissionScheme);
	soap_serialize_string(soap, &this->ns2__RemoteProject::projectUrl);
	soap_serialize_string(soap, &this->ns2__RemoteProject::url);
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteProject::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteProject(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteProject(struct soap *soap, const char *tag, int id, const ns2__RemoteProject *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteProject), "ns2:RemoteProject"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__RemoteProject::description), ""))
		return soap->error;
	if (soap_out_PointerTons2__RemoteScheme(soap, "issueSecurityScheme", -1, &(a->ns2__RemoteProject::issueSecurityScheme), ""))
		return soap->error;
	if (soap_out_string(soap, "key", -1, &(a->ns2__RemoteProject::key), ""))
		return soap->error;
	if (soap_out_string(soap, "lead", -1, &(a->ns2__RemoteProject::lead), ""))
		return soap->error;
	if (soap_out_PointerTons2__RemoteScheme(soap, "notificationScheme", -1, &(a->ns2__RemoteProject::notificationScheme), ""))
		return soap->error;
	if (soap_out_PointerTons2__RemotePermissionScheme(soap, "permissionScheme", -1, &(a->ns2__RemoteProject::permissionScheme), ""))
		return soap->error;
	if (soap_out_string(soap, "projectUrl", -1, &(a->ns2__RemoteProject::projectUrl), ""))
		return soap->error;
	if (soap_out_string(soap, "url", -1, &(a->ns2__RemoteProject::url), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteProject::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteProject(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteProject * SOAP_FMAC4 soap_in_ns2__RemoteProject(struct soap *soap, const char *tag, ns2__RemoteProject *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteProject *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteProject, sizeof(ns2__RemoteProject), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteProject)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteProject *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id3 = 1;
	size_t soap_flag_name2 = 1;
	size_t soap_flag_description1 = 1;
	size_t soap_flag_issueSecurityScheme1 = 1;
	size_t soap_flag_key1 = 1;
	size_t soap_flag_lead1 = 1;
	size_t soap_flag_notificationScheme1 = 1;
	size_t soap_flag_permissionScheme1 = 1;
	size_t soap_flag_projectUrl1 = 1;
	size_t soap_flag_url1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id3--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name2--;
					continue;
				}
			if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__RemoteProject::description), "xsd:string"))
				{	soap_flag_description1--;
					continue;
				}
			if (soap_flag_issueSecurityScheme1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteScheme(soap, "issueSecurityScheme", &(a->ns2__RemoteProject::issueSecurityScheme), "ns2:RemoteScheme"))
				{	soap_flag_issueSecurityScheme1--;
					continue;
				}
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "key", &(a->ns2__RemoteProject::key), "xsd:string"))
				{	soap_flag_key1--;
					continue;
				}
			if (soap_flag_lead1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "lead", &(a->ns2__RemoteProject::lead), "xsd:string"))
				{	soap_flag_lead1--;
					continue;
				}
			if (soap_flag_notificationScheme1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteScheme(soap, "notificationScheme", &(a->ns2__RemoteProject::notificationScheme), "ns2:RemoteScheme"))
				{	soap_flag_notificationScheme1--;
					continue;
				}
			if (soap_flag_permissionScheme1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemotePermissionScheme(soap, "permissionScheme", &(a->ns2__RemoteProject::permissionScheme), "ns2:RemotePermissionScheme"))
				{	soap_flag_permissionScheme1--;
					continue;
				}
			if (soap_flag_projectUrl1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "projectUrl", &(a->ns2__RemoteProject::projectUrl), "xsd:string"))
				{	soap_flag_projectUrl1--;
					continue;
				}
			if (soap_flag_url1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "url", &(a->ns2__RemoteProject::url), "xsd:string"))
				{	soap_flag_url1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteProject *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteProject, 0, sizeof(ns2__RemoteProject), 0, soap_copy_ns2__RemoteProject);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteProject::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteProject);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteProject", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteProject::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteProject(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteProject * SOAP_FMAC4 soap_get_ns2__RemoteProject(struct soap *soap, ns2__RemoteProject *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteProject(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteProject * SOAP_FMAC2 soap_instantiate_ns2__RemoteProject(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteProject(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteProject, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteProject);
		if (size)
			*size = sizeof(ns2__RemoteProject);
		((ns2__RemoteProject*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteProject[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteProject);
		for (int i = 0; i < n; i++)
			((ns2__RemoteProject*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteProject*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteProject(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteProject %p -> %p\n", q, p));
	*(ns2__RemoteProject*)p = *(ns2__RemoteProject*)q;
}

void ns2__RemotePermissionScheme::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->ns2__RemotePermissionScheme::permissionMappings = NULL;
	soap_default_string(soap, &this->ns2__RemoteScheme::description);
	this->ns2__RemoteScheme::id = NULL;
	soap_default_string(soap, &this->ns2__RemoteScheme::name);
	soap_default_string(soap, &this->ns2__RemoteScheme::type);
	/* transient soap skipped */
}

void ns2__RemotePermissionScheme::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, &this->ns2__RemotePermissionScheme::permissionMappings);
	soap_serialize_string(soap, &this->ns2__RemoteScheme::description);
	soap_serialize_PointerToLONG64(soap, &this->ns2__RemoteScheme::id);
	soap_serialize_string(soap, &this->ns2__RemoteScheme::name);
	soap_serialize_string(soap, &this->ns2__RemoteScheme::type);
	/* transient soap skipped */
}

int ns2__RemotePermissionScheme::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemotePermissionScheme(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemotePermissionScheme(struct soap *soap, const char *tag, int id, const ns2__RemotePermissionScheme *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemotePermissionScheme), "ns2:RemotePermissionScheme"))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__RemoteScheme::description), ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &(a->ns2__RemoteScheme::id), ""))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &(a->ns2__RemoteScheme::name), ""))
		return soap->error;
	if (soap_out_string(soap, "type", -1, &(a->ns2__RemoteScheme::type), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, "permissionMappings", -1, &(a->ns2__RemotePermissionScheme::permissionMappings), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemotePermissionScheme::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemotePermissionScheme(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemotePermissionScheme * SOAP_FMAC4 soap_in_ns2__RemotePermissionScheme(struct soap *soap, const char *tag, ns2__RemotePermissionScheme *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemotePermissionScheme *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemotePermissionScheme, sizeof(ns2__RemotePermissionScheme), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemotePermissionScheme)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemotePermissionScheme *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_description2 = 1;
	size_t soap_flag_id2 = 1;
	size_t soap_flag_name2 = 1;
	size_t soap_flag_type2 = 1;
	size_t soap_flag_permissionMappings1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_description2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__RemoteScheme::description), "xsd:string"))
				{	soap_flag_description2--;
					continue;
				}
			if (soap_flag_id2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &(a->ns2__RemoteScheme::id), "xsd:long"))
				{	soap_flag_id2--;
					continue;
				}
			if (soap_flag_name2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__RemoteScheme::name), "xsd:string"))
				{	soap_flag_name2--;
					continue;
				}
			if (soap_flag_type2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "type", &(a->ns2__RemoteScheme::type), "xsd:string"))
				{	soap_flag_type2--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_permissionMappings1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemotePermissionMapping(soap, "permissionMappings", &(a->ns2__RemotePermissionScheme::permissionMappings), "ns2:RemotePermissionMapping"))
				{	soap_flag_permissionMappings1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemotePermissionScheme *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemotePermissionScheme, 0, sizeof(ns2__RemotePermissionScheme), 0, soap_copy_ns2__RemotePermissionScheme);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemotePermissionScheme::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemotePermissionScheme);
	if (this->soap_out(soap, tag?tag:"ns2:RemotePermissionScheme", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemotePermissionScheme::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemotePermissionScheme(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemotePermissionScheme * SOAP_FMAC4 soap_get_ns2__RemotePermissionScheme(struct soap *soap, ns2__RemotePermissionScheme *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemotePermissionScheme(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemotePermissionScheme * SOAP_FMAC2 soap_instantiate_ns2__RemotePermissionScheme(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemotePermissionScheme(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemotePermissionScheme, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemotePermissionScheme);
		if (size)
			*size = sizeof(ns2__RemotePermissionScheme);
		((ns2__RemotePermissionScheme*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemotePermissionScheme[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemotePermissionScheme);
		for (int i = 0; i < n; i++)
			((ns2__RemotePermissionScheme*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemotePermissionScheme*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemotePermissionScheme(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemotePermissionScheme %p -> %p\n", q, p));
	*(ns2__RemotePermissionScheme*)p = *(ns2__RemotePermissionScheme*)q;
}

void ns2__RemotePermissionMapping::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->ns2__RemotePermissionMapping::permission = NULL;
	this->ns2__RemotePermissionMapping::remoteEntities = NULL;
	/* transient soap skipped */
}

void ns2__RemotePermissionMapping::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__RemotePermission(soap, &this->ns2__RemotePermissionMapping::permission);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteEntity(soap, &this->ns2__RemotePermissionMapping::remoteEntities);
	/* transient soap skipped */
}

int ns2__RemotePermissionMapping::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemotePermissionMapping(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemotePermissionMapping(struct soap *soap, const char *tag, int id, const ns2__RemotePermissionMapping *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemotePermissionMapping), type))
		return soap->error;
	if (soap_out_PointerTons2__RemotePermission(soap, "permission", -1, &(a->ns2__RemotePermissionMapping::permission), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteEntity(soap, "remoteEntities", -1, &(a->ns2__RemotePermissionMapping::remoteEntities), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemotePermissionMapping::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemotePermissionMapping(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemotePermissionMapping * SOAP_FMAC4 soap_in_ns2__RemotePermissionMapping(struct soap *soap, const char *tag, ns2__RemotePermissionMapping *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemotePermissionMapping *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemotePermissionMapping, sizeof(ns2__RemotePermissionMapping), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemotePermissionMapping)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemotePermissionMapping *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_permission1 = 1;
	size_t soap_flag_remoteEntities1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_permission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemotePermission(soap, "permission", &(a->ns2__RemotePermissionMapping::permission), "ns2:RemotePermission"))
				{	soap_flag_permission1--;
					continue;
				}
			if (soap_flag_remoteEntities1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteEntity(soap, "remoteEntities", &(a->ns2__RemotePermissionMapping::remoteEntities), "ns2:RemoteEntity"))
				{	soap_flag_remoteEntities1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemotePermissionMapping *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemotePermissionMapping, 0, sizeof(ns2__RemotePermissionMapping), 0, soap_copy_ns2__RemotePermissionMapping);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemotePermissionMapping::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemotePermissionMapping);
	if (this->soap_out(soap, tag?tag:"ns2:RemotePermissionMapping", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemotePermissionMapping::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemotePermissionMapping(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemotePermissionMapping * SOAP_FMAC4 soap_get_ns2__RemotePermissionMapping(struct soap *soap, ns2__RemotePermissionMapping *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemotePermissionMapping(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemotePermissionMapping * SOAP_FMAC2 soap_instantiate_ns2__RemotePermissionMapping(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemotePermissionMapping(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemotePermissionMapping, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemotePermissionMapping);
		if (size)
			*size = sizeof(ns2__RemotePermissionMapping);
		((ns2__RemotePermissionMapping*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemotePermissionMapping[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemotePermissionMapping);
		for (int i = 0; i < n; i++)
			((ns2__RemotePermissionMapping*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemotePermissionMapping*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemotePermissionMapping(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemotePermissionMapping %p -> %p\n", q, p));
	*(ns2__RemotePermissionMapping*)p = *(ns2__RemotePermissionMapping*)q;
}

void ns2__RemotePermission::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemotePermission::name);
	this->ns2__RemotePermission::permission = NULL;
	/* transient soap skipped */
}

void ns2__RemotePermission::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemotePermission::name);
	soap_serialize_PointerToLONG64(soap, &this->ns2__RemotePermission::permission);
	/* transient soap skipped */
}

int ns2__RemotePermission::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemotePermission(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemotePermission(struct soap *soap, const char *tag, int id, const ns2__RemotePermission *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemotePermission), type))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &(a->ns2__RemotePermission::name), ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "permission", -1, &(a->ns2__RemotePermission::permission), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemotePermission::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemotePermission(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemotePermission * SOAP_FMAC4 soap_in_ns2__RemotePermission(struct soap *soap, const char *tag, ns2__RemotePermission *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemotePermission *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemotePermission, sizeof(ns2__RemotePermission), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemotePermission)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemotePermission *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_name1 = 1;
	size_t soap_flag_permission1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__RemotePermission::name), "xsd:string"))
				{	soap_flag_name1--;
					continue;
				}
			if (soap_flag_permission1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "permission", &(a->ns2__RemotePermission::permission), "xsd:long"))
				{	soap_flag_permission1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemotePermission *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemotePermission, 0, sizeof(ns2__RemotePermission), 0, soap_copy_ns2__RemotePermission);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemotePermission::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemotePermission);
	if (this->soap_out(soap, tag?tag:"ns2:RemotePermission", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemotePermission::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemotePermission(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemotePermission * SOAP_FMAC4 soap_get_ns2__RemotePermission(struct soap *soap, ns2__RemotePermission *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemotePermission(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemotePermission * SOAP_FMAC2 soap_instantiate_ns2__RemotePermission(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemotePermission(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemotePermission, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemotePermission);
		if (size)
			*size = sizeof(ns2__RemotePermission);
		((ns2__RemotePermission*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemotePermission[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemotePermission);
		for (int i = 0; i < n; i++)
			((ns2__RemotePermission*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemotePermission*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemotePermission(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemotePermission %p -> %p\n", q, p));
	*(ns2__RemotePermission*)p = *(ns2__RemotePermission*)q;
}

void ns2__RemoteScheme::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteScheme::description);
	this->ns2__RemoteScheme::id = NULL;
	soap_default_string(soap, &this->ns2__RemoteScheme::name);
	soap_default_string(soap, &this->ns2__RemoteScheme::type);
	/* transient soap skipped */
}

void ns2__RemoteScheme::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteScheme::description);
	soap_serialize_PointerToLONG64(soap, &this->ns2__RemoteScheme::id);
	soap_serialize_string(soap, &this->ns2__RemoteScheme::name);
	soap_serialize_string(soap, &this->ns2__RemoteScheme::type);
	/* transient soap skipped */
}

int ns2__RemoteScheme::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteScheme(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteScheme(struct soap *soap, const char *tag, int id, const ns2__RemoteScheme *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteScheme), type))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__RemoteScheme::description), ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "id", -1, &(a->ns2__RemoteScheme::id), ""))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &(a->ns2__RemoteScheme::name), ""))
		return soap->error;
	if (soap_out_string(soap, "type", -1, &(a->ns2__RemoteScheme::type), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteScheme::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteScheme(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteScheme * SOAP_FMAC4 soap_in_ns2__RemoteScheme(struct soap *soap, const char *tag, ns2__RemoteScheme *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteScheme *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteScheme, sizeof(ns2__RemoteScheme), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteScheme)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteScheme *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_description1 = 1;
	size_t soap_flag_id1 = 1;
	size_t soap_flag_name1 = 1;
	size_t soap_flag_type1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__RemoteScheme::description), "xsd:string"))
				{	soap_flag_description1--;
					continue;
				}
			if (soap_flag_id1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "id", &(a->ns2__RemoteScheme::id), "xsd:long"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__RemoteScheme::name), "xsd:string"))
				{	soap_flag_name1--;
					continue;
				}
			if (soap_flag_type1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "type", &(a->ns2__RemoteScheme::type), "xsd:string"))
				{	soap_flag_type1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteScheme *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteScheme, 0, sizeof(ns2__RemoteScheme), 0, soap_copy_ns2__RemoteScheme);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteScheme::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteScheme);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteScheme", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteScheme::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteScheme(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteScheme * SOAP_FMAC4 soap_get_ns2__RemoteScheme(struct soap *soap, ns2__RemoteScheme *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteScheme(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteScheme * SOAP_FMAC2 soap_instantiate_ns2__RemoteScheme(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteScheme(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteScheme, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "ns2:RemotePermissionScheme"))
	{	cp->type = SOAP_TYPE_ns2__RemotePermissionScheme;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemotePermissionScheme);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemotePermissionScheme);
			((ns2__RemotePermissionScheme*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemotePermissionScheme[n]);
			if (size)
				*size = n * sizeof(ns2__RemotePermissionScheme);
			for (int i = 0; i < n; i++)
				((ns2__RemotePermissionScheme*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemotePermissionScheme*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteScheme);
		if (size)
			*size = sizeof(ns2__RemoteScheme);
		((ns2__RemoteScheme*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteScheme[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteScheme);
		for (int i = 0; i < n; i++)
			((ns2__RemoteScheme*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteScheme*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteScheme(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteScheme %p -> %p\n", q, p));
	*(ns2__RemoteScheme*)p = *(ns2__RemoteScheme*)q;
}

void ns2__RemoteConfiguration::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->ns2__RemoteConfiguration::allowAttachments);
	soap_default_bool(soap, &this->ns2__RemoteConfiguration::allowExternalUserManagment);
	soap_default_bool(soap, &this->ns2__RemoteConfiguration::allowIssueLinking);
	soap_default_bool(soap, &this->ns2__RemoteConfiguration::allowSubTasks);
	soap_default_bool(soap, &this->ns2__RemoteConfiguration::allowTimeTracking);
	soap_default_bool(soap, &this->ns2__RemoteConfiguration::allowUnassignedIssues);
	soap_default_bool(soap, &this->ns2__RemoteConfiguration::allowVoting);
	soap_default_bool(soap, &this->ns2__RemoteConfiguration::allowWatching);
	soap_default_int(soap, &this->ns2__RemoteConfiguration::timeTrackingDaysPerWeek);
	soap_default_int(soap, &this->ns2__RemoteConfiguration::timeTrackingHoursPerDay);
	/* transient soap skipped */
}

void ns2__RemoteConfiguration::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns2__RemoteConfiguration::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteConfiguration(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteConfiguration(struct soap *soap, const char *tag, int id, const ns2__RemoteConfiguration *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteConfiguration), type))
		return soap->error;
	if (soap_out_bool(soap, "allowAttachments", -1, &(a->ns2__RemoteConfiguration::allowAttachments), ""))
		return soap->error;
	if (soap_out_bool(soap, "allowExternalUserManagment", -1, &(a->ns2__RemoteConfiguration::allowExternalUserManagment), ""))
		return soap->error;
	if (soap_out_bool(soap, "allowIssueLinking", -1, &(a->ns2__RemoteConfiguration::allowIssueLinking), ""))
		return soap->error;
	if (soap_out_bool(soap, "allowSubTasks", -1, &(a->ns2__RemoteConfiguration::allowSubTasks), ""))
		return soap->error;
	if (soap_out_bool(soap, "allowTimeTracking", -1, &(a->ns2__RemoteConfiguration::allowTimeTracking), ""))
		return soap->error;
	if (soap_out_bool(soap, "allowUnassignedIssues", -1, &(a->ns2__RemoteConfiguration::allowUnassignedIssues), ""))
		return soap->error;
	if (soap_out_bool(soap, "allowVoting", -1, &(a->ns2__RemoteConfiguration::allowVoting), ""))
		return soap->error;
	if (soap_out_bool(soap, "allowWatching", -1, &(a->ns2__RemoteConfiguration::allowWatching), ""))
		return soap->error;
	if (soap_out_int(soap, "timeTrackingDaysPerWeek", -1, &(a->ns2__RemoteConfiguration::timeTrackingDaysPerWeek), ""))
		return soap->error;
	if (soap_out_int(soap, "timeTrackingHoursPerDay", -1, &(a->ns2__RemoteConfiguration::timeTrackingHoursPerDay), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteConfiguration::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteConfiguration(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteConfiguration * SOAP_FMAC4 soap_in_ns2__RemoteConfiguration(struct soap *soap, const char *tag, ns2__RemoteConfiguration *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteConfiguration *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteConfiguration, sizeof(ns2__RemoteConfiguration), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteConfiguration)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteConfiguration *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_allowAttachments1 = 1;
	size_t soap_flag_allowExternalUserManagment1 = 1;
	size_t soap_flag_allowIssueLinking1 = 1;
	size_t soap_flag_allowSubTasks1 = 1;
	size_t soap_flag_allowTimeTracking1 = 1;
	size_t soap_flag_allowUnassignedIssues1 = 1;
	size_t soap_flag_allowVoting1 = 1;
	size_t soap_flag_allowWatching1 = 1;
	size_t soap_flag_timeTrackingDaysPerWeek1 = 1;
	size_t soap_flag_timeTrackingHoursPerDay1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_allowAttachments1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "allowAttachments", &(a->ns2__RemoteConfiguration::allowAttachments), "xsd:boolean"))
				{	soap_flag_allowAttachments1--;
					continue;
				}
			if (soap_flag_allowExternalUserManagment1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "allowExternalUserManagment", &(a->ns2__RemoteConfiguration::allowExternalUserManagment), "xsd:boolean"))
				{	soap_flag_allowExternalUserManagment1--;
					continue;
				}
			if (soap_flag_allowIssueLinking1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "allowIssueLinking", &(a->ns2__RemoteConfiguration::allowIssueLinking), "xsd:boolean"))
				{	soap_flag_allowIssueLinking1--;
					continue;
				}
			if (soap_flag_allowSubTasks1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "allowSubTasks", &(a->ns2__RemoteConfiguration::allowSubTasks), "xsd:boolean"))
				{	soap_flag_allowSubTasks1--;
					continue;
				}
			if (soap_flag_allowTimeTracking1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "allowTimeTracking", &(a->ns2__RemoteConfiguration::allowTimeTracking), "xsd:boolean"))
				{	soap_flag_allowTimeTracking1--;
					continue;
				}
			if (soap_flag_allowUnassignedIssues1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "allowUnassignedIssues", &(a->ns2__RemoteConfiguration::allowUnassignedIssues), "xsd:boolean"))
				{	soap_flag_allowUnassignedIssues1--;
					continue;
				}
			if (soap_flag_allowVoting1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "allowVoting", &(a->ns2__RemoteConfiguration::allowVoting), "xsd:boolean"))
				{	soap_flag_allowVoting1--;
					continue;
				}
			if (soap_flag_allowWatching1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "allowWatching", &(a->ns2__RemoteConfiguration::allowWatching), "xsd:boolean"))
				{	soap_flag_allowWatching1--;
					continue;
				}
			if (soap_flag_timeTrackingDaysPerWeek1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "timeTrackingDaysPerWeek", &(a->ns2__RemoteConfiguration::timeTrackingDaysPerWeek), "xsd:int"))
				{	soap_flag_timeTrackingDaysPerWeek1--;
					continue;
				}
			if (soap_flag_timeTrackingHoursPerDay1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, "timeTrackingHoursPerDay", &(a->ns2__RemoteConfiguration::timeTrackingHoursPerDay), "xsd:int"))
				{	soap_flag_timeTrackingHoursPerDay1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteConfiguration *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteConfiguration, 0, sizeof(ns2__RemoteConfiguration), 0, soap_copy_ns2__RemoteConfiguration);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_allowAttachments1 > 0 || soap_flag_allowExternalUserManagment1 > 0 || soap_flag_allowIssueLinking1 > 0 || soap_flag_allowSubTasks1 > 0 || soap_flag_allowTimeTracking1 > 0 || soap_flag_allowUnassignedIssues1 > 0 || soap_flag_allowVoting1 > 0 || soap_flag_allowWatching1 > 0 || soap_flag_timeTrackingDaysPerWeek1 > 0 || soap_flag_timeTrackingHoursPerDay1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int ns2__RemoteConfiguration::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteConfiguration);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteConfiguration", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteConfiguration::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteConfiguration(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteConfiguration * SOAP_FMAC4 soap_get_ns2__RemoteConfiguration(struct soap *soap, ns2__RemoteConfiguration *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteConfiguration(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteConfiguration * SOAP_FMAC2 soap_instantiate_ns2__RemoteConfiguration(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteConfiguration(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteConfiguration, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteConfiguration);
		if (size)
			*size = sizeof(ns2__RemoteConfiguration);
		((ns2__RemoteConfiguration*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteConfiguration[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteConfiguration);
		for (int i = 0; i < n; i++)
			((ns2__RemoteConfiguration*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteConfiguration*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteConfiguration(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteConfiguration %p -> %p\n", q, p));
	*(ns2__RemoteConfiguration*)p = *(ns2__RemoteConfiguration*)q;
}

void ns2__RemoteIssueType::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->ns2__RemoteIssueType::subTask);
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteIssueType::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteIssueType::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteIssueType(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteIssueType(struct soap *soap, const char *tag, int id, const ns2__RemoteIssueType *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteIssueType), "ns2:RemoteIssueType"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__AbstractRemoteConstant::description), ""))
		return soap->error;
	if (soap_out_string(soap, "icon", -1, &(a->ns2__AbstractRemoteConstant::icon), ""))
		return soap->error;
	if (soap_out_bool(soap, "subTask", -1, &(a->ns2__RemoteIssueType::subTask), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteIssueType::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteIssueType(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteIssueType * SOAP_FMAC4 soap_in_ns2__RemoteIssueType(struct soap *soap, const char *tag, ns2__RemoteIssueType *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteIssueType *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteIssueType, sizeof(ns2__RemoteIssueType), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteIssueType)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteIssueType *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id4 = 1;
	size_t soap_flag_name3 = 1;
	size_t soap_flag_description2 = 1;
	size_t soap_flag_icon2 = 1;
	size_t soap_flag_subTask1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id4 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id4--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name3--;
					continue;
				}
			if (soap_flag_description2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__AbstractRemoteConstant::description), "xsd:string"))
				{	soap_flag_description2--;
					continue;
				}
			if (soap_flag_icon2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "icon", &(a->ns2__AbstractRemoteConstant::icon), "xsd:string"))
				{	soap_flag_icon2--;
					continue;
				}
			if (soap_flag_subTask1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "subTask", &(a->ns2__RemoteIssueType::subTask), "xsd:boolean"))
				{	soap_flag_subTask1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteIssueType *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteIssueType, 0, sizeof(ns2__RemoteIssueType), 0, soap_copy_ns2__RemoteIssueType);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_subTask1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int ns2__RemoteIssueType::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteIssueType);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteIssueType", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteIssueType::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteIssueType(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteIssueType * SOAP_FMAC4 soap_get_ns2__RemoteIssueType(struct soap *soap, ns2__RemoteIssueType *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteIssueType(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteIssueType * SOAP_FMAC2 soap_instantiate_ns2__RemoteIssueType(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteIssueType(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteIssueType, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteIssueType);
		if (size)
			*size = sizeof(ns2__RemoteIssueType);
		((ns2__RemoteIssueType*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteIssueType[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteIssueType);
		for (int i = 0; i < n; i++)
			((ns2__RemoteIssueType*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteIssueType*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteIssueType(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteIssueType %p -> %p\n", q, p));
	*(ns2__RemoteIssueType*)p = *(ns2__RemoteIssueType*)q;
}

void ns2__AbstractRemoteConstant::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_default_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__AbstractRemoteConstant::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::description);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteConstant::icon);
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__AbstractRemoteConstant::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__AbstractRemoteConstant(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__AbstractRemoteConstant(struct soap *soap, const char *tag, int id, const ns2__AbstractRemoteConstant *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__AbstractRemoteConstant), "ns2:AbstractRemoteConstant"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__AbstractRemoteConstant::description), ""))
		return soap->error;
	if (soap_out_string(soap, "icon", -1, &(a->ns2__AbstractRemoteConstant::icon), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__AbstractRemoteConstant::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__AbstractRemoteConstant(soap, tag, this, type);
}

SOAP_FMAC3 ns2__AbstractRemoteConstant * SOAP_FMAC4 soap_in_ns2__AbstractRemoteConstant(struct soap *soap, const char *tag, ns2__AbstractRemoteConstant *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__AbstractRemoteConstant *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__AbstractRemoteConstant, sizeof(ns2__AbstractRemoteConstant), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__AbstractRemoteConstant)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__AbstractRemoteConstant *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id3 = 1;
	size_t soap_flag_name2 = 1;
	size_t soap_flag_description1 = 1;
	size_t soap_flag_icon1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id3--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name2--;
					continue;
				}
			if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__AbstractRemoteConstant::description), "xsd:string"))
				{	soap_flag_description1--;
					continue;
				}
			if (soap_flag_icon1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "icon", &(a->ns2__AbstractRemoteConstant::icon), "xsd:string"))
				{	soap_flag_icon1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__AbstractRemoteConstant *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__AbstractRemoteConstant, 0, sizeof(ns2__AbstractRemoteConstant), 0, soap_copy_ns2__AbstractRemoteConstant);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__AbstractRemoteConstant::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__AbstractRemoteConstant);
	if (this->soap_out(soap, tag?tag:"ns2:AbstractRemoteConstant", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__AbstractRemoteConstant::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__AbstractRemoteConstant(soap, this, tag, type);
}

SOAP_FMAC3 ns2__AbstractRemoteConstant * SOAP_FMAC4 soap_get_ns2__AbstractRemoteConstant(struct soap *soap, ns2__AbstractRemoteConstant *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__AbstractRemoteConstant(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__AbstractRemoteConstant * SOAP_FMAC2 soap_instantiate_ns2__AbstractRemoteConstant(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__AbstractRemoteConstant(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__AbstractRemoteConstant, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "ns2:RemoteIssueType"))
	{	cp->type = SOAP_TYPE_ns2__RemoteIssueType;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteIssueType);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteIssueType);
			((ns2__RemoteIssueType*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteIssueType[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteIssueType);
			for (int i = 0; i < n; i++)
				((ns2__RemoteIssueType*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteIssueType*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemotePriority"))
	{	cp->type = SOAP_TYPE_ns2__RemotePriority;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemotePriority);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemotePriority);
			((ns2__RemotePriority*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemotePriority[n]);
			if (size)
				*size = n * sizeof(ns2__RemotePriority);
			for (int i = 0; i < n; i++)
				((ns2__RemotePriority*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemotePriority*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteResolution"))
	{	cp->type = SOAP_TYPE_ns2__RemoteResolution;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteResolution);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteResolution);
			((ns2__RemoteResolution*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteResolution[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteResolution);
			for (int i = 0; i < n; i++)
				((ns2__RemoteResolution*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteResolution*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteStatus"))
	{	cp->type = SOAP_TYPE_ns2__RemoteStatus;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteStatus);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteStatus);
			((ns2__RemoteStatus*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteStatus[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteStatus);
			for (int i = 0; i < n; i++)
				((ns2__RemoteStatus*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteStatus*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__AbstractRemoteConstant);
		if (size)
			*size = sizeof(ns2__AbstractRemoteConstant);
		((ns2__AbstractRemoteConstant*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__AbstractRemoteConstant[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__AbstractRemoteConstant);
		for (int i = 0; i < n; i++)
			((ns2__AbstractRemoteConstant*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__AbstractRemoteConstant*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__AbstractRemoteConstant(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__AbstractRemoteConstant %p -> %p\n", q, p));
	*(ns2__AbstractRemoteConstant*)p = *(ns2__AbstractRemoteConstant*)q;
}

void ns2__RemoteNamedObject::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteNamedObject::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteNamedObject::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteNamedObject(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteNamedObject(struct soap *soap, const char *tag, int id, const ns2__RemoteNamedObject *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteNamedObject), "ns2:RemoteNamedObject"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteNamedObject::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteNamedObject(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteNamedObject * SOAP_FMAC4 soap_in_ns2__RemoteNamedObject(struct soap *soap, const char *tag, ns2__RemoteNamedObject *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteNamedObject *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteNamedObject, sizeof(ns2__RemoteNamedObject), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteNamedObject)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteNamedObject *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id3 = 1;
	size_t soap_flag_name2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id3--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteNamedObject *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteNamedObject, 0, sizeof(ns2__RemoteNamedObject), 0, soap_copy_ns2__RemoteNamedObject);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteNamedObject::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteNamedObject);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteNamedObject", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteNamedObject::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteNamedObject(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteNamedObject * SOAP_FMAC4 soap_get_ns2__RemoteNamedObject(struct soap *soap, ns2__RemoteNamedObject *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteNamedObject(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteNamedObject * SOAP_FMAC2 soap_instantiate_ns2__RemoteNamedObject(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteNamedObject(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteNamedObject, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteNamedObject);
		if (size)
			*size = sizeof(ns2__RemoteNamedObject);
		((ns2__RemoteNamedObject*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteNamedObject[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteNamedObject);
		for (int i = 0; i < n; i++)
			((ns2__RemoteNamedObject*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteNamedObject*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteNamedObject(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteNamedObject %p -> %p\n", q, p));
	*(ns2__RemoteNamedObject*)p = *(ns2__RemoteNamedObject*)q;
}

void ns2__RemoteIssue::soap_default(struct soap *soap)
{
	this->soap = soap;
	this->ns2__RemoteIssue::affectsVersions = NULL;
	soap_default_string(soap, &this->ns2__RemoteIssue::assignee);
	this->ns2__RemoteIssue::attachmentNames = NULL;
	this->ns2__RemoteIssue::components = NULL;
	this->ns2__RemoteIssue::created = NULL;
	this->ns2__RemoteIssue::customFieldValues = NULL;
	soap_default_string(soap, &this->ns2__RemoteIssue::description);
	this->ns2__RemoteIssue::duedate = NULL;
	soap_default_string(soap, &this->ns2__RemoteIssue::environment);
	this->ns2__RemoteIssue::fixVersions = NULL;
	soap_default_string(soap, &this->ns2__RemoteIssue::key);
	soap_default_string(soap, &this->ns2__RemoteIssue::priority);
	soap_default_string(soap, &this->ns2__RemoteIssue::project);
	soap_default_string(soap, &this->ns2__RemoteIssue::reporter);
	soap_default_string(soap, &this->ns2__RemoteIssue::resolution);
	soap_default_string(soap, &this->ns2__RemoteIssue::status);
	soap_default_string(soap, &this->ns2__RemoteIssue::summary);
	soap_default_string(soap, &this->ns2__RemoteIssue::type);
	this->ns2__RemoteIssue::updated = NULL;
	this->ns2__RemoteIssue::votes = NULL;
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteIssue::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteVersion(soap, &this->ns2__RemoteIssue::affectsVersions);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::assignee);
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREstring(soap, &this->ns2__RemoteIssue::attachmentNames);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteComponent(soap, &this->ns2__RemoteIssue::components);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteIssue::created);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, &this->ns2__RemoteIssue::customFieldValues);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::description);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteIssue::duedate);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::environment);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteVersion(soap, &this->ns2__RemoteIssue::fixVersions);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::key);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::priority);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::project);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::reporter);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::resolution);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::status);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::summary);
	soap_serialize_string(soap, &this->ns2__RemoteIssue::type);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteIssue::updated);
	soap_serialize_PointerToLONG64(soap, &this->ns2__RemoteIssue::votes);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteIssue::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteIssue(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteIssue(struct soap *soap, const char *tag, int id, const ns2__RemoteIssue *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteIssue), "ns2:RemoteIssue"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteVersion(soap, "affectsVersions", -1, &(a->ns2__RemoteIssue::affectsVersions), ""))
		return soap->error;
	if (soap_out_string(soap, "assignee", -1, &(a->ns2__RemoteIssue::assignee), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREstring(soap, "attachmentNames", -1, &(a->ns2__RemoteIssue::attachmentNames), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteComponent(soap, "components", -1, &(a->ns2__RemoteIssue::components), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "created", -1, &(a->ns2__RemoteIssue::created), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, "customFieldValues", -1, &(a->ns2__RemoteIssue::customFieldValues), ""))
		return soap->error;
	if (soap_out_string(soap, "description", -1, &(a->ns2__RemoteIssue::description), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "duedate", -1, &(a->ns2__RemoteIssue::duedate), ""))
		return soap->error;
	if (soap_out_string(soap, "environment", -1, &(a->ns2__RemoteIssue::environment), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteVersion(soap, "fixVersions", -1, &(a->ns2__RemoteIssue::fixVersions), ""))
		return soap->error;
	if (soap_out_string(soap, "key", -1, &(a->ns2__RemoteIssue::key), ""))
		return soap->error;
	if (soap_out_string(soap, "priority", -1, &(a->ns2__RemoteIssue::priority), ""))
		return soap->error;
	if (soap_out_string(soap, "project", -1, &(a->ns2__RemoteIssue::project), ""))
		return soap->error;
	if (soap_out_string(soap, "reporter", -1, &(a->ns2__RemoteIssue::reporter), ""))
		return soap->error;
	if (soap_out_string(soap, "resolution", -1, &(a->ns2__RemoteIssue::resolution), ""))
		return soap->error;
	if (soap_out_string(soap, "status", -1, &(a->ns2__RemoteIssue::status), ""))
		return soap->error;
	if (soap_out_string(soap, "summary", -1, &(a->ns2__RemoteIssue::summary), ""))
		return soap->error;
	if (soap_out_string(soap, "type", -1, &(a->ns2__RemoteIssue::type), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "updated", -1, &(a->ns2__RemoteIssue::updated), ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "votes", -1, &(a->ns2__RemoteIssue::votes), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteIssue::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteIssue(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteIssue * SOAP_FMAC4 soap_in_ns2__RemoteIssue(struct soap *soap, const char *tag, ns2__RemoteIssue *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteIssue *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteIssue, sizeof(ns2__RemoteIssue), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteIssue)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteIssue *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id2 = 1;
	size_t soap_flag_affectsVersions1 = 1;
	size_t soap_flag_assignee1 = 1;
	size_t soap_flag_attachmentNames1 = 1;
	size_t soap_flag_components1 = 1;
	size_t soap_flag_created1 = 1;
	size_t soap_flag_customFieldValues1 = 1;
	size_t soap_flag_description1 = 1;
	size_t soap_flag_duedate1 = 1;
	size_t soap_flag_environment1 = 1;
	size_t soap_flag_fixVersions1 = 1;
	size_t soap_flag_key1 = 1;
	size_t soap_flag_priority1 = 1;
	size_t soap_flag_project1 = 1;
	size_t soap_flag_reporter1 = 1;
	size_t soap_flag_resolution1 = 1;
	size_t soap_flag_status1 = 1;
	size_t soap_flag_summary1 = 1;
	size_t soap_flag_type1 = 1;
	size_t soap_flag_updated1 = 1;
	size_t soap_flag_votes1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id2--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_affectsVersions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteVersion(soap, "affectsVersions", &(a->ns2__RemoteIssue::affectsVersions), "ns2:RemoteVersion"))
				{	soap_flag_affectsVersions1--;
					continue;
				}
			if (soap_flag_assignee1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "assignee", &(a->ns2__RemoteIssue::assignee), "xsd:string"))
				{	soap_flag_assignee1--;
					continue;
				}
			if (soap_flag_attachmentNames1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREstring(soap, "attachmentNames", &(a->ns2__RemoteIssue::attachmentNames), "xsd:string"))
				{	soap_flag_attachmentNames1--;
					continue;
				}
			if (soap_flag_components1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteComponent(soap, "components", &(a->ns2__RemoteIssue::components), "ns2:RemoteComponent"))
				{	soap_flag_components1--;
					continue;
				}
			if (soap_flag_created1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "created", &(a->ns2__RemoteIssue::created), "xsd:dateTime"))
				{	soap_flag_created1--;
					continue;
				}
			if (soap_flag_customFieldValues1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteCustomFieldValue(soap, "customFieldValues", &(a->ns2__RemoteIssue::customFieldValues), "ns2:RemoteCustomFieldValue"))
				{	soap_flag_customFieldValues1--;
					continue;
				}
			if (soap_flag_description1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "description", &(a->ns2__RemoteIssue::description), "xsd:string"))
				{	soap_flag_description1--;
					continue;
				}
			if (soap_flag_duedate1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "duedate", &(a->ns2__RemoteIssue::duedate), "xsd:dateTime"))
				{	soap_flag_duedate1--;
					continue;
				}
			if (soap_flag_environment1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "environment", &(a->ns2__RemoteIssue::environment), "xsd:string"))
				{	soap_flag_environment1--;
					continue;
				}
			if (soap_flag_fixVersions1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteVersion(soap, "fixVersions", &(a->ns2__RemoteIssue::fixVersions), "ns2:RemoteVersion"))
				{	soap_flag_fixVersions1--;
					continue;
				}
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "key", &(a->ns2__RemoteIssue::key), "xsd:string"))
				{	soap_flag_key1--;
					continue;
				}
			if (soap_flag_priority1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "priority", &(a->ns2__RemoteIssue::priority), "xsd:string"))
				{	soap_flag_priority1--;
					continue;
				}
			if (soap_flag_project1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "project", &(a->ns2__RemoteIssue::project), "xsd:string"))
				{	soap_flag_project1--;
					continue;
				}
			if (soap_flag_reporter1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "reporter", &(a->ns2__RemoteIssue::reporter), "xsd:string"))
				{	soap_flag_reporter1--;
					continue;
				}
			if (soap_flag_resolution1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "resolution", &(a->ns2__RemoteIssue::resolution), "xsd:string"))
				{	soap_flag_resolution1--;
					continue;
				}
			if (soap_flag_status1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "status", &(a->ns2__RemoteIssue::status), "xsd:string"))
				{	soap_flag_status1--;
					continue;
				}
			if (soap_flag_summary1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "summary", &(a->ns2__RemoteIssue::summary), "xsd:string"))
				{	soap_flag_summary1--;
					continue;
				}
			if (soap_flag_type1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "type", &(a->ns2__RemoteIssue::type), "xsd:string"))
				{	soap_flag_type1--;
					continue;
				}
			if (soap_flag_updated1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "updated", &(a->ns2__RemoteIssue::updated), "xsd:dateTime"))
				{	soap_flag_updated1--;
					continue;
				}
			if (soap_flag_votes1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "votes", &(a->ns2__RemoteIssue::votes), "xsd:long"))
				{	soap_flag_votes1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteIssue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteIssue, 0, sizeof(ns2__RemoteIssue), 0, soap_copy_ns2__RemoteIssue);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteIssue::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteIssue);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteIssue", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteIssue::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteIssue(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteIssue * SOAP_FMAC4 soap_get_ns2__RemoteIssue(struct soap *soap, ns2__RemoteIssue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteIssue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteIssue * SOAP_FMAC2 soap_instantiate_ns2__RemoteIssue(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteIssue(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteIssue, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteIssue);
		if (size)
			*size = sizeof(ns2__RemoteIssue);
		((ns2__RemoteIssue*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteIssue[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteIssue);
		for (int i = 0; i < n; i++)
			((ns2__RemoteIssue*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteIssue*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteIssue(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteIssue %p -> %p\n", q, p));
	*(ns2__RemoteIssue*)p = *(ns2__RemoteIssue*)q;
}

void ns2__RemoteCustomFieldValue::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteCustomFieldValue::customfieldId);
	soap_default_string(soap, &this->ns2__RemoteCustomFieldValue::key);
	this->ns2__RemoteCustomFieldValue::values = NULL;
	/* transient soap skipped */
}

void ns2__RemoteCustomFieldValue::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteCustomFieldValue::customfieldId);
	soap_serialize_string(soap, &this->ns2__RemoteCustomFieldValue::key);
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREstring(soap, &this->ns2__RemoteCustomFieldValue::values);
	/* transient soap skipped */
}

int ns2__RemoteCustomFieldValue::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteCustomFieldValue(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteCustomFieldValue(struct soap *soap, const char *tag, int id, const ns2__RemoteCustomFieldValue *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteCustomFieldValue), type))
		return soap->error;
	if (soap_out_string(soap, "customfieldId", -1, &(a->ns2__RemoteCustomFieldValue::customfieldId), ""))
		return soap->error;
	if (soap_out_string(soap, "key", -1, &(a->ns2__RemoteCustomFieldValue::key), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREstring(soap, "values", -1, &(a->ns2__RemoteCustomFieldValue::values), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteCustomFieldValue::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteCustomFieldValue(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteCustomFieldValue * SOAP_FMAC4 soap_in_ns2__RemoteCustomFieldValue(struct soap *soap, const char *tag, ns2__RemoteCustomFieldValue *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteCustomFieldValue *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteCustomFieldValue, sizeof(ns2__RemoteCustomFieldValue), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteCustomFieldValue)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteCustomFieldValue *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_customfieldId1 = 1;
	size_t soap_flag_key1 = 1;
	size_t soap_flag_values1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_customfieldId1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "customfieldId", &(a->ns2__RemoteCustomFieldValue::customfieldId), "xsd:string"))
				{	soap_flag_customfieldId1--;
					continue;
				}
			if (soap_flag_key1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "key", &(a->ns2__RemoteCustomFieldValue::key), "xsd:string"))
				{	soap_flag_key1--;
					continue;
				}
			if (soap_flag_values1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREstring(soap, "values", &(a->ns2__RemoteCustomFieldValue::values), "xsd:string"))
				{	soap_flag_values1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteCustomFieldValue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteCustomFieldValue, 0, sizeof(ns2__RemoteCustomFieldValue), 0, soap_copy_ns2__RemoteCustomFieldValue);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteCustomFieldValue::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteCustomFieldValue);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteCustomFieldValue", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteCustomFieldValue::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteCustomFieldValue(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteCustomFieldValue * SOAP_FMAC4 soap_get_ns2__RemoteCustomFieldValue(struct soap *soap, ns2__RemoteCustomFieldValue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteCustomFieldValue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteCustomFieldValue * SOAP_FMAC2 soap_instantiate_ns2__RemoteCustomFieldValue(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteCustomFieldValue(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteCustomFieldValue, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteCustomFieldValue);
		if (size)
			*size = sizeof(ns2__RemoteCustomFieldValue);
		((ns2__RemoteCustomFieldValue*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteCustomFieldValue[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteCustomFieldValue);
		for (int i = 0; i < n; i++)
			((ns2__RemoteCustomFieldValue*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteCustomFieldValue*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteCustomFieldValue(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteCustomFieldValue %p -> %p\n", q, p));
	*(ns2__RemoteCustomFieldValue*)p = *(ns2__RemoteCustomFieldValue*)q;
}

void ns2__RemoteVersion::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_bool(soap, &this->ns2__RemoteVersion::archived);
	this->ns2__RemoteVersion::releaseDate = NULL;
	soap_default_bool(soap, &this->ns2__RemoteVersion::released);
	this->ns2__RemoteVersion::sequence = NULL;
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteVersion::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteVersion::releaseDate);
	soap_serialize_PointerToLONG64(soap, &this->ns2__RemoteVersion::sequence);
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteVersion::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteVersion(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteVersion(struct soap *soap, const char *tag, int id, const ns2__RemoteVersion *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteVersion), "ns2:RemoteVersion"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	if (soap_out_bool(soap, "archived", -1, &(a->ns2__RemoteVersion::archived), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "releaseDate", -1, &(a->ns2__RemoteVersion::releaseDate), ""))
		return soap->error;
	if (soap_out_bool(soap, "released", -1, &(a->ns2__RemoteVersion::released), ""))
		return soap->error;
	if (soap_out_PointerToLONG64(soap, "sequence", -1, &(a->ns2__RemoteVersion::sequence), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteVersion::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteVersion(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteVersion * SOAP_FMAC4 soap_in_ns2__RemoteVersion(struct soap *soap, const char *tag, ns2__RemoteVersion *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteVersion *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteVersion, sizeof(ns2__RemoteVersion), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteVersion)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteVersion *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id3 = 1;
	size_t soap_flag_name2 = 1;
	size_t soap_flag_archived1 = 1;
	size_t soap_flag_releaseDate1 = 1;
	size_t soap_flag_released1 = 1;
	size_t soap_flag_sequence1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id3--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name2--;
					continue;
				}
			if (soap_flag_archived1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "archived", &(a->ns2__RemoteVersion::archived), "xsd:boolean"))
				{	soap_flag_archived1--;
					continue;
				}
			if (soap_flag_releaseDate1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "releaseDate", &(a->ns2__RemoteVersion::releaseDate), "xsd:dateTime"))
				{	soap_flag_releaseDate1--;
					continue;
				}
			if (soap_flag_released1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, "released", &(a->ns2__RemoteVersion::released), "xsd:boolean"))
				{	soap_flag_released1--;
					continue;
				}
			if (soap_flag_sequence1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToLONG64(soap, "sequence", &(a->ns2__RemoteVersion::sequence), "xsd:long"))
				{	soap_flag_sequence1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteVersion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteVersion, 0, sizeof(ns2__RemoteVersion), 0, soap_copy_ns2__RemoteVersion);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag_archived1 > 0 || soap_flag_released1 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

int ns2__RemoteVersion::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteVersion);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteVersion", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteVersion::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteVersion(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteVersion * SOAP_FMAC4 soap_get_ns2__RemoteVersion(struct soap *soap, ns2__RemoteVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteVersion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteVersion * SOAP_FMAC2 soap_instantiate_ns2__RemoteVersion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteVersion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteVersion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteVersion);
		if (size)
			*size = sizeof(ns2__RemoteVersion);
		((ns2__RemoteVersion*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteVersion[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteVersion);
		for (int i = 0; i < n; i++)
			((ns2__RemoteVersion*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteVersion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteVersion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteVersion %p -> %p\n", q, p));
	*(ns2__RemoteVersion*)p = *(ns2__RemoteVersion*)q;
}

void ns2__RemoteComponent::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__RemoteComponent::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__RemoteComponent::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteComponent(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteComponent(struct soap *soap, const char *tag, int id, const ns2__RemoteComponent *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteComponent), "ns2:RemoteComponent"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteComponent::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteComponent(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteComponent * SOAP_FMAC4 soap_in_ns2__RemoteComponent(struct soap *soap, const char *tag, ns2__RemoteComponent *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteComponent *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteComponent, sizeof(ns2__RemoteComponent), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteComponent)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteComponent *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id3 = 1;
	size_t soap_flag_name2 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id3--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteComponent *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteComponent, 0, sizeof(ns2__RemoteComponent), 0, soap_copy_ns2__RemoteComponent);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteComponent::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteComponent);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteComponent", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteComponent::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteComponent(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteComponent * SOAP_FMAC4 soap_get_ns2__RemoteComponent(struct soap *soap, ns2__RemoteComponent *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteComponent(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteComponent * SOAP_FMAC2 soap_instantiate_ns2__RemoteComponent(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteComponent(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteComponent, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteComponent);
		if (size)
			*size = sizeof(ns2__RemoteComponent);
		((ns2__RemoteComponent*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteComponent[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteComponent);
		for (int i = 0; i < n; i++)
			((ns2__RemoteComponent*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteComponent*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteComponent(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteComponent %p -> %p\n", q, p));
	*(ns2__RemoteComponent*)p = *(ns2__RemoteComponent*)q;
}

void ns2__AbstractNamedRemoteEntity::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__AbstractNamedRemoteEntity::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__AbstractNamedRemoteEntity::name);
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__AbstractNamedRemoteEntity::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__AbstractNamedRemoteEntity(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__AbstractNamedRemoteEntity(struct soap *soap, const char *tag, int id, const ns2__AbstractNamedRemoteEntity *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__AbstractNamedRemoteEntity), "ns2:AbstractNamedRemoteEntity"))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__AbstractNamedRemoteEntity::name), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__AbstractNamedRemoteEntity::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__AbstractNamedRemoteEntity(soap, tag, this, type);
}

SOAP_FMAC3 ns2__AbstractNamedRemoteEntity * SOAP_FMAC4 soap_in_ns2__AbstractNamedRemoteEntity(struct soap *soap, const char *tag, ns2__AbstractNamedRemoteEntity *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__AbstractNamedRemoteEntity *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__AbstractNamedRemoteEntity, sizeof(ns2__AbstractNamedRemoteEntity), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__AbstractNamedRemoteEntity)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__AbstractNamedRemoteEntity *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id2 = 1;
	size_t soap_flag_name1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id2--;
					continue;
				}
			/* transient soap skipped */
			if (soap_flag_name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__AbstractNamedRemoteEntity::name), "xsd:string"))
				{	soap_flag_name1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__AbstractNamedRemoteEntity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__AbstractNamedRemoteEntity, 0, sizeof(ns2__AbstractNamedRemoteEntity), 0, soap_copy_ns2__AbstractNamedRemoteEntity);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__AbstractNamedRemoteEntity::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__AbstractNamedRemoteEntity);
	if (this->soap_out(soap, tag?tag:"ns2:AbstractNamedRemoteEntity", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__AbstractNamedRemoteEntity::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__AbstractNamedRemoteEntity(soap, this, tag, type);
}

SOAP_FMAC3 ns2__AbstractNamedRemoteEntity * SOAP_FMAC4 soap_get_ns2__AbstractNamedRemoteEntity(struct soap *soap, ns2__AbstractNamedRemoteEntity *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__AbstractNamedRemoteEntity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__AbstractNamedRemoteEntity * SOAP_FMAC2 soap_instantiate_ns2__AbstractNamedRemoteEntity(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__AbstractNamedRemoteEntity(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__AbstractNamedRemoteEntity, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "ns2:RemoteComponent"))
	{	cp->type = SOAP_TYPE_ns2__RemoteComponent;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteComponent);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteComponent);
			((ns2__RemoteComponent*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteComponent[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteComponent);
			for (int i = 0; i < n; i++)
				((ns2__RemoteComponent*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteComponent*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteVersion"))
	{	cp->type = SOAP_TYPE_ns2__RemoteVersion;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteVersion);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteVersion);
			((ns2__RemoteVersion*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteVersion[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteVersion);
			for (int i = 0; i < n; i++)
				((ns2__RemoteVersion*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteVersion*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteNamedObject"))
	{	cp->type = SOAP_TYPE_ns2__RemoteNamedObject;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteNamedObject);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteNamedObject);
			((ns2__RemoteNamedObject*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteNamedObject[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteNamedObject);
			for (int i = 0; i < n; i++)
				((ns2__RemoteNamedObject*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteNamedObject*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:AbstractRemoteConstant"))
	{	cp->type = SOAP_TYPE_ns2__AbstractRemoteConstant;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__AbstractRemoteConstant);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__AbstractRemoteConstant);
			((ns2__AbstractRemoteConstant*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__AbstractRemoteConstant[n]);
			if (size)
				*size = n * sizeof(ns2__AbstractRemoteConstant);
			for (int i = 0; i < n; i++)
				((ns2__AbstractRemoteConstant*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__AbstractRemoteConstant*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteProject"))
	{	cp->type = SOAP_TYPE_ns2__RemoteProject;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteProject);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteProject);
			((ns2__RemoteProject*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteProject[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteProject);
			for (int i = 0; i < n; i++)
				((ns2__RemoteProject*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteProject*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteField"))
	{	cp->type = SOAP_TYPE_ns2__RemoteField;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteField);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteField);
			((ns2__RemoteField*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteField[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteField);
			for (int i = 0; i < n; i++)
				((ns2__RemoteField*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteField*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteFilter"))
	{	cp->type = SOAP_TYPE_ns2__RemoteFilter;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteFilter);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteFilter);
			((ns2__RemoteFilter*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteFilter[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteFilter);
			for (int i = 0; i < n; i++)
				((ns2__RemoteFilter*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteFilter*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteSecurityLevel"))
	{	cp->type = SOAP_TYPE_ns2__RemoteSecurityLevel;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteSecurityLevel);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteSecurityLevel);
			((ns2__RemoteSecurityLevel*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteSecurityLevel[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteSecurityLevel);
			for (int i = 0; i < n; i++)
				((ns2__RemoteSecurityLevel*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteSecurityLevel*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteIssueType"))
	{	cp->type = SOAP_TYPE_ns2__RemoteIssueType;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteIssueType);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteIssueType);
			((ns2__RemoteIssueType*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteIssueType[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteIssueType);
			for (int i = 0; i < n; i++)
				((ns2__RemoteIssueType*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteIssueType*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemotePriority"))
	{	cp->type = SOAP_TYPE_ns2__RemotePriority;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemotePriority);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemotePriority);
			((ns2__RemotePriority*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemotePriority[n]);
			if (size)
				*size = n * sizeof(ns2__RemotePriority);
			for (int i = 0; i < n; i++)
				((ns2__RemotePriority*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemotePriority*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteResolution"))
	{	cp->type = SOAP_TYPE_ns2__RemoteResolution;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteResolution);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteResolution);
			((ns2__RemoteResolution*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteResolution[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteResolution);
			for (int i = 0; i < n; i++)
				((ns2__RemoteResolution*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteResolution*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteStatus"))
	{	cp->type = SOAP_TYPE_ns2__RemoteStatus;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteStatus);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteStatus);
			((ns2__RemoteStatus*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteStatus[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteStatus);
			for (int i = 0; i < n; i++)
				((ns2__RemoteStatus*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteStatus*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__AbstractNamedRemoteEntity);
		if (size)
			*size = sizeof(ns2__AbstractNamedRemoteEntity);
		((ns2__AbstractNamedRemoteEntity*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__AbstractNamedRemoteEntity[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__AbstractNamedRemoteEntity);
		for (int i = 0; i < n; i++)
			((ns2__AbstractNamedRemoteEntity*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__AbstractNamedRemoteEntity*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__AbstractNamedRemoteEntity(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__AbstractNamedRemoteEntity %p -> %p\n", q, p));
	*(ns2__AbstractNamedRemoteEntity*)p = *(ns2__AbstractNamedRemoteEntity*)q;
}

void ns2__AbstractRemoteEntity::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

void ns2__AbstractRemoteEntity::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__AbstractRemoteEntity::id);
	/* transient soap skipped */
}

int ns2__AbstractRemoteEntity::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__AbstractRemoteEntity(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__AbstractRemoteEntity(struct soap *soap, const char *tag, int id, const ns2__AbstractRemoteEntity *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__AbstractRemoteEntity), type))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__AbstractRemoteEntity::id), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__AbstractRemoteEntity::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__AbstractRemoteEntity(soap, tag, this, type);
}

SOAP_FMAC3 ns2__AbstractRemoteEntity * SOAP_FMAC4 soap_in_ns2__AbstractRemoteEntity(struct soap *soap, const char *tag, ns2__AbstractRemoteEntity *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__AbstractRemoteEntity *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__AbstractRemoteEntity, sizeof(ns2__AbstractRemoteEntity), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__AbstractRemoteEntity)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__AbstractRemoteEntity *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_id1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__AbstractRemoteEntity::id), "xsd:string"))
				{	soap_flag_id1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__AbstractRemoteEntity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__AbstractRemoteEntity, 0, sizeof(ns2__AbstractRemoteEntity), 0, soap_copy_ns2__AbstractRemoteEntity);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__AbstractRemoteEntity::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__AbstractRemoteEntity);
	if (this->soap_out(soap, tag?tag:"ns2:AbstractRemoteEntity", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__AbstractRemoteEntity::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__AbstractRemoteEntity(soap, this, tag, type);
}

SOAP_FMAC3 ns2__AbstractRemoteEntity * SOAP_FMAC4 soap_get_ns2__AbstractRemoteEntity(struct soap *soap, ns2__AbstractRemoteEntity *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__AbstractRemoteEntity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__AbstractRemoteEntity * SOAP_FMAC2 soap_instantiate_ns2__AbstractRemoteEntity(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__AbstractRemoteEntity(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__AbstractRemoteEntity, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "ns2:AbstractNamedRemoteEntity"))
	{	cp->type = SOAP_TYPE_ns2__AbstractNamedRemoteEntity;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__AbstractNamedRemoteEntity);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__AbstractNamedRemoteEntity);
			((ns2__AbstractNamedRemoteEntity*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__AbstractNamedRemoteEntity[n]);
			if (size)
				*size = n * sizeof(ns2__AbstractNamedRemoteEntity);
			for (int i = 0; i < n; i++)
				((ns2__AbstractNamedRemoteEntity*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__AbstractNamedRemoteEntity*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteIssue"))
	{	cp->type = SOAP_TYPE_ns2__RemoteIssue;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteIssue);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteIssue);
			((ns2__RemoteIssue*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteIssue[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteIssue);
			for (int i = 0; i < n; i++)
				((ns2__RemoteIssue*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteIssue*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteAttachment"))
	{	cp->type = SOAP_TYPE_ns2__RemoteAttachment;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteAttachment);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteAttachment);
			((ns2__RemoteAttachment*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteAttachment[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteAttachment);
			for (int i = 0; i < n; i++)
				((ns2__RemoteAttachment*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteAttachment*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteComponent"))
	{	cp->type = SOAP_TYPE_ns2__RemoteComponent;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteComponent);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteComponent);
			((ns2__RemoteComponent*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteComponent[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteComponent);
			for (int i = 0; i < n; i++)
				((ns2__RemoteComponent*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteComponent*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteVersion"))
	{	cp->type = SOAP_TYPE_ns2__RemoteVersion;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteVersion);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteVersion);
			((ns2__RemoteVersion*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteVersion[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteVersion);
			for (int i = 0; i < n; i++)
				((ns2__RemoteVersion*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteVersion*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteNamedObject"))
	{	cp->type = SOAP_TYPE_ns2__RemoteNamedObject;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteNamedObject);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteNamedObject);
			((ns2__RemoteNamedObject*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteNamedObject[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteNamedObject);
			for (int i = 0; i < n; i++)
				((ns2__RemoteNamedObject*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteNamedObject*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:AbstractRemoteConstant"))
	{	cp->type = SOAP_TYPE_ns2__AbstractRemoteConstant;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__AbstractRemoteConstant);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__AbstractRemoteConstant);
			((ns2__AbstractRemoteConstant*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__AbstractRemoteConstant[n]);
			if (size)
				*size = n * sizeof(ns2__AbstractRemoteConstant);
			for (int i = 0; i < n; i++)
				((ns2__AbstractRemoteConstant*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__AbstractRemoteConstant*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteProject"))
	{	cp->type = SOAP_TYPE_ns2__RemoteProject;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteProject);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteProject);
			((ns2__RemoteProject*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteProject[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteProject);
			for (int i = 0; i < n; i++)
				((ns2__RemoteProject*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteProject*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteField"))
	{	cp->type = SOAP_TYPE_ns2__RemoteField;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteField);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteField);
			((ns2__RemoteField*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteField[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteField);
			for (int i = 0; i < n; i++)
				((ns2__RemoteField*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteField*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteFilter"))
	{	cp->type = SOAP_TYPE_ns2__RemoteFilter;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteFilter);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteFilter);
			((ns2__RemoteFilter*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteFilter[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteFilter);
			for (int i = 0; i < n; i++)
				((ns2__RemoteFilter*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteFilter*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteSecurityLevel"))
	{	cp->type = SOAP_TYPE_ns2__RemoteSecurityLevel;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteSecurityLevel);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteSecurityLevel);
			((ns2__RemoteSecurityLevel*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteSecurityLevel[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteSecurityLevel);
			for (int i = 0; i < n; i++)
				((ns2__RemoteSecurityLevel*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteSecurityLevel*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteIssueType"))
	{	cp->type = SOAP_TYPE_ns2__RemoteIssueType;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteIssueType);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteIssueType);
			((ns2__RemoteIssueType*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteIssueType[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteIssueType);
			for (int i = 0; i < n; i++)
				((ns2__RemoteIssueType*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteIssueType*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemotePriority"))
	{	cp->type = SOAP_TYPE_ns2__RemotePriority;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemotePriority);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemotePriority);
			((ns2__RemotePriority*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemotePriority[n]);
			if (size)
				*size = n * sizeof(ns2__RemotePriority);
			for (int i = 0; i < n; i++)
				((ns2__RemotePriority*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemotePriority*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteResolution"))
	{	cp->type = SOAP_TYPE_ns2__RemoteResolution;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteResolution);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteResolution);
			((ns2__RemoteResolution*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteResolution[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteResolution);
			for (int i = 0; i < n; i++)
				((ns2__RemoteResolution*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteResolution*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteStatus"))
	{	cp->type = SOAP_TYPE_ns2__RemoteStatus;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteStatus);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteStatus);
			((ns2__RemoteStatus*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteStatus[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteStatus);
			for (int i = 0; i < n; i++)
				((ns2__RemoteStatus*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteStatus*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__AbstractRemoteEntity);
		if (size)
			*size = sizeof(ns2__AbstractRemoteEntity);
		((ns2__AbstractRemoteEntity*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__AbstractRemoteEntity[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__AbstractRemoteEntity);
		for (int i = 0; i < n; i++)
			((ns2__AbstractRemoteEntity*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__AbstractRemoteEntity*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__AbstractRemoteEntity(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__AbstractRemoteEntity %p -> %p\n", q, p));
	*(ns2__AbstractRemoteEntity*)p = *(ns2__AbstractRemoteEntity*)q;
}

void ns2__RemoteGroup::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteGroup::name);
	this->ns2__RemoteGroup::users = NULL;
	/* transient soap skipped */
}

void ns2__RemoteGroup::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteGroup::name);
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, &this->ns2__RemoteGroup::users);
	/* transient soap skipped */
}

int ns2__RemoteGroup::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteGroup(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteGroup(struct soap *soap, const char *tag, int id, const ns2__RemoteGroup *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteGroup), "ns2:RemoteGroup"))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "name", -1, &(a->ns2__RemoteGroup::name), ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, "users", -1, &(a->ns2__RemoteGroup::users), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteGroup::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteGroup(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteGroup * SOAP_FMAC4 soap_in_ns2__RemoteGroup(struct soap *soap, const char *tag, ns2__RemoteGroup *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteGroup *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteGroup, sizeof(ns2__RemoteGroup), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteGroup)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteGroup *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_name1 = 1;
	size_t soap_flag_users1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap_flag_name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__RemoteGroup::name), "xsd:string"))
				{	soap_flag_name1--;
					continue;
				}
			if (soap_flag_users1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteUser(soap, "users", &(a->ns2__RemoteGroup::users), "ns2:RemoteUser"))
				{	soap_flag_users1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteGroup *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteGroup, 0, sizeof(ns2__RemoteGroup), 0, soap_copy_ns2__RemoteGroup);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteGroup::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteGroup);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteGroup", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteGroup::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteGroup(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteGroup * SOAP_FMAC4 soap_get_ns2__RemoteGroup(struct soap *soap, ns2__RemoteGroup *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteGroup(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteGroup * SOAP_FMAC2 soap_instantiate_ns2__RemoteGroup(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteGroup(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteGroup, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteGroup);
		if (size)
			*size = sizeof(ns2__RemoteGroup);
		((ns2__RemoteGroup*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteGroup[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteGroup);
		for (int i = 0; i < n; i++)
			((ns2__RemoteGroup*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteGroup*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteGroup(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteGroup %p -> %p\n", q, p));
	*(ns2__RemoteGroup*)p = *(ns2__RemoteGroup*)q;
}

void ns2__RemoteUser::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteUser::email);
	soap_default_string(soap, &this->ns2__RemoteUser::fullname);
	soap_default_string(soap, &this->ns2__RemoteUser::name);
	/* transient soap skipped */
}

void ns2__RemoteUser::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteUser::email);
	soap_serialize_string(soap, &this->ns2__RemoteUser::fullname);
	soap_serialize_string(soap, &this->ns2__RemoteUser::name);
	/* transient soap skipped */
}

int ns2__RemoteUser::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteUser(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteUser(struct soap *soap, const char *tag, int id, const ns2__RemoteUser *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteUser), "ns2:RemoteUser"))
		return soap->error;
	/* transient soap skipped */
	if (soap_out_string(soap, "email", -1, &(a->ns2__RemoteUser::email), ""))
		return soap->error;
	if (soap_out_string(soap, "fullname", -1, &(a->ns2__RemoteUser::fullname), ""))
		return soap->error;
	if (soap_out_string(soap, "name", -1, &(a->ns2__RemoteUser::name), ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteUser::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteUser(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteUser * SOAP_FMAC4 soap_in_ns2__RemoteUser(struct soap *soap, const char *tag, ns2__RemoteUser *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteUser *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteUser, sizeof(ns2__RemoteUser), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteUser)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteUser *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_email1 = 1;
	size_t soap_flag_fullname1 = 1;
	size_t soap_flag_name1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap_flag_email1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "email", &(a->ns2__RemoteUser::email), "xsd:string"))
				{	soap_flag_email1--;
					continue;
				}
			if (soap_flag_fullname1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "fullname", &(a->ns2__RemoteUser::fullname), "xsd:string"))
				{	soap_flag_fullname1--;
					continue;
				}
			if (soap_flag_name1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "name", &(a->ns2__RemoteUser::name), "xsd:string"))
				{	soap_flag_name1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteUser *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteUser, 0, sizeof(ns2__RemoteUser), 0, soap_copy_ns2__RemoteUser);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteUser::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteUser);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteUser", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteUser::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteUser(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteUser * SOAP_FMAC4 soap_get_ns2__RemoteUser(struct soap *soap, ns2__RemoteUser *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteUser(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteUser * SOAP_FMAC2 soap_instantiate_ns2__RemoteUser(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteUser(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteUser, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteUser);
		if (size)
			*size = sizeof(ns2__RemoteUser);
		((ns2__RemoteUser*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteUser[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteUser);
		for (int i = 0; i < n; i++)
			((ns2__RemoteUser*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteUser*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteUser(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteUser %p -> %p\n", q, p));
	*(ns2__RemoteUser*)p = *(ns2__RemoteUser*)q;
}

void ns2__RemoteEntity::soap_default(struct soap *soap)
{
	this->soap = soap;
	/* transient soap skipped */
}

void ns2__RemoteEntity::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	/* transient soap skipped */
}

int ns2__RemoteEntity::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteEntity(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteEntity(struct soap *soap, const char *tag, int id, const ns2__RemoteEntity *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteEntity), type))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteEntity::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteEntity(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteEntity * SOAP_FMAC4 soap_in_ns2__RemoteEntity(struct soap *soap, const char *tag, ns2__RemoteEntity *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteEntity *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteEntity, sizeof(ns2__RemoteEntity), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteEntity)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteEntity *)a->soap_in(soap, tag, type);
		}
	}
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteEntity *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteEntity, 0, sizeof(ns2__RemoteEntity), 0, soap_copy_ns2__RemoteEntity);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteEntity::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteEntity);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteEntity", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteEntity::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteEntity(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteEntity * SOAP_FMAC4 soap_get_ns2__RemoteEntity(struct soap *soap, ns2__RemoteEntity *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteEntity(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteEntity * SOAP_FMAC2 soap_instantiate_ns2__RemoteEntity(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteEntity(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteEntity, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (type && !soap_match_tag(soap, type, "ns2:RemoteUser"))
	{	cp->type = SOAP_TYPE_ns2__RemoteUser;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteUser);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteUser);
			((ns2__RemoteUser*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteUser[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteUser);
			for (int i = 0; i < n; i++)
				((ns2__RemoteUser*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteUser*)cp->ptr;
	}
	if (type && !soap_match_tag(soap, type, "ns2:RemoteGroup"))
	{	cp->type = SOAP_TYPE_ns2__RemoteGroup;
		if (n < 0)
		{	cp->ptr = (void*)new (ns2__RemoteGroup);
			if (!cp->ptr)
			{	soap->error = SOAP_EOM;
				return NULL;
			}
			if (size)
				*size = sizeof(ns2__RemoteGroup);
			((ns2__RemoteGroup*)cp->ptr)->soap = soap;
		}
		else
		{	cp->ptr = (void*)new (ns2__RemoteGroup[n]);
			if (size)
				*size = n * sizeof(ns2__RemoteGroup);
			for (int i = 0; i < n; i++)
				((ns2__RemoteGroup*)cp->ptr)[i].soap = soap;
		}
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
		return (ns2__RemoteGroup*)cp->ptr;
	}
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteEntity);
		if (size)
			*size = sizeof(ns2__RemoteEntity);
		((ns2__RemoteEntity*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteEntity[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteEntity);
		for (int i = 0; i < n; i++)
			((ns2__RemoteEntity*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteEntity*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteEntity(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteEntity %p -> %p\n", q, p));
	*(ns2__RemoteEntity*)p = *(ns2__RemoteEntity*)q;
}

void ns2__RemoteServerInfo::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteServerInfo::baseUrl);
	this->ns2__RemoteServerInfo::buildDate = NULL;
	soap_default_string(soap, &this->ns2__RemoteServerInfo::buildNumber);
	soap_default_string(soap, &this->ns2__RemoteServerInfo::edition);
	this->ns2__RemoteServerInfo::serverTime = NULL;
	soap_default_string(soap, &this->ns2__RemoteServerInfo::version);
	/* transient soap skipped */
}

void ns2__RemoteServerInfo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteServerInfo::baseUrl);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteServerInfo::buildDate);
	soap_serialize_string(soap, &this->ns2__RemoteServerInfo::buildNumber);
	soap_serialize_string(soap, &this->ns2__RemoteServerInfo::edition);
	soap_serialize_PointerTons2__RemoteTimeInfo(soap, &this->ns2__RemoteServerInfo::serverTime);
	soap_serialize_string(soap, &this->ns2__RemoteServerInfo::version);
	/* transient soap skipped */
}

int ns2__RemoteServerInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteServerInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteServerInfo(struct soap *soap, const char *tag, int id, const ns2__RemoteServerInfo *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteServerInfo), type))
		return soap->error;
	if (soap_out_string(soap, "baseUrl", -1, &(a->ns2__RemoteServerInfo::baseUrl), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "buildDate", -1, &(a->ns2__RemoteServerInfo::buildDate), ""))
		return soap->error;
	if (soap_out_string(soap, "buildNumber", -1, &(a->ns2__RemoteServerInfo::buildNumber), ""))
		return soap->error;
	if (soap_out_string(soap, "edition", -1, &(a->ns2__RemoteServerInfo::edition), ""))
		return soap->error;
	if (soap_out_PointerTons2__RemoteTimeInfo(soap, "serverTime", -1, &(a->ns2__RemoteServerInfo::serverTime), ""))
		return soap->error;
	if (soap_out_string(soap, "version", -1, &(a->ns2__RemoteServerInfo::version), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteServerInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteServerInfo(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteServerInfo * SOAP_FMAC4 soap_in_ns2__RemoteServerInfo(struct soap *soap, const char *tag, ns2__RemoteServerInfo *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteServerInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteServerInfo, sizeof(ns2__RemoteServerInfo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteServerInfo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteServerInfo *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_baseUrl1 = 1;
	size_t soap_flag_buildDate1 = 1;
	size_t soap_flag_buildNumber1 = 1;
	size_t soap_flag_edition1 = 1;
	size_t soap_flag_serverTime1 = 1;
	size_t soap_flag_version1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_baseUrl1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "baseUrl", &(a->ns2__RemoteServerInfo::baseUrl), "xsd:string"))
				{	soap_flag_baseUrl1--;
					continue;
				}
			if (soap_flag_buildDate1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "buildDate", &(a->ns2__RemoteServerInfo::buildDate), "xsd:dateTime"))
				{	soap_flag_buildDate1--;
					continue;
				}
			if (soap_flag_buildNumber1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "buildNumber", &(a->ns2__RemoteServerInfo::buildNumber), "xsd:string"))
				{	soap_flag_buildNumber1--;
					continue;
				}
			if (soap_flag_edition1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "edition", &(a->ns2__RemoteServerInfo::edition), "xsd:string"))
				{	soap_flag_edition1--;
					continue;
				}
			if (soap_flag_serverTime1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteTimeInfo(soap, "serverTime", &(a->ns2__RemoteServerInfo::serverTime), "ns2:RemoteTimeInfo"))
				{	soap_flag_serverTime1--;
					continue;
				}
			if (soap_flag_version1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "version", &(a->ns2__RemoteServerInfo::version), "xsd:string"))
				{	soap_flag_version1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteServerInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteServerInfo, 0, sizeof(ns2__RemoteServerInfo), 0, soap_copy_ns2__RemoteServerInfo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteServerInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteServerInfo);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteServerInfo", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteServerInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteServerInfo(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteServerInfo * SOAP_FMAC4 soap_get_ns2__RemoteServerInfo(struct soap *soap, ns2__RemoteServerInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteServerInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteServerInfo * SOAP_FMAC2 soap_instantiate_ns2__RemoteServerInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteServerInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteServerInfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteServerInfo);
		if (size)
			*size = sizeof(ns2__RemoteServerInfo);
		((ns2__RemoteServerInfo*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteServerInfo[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteServerInfo);
		for (int i = 0; i < n; i++)
			((ns2__RemoteServerInfo*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteServerInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteServerInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteServerInfo %p -> %p\n", q, p));
	*(ns2__RemoteServerInfo*)p = *(ns2__RemoteServerInfo*)q;
}

void ns2__RemoteTimeInfo::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteTimeInfo::serverTime);
	soap_default_string(soap, &this->ns2__RemoteTimeInfo::timeZoneId);
	/* transient soap skipped */
}

void ns2__RemoteTimeInfo::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteTimeInfo::serverTime);
	soap_serialize_string(soap, &this->ns2__RemoteTimeInfo::timeZoneId);
	/* transient soap skipped */
}

int ns2__RemoteTimeInfo::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteTimeInfo(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteTimeInfo(struct soap *soap, const char *tag, int id, const ns2__RemoteTimeInfo *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteTimeInfo), type))
		return soap->error;
	if (soap_out_string(soap, "serverTime", -1, &(a->ns2__RemoteTimeInfo::serverTime), ""))
		return soap->error;
	if (soap_out_string(soap, "timeZoneId", -1, &(a->ns2__RemoteTimeInfo::timeZoneId), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteTimeInfo::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteTimeInfo(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteTimeInfo * SOAP_FMAC4 soap_in_ns2__RemoteTimeInfo(struct soap *soap, const char *tag, ns2__RemoteTimeInfo *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteTimeInfo *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteTimeInfo, sizeof(ns2__RemoteTimeInfo), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteTimeInfo)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteTimeInfo *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_serverTime1 = 1;
	size_t soap_flag_timeZoneId1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_serverTime1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "serverTime", &(a->ns2__RemoteTimeInfo::serverTime), "xsd:string"))
				{	soap_flag_serverTime1--;
					continue;
				}
			if (soap_flag_timeZoneId1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "timeZoneId", &(a->ns2__RemoteTimeInfo::timeZoneId), "xsd:string"))
				{	soap_flag_timeZoneId1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteTimeInfo *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteTimeInfo, 0, sizeof(ns2__RemoteTimeInfo), 0, soap_copy_ns2__RemoteTimeInfo);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteTimeInfo::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteTimeInfo);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteTimeInfo", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteTimeInfo::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteTimeInfo(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteTimeInfo * SOAP_FMAC4 soap_get_ns2__RemoteTimeInfo(struct soap *soap, ns2__RemoteTimeInfo *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteTimeInfo(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteTimeInfo * SOAP_FMAC2 soap_instantiate_ns2__RemoteTimeInfo(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteTimeInfo(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteTimeInfo, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteTimeInfo);
		if (size)
			*size = sizeof(ns2__RemoteTimeInfo);
		((ns2__RemoteTimeInfo*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteTimeInfo[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteTimeInfo);
		for (int i = 0; i < n; i++)
			((ns2__RemoteTimeInfo*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteTimeInfo*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteTimeInfo(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteTimeInfo %p -> %p\n", q, p));
	*(ns2__RemoteTimeInfo*)p = *(ns2__RemoteTimeInfo*)q;
}

void ns2__RemoteComment::soap_default(struct soap *soap)
{
	this->soap = soap;
	soap_default_string(soap, &this->ns2__RemoteComment::author);
	soap_default_string(soap, &this->ns2__RemoteComment::body);
	this->ns2__RemoteComment::created = NULL;
	soap_default_string(soap, &this->ns2__RemoteComment::groupLevel);
	soap_default_string(soap, &this->ns2__RemoteComment::id);
	soap_default_string(soap, &this->ns2__RemoteComment::roleLevel);
	soap_default_string(soap, &this->ns2__RemoteComment::updateAuthor);
	this->ns2__RemoteComment::updated = NULL;
	/* transient soap skipped */
}

void ns2__RemoteComment::soap_serialize(struct soap *soap) const
{
	(void)soap; /* appease -Wall -Werror */
	soap_serialize_string(soap, &this->ns2__RemoteComment::author);
	soap_serialize_string(soap, &this->ns2__RemoteComment::body);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteComment::created);
	soap_serialize_string(soap, &this->ns2__RemoteComment::groupLevel);
	soap_serialize_string(soap, &this->ns2__RemoteComment::id);
	soap_serialize_string(soap, &this->ns2__RemoteComment::roleLevel);
	soap_serialize_string(soap, &this->ns2__RemoteComment::updateAuthor);
	soap_serialize_PointerTotime(soap, &this->ns2__RemoteComment::updated);
	/* transient soap skipped */
}

int ns2__RemoteComment::soap_out(struct soap *soap, const char *tag, int id, const char *type) const
{
	return soap_out_ns2__RemoteComment(soap, tag, id, this, type);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns2__RemoteComment(struct soap *soap, const char *tag, int id, const ns2__RemoteComment *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns2__RemoteComment), type))
		return soap->error;
	if (soap_out_string(soap, "author", -1, &(a->ns2__RemoteComment::author), ""))
		return soap->error;
	if (soap_out_string(soap, "body", -1, &(a->ns2__RemoteComment::body), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "created", -1, &(a->ns2__RemoteComment::created), ""))
		return soap->error;
	if (soap_out_string(soap, "groupLevel", -1, &(a->ns2__RemoteComment::groupLevel), ""))
		return soap->error;
	if (soap_out_string(soap, "id", -1, &(a->ns2__RemoteComment::id), ""))
		return soap->error;
	if (soap_out_string(soap, "roleLevel", -1, &(a->ns2__RemoteComment::roleLevel), ""))
		return soap->error;
	if (soap_out_string(soap, "updateAuthor", -1, &(a->ns2__RemoteComment::updateAuthor), ""))
		return soap->error;
	if (soap_out_PointerTotime(soap, "updated", -1, &(a->ns2__RemoteComment::updated), ""))
		return soap->error;
	/* transient soap skipped */
	return soap_element_end_out(soap, tag);
}

void *ns2__RemoteComment::soap_in(struct soap *soap, const char *tag, const char *type)
{	return soap_in_ns2__RemoteComment(soap, tag, this, type);
}

SOAP_FMAC3 ns2__RemoteComment * SOAP_FMAC4 soap_in_ns2__RemoteComment(struct soap *soap, const char *tag, ns2__RemoteComment *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, NULL))
		return NULL;
	a = (ns2__RemoteComment *)soap_class_id_enter(soap, soap->id, a, SOAP_TYPE_ns2__RemoteComment, sizeof(ns2__RemoteComment), soap->type, soap->arrayType);
	if (!a)
		return NULL;
	if (soap->alloced)
	{	a->soap_default(soap);
		if (soap->clist->type != SOAP_TYPE_ns2__RemoteComment)
		{	soap_revert(soap);
			*soap->id = '\0';
			return (ns2__RemoteComment *)a->soap_in(soap, tag, type);
		}
	}
	size_t soap_flag_author1 = 1;
	size_t soap_flag_body1 = 1;
	size_t soap_flag_created1 = 1;
	size_t soap_flag_groupLevel1 = 1;
	size_t soap_flag_id1 = 1;
	size_t soap_flag_roleLevel1 = 1;
	size_t soap_flag_updateAuthor1 = 1;
	size_t soap_flag_updated1 = 1;
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_author1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "author", &(a->ns2__RemoteComment::author), "xsd:string"))
				{	soap_flag_author1--;
					continue;
				}
			if (soap_flag_body1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "body", &(a->ns2__RemoteComment::body), "xsd:string"))
				{	soap_flag_body1--;
					continue;
				}
			if (soap_flag_created1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "created", &(a->ns2__RemoteComment::created), "xsd:dateTime"))
				{	soap_flag_created1--;
					continue;
				}
			if (soap_flag_groupLevel1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "groupLevel", &(a->ns2__RemoteComment::groupLevel), "xsd:string"))
				{	soap_flag_groupLevel1--;
					continue;
				}
			if (soap_flag_id1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "id", &(a->ns2__RemoteComment::id), "xsd:string"))
				{	soap_flag_id1--;
					continue;
				}
			if (soap_flag_roleLevel1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "roleLevel", &(a->ns2__RemoteComment::roleLevel), "xsd:string"))
				{	soap_flag_roleLevel1--;
					continue;
				}
			if (soap_flag_updateAuthor1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "updateAuthor", &(a->ns2__RemoteComment::updateAuthor), "xsd:string"))
				{	soap_flag_updateAuthor1--;
					continue;
				}
			if (soap_flag_updated1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTotime(soap, "updated", &(a->ns2__RemoteComment::updated), "xsd:dateTime"))
				{	soap_flag_updated1--;
					continue;
				}
			/* transient soap skipped */
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (ns2__RemoteComment *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns2__RemoteComment, 0, sizeof(ns2__RemoteComment), 0, soap_copy_ns2__RemoteComment);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

int ns2__RemoteComment::soap_put(struct soap *soap, const char *tag, const  char *type) const
{
	register int id = soap_embed(soap, (void*)this, NULL, 0, tag, SOAP_TYPE_ns2__RemoteComment);
	if (this->soap_out(soap, tag?tag:"ns2:RemoteComment", id, type))
		return soap->error;
	return soap_putindependent(soap);
}

void *ns2__RemoteComment::soap_get(struct soap *soap, const char *tag, const char *type)
{
	return soap_get_ns2__RemoteComment(soap, this, tag, type);
}

SOAP_FMAC3 ns2__RemoteComment * SOAP_FMAC4 soap_get_ns2__RemoteComment(struct soap *soap, ns2__RemoteComment *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns2__RemoteComment(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 ns2__RemoteComment * SOAP_FMAC2 soap_instantiate_ns2__RemoteComment(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns2__RemoteComment(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns2__RemoteComment, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (ns2__RemoteComment);
		if (size)
			*size = sizeof(ns2__RemoteComment);
		((ns2__RemoteComment*)cp->ptr)->soap = soap;
	}
	else
	{	cp->ptr = (void*)new (ns2__RemoteComment[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(ns2__RemoteComment);
		for (int i = 0; i < n; i++)
			((ns2__RemoteComment*)cp->ptr)[i].soap = soap;
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (ns2__RemoteComment*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns2__RemoteComment(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying ns2__RemoteComment %p -> %p\n", q, p));
	*(ns2__RemoteComment*)p = *(ns2__RemoteComment*)q;
}

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->faultcode);
	soap_default_string(soap, &a->faultstring);
	soap_default_string(soap, &a->faultactor);
	a->detail = NULL;
	a->SOAP_ENV__Code = NULL;
	a->SOAP_ENV__Reason = NULL;
	soap_default_string(soap, &a->SOAP_ENV__Node);
	soap_default_string(soap, &a->SOAP_ENV__Role);
	a->SOAP_ENV__Detail = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->faultcode);
	soap_serialize_string(soap, &a->faultstring);
	soap_serialize_string(soap, &a->faultactor);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->detail);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Code);
	soap_serialize_PointerToSOAP_ENV__Reason(soap, &a->SOAP_ENV__Reason);
	soap_serialize_string(soap, &a->SOAP_ENV__Node);
	soap_serialize_string(soap, &a->SOAP_ENV__Role);
	soap_serialize_PointerToSOAP_ENV__Detail(soap, &a->SOAP_ENV__Detail);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Fault(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Fault *a, const char *type)
{
	const char *soap_tmp_faultcode = soap_QName2s(soap, a->faultcode);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Fault), type))
		return soap->error;
	if (soap_out__QName(soap, "faultcode", -1, (char*const*)&soap_tmp_faultcode, ""))
		return soap->error;
	if (soap_out_string(soap, "faultstring", -1, &a->faultstring, ""))
		return soap->error;
	if (soap_out_string(soap, "faultactor", -1, &a->faultactor, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "detail", -1, &a->detail, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", -1, &a->SOAP_ENV__Code, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", -1, &a->SOAP_ENV__Reason, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Node", -1, &a->SOAP_ENV__Node, ""))
		return soap->error;
	if (soap_out_string(soap, "SOAP-ENV:Role", -1, &a->SOAP_ENV__Role, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", -1, &a->SOAP_ENV__Detail, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_in_SOAP_ENV__Fault(struct soap *soap, const char *tag, struct SOAP_ENV__Fault *a, const char *type)
{
	size_t soap_flag_faultcode = 1;
	size_t soap_flag_faultstring = 1;
	size_t soap_flag_faultactor = 1;
	size_t soap_flag_detail = 1;
	size_t soap_flag_SOAP_ENV__Code = 1;
	size_t soap_flag_SOAP_ENV__Reason = 1;
	size_t soap_flag_SOAP_ENV__Node = 1;
	size_t soap_flag_SOAP_ENV__Role = 1;
	size_t soap_flag_SOAP_ENV__Detail = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Fault *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Fault, sizeof(struct SOAP_ENV__Fault), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Fault(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_faultcode && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "faultcode", &a->faultcode, ""))
				{	soap_flag_faultcode--;
					continue;
				}
			if (soap_flag_faultstring && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultstring", &a->faultstring, "xsd:string"))
				{	soap_flag_faultstring--;
					continue;
				}
			if (soap_flag_faultactor && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "faultactor", &a->faultactor, "xsd:string"))
				{	soap_flag_faultactor--;
					continue;
				}
			if (soap_flag_detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "detail", &a->detail, ""))
				{	soap_flag_detail--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Code && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Code", &a->SOAP_ENV__Code, ""))
				{	soap_flag_SOAP_ENV__Code--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Reason && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Reason(soap, "SOAP-ENV:Reason", &a->SOAP_ENV__Reason, ""))
				{	soap_flag_SOAP_ENV__Reason--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Node && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Node", &a->SOAP_ENV__Node, "xsd:string"))
				{	soap_flag_SOAP_ENV__Node--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Role && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Role", &a->SOAP_ENV__Role, "xsd:string"))
				{	soap_flag_SOAP_ENV__Role--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Detail && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Detail(soap, "SOAP-ENV:Detail", &a->SOAP_ENV__Detail, ""))
				{	soap_flag_SOAP_ENV__Detail--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Fault *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Fault, 0, sizeof(struct SOAP_ENV__Fault), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Fault(struct soap *soap, const struct SOAP_ENV__Fault *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Fault);
	if (soap_out_SOAP_ENV__Fault(soap, tag?tag:"SOAP-ENV:Fault", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Fault * SOAP_FMAC4 soap_get_SOAP_ENV__Fault(struct soap *soap, struct SOAP_ENV__Fault *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Fault(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Fault * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Fault(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Fault(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Fault, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct SOAP_ENV__Fault);
		if (size)
			*size = sizeof(struct SOAP_ENV__Fault);
	}
	else
	{	cp->ptr = (void*)new (struct SOAP_ENV__Fault[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Fault);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Fault*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Fault(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Fault %p -> %p\n", q, p));
	*(struct SOAP_ENV__Fault*)p = *(struct SOAP_ENV__Fault*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->SOAP_ENV__Text);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Reason(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Reason *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Reason), type))
		return soap->error;
	if (soap->lang)
		soap_set_attr(soap, "xml:lang", soap->lang);
	if (soap_out_string(soap, "SOAP-ENV:Text", -1, &a->SOAP_ENV__Text, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_in_SOAP_ENV__Reason(struct soap *soap, const char *tag, struct SOAP_ENV__Reason *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Text = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Reason *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Reason, sizeof(struct SOAP_ENV__Reason), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Reason(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Text && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, "SOAP-ENV:Text", &a->SOAP_ENV__Text, "xsd:string"))
				{	soap_flag_SOAP_ENV__Text--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Reason *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Reason, 0, sizeof(struct SOAP_ENV__Reason), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Reason(struct soap *soap, const struct SOAP_ENV__Reason *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Reason);
	if (soap_out_SOAP_ENV__Reason(soap, tag?tag:"SOAP-ENV:Reason", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Reason * SOAP_FMAC4 soap_get_SOAP_ENV__Reason(struct soap *soap, struct SOAP_ENV__Reason *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Reason(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Reason * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Reason(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Reason(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Reason, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct SOAP_ENV__Reason);
		if (size)
			*size = sizeof(struct SOAP_ENV__Reason);
	}
	else
	{	cp->ptr = (void*)new (struct SOAP_ENV__Reason[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Reason);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Reason*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Reason(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Reason %p -> %p\n", q, p));
	*(struct SOAP_ENV__Reason*)p = *(struct SOAP_ENV__Reason*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default__QName(soap, &a->SOAP_ENV__Value);
	a->SOAP_ENV__Subcode = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize__QName(soap, &a->SOAP_ENV__Value);
	soap_serialize_PointerToSOAP_ENV__Code(soap, &a->SOAP_ENV__Subcode);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Code(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Code *a, const char *type)
{
	const char *soap_tmp_SOAP_ENV__Value = soap_QName2s(soap, a->SOAP_ENV__Value);
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Code), type))
		return soap->error;
	if (soap_out__QName(soap, "SOAP-ENV:Value", -1, (char*const*)&soap_tmp_SOAP_ENV__Value, ""))
		return soap->error;
	if (soap_out_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", -1, &a->SOAP_ENV__Subcode, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_in_SOAP_ENV__Code(struct soap *soap, const char *tag, struct SOAP_ENV__Code *a, const char *type)
{
	size_t soap_flag_SOAP_ENV__Value = 1;
	size_t soap_flag_SOAP_ENV__Subcode = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Code *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Code, sizeof(struct SOAP_ENV__Code), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Code(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag_SOAP_ENV__Value && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in__QName(soap, "SOAP-ENV:Value", &a->SOAP_ENV__Value, ""))
				{	soap_flag_SOAP_ENV__Value--;
					continue;
				}
			if (soap_flag_SOAP_ENV__Subcode && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToSOAP_ENV__Code(soap, "SOAP-ENV:Subcode", &a->SOAP_ENV__Subcode, ""))
				{	soap_flag_SOAP_ENV__Subcode--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Code *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Code, 0, sizeof(struct SOAP_ENV__Code), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Code(struct soap *soap, const struct SOAP_ENV__Code *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Code);
	if (soap_out_SOAP_ENV__Code(soap, tag?tag:"SOAP-ENV:Code", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Code * SOAP_FMAC4 soap_get_SOAP_ENV__Code(struct soap *soap, struct SOAP_ENV__Code *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Code(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Code * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Code(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Code(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Code, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct SOAP_ENV__Code);
		if (size)
			*size = sizeof(struct SOAP_ENV__Code);
	}
	else
	{	cp->ptr = (void*)new (struct SOAP_ENV__Code[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Code);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Code*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Code(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Code %p -> %p\n", q, p));
	*(struct SOAP_ENV__Code*)p = *(struct SOAP_ENV__Code*)q;
}

#endif

#ifndef WITH_NOGLOBAL

SOAP_FMAC3 void SOAP_FMAC4 soap_default_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_SOAP_ENV__Header(struct soap *soap, const char *tag, int id, const struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_SOAP_ENV__Header), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_in_SOAP_ENV__Header(struct soap *soap, const char *tag, struct SOAP_ENV__Header *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct SOAP_ENV__Header *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_SOAP_ENV__Header, sizeof(struct SOAP_ENV__Header), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_SOAP_ENV__Header(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct SOAP_ENV__Header *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_SOAP_ENV__Header, 0, sizeof(struct SOAP_ENV__Header), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_SOAP_ENV__Header(struct soap *soap, const struct SOAP_ENV__Header *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_SOAP_ENV__Header);
	if (soap_out_SOAP_ENV__Header(soap, tag?tag:"SOAP-ENV:Header", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct SOAP_ENV__Header * SOAP_FMAC4 soap_get_SOAP_ENV__Header(struct soap *soap, struct SOAP_ENV__Header *p, const char *tag, const char *type)
{
	if ((p = soap_in_SOAP_ENV__Header(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct SOAP_ENV__Header * SOAP_FMAC2 soap_instantiate_SOAP_ENV__Header(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_SOAP_ENV__Header(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_SOAP_ENV__Header, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct SOAP_ENV__Header);
		if (size)
			*size = sizeof(struct SOAP_ENV__Header);
	}
	else
	{	cp->ptr = (void*)new (struct SOAP_ENV__Header[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct SOAP_ENV__Header);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct SOAP_ENV__Header*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_SOAP_ENV__Header(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct SOAP_ENV__Header %p -> %p\n", q, p));
	*(struct SOAP_ENV__Header*)p = *(struct SOAP_ENV__Header*)q;
}

#endif

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__setNewProjectAvatar(struct soap *soap, struct ns4__setNewProjectAvatar *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
	soap_default_string(soap, &a->_in2);
	soap_default_string(soap, &a->_in3);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__setNewProjectAvatar(struct soap *soap, const struct ns4__setNewProjectAvatar *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
	soap_serialize_string(soap, &a->_in2);
	soap_serialize_string(soap, &a->_in3);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__setNewProjectAvatar(struct soap *soap, const char *tag, int id, const struct ns4__setNewProjectAvatar *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__setNewProjectAvatar), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	if (soap_out_string(soap, "in2", -1, &a->_in2, ""))
		return soap->error;
	if (soap_out_string(soap, "in3", -1, &a->_in3, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__setNewProjectAvatar * SOAP_FMAC4 soap_in_ns4__setNewProjectAvatar(struct soap *soap, const char *tag, struct ns4__setNewProjectAvatar *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	size_t soap_flag__in2 = 1;
	size_t soap_flag__in3 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__setNewProjectAvatar *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__setNewProjectAvatar, sizeof(struct ns4__setNewProjectAvatar), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__setNewProjectAvatar(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap_flag__in2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in2, "xsd:string"))
				{	soap_flag__in2--;
					continue;
				}
			if (soap_flag__in3 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in3, "xsd:string"))
				{	soap_flag__in3--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__setNewProjectAvatar *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__setNewProjectAvatar, 0, sizeof(struct ns4__setNewProjectAvatar), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__setNewProjectAvatar(struct soap *soap, const struct ns4__setNewProjectAvatar *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__setNewProjectAvatar);
	if (soap_out_ns4__setNewProjectAvatar(soap, tag?tag:"ns4:setNewProjectAvatar", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__setNewProjectAvatar * SOAP_FMAC4 soap_get_ns4__setNewProjectAvatar(struct soap *soap, struct ns4__setNewProjectAvatar *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__setNewProjectAvatar(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__setNewProjectAvatar * SOAP_FMAC2 soap_instantiate_ns4__setNewProjectAvatar(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__setNewProjectAvatar(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__setNewProjectAvatar, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__setNewProjectAvatar);
		if (size)
			*size = sizeof(struct ns4__setNewProjectAvatar);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__setNewProjectAvatar[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__setNewProjectAvatar);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__setNewProjectAvatar*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__setNewProjectAvatar(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__setNewProjectAvatar %p -> %p\n", q, p));
	*(struct ns4__setNewProjectAvatar*)p = *(struct ns4__setNewProjectAvatar*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__setNewProjectAvatarResponse(struct soap *soap, struct ns4__setNewProjectAvatarResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__setNewProjectAvatarResponse(struct soap *soap, const struct ns4__setNewProjectAvatarResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__setNewProjectAvatarResponse(struct soap *soap, const char *tag, int id, const struct ns4__setNewProjectAvatarResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__setNewProjectAvatarResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__setNewProjectAvatarResponse * SOAP_FMAC4 soap_in_ns4__setNewProjectAvatarResponse(struct soap *soap, const char *tag, struct ns4__setNewProjectAvatarResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__setNewProjectAvatarResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__setNewProjectAvatarResponse, sizeof(struct ns4__setNewProjectAvatarResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__setNewProjectAvatarResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__setNewProjectAvatarResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__setNewProjectAvatarResponse, 0, sizeof(struct ns4__setNewProjectAvatarResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__setNewProjectAvatarResponse(struct soap *soap, const struct ns4__setNewProjectAvatarResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__setNewProjectAvatarResponse);
	if (soap_out_ns4__setNewProjectAvatarResponse(soap, tag?tag:"ns4:setNewProjectAvatarResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__setNewProjectAvatarResponse * SOAP_FMAC4 soap_get_ns4__setNewProjectAvatarResponse(struct soap *soap, struct ns4__setNewProjectAvatarResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__setNewProjectAvatarResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__setNewProjectAvatarResponse * SOAP_FMAC2 soap_instantiate_ns4__setNewProjectAvatarResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__setNewProjectAvatarResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__setNewProjectAvatarResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__setNewProjectAvatarResponse);
		if (size)
			*size = sizeof(struct ns4__setNewProjectAvatarResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__setNewProjectAvatarResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__setNewProjectAvatarResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__setNewProjectAvatarResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__setNewProjectAvatarResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__setNewProjectAvatarResponse %p -> %p\n", q, p));
	*(struct ns4__setNewProjectAvatarResponse*)p = *(struct ns4__setNewProjectAvatarResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getProjectsNoSchemes(struct soap *soap, struct ns4__getProjectsNoSchemes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getProjectsNoSchemes(struct soap *soap, const struct ns4__getProjectsNoSchemes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getProjectsNoSchemes(struct soap *soap, const char *tag, int id, const struct ns4__getProjectsNoSchemes *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getProjectsNoSchemes), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getProjectsNoSchemes * SOAP_FMAC4 soap_in_ns4__getProjectsNoSchemes(struct soap *soap, const char *tag, struct ns4__getProjectsNoSchemes *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getProjectsNoSchemes *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getProjectsNoSchemes, sizeof(struct ns4__getProjectsNoSchemes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getProjectsNoSchemes(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getProjectsNoSchemes *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getProjectsNoSchemes, 0, sizeof(struct ns4__getProjectsNoSchemes), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getProjectsNoSchemes(struct soap *soap, const struct ns4__getProjectsNoSchemes *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getProjectsNoSchemes);
	if (soap_out_ns4__getProjectsNoSchemes(soap, tag?tag:"ns4:getProjectsNoSchemes", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getProjectsNoSchemes * SOAP_FMAC4 soap_get_ns4__getProjectsNoSchemes(struct soap *soap, struct ns4__getProjectsNoSchemes *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getProjectsNoSchemes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getProjectsNoSchemes * SOAP_FMAC2 soap_instantiate_ns4__getProjectsNoSchemes(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getProjectsNoSchemes(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getProjectsNoSchemes, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getProjectsNoSchemes);
		if (size)
			*size = sizeof(struct ns4__getProjectsNoSchemes);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getProjectsNoSchemes[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getProjectsNoSchemes);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getProjectsNoSchemes*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getProjectsNoSchemes(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getProjectsNoSchemes %p -> %p\n", q, p));
	*(struct ns4__getProjectsNoSchemes*)p = *(struct ns4__getProjectsNoSchemes*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getProjectsNoSchemesResponse(struct soap *soap, struct ns4__getProjectsNoSchemesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getProjectsNoSchemesReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getProjectsNoSchemesResponse(struct soap *soap, const struct ns4__getProjectsNoSchemesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteProject(soap, &a->_getProjectsNoSchemesReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getProjectsNoSchemesResponse(struct soap *soap, const char *tag, int id, const struct ns4__getProjectsNoSchemesResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getProjectsNoSchemesResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteProject(soap, "getProjectsNoSchemesReturn", -1, &a->_getProjectsNoSchemesReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getProjectsNoSchemesResponse * SOAP_FMAC4 soap_in_ns4__getProjectsNoSchemesResponse(struct soap *soap, const char *tag, struct ns4__getProjectsNoSchemesResponse *a, const char *type)
{
	size_t soap_flag__getProjectsNoSchemesReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getProjectsNoSchemesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getProjectsNoSchemesResponse, sizeof(struct ns4__getProjectsNoSchemesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getProjectsNoSchemesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getProjectsNoSchemesReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteProject(soap, NULL, &a->_getProjectsNoSchemesReturn, "ns2:RemoteProject"))
				{	soap_flag__getProjectsNoSchemesReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getProjectsNoSchemesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getProjectsNoSchemesResponse, 0, sizeof(struct ns4__getProjectsNoSchemesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getProjectsNoSchemesResponse(struct soap *soap, const struct ns4__getProjectsNoSchemesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getProjectsNoSchemesResponse);
	if (soap_out_ns4__getProjectsNoSchemesResponse(soap, tag?tag:"ns4:getProjectsNoSchemesResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getProjectsNoSchemesResponse * SOAP_FMAC4 soap_get_ns4__getProjectsNoSchemesResponse(struct soap *soap, struct ns4__getProjectsNoSchemesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getProjectsNoSchemesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getProjectsNoSchemesResponse * SOAP_FMAC2 soap_instantiate_ns4__getProjectsNoSchemesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getProjectsNoSchemesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getProjectsNoSchemesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getProjectsNoSchemesResponse);
		if (size)
			*size = sizeof(struct ns4__getProjectsNoSchemesResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getProjectsNoSchemesResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getProjectsNoSchemesResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getProjectsNoSchemesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getProjectsNoSchemesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getProjectsNoSchemesResponse %p -> %p\n", q, p));
	*(struct ns4__getProjectsNoSchemesResponse*)p = *(struct ns4__getProjectsNoSchemesResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getIssuesFromTextSearchWithLimit(struct soap *soap, struct ns4__getIssuesFromTextSearchWithLimit *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
	soap_default_int(soap, &a->_in2);
	soap_default_int(soap, &a->_in3);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getIssuesFromTextSearchWithLimit(struct soap *soap, const struct ns4__getIssuesFromTextSearchWithLimit *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getIssuesFromTextSearchWithLimit(struct soap *soap, const char *tag, int id, const struct ns4__getIssuesFromTextSearchWithLimit *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	if (soap_out_int(soap, "in2", -1, &a->_in2, ""))
		return soap->error;
	if (soap_out_int(soap, "in3", -1, &a->_in3, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getIssuesFromTextSearchWithLimit * SOAP_FMAC4 soap_in_ns4__getIssuesFromTextSearchWithLimit(struct soap *soap, const char *tag, struct ns4__getIssuesFromTextSearchWithLimit *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	size_t soap_flag__in2 = 1;
	size_t soap_flag__in3 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getIssuesFromTextSearchWithLimit *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit, sizeof(struct ns4__getIssuesFromTextSearchWithLimit), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getIssuesFromTextSearchWithLimit(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap_flag__in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_in2, "xsd:int"))
				{	soap_flag__in2--;
					continue;
				}
			if (soap_flag__in3 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_in3, "xsd:int"))
				{	soap_flag__in3--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getIssuesFromTextSearchWithLimit *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit, 0, sizeof(struct ns4__getIssuesFromTextSearchWithLimit), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in2 > 0 || soap_flag__in3 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getIssuesFromTextSearchWithLimit(struct soap *soap, const struct ns4__getIssuesFromTextSearchWithLimit *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit);
	if (soap_out_ns4__getIssuesFromTextSearchWithLimit(soap, tag?tag:"ns4:getIssuesFromTextSearchWithLimit", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getIssuesFromTextSearchWithLimit * SOAP_FMAC4 soap_get_ns4__getIssuesFromTextSearchWithLimit(struct soap *soap, struct ns4__getIssuesFromTextSearchWithLimit *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getIssuesFromTextSearchWithLimit(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getIssuesFromTextSearchWithLimit * SOAP_FMAC2 soap_instantiate_ns4__getIssuesFromTextSearchWithLimit(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getIssuesFromTextSearchWithLimit(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimit, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromTextSearchWithLimit);
		if (size)
			*size = sizeof(struct ns4__getIssuesFromTextSearchWithLimit);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromTextSearchWithLimit[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getIssuesFromTextSearchWithLimit);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getIssuesFromTextSearchWithLimit*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getIssuesFromTextSearchWithLimit(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getIssuesFromTextSearchWithLimit %p -> %p\n", q, p));
	*(struct ns4__getIssuesFromTextSearchWithLimit*)p = *(struct ns4__getIssuesFromTextSearchWithLimit*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getIssuesFromTextSearchWithLimitResponse(struct soap *soap, struct ns4__getIssuesFromTextSearchWithLimitResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getIssuesFromTextSearchWithLimitReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getIssuesFromTextSearchWithLimitResponse(struct soap *soap, const struct ns4__getIssuesFromTextSearchWithLimitResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, &a->_getIssuesFromTextSearchWithLimitReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getIssuesFromTextSearchWithLimitResponse(struct soap *soap, const char *tag, int id, const struct ns4__getIssuesFromTextSearchWithLimitResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, "getIssuesFromTextSearchWithLimitReturn", -1, &a->_getIssuesFromTextSearchWithLimitReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getIssuesFromTextSearchWithLimitResponse * SOAP_FMAC4 soap_in_ns4__getIssuesFromTextSearchWithLimitResponse(struct soap *soap, const char *tag, struct ns4__getIssuesFromTextSearchWithLimitResponse *a, const char *type)
{
	size_t soap_flag__getIssuesFromTextSearchWithLimitReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getIssuesFromTextSearchWithLimitResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse, sizeof(struct ns4__getIssuesFromTextSearchWithLimitResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getIssuesFromTextSearchWithLimitResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getIssuesFromTextSearchWithLimitReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, NULL, &a->_getIssuesFromTextSearchWithLimitReturn, "ns2:RemoteIssue"))
				{	soap_flag__getIssuesFromTextSearchWithLimitReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getIssuesFromTextSearchWithLimitResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse, 0, sizeof(struct ns4__getIssuesFromTextSearchWithLimitResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getIssuesFromTextSearchWithLimitResponse(struct soap *soap, const struct ns4__getIssuesFromTextSearchWithLimitResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse);
	if (soap_out_ns4__getIssuesFromTextSearchWithLimitResponse(soap, tag?tag:"ns4:getIssuesFromTextSearchWithLimitResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getIssuesFromTextSearchWithLimitResponse * SOAP_FMAC4 soap_get_ns4__getIssuesFromTextSearchWithLimitResponse(struct soap *soap, struct ns4__getIssuesFromTextSearchWithLimitResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getIssuesFromTextSearchWithLimitResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getIssuesFromTextSearchWithLimitResponse * SOAP_FMAC2 soap_instantiate_ns4__getIssuesFromTextSearchWithLimitResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getIssuesFromTextSearchWithLimitResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getIssuesFromTextSearchWithLimitResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromTextSearchWithLimitResponse);
		if (size)
			*size = sizeof(struct ns4__getIssuesFromTextSearchWithLimitResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromTextSearchWithLimitResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getIssuesFromTextSearchWithLimitResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getIssuesFromTextSearchWithLimitResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getIssuesFromTextSearchWithLimitResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getIssuesFromTextSearchWithLimitResponse %p -> %p\n", q, p));
	*(struct ns4__getIssuesFromTextSearchWithLimitResponse*)p = *(struct ns4__getIssuesFromTextSearchWithLimitResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getIssuesFromFilterWithLimit(struct soap *soap, struct ns4__getIssuesFromFilterWithLimit *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
	soap_default_int(soap, &a->_in2);
	soap_default_int(soap, &a->_in3);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getIssuesFromFilterWithLimit(struct soap *soap, const struct ns4__getIssuesFromFilterWithLimit *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getIssuesFromFilterWithLimit(struct soap *soap, const char *tag, int id, const struct ns4__getIssuesFromFilterWithLimit *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getIssuesFromFilterWithLimit), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	if (soap_out_int(soap, "in2", -1, &a->_in2, ""))
		return soap->error;
	if (soap_out_int(soap, "in3", -1, &a->_in3, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getIssuesFromFilterWithLimit * SOAP_FMAC4 soap_in_ns4__getIssuesFromFilterWithLimit(struct soap *soap, const char *tag, struct ns4__getIssuesFromFilterWithLimit *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	size_t soap_flag__in2 = 1;
	size_t soap_flag__in3 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getIssuesFromFilterWithLimit *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getIssuesFromFilterWithLimit, sizeof(struct ns4__getIssuesFromFilterWithLimit), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getIssuesFromFilterWithLimit(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap_flag__in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_in2, "xsd:int"))
				{	soap_flag__in2--;
					continue;
				}
			if (soap_flag__in3 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_in3, "xsd:int"))
				{	soap_flag__in3--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getIssuesFromFilterWithLimit *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getIssuesFromFilterWithLimit, 0, sizeof(struct ns4__getIssuesFromFilterWithLimit), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in2 > 0 || soap_flag__in3 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getIssuesFromFilterWithLimit(struct soap *soap, const struct ns4__getIssuesFromFilterWithLimit *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getIssuesFromFilterWithLimit);
	if (soap_out_ns4__getIssuesFromFilterWithLimit(soap, tag?tag:"ns4:getIssuesFromFilterWithLimit", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getIssuesFromFilterWithLimit * SOAP_FMAC4 soap_get_ns4__getIssuesFromFilterWithLimit(struct soap *soap, struct ns4__getIssuesFromFilterWithLimit *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getIssuesFromFilterWithLimit(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getIssuesFromFilterWithLimit * SOAP_FMAC2 soap_instantiate_ns4__getIssuesFromFilterWithLimit(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getIssuesFromFilterWithLimit(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getIssuesFromFilterWithLimit, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromFilterWithLimit);
		if (size)
			*size = sizeof(struct ns4__getIssuesFromFilterWithLimit);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromFilterWithLimit[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getIssuesFromFilterWithLimit);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getIssuesFromFilterWithLimit*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getIssuesFromFilterWithLimit(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getIssuesFromFilterWithLimit %p -> %p\n", q, p));
	*(struct ns4__getIssuesFromFilterWithLimit*)p = *(struct ns4__getIssuesFromFilterWithLimit*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getIssuesFromFilterWithLimitResponse(struct soap *soap, struct ns4__getIssuesFromFilterWithLimitResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getIssuesFromFilterWithLimitReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getIssuesFromFilterWithLimitResponse(struct soap *soap, const struct ns4__getIssuesFromFilterWithLimitResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, &a->_getIssuesFromFilterWithLimitReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getIssuesFromFilterWithLimitResponse(struct soap *soap, const char *tag, int id, const struct ns4__getIssuesFromFilterWithLimitResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, "getIssuesFromFilterWithLimitReturn", -1, &a->_getIssuesFromFilterWithLimitReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getIssuesFromFilterWithLimitResponse * SOAP_FMAC4 soap_in_ns4__getIssuesFromFilterWithLimitResponse(struct soap *soap, const char *tag, struct ns4__getIssuesFromFilterWithLimitResponse *a, const char *type)
{
	size_t soap_flag__getIssuesFromFilterWithLimitReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getIssuesFromFilterWithLimitResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse, sizeof(struct ns4__getIssuesFromFilterWithLimitResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getIssuesFromFilterWithLimitResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getIssuesFromFilterWithLimitReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, NULL, &a->_getIssuesFromFilterWithLimitReturn, "ns2:RemoteIssue"))
				{	soap_flag__getIssuesFromFilterWithLimitReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getIssuesFromFilterWithLimitResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse, 0, sizeof(struct ns4__getIssuesFromFilterWithLimitResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getIssuesFromFilterWithLimitResponse(struct soap *soap, const struct ns4__getIssuesFromFilterWithLimitResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse);
	if (soap_out_ns4__getIssuesFromFilterWithLimitResponse(soap, tag?tag:"ns4:getIssuesFromFilterWithLimitResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getIssuesFromFilterWithLimitResponse * SOAP_FMAC4 soap_get_ns4__getIssuesFromFilterWithLimitResponse(struct soap *soap, struct ns4__getIssuesFromFilterWithLimitResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getIssuesFromFilterWithLimitResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getIssuesFromFilterWithLimitResponse * SOAP_FMAC2 soap_instantiate_ns4__getIssuesFromFilterWithLimitResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getIssuesFromFilterWithLimitResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getIssuesFromFilterWithLimitResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromFilterWithLimitResponse);
		if (size)
			*size = sizeof(struct ns4__getIssuesFromFilterWithLimitResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromFilterWithLimitResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getIssuesFromFilterWithLimitResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getIssuesFromFilterWithLimitResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getIssuesFromFilterWithLimitResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getIssuesFromFilterWithLimitResponse %p -> %p\n", q, p));
	*(struct ns4__getIssuesFromFilterWithLimitResponse*)p = *(struct ns4__getIssuesFromFilterWithLimitResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getIssuesFromFilter(struct soap *soap, struct ns4__getIssuesFromFilter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getIssuesFromFilter(struct soap *soap, const struct ns4__getIssuesFromFilter *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getIssuesFromFilter(struct soap *soap, const char *tag, int id, const struct ns4__getIssuesFromFilter *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getIssuesFromFilter), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getIssuesFromFilter * SOAP_FMAC4 soap_in_ns4__getIssuesFromFilter(struct soap *soap, const char *tag, struct ns4__getIssuesFromFilter *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getIssuesFromFilter *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getIssuesFromFilter, sizeof(struct ns4__getIssuesFromFilter), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getIssuesFromFilter(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getIssuesFromFilter *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getIssuesFromFilter, 0, sizeof(struct ns4__getIssuesFromFilter), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getIssuesFromFilter(struct soap *soap, const struct ns4__getIssuesFromFilter *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getIssuesFromFilter);
	if (soap_out_ns4__getIssuesFromFilter(soap, tag?tag:"ns4:getIssuesFromFilter", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getIssuesFromFilter * SOAP_FMAC4 soap_get_ns4__getIssuesFromFilter(struct soap *soap, struct ns4__getIssuesFromFilter *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getIssuesFromFilter(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getIssuesFromFilter * SOAP_FMAC2 soap_instantiate_ns4__getIssuesFromFilter(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getIssuesFromFilter(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getIssuesFromFilter, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromFilter);
		if (size)
			*size = sizeof(struct ns4__getIssuesFromFilter);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromFilter[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getIssuesFromFilter);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getIssuesFromFilter*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getIssuesFromFilter(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getIssuesFromFilter %p -> %p\n", q, p));
	*(struct ns4__getIssuesFromFilter*)p = *(struct ns4__getIssuesFromFilter*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getIssuesFromFilterResponse(struct soap *soap, struct ns4__getIssuesFromFilterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getIssuesFromFilterReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getIssuesFromFilterResponse(struct soap *soap, const struct ns4__getIssuesFromFilterResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, &a->_getIssuesFromFilterReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getIssuesFromFilterResponse(struct soap *soap, const char *tag, int id, const struct ns4__getIssuesFromFilterResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getIssuesFromFilterResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, "getIssuesFromFilterReturn", -1, &a->_getIssuesFromFilterReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getIssuesFromFilterResponse * SOAP_FMAC4 soap_in_ns4__getIssuesFromFilterResponse(struct soap *soap, const char *tag, struct ns4__getIssuesFromFilterResponse *a, const char *type)
{
	size_t soap_flag__getIssuesFromFilterReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getIssuesFromFilterResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getIssuesFromFilterResponse, sizeof(struct ns4__getIssuesFromFilterResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getIssuesFromFilterResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getIssuesFromFilterReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteIssue(soap, NULL, &a->_getIssuesFromFilterReturn, "ns2:RemoteIssue"))
				{	soap_flag__getIssuesFromFilterReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getIssuesFromFilterResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getIssuesFromFilterResponse, 0, sizeof(struct ns4__getIssuesFromFilterResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getIssuesFromFilterResponse(struct soap *soap, const struct ns4__getIssuesFromFilterResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getIssuesFromFilterResponse);
	if (soap_out_ns4__getIssuesFromFilterResponse(soap, tag?tag:"ns4:getIssuesFromFilterResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getIssuesFromFilterResponse * SOAP_FMAC4 soap_get_ns4__getIssuesFromFilterResponse(struct soap *soap, struct ns4__getIssuesFromFilterResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getIssuesFromFilterResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getIssuesFromFilterResponse * SOAP_FMAC2 soap_instantiate_ns4__getIssuesFromFilterResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getIssuesFromFilterResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getIssuesFromFilterResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromFilterResponse);
		if (size)
			*size = sizeof(struct ns4__getIssuesFromFilterResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getIssuesFromFilterResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getIssuesFromFilterResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getIssuesFromFilterResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getIssuesFromFilterResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getIssuesFromFilterResponse %p -> %p\n", q, p));
	*(struct ns4__getIssuesFromFilterResponse*)p = *(struct ns4__getIssuesFromFilterResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__addVersion(struct soap *soap, struct ns4__addVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
	a->_in2 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__addVersion(struct soap *soap, const struct ns4__addVersion *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
	soap_serialize_PointerTons2__RemoteVersion(soap, &a->_in2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__addVersion(struct soap *soap, const char *tag, int id, const struct ns4__addVersion *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__addVersion), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	if (soap_out_PointerTons2__RemoteVersion(soap, "in2", -1, &a->_in2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__addVersion * SOAP_FMAC4 soap_in_ns4__addVersion(struct soap *soap, const char *tag, struct ns4__addVersion *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	size_t soap_flag__in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__addVersion *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__addVersion, sizeof(struct ns4__addVersion), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__addVersion(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap_flag__in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteVersion(soap, NULL, &a->_in2, "ns2:RemoteVersion"))
				{	soap_flag__in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__addVersion *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__addVersion, 0, sizeof(struct ns4__addVersion), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__addVersion(struct soap *soap, const struct ns4__addVersion *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__addVersion);
	if (soap_out_ns4__addVersion(soap, tag?tag:"ns4:addVersion", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__addVersion * SOAP_FMAC4 soap_get_ns4__addVersion(struct soap *soap, struct ns4__addVersion *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__addVersion(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__addVersion * SOAP_FMAC2 soap_instantiate_ns4__addVersion(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__addVersion(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__addVersion, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__addVersion);
		if (size)
			*size = sizeof(struct ns4__addVersion);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__addVersion[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__addVersion);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__addVersion*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__addVersion(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__addVersion %p -> %p\n", q, p));
	*(struct ns4__addVersion*)p = *(struct ns4__addVersion*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__addVersionResponse(struct soap *soap, struct ns4__addVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_addVersionReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__addVersionResponse(struct soap *soap, const struct ns4__addVersionResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__RemoteVersion(soap, &a->_addVersionReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__addVersionResponse(struct soap *soap, const char *tag, int id, const struct ns4__addVersionResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__addVersionResponse), type))
		return soap->error;
	if (soap_out_PointerTons2__RemoteVersion(soap, "addVersionReturn", -1, &a->_addVersionReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__addVersionResponse * SOAP_FMAC4 soap_in_ns4__addVersionResponse(struct soap *soap, const char *tag, struct ns4__addVersionResponse *a, const char *type)
{
	size_t soap_flag__addVersionReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__addVersionResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__addVersionResponse, sizeof(struct ns4__addVersionResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__addVersionResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__addVersionReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteVersion(soap, NULL, &a->_addVersionReturn, "ns2:RemoteVersion"))
				{	soap_flag__addVersionReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__addVersionResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__addVersionResponse, 0, sizeof(struct ns4__addVersionResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__addVersionResponse(struct soap *soap, const struct ns4__addVersionResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__addVersionResponse);
	if (soap_out_ns4__addVersionResponse(soap, tag?tag:"ns4:addVersionResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__addVersionResponse * SOAP_FMAC4 soap_get_ns4__addVersionResponse(struct soap *soap, struct ns4__addVersionResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__addVersionResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__addVersionResponse * SOAP_FMAC2 soap_instantiate_ns4__addVersionResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__addVersionResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__addVersionResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__addVersionResponse);
		if (size)
			*size = sizeof(struct ns4__addVersionResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__addVersionResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__addVersionResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__addVersionResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__addVersionResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__addVersionResponse %p -> %p\n", q, p));
	*(struct ns4__addVersionResponse*)p = *(struct ns4__addVersionResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getSecuritySchemes(struct soap *soap, struct ns4__getSecuritySchemes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getSecuritySchemes(struct soap *soap, const struct ns4__getSecuritySchemes *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getSecuritySchemes(struct soap *soap, const char *tag, int id, const struct ns4__getSecuritySchemes *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getSecuritySchemes), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getSecuritySchemes * SOAP_FMAC4 soap_in_ns4__getSecuritySchemes(struct soap *soap, const char *tag, struct ns4__getSecuritySchemes *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getSecuritySchemes *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getSecuritySchemes, sizeof(struct ns4__getSecuritySchemes), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getSecuritySchemes(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getSecuritySchemes *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getSecuritySchemes, 0, sizeof(struct ns4__getSecuritySchemes), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getSecuritySchemes(struct soap *soap, const struct ns4__getSecuritySchemes *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getSecuritySchemes);
	if (soap_out_ns4__getSecuritySchemes(soap, tag?tag:"ns4:getSecuritySchemes", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getSecuritySchemes * SOAP_FMAC4 soap_get_ns4__getSecuritySchemes(struct soap *soap, struct ns4__getSecuritySchemes *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getSecuritySchemes(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getSecuritySchemes * SOAP_FMAC2 soap_instantiate_ns4__getSecuritySchemes(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getSecuritySchemes(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getSecuritySchemes, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getSecuritySchemes);
		if (size)
			*size = sizeof(struct ns4__getSecuritySchemes);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getSecuritySchemes[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getSecuritySchemes);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getSecuritySchemes*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getSecuritySchemes(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getSecuritySchemes %p -> %p\n", q, p));
	*(struct ns4__getSecuritySchemes*)p = *(struct ns4__getSecuritySchemes*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getSecuritySchemesResponse(struct soap *soap, struct ns4__getSecuritySchemesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getSecuritySchemesReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getSecuritySchemesResponse(struct soap *soap, const struct ns4__getSecuritySchemesResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteScheme(soap, &a->_getSecuritySchemesReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getSecuritySchemesResponse(struct soap *soap, const char *tag, int id, const struct ns4__getSecuritySchemesResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getSecuritySchemesResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteScheme(soap, "getSecuritySchemesReturn", -1, &a->_getSecuritySchemesReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getSecuritySchemesResponse * SOAP_FMAC4 soap_in_ns4__getSecuritySchemesResponse(struct soap *soap, const char *tag, struct ns4__getSecuritySchemesResponse *a, const char *type)
{
	size_t soap_flag__getSecuritySchemesReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getSecuritySchemesResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getSecuritySchemesResponse, sizeof(struct ns4__getSecuritySchemesResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getSecuritySchemesResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getSecuritySchemesReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteScheme(soap, NULL, &a->_getSecuritySchemesReturn, "ns2:RemoteScheme"))
				{	soap_flag__getSecuritySchemesReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getSecuritySchemesResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getSecuritySchemesResponse, 0, sizeof(struct ns4__getSecuritySchemesResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getSecuritySchemesResponse(struct soap *soap, const struct ns4__getSecuritySchemesResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getSecuritySchemesResponse);
	if (soap_out_ns4__getSecuritySchemesResponse(soap, tag?tag:"ns4:getSecuritySchemesResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getSecuritySchemesResponse * SOAP_FMAC4 soap_get_ns4__getSecuritySchemesResponse(struct soap *soap, struct ns4__getSecuritySchemesResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getSecuritySchemesResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getSecuritySchemesResponse * SOAP_FMAC2 soap_instantiate_ns4__getSecuritySchemesResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getSecuritySchemesResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getSecuritySchemesResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getSecuritySchemesResponse);
		if (size)
			*size = sizeof(struct ns4__getSecuritySchemesResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getSecuritySchemesResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getSecuritySchemesResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getSecuritySchemesResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getSecuritySchemesResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getSecuritySchemesResponse %p -> %p\n", q, p));
	*(struct ns4__getSecuritySchemesResponse*)p = *(struct ns4__getSecuritySchemesResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__createProjectFromObject(struct soap *soap, struct ns4__createProjectFromObject *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	a->_in1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__createProjectFromObject(struct soap *soap, const struct ns4__createProjectFromObject *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_PointerTons2__RemoteProject(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__createProjectFromObject(struct soap *soap, const char *tag, int id, const struct ns4__createProjectFromObject *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__createProjectFromObject), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_PointerTons2__RemoteProject(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__createProjectFromObject * SOAP_FMAC4 soap_in_ns4__createProjectFromObject(struct soap *soap, const char *tag, struct ns4__createProjectFromObject *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__createProjectFromObject *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__createProjectFromObject, sizeof(struct ns4__createProjectFromObject), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__createProjectFromObject(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteProject(soap, NULL, &a->_in1, "ns2:RemoteProject"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__createProjectFromObject *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__createProjectFromObject, 0, sizeof(struct ns4__createProjectFromObject), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__createProjectFromObject(struct soap *soap, const struct ns4__createProjectFromObject *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__createProjectFromObject);
	if (soap_out_ns4__createProjectFromObject(soap, tag?tag:"ns4:createProjectFromObject", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__createProjectFromObject * SOAP_FMAC4 soap_get_ns4__createProjectFromObject(struct soap *soap, struct ns4__createProjectFromObject *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__createProjectFromObject(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__createProjectFromObject * SOAP_FMAC2 soap_instantiate_ns4__createProjectFromObject(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__createProjectFromObject(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__createProjectFromObject, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__createProjectFromObject);
		if (size)
			*size = sizeof(struct ns4__createProjectFromObject);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__createProjectFromObject[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__createProjectFromObject);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__createProjectFromObject*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__createProjectFromObject(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__createProjectFromObject %p -> %p\n", q, p));
	*(struct ns4__createProjectFromObject*)p = *(struct ns4__createProjectFromObject*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__createProjectFromObjectResponse(struct soap *soap, struct ns4__createProjectFromObjectResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_createProjectFromObjectReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__createProjectFromObjectResponse(struct soap *soap, const struct ns4__createProjectFromObjectResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__RemoteProject(soap, &a->_createProjectFromObjectReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__createProjectFromObjectResponse(struct soap *soap, const char *tag, int id, const struct ns4__createProjectFromObjectResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__createProjectFromObjectResponse), type))
		return soap->error;
	if (soap_out_PointerTons2__RemoteProject(soap, "createProjectFromObjectReturn", -1, &a->_createProjectFromObjectReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__createProjectFromObjectResponse * SOAP_FMAC4 soap_in_ns4__createProjectFromObjectResponse(struct soap *soap, const char *tag, struct ns4__createProjectFromObjectResponse *a, const char *type)
{
	size_t soap_flag__createProjectFromObjectReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__createProjectFromObjectResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__createProjectFromObjectResponse, sizeof(struct ns4__createProjectFromObjectResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__createProjectFromObjectResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__createProjectFromObjectReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteProject(soap, NULL, &a->_createProjectFromObjectReturn, "ns2:RemoteProject"))
				{	soap_flag__createProjectFromObjectReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__createProjectFromObjectResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__createProjectFromObjectResponse, 0, sizeof(struct ns4__createProjectFromObjectResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__createProjectFromObjectResponse(struct soap *soap, const struct ns4__createProjectFromObjectResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__createProjectFromObjectResponse);
	if (soap_out_ns4__createProjectFromObjectResponse(soap, tag?tag:"ns4:createProjectFromObjectResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__createProjectFromObjectResponse * SOAP_FMAC4 soap_get_ns4__createProjectFromObjectResponse(struct soap *soap, struct ns4__createProjectFromObjectResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__createProjectFromObjectResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__createProjectFromObjectResponse * SOAP_FMAC2 soap_instantiate_ns4__createProjectFromObjectResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__createProjectFromObjectResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__createProjectFromObjectResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__createProjectFromObjectResponse);
		if (size)
			*size = sizeof(struct ns4__createProjectFromObjectResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__createProjectFromObjectResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__createProjectFromObjectResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__createProjectFromObjectResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__createProjectFromObjectResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__createProjectFromObjectResponse %p -> %p\n", q, p));
	*(struct ns4__createProjectFromObjectResponse*)p = *(struct ns4__createProjectFromObjectResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__addBase64EncodedAttachmentsToIssue(struct soap *soap, struct ns4__addBase64EncodedAttachmentsToIssue *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
	a->_in2 = NULL;
	a->_in3 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__addBase64EncodedAttachmentsToIssue(struct soap *soap, const struct ns4__addBase64EncodedAttachmentsToIssue *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREstring(soap, &a->_in2);
	soap_serialize_PointerToArrayOf_USCORExsd_USCOREstring(soap, &a->_in3);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__addBase64EncodedAttachmentsToIssue(struct soap *soap, const char *tag, int id, const struct ns4__addBase64EncodedAttachmentsToIssue *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREstring(soap, "in2", -1, &a->_in2, ""))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCORExsd_USCOREstring(soap, "in3", -1, &a->_in3, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__addBase64EncodedAttachmentsToIssue * SOAP_FMAC4 soap_in_ns4__addBase64EncodedAttachmentsToIssue(struct soap *soap, const char *tag, struct ns4__addBase64EncodedAttachmentsToIssue *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	size_t soap_flag__in2 = 1;
	size_t soap_flag__in3 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__addBase64EncodedAttachmentsToIssue *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue, sizeof(struct ns4__addBase64EncodedAttachmentsToIssue), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__addBase64EncodedAttachmentsToIssue(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap_flag__in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREstring(soap, NULL, &a->_in2, "xsd:string"))
				{	soap_flag__in2--;
					continue;
				}
			if (soap_flag__in3 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCORExsd_USCOREstring(soap, NULL, &a->_in3, "xsd:string"))
				{	soap_flag__in3--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__addBase64EncodedAttachmentsToIssue *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue, 0, sizeof(struct ns4__addBase64EncodedAttachmentsToIssue), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__addBase64EncodedAttachmentsToIssue(struct soap *soap, const struct ns4__addBase64EncodedAttachmentsToIssue *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue);
	if (soap_out_ns4__addBase64EncodedAttachmentsToIssue(soap, tag?tag:"ns4:addBase64EncodedAttachmentsToIssue", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__addBase64EncodedAttachmentsToIssue * SOAP_FMAC4 soap_get_ns4__addBase64EncodedAttachmentsToIssue(struct soap *soap, struct ns4__addBase64EncodedAttachmentsToIssue *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__addBase64EncodedAttachmentsToIssue(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__addBase64EncodedAttachmentsToIssue * SOAP_FMAC2 soap_instantiate_ns4__addBase64EncodedAttachmentsToIssue(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__addBase64EncodedAttachmentsToIssue(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssue, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__addBase64EncodedAttachmentsToIssue);
		if (size)
			*size = sizeof(struct ns4__addBase64EncodedAttachmentsToIssue);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__addBase64EncodedAttachmentsToIssue[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__addBase64EncodedAttachmentsToIssue);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__addBase64EncodedAttachmentsToIssue*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__addBase64EncodedAttachmentsToIssue(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__addBase64EncodedAttachmentsToIssue %p -> %p\n", q, p));
	*(struct ns4__addBase64EncodedAttachmentsToIssue*)p = *(struct ns4__addBase64EncodedAttachmentsToIssue*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__addBase64EncodedAttachmentsToIssueResponse(struct soap *soap, struct ns4__addBase64EncodedAttachmentsToIssueResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_bool(soap, &a->_addBase64EncodedAttachmentsToIssueReturn);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__addBase64EncodedAttachmentsToIssueResponse(struct soap *soap, const struct ns4__addBase64EncodedAttachmentsToIssueResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__addBase64EncodedAttachmentsToIssueResponse(struct soap *soap, const char *tag, int id, const struct ns4__addBase64EncodedAttachmentsToIssueResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse), type))
		return soap->error;
	if (soap_out_bool(soap, "addBase64EncodedAttachmentsToIssueReturn", -1, &a->_addBase64EncodedAttachmentsToIssueReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__addBase64EncodedAttachmentsToIssueResponse * SOAP_FMAC4 soap_in_ns4__addBase64EncodedAttachmentsToIssueResponse(struct soap *soap, const char *tag, struct ns4__addBase64EncodedAttachmentsToIssueResponse *a, const char *type)
{
	size_t soap_flag__addBase64EncodedAttachmentsToIssueReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__addBase64EncodedAttachmentsToIssueResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse, sizeof(struct ns4__addBase64EncodedAttachmentsToIssueResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__addBase64EncodedAttachmentsToIssueResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__addBase64EncodedAttachmentsToIssueReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_bool(soap, NULL, &a->_addBase64EncodedAttachmentsToIssueReturn, "xsd:boolean"))
				{	soap_flag__addBase64EncodedAttachmentsToIssueReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__addBase64EncodedAttachmentsToIssueResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse, 0, sizeof(struct ns4__addBase64EncodedAttachmentsToIssueResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__addBase64EncodedAttachmentsToIssueReturn > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__addBase64EncodedAttachmentsToIssueResponse(struct soap *soap, const struct ns4__addBase64EncodedAttachmentsToIssueResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse);
	if (soap_out_ns4__addBase64EncodedAttachmentsToIssueResponse(soap, tag?tag:"ns4:addBase64EncodedAttachmentsToIssueResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__addBase64EncodedAttachmentsToIssueResponse * SOAP_FMAC4 soap_get_ns4__addBase64EncodedAttachmentsToIssueResponse(struct soap *soap, struct ns4__addBase64EncodedAttachmentsToIssueResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__addBase64EncodedAttachmentsToIssueResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__addBase64EncodedAttachmentsToIssueResponse * SOAP_FMAC2 soap_instantiate_ns4__addBase64EncodedAttachmentsToIssueResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__addBase64EncodedAttachmentsToIssueResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__addBase64EncodedAttachmentsToIssueResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__addBase64EncodedAttachmentsToIssueResponse);
		if (size)
			*size = sizeof(struct ns4__addBase64EncodedAttachmentsToIssueResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__addBase64EncodedAttachmentsToIssueResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__addBase64EncodedAttachmentsToIssueResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__addBase64EncodedAttachmentsToIssueResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__addBase64EncodedAttachmentsToIssueResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__addBase64EncodedAttachmentsToIssueResponse %p -> %p\n", q, p));
	*(struct ns4__addBase64EncodedAttachmentsToIssueResponse*)p = *(struct ns4__addBase64EncodedAttachmentsToIssueResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getSavedFilters(struct soap *soap, struct ns4__getSavedFilters *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getSavedFilters(struct soap *soap, const struct ns4__getSavedFilters *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getSavedFilters(struct soap *soap, const char *tag, int id, const struct ns4__getSavedFilters *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getSavedFilters), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getSavedFilters * SOAP_FMAC4 soap_in_ns4__getSavedFilters(struct soap *soap, const char *tag, struct ns4__getSavedFilters *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getSavedFilters *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getSavedFilters, sizeof(struct ns4__getSavedFilters), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getSavedFilters(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getSavedFilters *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getSavedFilters, 0, sizeof(struct ns4__getSavedFilters), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getSavedFilters(struct soap *soap, const struct ns4__getSavedFilters *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getSavedFilters);
	if (soap_out_ns4__getSavedFilters(soap, tag?tag:"ns4:getSavedFilters", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getSavedFilters * SOAP_FMAC4 soap_get_ns4__getSavedFilters(struct soap *soap, struct ns4__getSavedFilters *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getSavedFilters(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getSavedFilters * SOAP_FMAC2 soap_instantiate_ns4__getSavedFilters(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getSavedFilters(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getSavedFilters, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getSavedFilters);
		if (size)
			*size = sizeof(struct ns4__getSavedFilters);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getSavedFilters[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getSavedFilters);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getSavedFilters*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getSavedFilters(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getSavedFilters %p -> %p\n", q, p));
	*(struct ns4__getSavedFilters*)p = *(struct ns4__getSavedFilters*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getSavedFiltersResponse(struct soap *soap, struct ns4__getSavedFiltersResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_getSavedFiltersReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getSavedFiltersResponse(struct soap *soap, const struct ns4__getSavedFiltersResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerToArrayOf_USCOREtns1_USCORERemoteFilter(soap, &a->_getSavedFiltersReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getSavedFiltersResponse(struct soap *soap, const char *tag, int id, const struct ns4__getSavedFiltersResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getSavedFiltersResponse), type))
		return soap->error;
	if (soap_out_PointerToArrayOf_USCOREtns1_USCORERemoteFilter(soap, "getSavedFiltersReturn", -1, &a->_getSavedFiltersReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getSavedFiltersResponse * SOAP_FMAC4 soap_in_ns4__getSavedFiltersResponse(struct soap *soap, const char *tag, struct ns4__getSavedFiltersResponse *a, const char *type)
{
	size_t soap_flag__getSavedFiltersReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getSavedFiltersResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getSavedFiltersResponse, sizeof(struct ns4__getSavedFiltersResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getSavedFiltersResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__getSavedFiltersReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerToArrayOf_USCOREtns1_USCORERemoteFilter(soap, NULL, &a->_getSavedFiltersReturn, "ns2:RemoteFilter"))
				{	soap_flag__getSavedFiltersReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getSavedFiltersResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getSavedFiltersResponse, 0, sizeof(struct ns4__getSavedFiltersResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__getSavedFiltersResponse(struct soap *soap, const struct ns4__getSavedFiltersResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__getSavedFiltersResponse);
	if (soap_out_ns4__getSavedFiltersResponse(soap, tag?tag:"ns4:getSavedFiltersResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__getSavedFiltersResponse * SOAP_FMAC4 soap_get_ns4__getSavedFiltersResponse(struct soap *soap, struct ns4__getSavedFiltersResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__getSavedFiltersResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__getSavedFiltersResponse * SOAP_FMAC2 soap_instantiate_ns4__getSavedFiltersResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__getSavedFiltersResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__getSavedFiltersResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__getSavedFiltersResponse);
		if (size)
			*size = sizeof(struct ns4__getSavedFiltersResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__getSavedFiltersResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__getSavedFiltersResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__getSavedFiltersResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__getSavedFiltersResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__getSavedFiltersResponse %p -> %p\n", q, p));
	*(struct ns4__getSavedFiltersResponse*)p = *(struct ns4__getSavedFiltersResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__refreshCustomFields(struct soap *soap, struct ns4__refreshCustomFields *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__refreshCustomFields(struct soap *soap, const struct ns4__refreshCustomFields *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__refreshCustomFields(struct soap *soap, const char *tag, int id, const struct ns4__refreshCustomFields *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__refreshCustomFields), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__refreshCustomFields * SOAP_FMAC4 soap_in_ns4__refreshCustomFields(struct soap *soap, const char *tag, struct ns4__refreshCustomFields *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__refreshCustomFields *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__refreshCustomFields, sizeof(struct ns4__refreshCustomFields), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__refreshCustomFields(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__refreshCustomFields *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__refreshCustomFields, 0, sizeof(struct ns4__refreshCustomFields), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__refreshCustomFields(struct soap *soap, const struct ns4__refreshCustomFields *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__refreshCustomFields);
	if (soap_out_ns4__refreshCustomFields(soap, tag?tag:"ns4:refreshCustomFields", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__refreshCustomFields * SOAP_FMAC4 soap_get_ns4__refreshCustomFields(struct soap *soap, struct ns4__refreshCustomFields *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__refreshCustomFields(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__refreshCustomFields * SOAP_FMAC2 soap_instantiate_ns4__refreshCustomFields(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__refreshCustomFields(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__refreshCustomFields, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__refreshCustomFields);
		if (size)
			*size = sizeof(struct ns4__refreshCustomFields);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__refreshCustomFields[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__refreshCustomFields);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__refreshCustomFields*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__refreshCustomFields(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__refreshCustomFields %p -> %p\n", q, p));
	*(struct ns4__refreshCustomFields*)p = *(struct ns4__refreshCustomFields*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__refreshCustomFieldsResponse(struct soap *soap, struct ns4__refreshCustomFieldsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__refreshCustomFieldsResponse(struct soap *soap, const struct ns4__refreshCustomFieldsResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__refreshCustomFieldsResponse(struct soap *soap, const char *tag, int id, const struct ns4__refreshCustomFieldsResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__refreshCustomFieldsResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__refreshCustomFieldsResponse * SOAP_FMAC4 soap_in_ns4__refreshCustomFieldsResponse(struct soap *soap, const char *tag, struct ns4__refreshCustomFieldsResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__refreshCustomFieldsResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__refreshCustomFieldsResponse, sizeof(struct ns4__refreshCustomFieldsResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__refreshCustomFieldsResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__refreshCustomFieldsResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__refreshCustomFieldsResponse, 0, sizeof(struct ns4__refreshCustomFieldsResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__refreshCustomFieldsResponse(struct soap *soap, const struct ns4__refreshCustomFieldsResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__refreshCustomFieldsResponse);
	if (soap_out_ns4__refreshCustomFieldsResponse(soap, tag?tag:"ns4:refreshCustomFieldsResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__refreshCustomFieldsResponse * SOAP_FMAC4 soap_get_ns4__refreshCustomFieldsResponse(struct soap *soap, struct ns4__refreshCustomFieldsResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__refreshCustomFieldsResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__refreshCustomFieldsResponse * SOAP_FMAC2 soap_instantiate_ns4__refreshCustomFieldsResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__refreshCustomFieldsResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__refreshCustomFieldsResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__refreshCustomFieldsResponse);
		if (size)
			*size = sizeof(struct ns4__refreshCustomFieldsResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__refreshCustomFieldsResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__refreshCustomFieldsResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__refreshCustomFieldsResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__refreshCustomFieldsResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__refreshCustomFieldsResponse %p -> %p\n", q, p));
	*(struct ns4__refreshCustomFieldsResponse*)p = *(struct ns4__refreshCustomFieldsResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__deleteGroup(struct soap *soap, struct ns4__deleteGroup *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
	soap_default_string(soap, &a->_in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__deleteGroup(struct soap *soap, const struct ns4__deleteGroup *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
	soap_serialize_string(soap, &a->_in2);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__deleteGroup(struct soap *soap, const char *tag, int id, const struct ns4__deleteGroup *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__deleteGroup), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	if (soap_out_string(soap, "in2", -1, &a->_in2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__deleteGroup * SOAP_FMAC4 soap_in_ns4__deleteGroup(struct soap *soap, const char *tag, struct ns4__deleteGroup *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	size_t soap_flag__in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__deleteGroup *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__deleteGroup, sizeof(struct ns4__deleteGroup), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__deleteGroup(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap_flag__in2 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in2, "xsd:string"))
				{	soap_flag__in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__deleteGroup *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__deleteGroup, 0, sizeof(struct ns4__deleteGroup), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__deleteGroup(struct soap *soap, const struct ns4__deleteGroup *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__deleteGroup);
	if (soap_out_ns4__deleteGroup(soap, tag?tag:"ns4:deleteGroup", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__deleteGroup * SOAP_FMAC4 soap_get_ns4__deleteGroup(struct soap *soap, struct ns4__deleteGroup *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__deleteGroup(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__deleteGroup * SOAP_FMAC2 soap_instantiate_ns4__deleteGroup(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__deleteGroup(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__deleteGroup, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__deleteGroup);
		if (size)
			*size = sizeof(struct ns4__deleteGroup);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__deleteGroup[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__deleteGroup);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__deleteGroup*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__deleteGroup(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__deleteGroup %p -> %p\n", q, p));
	*(struct ns4__deleteGroup*)p = *(struct ns4__deleteGroup*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__deleteGroupResponse(struct soap *soap, struct ns4__deleteGroupResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__deleteGroupResponse(struct soap *soap, const struct ns4__deleteGroupResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__deleteGroupResponse(struct soap *soap, const char *tag, int id, const struct ns4__deleteGroupResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__deleteGroupResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__deleteGroupResponse * SOAP_FMAC4 soap_in_ns4__deleteGroupResponse(struct soap *soap, const char *tag, struct ns4__deleteGroupResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__deleteGroupResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__deleteGroupResponse, sizeof(struct ns4__deleteGroupResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__deleteGroupResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__deleteGroupResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__deleteGroupResponse, 0, sizeof(struct ns4__deleteGroupResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__deleteGroupResponse(struct soap *soap, const struct ns4__deleteGroupResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__deleteGroupResponse);
	if (soap_out_ns4__deleteGroupResponse(soap, tag?tag:"ns4:deleteGroupResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__deleteGroupResponse * SOAP_FMAC4 soap_get_ns4__deleteGroupResponse(struct soap *soap, struct ns4__deleteGroupResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__deleteGroupResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__deleteGroupResponse * SOAP_FMAC2 soap_instantiate_ns4__deleteGroupResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__deleteGroupResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__deleteGroupResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__deleteGroupResponse);
		if (size)
			*size = sizeof(struct ns4__deleteGroupResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__deleteGroupResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__deleteGroupResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__deleteGroupResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__deleteGroupResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__deleteGroupResponse %p -> %p\n", q, p));
	*(struct ns4__deleteGroupResponse*)p = *(struct ns4__deleteGroupResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__updateGroup(struct soap *soap, struct ns4__updateGroup *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	a->_in1 = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__updateGroup(struct soap *soap, const struct ns4__updateGroup *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_PointerTons2__RemoteGroup(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__updateGroup(struct soap *soap, const char *tag, int id, const struct ns4__updateGroup *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__updateGroup), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_PointerTons2__RemoteGroup(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__updateGroup * SOAP_FMAC4 soap_in_ns4__updateGroup(struct soap *soap, const char *tag, struct ns4__updateGroup *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__updateGroup *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__updateGroup, sizeof(struct ns4__updateGroup), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__updateGroup(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteGroup(soap, NULL, &a->_in1, "ns2:RemoteGroup"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__updateGroup *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__updateGroup, 0, sizeof(struct ns4__updateGroup), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__updateGroup(struct soap *soap, const struct ns4__updateGroup *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__updateGroup);
	if (soap_out_ns4__updateGroup(soap, tag?tag:"ns4:updateGroup", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__updateGroup * SOAP_FMAC4 soap_get_ns4__updateGroup(struct soap *soap, struct ns4__updateGroup *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__updateGroup(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__updateGroup * SOAP_FMAC2 soap_instantiate_ns4__updateGroup(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__updateGroup(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__updateGroup, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__updateGroup);
		if (size)
			*size = sizeof(struct ns4__updateGroup);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__updateGroup[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__updateGroup);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__updateGroup*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__updateGroup(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__updateGroup %p -> %p\n", q, p));
	*(struct ns4__updateGroup*)p = *(struct ns4__updateGroup*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__updateGroupResponse(struct soap *soap, struct ns4__updateGroupResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	a->_updateGroupReturn = NULL;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__updateGroupResponse(struct soap *soap, const struct ns4__updateGroupResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_PointerTons2__RemoteGroup(soap, &a->_updateGroupReturn);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__updateGroupResponse(struct soap *soap, const char *tag, int id, const struct ns4__updateGroupResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__updateGroupResponse), type))
		return soap->error;
	if (soap_out_PointerTons2__RemoteGroup(soap, "updateGroupReturn", -1, &a->_updateGroupReturn, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__updateGroupResponse * SOAP_FMAC4 soap_in_ns4__updateGroupResponse(struct soap *soap, const char *tag, struct ns4__updateGroupResponse *a, const char *type)
{
	size_t soap_flag__updateGroupReturn = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__updateGroupResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__updateGroupResponse, sizeof(struct ns4__updateGroupResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__updateGroupResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__updateGroupReturn && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_PointerTons2__RemoteGroup(soap, NULL, &a->_updateGroupReturn, "ns2:RemoteGroup"))
				{	soap_flag__updateGroupReturn--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__updateGroupResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__updateGroupResponse, 0, sizeof(struct ns4__updateGroupResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__updateGroupResponse(struct soap *soap, const struct ns4__updateGroupResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__updateGroupResponse);
	if (soap_out_ns4__updateGroupResponse(soap, tag?tag:"ns4:updateGroupResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__updateGroupResponse * SOAP_FMAC4 soap_get_ns4__updateGroupResponse(struct soap *soap, struct ns4__updateGroupResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__updateGroupResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__updateGroupResponse * SOAP_FMAC2 soap_instantiate_ns4__updateGroupResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__updateGroupResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__updateGroupResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__updateGroupResponse);
		if (size)
			*size = sizeof(struct ns4__updateGroupResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__updateGroupResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__updateGroupResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__updateGroupResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__updateGroupResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__updateGroupResponse %p -> %p\n", q, p));
	*(struct ns4__updateGroupResponse*)p = *(struct ns4__updateGroupResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__deleteUser(struct soap *soap, struct ns4__deleteUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__deleteUser(struct soap *soap, const struct ns4__deleteUser *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__deleteUser(struct soap *soap, const char *tag, int id, const struct ns4__deleteUser *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__deleteUser), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__deleteUser * SOAP_FMAC4 soap_in_ns4__deleteUser(struct soap *soap, const char *tag, struct ns4__deleteUser *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__deleteUser *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__deleteUser, sizeof(struct ns4__deleteUser), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__deleteUser(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__deleteUser *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__deleteUser, 0, sizeof(struct ns4__deleteUser), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__deleteUser(struct soap *soap, const struct ns4__deleteUser *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__deleteUser);
	if (soap_out_ns4__deleteUser(soap, tag?tag:"ns4:deleteUser", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__deleteUser * SOAP_FMAC4 soap_get_ns4__deleteUser(struct soap *soap, struct ns4__deleteUser *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__deleteUser(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__deleteUser * SOAP_FMAC2 soap_instantiate_ns4__deleteUser(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__deleteUser(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__deleteUser, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__deleteUser);
		if (size)
			*size = sizeof(struct ns4__deleteUser);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__deleteUser[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__deleteUser);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__deleteUser*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__deleteUser(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__deleteUser %p -> %p\n", q, p));
	*(struct ns4__deleteUser*)p = *(struct ns4__deleteUser*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__deleteUserResponse(struct soap *soap, struct ns4__deleteUserResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__deleteUserResponse(struct soap *soap, const struct ns4__deleteUserResponse *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__deleteUserResponse(struct soap *soap, const char *tag, int id, const struct ns4__deleteUserResponse *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__deleteUserResponse), type))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__deleteUserResponse * SOAP_FMAC4 soap_in_ns4__deleteUserResponse(struct soap *soap, const char *tag, struct ns4__deleteUserResponse *a, const char *type)
{
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__deleteUserResponse *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__deleteUserResponse, sizeof(struct ns4__deleteUserResponse), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__deleteUserResponse(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__deleteUserResponse *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__deleteUserResponse, 0, sizeof(struct ns4__deleteUserResponse), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 soap_put_ns4__deleteUserResponse(struct soap *soap, const struct ns4__deleteUserResponse *a, const char *tag, const char *type)
{
	register int id = soap_embed(soap, (void*)a, NULL, 0, tag, SOAP_TYPE_ns4__deleteUserResponse);
	if (soap_out_ns4__deleteUserResponse(soap, tag?tag:"ns4:deleteUserResponse", id, a, type))
		return soap->error;
	return soap_putindependent(soap);
}

SOAP_FMAC3 struct ns4__deleteUserResponse * SOAP_FMAC4 soap_get_ns4__deleteUserResponse(struct soap *soap, struct ns4__deleteUserResponse *p, const char *tag, const char *type)
{
	if ((p = soap_in_ns4__deleteUserResponse(soap, tag, p, type)))
		if (soap_getindependent(soap))
			return NULL;
	return p;
}

SOAP_FMAC1 struct ns4__deleteUserResponse * SOAP_FMAC2 soap_instantiate_ns4__deleteUserResponse(struct soap *soap, int n, const char *type, const char *arrayType, size_t *size)
{
	(void)type; (void)arrayType; /* appease -Wall -Werror */
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "soap_instantiate_ns4__deleteUserResponse(%d, %s, %s)\n", n, type?type:"", arrayType?arrayType:""));
	struct soap_clist *cp = soap_link(soap, NULL, SOAP_TYPE_ns4__deleteUserResponse, n, soap_fdelete);
	if (!cp)
		return NULL;
	if (n < 0)
	{	cp->ptr = (void*)new (struct ns4__deleteUserResponse);
		if (size)
			*size = sizeof(struct ns4__deleteUserResponse);
	}
	else
	{	cp->ptr = (void*)new (struct ns4__deleteUserResponse[n]);
		if (!cp->ptr)
		{	soap->error = SOAP_EOM;
			return NULL;
		}
		if (size)
			*size = n * sizeof(struct ns4__deleteUserResponse);
	}
		DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Instantiated location=%p\n", cp->ptr));
	return (struct ns4__deleteUserResponse*)cp->ptr;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_copy_ns4__deleteUserResponse(struct soap *soap, int st, int tt, void *p, size_t len, const void *q, size_t n)
{
	DBGLOG(TEST, SOAP_MESSAGE(fdebug, "Copying struct ns4__deleteUserResponse %p -> %p\n", q, p));
	*(struct ns4__deleteUserResponse*)p = *(struct ns4__deleteUserResponse*)q;
}

SOAP_FMAC3 void SOAP_FMAC4 soap_default_ns4__getIssuesFromJqlSearch(struct soap *soap, struct ns4__getIssuesFromJqlSearch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_default_string(soap, &a->_in0);
	soap_default_string(soap, &a->_in1);
	soap_default_int(soap, &a->_in2);
}

SOAP_FMAC3 void SOAP_FMAC4 soap_serialize_ns4__getIssuesFromJqlSearch(struct soap *soap, const struct ns4__getIssuesFromJqlSearch *a)
{
	(void)soap; (void)a; /* appease -Wall -Werror */
	soap_serialize_string(soap, &a->_in0);
	soap_serialize_string(soap, &a->_in1);
}

SOAP_FMAC3 int SOAP_FMAC4 soap_out_ns4__getIssuesFromJqlSearch(struct soap *soap, const char *tag, int id, const struct ns4__getIssuesFromJqlSearch *a, const char *type)
{
	if (soap_element_begin_out(soap, tag, soap_embedded_id(soap, id, a, SOAP_TYPE_ns4__getIssuesFromJqlSearch), type))
		return soap->error;
	if (soap_out_string(soap, "in0", -1, &a->_in0, ""))
		return soap->error;
	if (soap_out_string(soap, "in1", -1, &a->_in1, ""))
		return soap->error;
	if (soap_out_int(soap, "in2", -1, &a->_in2, ""))
		return soap->error;
	return soap_element_end_out(soap, tag);
}

SOAP_FMAC3 struct ns4__getIssuesFromJqlSearch * SOAP_FMAC4 soap_in_ns4__getIssuesFromJqlSearch(struct soap *soap, const char *tag, struct ns4__getIssuesFromJqlSearch *a, const char *type)
{
	size_t soap_flag__in0 = 1;
	size_t soap_flag__in1 = 1;
	size_t soap_flag__in2 = 1;
	if (soap_element_begin_in(soap, tag, 0, type))
		return NULL;
	a = (struct ns4__getIssuesFromJqlSearch *)soap_id_enter(soap, soap->id, a, SOAP_TYPE_ns4__getIssuesFromJqlSearch, sizeof(struct ns4__getIssuesFromJqlSearch), 0, NULL, NULL, NULL);
	if (!a)
		return NULL;
	soap_default_ns4__getIssuesFromJqlSearch(soap, a);
	if (soap->body && !*soap->href)
	{
		for (;;)
		{	soap->error = SOAP_TAG_MISMATCH;
			if (soap_flag__in0 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in0, "xsd:string"))
				{	soap_flag__in0--;
					continue;
				}
			if (soap_flag__in1 && (soap->error == SOAP_TAG_MISMATCH || soap->error == SOAP_NO_TAG))
				if (soap_in_string(soap, NULL, &a->_in1, "xsd:string"))
				{	soap_flag__in1--;
					continue;
				}
			if (soap_flag__in2 && soap->error == SOAP_TAG_MISMATCH)
				if (soap_in_int(soap, NULL, &a->_in2, "xsd:int"))
				{	soap_flag__in2--;
					continue;
				}
			if (soap->error == SOAP_TAG_MISMATCH)
				soap->error = soap_ignore_element(soap);
			if (soap->error == SOAP_NO_TAG)
				break;
			if (soap->error)
				return NULL;
		}
		if (soap_element_end_in(soap, tag))
			return NULL;
	}
	else
	{	a = (struct ns4__getIssuesFromJqlSearch *)soap_id_forward(soap, soap->href, (void*)a, 0, SOAP_TYPE_ns4__getIssuesFromJqlSearch, 0, sizeof(struct ns4__getIssuesFromJqlSearch), 0, NULL);
		if (soap->body && soap_element_end_in(soap, tag))
			return NULL;
	}
	if ((soap->mode & SOAP_XML_STRICT) && (soap_flag__in2 > 0))
	{	soap->error = SOAP_OCCURS;
		return NULL;
	}
	return a;
}

SOAP_FMAC3 int SOAP_FMAC4 