#ifndef __MATHHELPERS_H__
#define __MATHHELPERS_H__

#include <float.h>

namespace MathHelpers
{
	inline unsigned int EnableFloatingPointExceptions(unsigned int mask)
	{
		_clearfp();
		unsigned int oldMask;
		_controlfp_s(&oldMask, 0, 0);
		unsigned int newMask;
		_controlfp_s(&newMask, ~mask, _MCW_EM);
		return ~oldMask;
	}

	class AutoFloatingPointExceptions
	{
	public:
		AutoFloatingPointExceptions(const unsigned int mask)
			: m_mask(EnableFloatingPointExceptions(mask))
		{
		}

		~AutoFloatingPointExceptions()
		{
			EnableFloatingPointExceptions(m_mask);
		}

	private:
		unsigned int m_mask;
	};
}

#endif


