#ifndef __CRYSIMPLEJOB__
#define __CRYSIMPLEJOB__

#include <vector>

class TiXmlDocument;

enum ECrySimpleJobState
{
	ECSJS_NONE,
	ECSJS_DONE					=	1,					//this is checked on client side, don't change!
	ECSJS_JOBNOTFOUND,
	ECSJS_ERROR,
	ECSJS_CACHEHIT,
};

class CCrySimpleJob
{
	ECrySimpleJobState		m_State;
	uint32_t							m_RequestIP;
	static volatile long	m_GlobalRequestNumber;
	std::string						m_Error;

protected:
	virtual bool					Execute(const std::string& rCmd,std::string &outError);
public:
												CCrySimpleJob(uint32_t requestIP);
	virtual								~CCrySimpleJob();

	void									Error(const std::string& rError)
												{
													m_State=ECSJS_ERROR;
													m_Error=rError;
													CrySimple_ERROR(rError);
												}
	const std::string&		Error()const{return m_Error;}
	void									State(ECrySimpleJobState S){if(m_State!=ECSJS_ERROR)m_State=S;}
	ECrySimpleJobState		State()const{return m_State;}
	const uint32_t&				RequestIP()const{return m_RequestIP;}
	volatile long					GlobalRequestNumber()const{return m_GlobalRequestNumber;}
};

#endif
