#include "../StdTypes.hpp"
#include "../Error.hpp"
#include "../STLHelper.hpp"
#include "../Common.h"
#include "../tinyxml/tinyxml.h"
#include "CrySimpleJobCache.hpp"
#include "CrySimpleCache.hpp"

CCrySimpleJobCache::CCrySimpleJobCache(uint32_t requestIP,std::vector<uint8_t>& rVec,size_t Size):
CCrySimpleJob(requestIP),
m_HashID(CSTLHelper::Hash(rVec,Size))
{
	if(CCrySimpleCache::Instance().Find(m_HashID,rVec))
	{
		State(ECSJS_CACHEHIT);
		printf( "\r%d",GlobalRequestNumber() );
	}
}
