#include "../StdTypes.hpp"
#include "../Error.hpp"
#include "../STLHelper.hpp"
#include "../Common.h"
#include "../tinyxml/tinyxml.h"
#include "CrySimpleJobRequest.hpp"
#include "ShaderList.hpp"

CCrySimpleJobRequest::CCrySimpleJobRequest(uint32_t requestIP,const TiXmlElement* pElement):
CCrySimpleJob(requestIP)
{
	const char* pPlatform						= pElement->Attribute("Platform");
	const char* pShaderRequestLine	=	pElement->Attribute("ShaderRequest");
	if(!pPlatform)
	{
		Error("Missing Platform for shader request");
		return;
	}
	if(!pShaderRequestLine)
	{
		Error("Missing shader request line");
		return;
	}

	std::string ShaderRequestLine(pShaderRequestLine);
	tdEntryVec Toks;
	CSTLHelper::Tokenize(Toks,ShaderRequestLine,";");
	for(size_t a=0,S=Toks.size();a<S;a++)
		CShaderList::Instance().Add(pPlatform,Toks[a].c_str());
		
//	CShaderList::Instance().Add(pPlatform,pShaderRequestLine );
	State(ECSJS_DONE);
}
