//*******************************************************************/
//*                                                                 */
//*                      ADOBE CONFIDENTIAL                         */
//*                   _ _ _ _ _ _ _ _ _ _ _ _ _                     */
//*                                                                 */
//* Copyright 1993 - 1999 Adobe Systems Incorporated                */
//* All Rights Reserved.                                            */
//*                                                                 */
//* NOTICE:  All information contained herein is, and remains the   */
//* property of Adobe Systems Incorporated and its suppliers, if    */
//* any.  The intellectual and technical concepts contained         */
//* herein are proprietary to Adobe Systems Incorporated and its    */
//* suppliers and may be covered by U.S. and Foreign Patents,       */
//* patents in process, and are protected by trade secret or        */
//* copyright law.  Dissemination of this information or            */
//* reproduction of this material is strictly forbidden unless      */
//* prior written permission is obtained from Adobe Systems         */
//* Incorporated.                                                   */
//*                                                                 */
//*******************************************************************/
//-------------------------------------------------------------------
//-------------------------------------------------------------------------------
//
//	File:
//		CryTIFPlugin.r
//
//	Description:
//		This file contains the resource definitions for the
//		File Format module CryTIFPlugin, 
//		which writes a flat file with merged document pixels.
//
//	Use:
//		Format modules are called from the Save, Save as,
//		and Save a copy dialogs.
//
//	Version history:
//		Version 1.0.0	1/1/1993	Created for Photoshop 3.0.
//			Written by Mark Hamburg
//
//		Version 2.0.0	5/27/1996	Updated for Photoshop 4.0.
//			Scripting added.
//
//		Version 2.1.0	6/28/1997	Updated for Photoshop 4.0.1.
//			Updated for new version of Photoshop and projects
//			moved to CodeWarrior Pro.
//
//-------------------------------------------------------------------------------

//-------------------------------------------------------------------------------
//	Definitions -- Required by include files.
//-------------------------------------------------------------------------------

// The About box and resources are created in DialogUtilities.r.
// You can easily override them, if you like.

#define plugInName			"CryTIFPlugin"
#define plugInCopyrightYear	"2004"
#define plugInDescription \
	"Crytek TIF Plugin to provide an image format with properties for the resource compiler."

//-------------------------------------------------------------------------------
//	Definitions -- Required by other resources in this rez file.
//-------------------------------------------------------------------------------

// Dictionary (aete) resources:

#define vendorName			"Crytek"
#define plugInAETEComment 	"CryTIFPlugin file format module"

#define plugInSuiteID		'sdK4'
#define plugInClassID		'simP'
#define plugInEventID		typeNull // must be this

//-------------------------------------------------------------------------------
//	Set up included files for Macintosh and Windows.
//-------------------------------------------------------------------------------

#include "PIDefines.h"

#ifdef __PIMac__
	#include "Types.r"
	#include "SysTypes.r"
	#include "PIGeneral.r"
	#include "PIUtilities.r"
	#include "DialogUtilities.r"
#elif defined(__PIWin__)
	#include "PIGeneral.h"
	#include "PIUtilities.r"
	/*#include "WinDialogUtils.r"*/
#endif

#include "PITerminology.h"
#include "PIActions.h"

#include "CryTIFPluginTerminology.h"	// Terminology for plug-in.

//-------------------------------------------------------------------------------
//	PiPL resource
//-------------------------------------------------------------------------------

resource 'PiPL' (ResourceID, plugInName " PiPL", purgeable)
{
    {
		Kind { ImageFormat },
		Name { plugInName },
		Version { (latestFormatVersion << 16) | latestFormatSubVersion },

		#ifdef __PIMac__
			#if (defined(__i386__))
				CodeMacIntel32 { "PluginMain" },
			#endif
			#if (defined(__ppc__))
				CodeMachOPowerPC { 0, 0, "PluginMain" },
			#endif
		#else
			#if defined(_WIN64)
				CodeWin64X86 { "PluginMain" },
			#else
				CodeWin32X86 { "PluginMain" },
			#endif
		#endif
	
		// ClassID, eventID, aete ID, uniqueString:
		HasTerminology { plugInClassID, plugInEventID, ResourceID, vendorName " " plugInName },
		
		SupportedModes
		{
			doesSupportBitmap, doesSupportGrayScale,
			doesSupportIndexedColor, doesSupportRGBColor,
			doesSupportCMYKColor, doesSupportHSLColor,
			doesSupportHSBColor, doesSupportMultichannel,
			doesSupportDuotone, doesSupportLABColor
		},
			
		EnableInfo { "true" },
	
		FmtFileType { '8B1F', '8BIM' },
		ReadTypes { { '8B1F', '    ' } },
		FilteredTypes { { '8B1F', '    ' } },
		ReadExtensions { { 'TIF ' } },
		WriteExtensions { { 'TIF ' } },
		FilteredExtensions { { 'TIF ' } },
		/*FormatFlags { fmtSavesImageResources, fmtCanRead, fmtCanWrite, fmtCanWriteIfRead, fmtCannotWriteTransparency },*/
		FormatFlags { fmtSavesImageResources, fmtCanRead, fmtCanWrite, fmtCanWriteIfRead, fmtCannotWriteTransparency, fmtCanCreateThumbnail },
		/* canRead, canWrite, canWriteIfRead, savesResources */
		FormatMaxSize { { 32767, 32767 } },
		FormatMaxChannels { {   1, 24, 24, 24, 24, 24, 
							   24, 24, 24, 24, 24, 24 } }
		}
	};


//-------------------------------------------------------------------------------
//	PiMI resource (kept for backward compatibility)
//-------------------------------------------------------------------------------

resource 'PiMI' (ResourceID, plugInName " PiMI", purgeable)
{
	latestFormatVersion, 	/* Version, subVersion, and priority of the interface */
	latestFormatSubVersion,
	0,
	supportsBitMap +
	supportsGrayScale +
	supportsIndexedColor +
	supportsRGBColor +
	supportsCMYKColor +
	supportsHSLColor +
	supportsHSBColor +
	supportsMultichannel +
	supportsDuotone +
	supportsLABColor,			/* Supported Image Modes */
	'    ',						/* Required host */
	
	{
		canRead,
		cannotReadAll,
		canWrite,
		canWriteIfRead,
		savesResources,
		{  1, 16, 16, 16,		/* Maximum # of channels for each plug-in mode */
		  16, 16, 16, 16,
		  16, 16,  0,  0,
		   0,  0,  0,  0 },
		32767,				/* Maximum rows allowed in document */
		32767,				/* Maximum columns allowed in document */
		'8B1F',				/* The file type if we create a file. */
		'8BIM',				/* The creator type if we create a file. */
		{					/* The type-creator pairs supported. */
			'8B1F', '    '
		},
		{					/* The extensions supported. */
		}
	},
	
};

//-------------------------------------------------------------------------------
//	Dictionary (scripting) resource
//-------------------------------------------------------------------------------

resource 'aete' (ResourceID, plugInName " dictionary", purgeable)
{
	1, 0, english, roman,									/* aete version and language specifiers */
	{
		vendorName,											/* vendor suite name */
		"Crytek TIF Plugin",							/* optional description */
		plugInSuiteID,										/* suite ID */
		1,													/* suite code, must be 1 */
		1,													/* suite level, must be 1 */
		{},													/* structure for filters */
		{													/* non-filter plug-in class here */
			vendorName " CryTIFPlugin",						/* unique class name */
			plugInClassID,									/* class ID, must be unique or Suite ID */
			plugInAETEComment,								/* optional description */
			{												/* define inheritance */
				"<Inheritance>",							/* must be exactly this */
				keyInherits,								/* must be keyInherits */
				classFormat,								/* parent: Format, Import, Export */
				"parent class format",						/* optional description */
				flagsSingleProperty,						/* if properties, list below */
							
				"foo",
				keyMyFoo,
				typeBoolean,
				"foobar",
				flagsSingleProperty,
				
				"bar",
				keyMyBar,
				typeBoolean,
				"foobar",
				flagsSingleProperty
				/* no properties */
			},
			{}, /* elements (not supported) */
			/* class descriptions */
		},
		{}, /* comparison ops (not supported) */
		{}	/* any enumerations */
	}
};

//-------------------------------------------------------------------------------
//	History resource
//-------------------------------------------------------------------------------

resource StringResource (kHistoryEntry, "History", purgeable)
{
	plugInName ": ref num=^0."
};

//-------------------------------------------------------------------------------

// end CryTIFPlugin.r
