#ifndef __DXPSLZSS__
#define __DXPSLZSS__


#include <vector>
#include <assert.h>
#include <windows.h>

#define LZSS_COMPRESS


#define LZSS_FLUSH(X,Y)	\
if(X)\
{\
	rDst[BitOffset]	=	Bits;\
	BitCount	=	0;\
	Bits			=	0;\
	if(Y)\
	{\
		BitOffset	=	rDst.size();\
		rDst.resize(rDst.size()+1);\
	}\
}

#define LZSS_PUSH(X)	\
		const size_t Idx	=	rDst.size();\
		rDst.resize(rDst.size()+1);\
		rDst[Idx]	=	X;



template<size_t DXPS_LZSS_OFFSETBITS>
class CDXPSLZSS
{
	static	uint32_t		OffsetBits(){return DXPS_LZSS_OFFSETBITS;}
	static	uint32_t		LenBits(){return 16-OffsetBits();}
	static	uint32_t		TresHold(){return 2;}//3;} 2bytes-lzss have just 1-bit of tag, while raw save has 2-bits
	static	uint32_t		MaxOffset(){return (1<<OffsetBits())-1;}
	static	uint32_t		MaxLen(){return (1<<LenBits())+TresHold()-1;}
	static	uint32_t		MaskOffset(){return MaxOffset();}
	static	bool				Verify(const uint8_t* pDst,const uint8_t* pSrc,const uint32_t Size)
											{
												for(uint32_t a=0;a<Size;a++)
													if(pDst[a]!=pSrc[a])
													{
														assert(0);
														return false;
													}
												return true;
											}
public:
	static bool					Encode(std::vector<uint8_t>&	rDst,const std::vector<uint8_t>& rSrc,const uint32_t ID)
											{
												{
													char Text[1024];
													sprintf(Text,"OffsetBits: %d\nLenBits %d\nMaxOffset: %d\nMaxLen: %d\nMaskOffset: %d ID:%d\n",OffsetBits(),LenBits(),MaxOffset(),MaxLen(),MaskOffset(),ID);
													OutputDebugString(Text);
												}
												const uint32_t Size	=	static_cast<uint32_t>(rSrc.size());

#if !defined(LZSS_COMPRESS)
												{
													rDst.resize(4+rSrc.size()+1);
													*reinterpret_cast<uint32_t*>(&rDst[0])	=	Size;
													CDXPSHelper::EndianSwizzleU32(*reinterpret_cast<uint32_t*>(&rDst[0]));
													memcpy(&rDst[4],&rSrc[0],rSrc.size());
													uint8_t Hash	=	0;
													for(uint32_t a=0;a<Size;a++)
														Hash	^=	rSrc[a];
													rDst[rDst.size()-1]	=	Hash;
													return true;
												}
#endif

												rDst.resize(0);
												rDst.reserve(rSrc.size());

												rDst.resize(12);
												*reinterpret_cast<uint32_t*>(&rDst[0])	=	Size|0x800000;//mask to indicate compression
												*reinterpret_cast<uint32_t*>(&rDst[8])	=	ID;
												rDst[3]	=	OffsetBits();
												CDXPSHelper::EndianSwizzleU32(*reinterpret_cast<uint32_t*>(&rDst[0]));
												CDXPSHelper::EndianSwizzleU32(*reinterpret_cast<uint32_t*>(&rDst[8]));

												uint8_t	Bits=0;
												uint8_t BitCount=0;
												size_t	BitOffset=rDst.size();
												rDst.resize(rDst.size()+1);

//												OutputDebugString("encode ------------\n");

												for(uint32_t a=0;a<Size;)
												{

													uint32_t BestOffset	=	a>MaxOffset()?a-MaxOffset():0;
													uint32_t BestLen		=	0;
													for(uint32_t Offset=BestOffset;Offset<a;Offset++)
													{
														uint32_t b=0;
														if(Offset==a)
															for(;b<MaxLen() && Offset+b<=Size && rSrc[a+b]==0;b++);
														else
															for(;b<MaxLen() && Offset+b<=Size && rSrc[a+b]==rSrc[Offset+b];b++);
														if(b>BestLen)
														{
															BestLen			=	b;
															BestOffset	=	a-Offset;
														}
													}
													if(BestLen>=TresHold())
													{
														Bits	|=	1<<BitCount;
														BitCount++;
														uint16_t	Data	=	BestOffset|((BestLen-TresHold())<<OffsetBits());
														uint32_t	Len		=	(Data>>OffsetBits())+TresHold();
														uint32_t	Offset	=	(Data&MaskOffset());
														assert(BestOffset==Offset);
														assert(BestLen==Len);

														CDXPSHelper::EndianSwizzleU16(Data);
														const size_t Idx	=	rDst.size();
														rDst.resize(rDst.size()+2);
														*reinterpret_cast<uint16_t*>(&rDst[Idx])	=	Data;
														a+=BestLen;
//														char Text[1024];
//														sprintf(Text,"1 %d %d\n",BestOffset,BestLen);
//														OutputDebugString(Text);
													}
													else
													{
														BitCount++;
														LZSS_PUSH(rSrc[a++]);
//														OutputDebugString("0\n");
													}
													LZSS_FLUSH(BitCount==8,true);
												}
												*reinterpret_cast<uint32_t*>(&rDst[4])	=	static_cast<uint32_t>(rDst.size());
												CDXPSHelper::EndianSwizzleU32(*reinterpret_cast<uint32_t*>(&rDst[4]));
												LZSS_FLUSH(BitCount,false);

#ifdef _DEBUG
												std::vector<uint8_t>	Test;
												Test.resize(Size*2);
												const uint32_t Ret	=	Decode(&Test[0],&rDst[0],&rSrc[0],static_cast<uint32_t>(rDst.size()));
												assert(Ret==Size);
												assert(Verify(&Test[0],&rSrc[0],static_cast<uint32_t>(rSrc.size())));
#endif
												uint8_t Hash	=	0;
												for(uint32_t a=0;a<Size;a++)
													Hash	^=	rSrc[a];
												LZSS_PUSH(Hash);
												char Text[1024];
												sprintf(Text,"HASH: %d\n",Hash);
												OutputDebugString(Text);


												return true;
											}
	static uint32_t			Decode(uint8_t*	pDst,const uint8_t* pSrc,const uint8_t* pReference,const uint32_t	Size)
											{
//												OutputDebugString("dencode ------------\n");

												uint32_t	IdxIn	=	0;
												uint32_t	IdxOut	=	0;
												uint32_t	FinalSize	=	*reinterpret_cast<const uint32_t*>(pSrc)&0xffff7f00;
												pSrc+=12;
												CDXPSHelper::EndianSwizzleU32(FinalSize);
												memset(pDst,0xff,FinalSize);//for debug purpose
												uint8_t	Bits;
												uint32_t a=0;
												for(;IdxOut<FinalSize;a++)
												{
													if(!(a&7))
														Bits	=	pSrc[IdxIn++];
													if(Bits&1)
													{
														uint16_t	Data		=	*reinterpret_cast<const uint16_t*>(&pSrc[IdxIn]);
														IdxIn	+=	2;
														CDXPSHelper::EndianSwizzleU16(Data);
														uint32_t	Len		=	(Data>>OffsetBits())+TresHold();
														uint32_t	Offset	=	(Data&MaskOffset());
//														char Text[1024];
//														sprintf(Text,"1 %d %d\n",Offset,Len);
//														OutputDebugString(Text);
														Offset	=	IdxOut-Offset;
														for(uint32_t b=0;b<Len;b++)
														{
															pDst[IdxOut+b]	=	pDst[Offset+b];
															assert(!pReference || pReference[IdxOut+b]==pDst[IdxOut+b]);
														}
														IdxOut	+=	Len;
													}
													else
													{
//														char Text[1024];
//														sprintf(Text,"0 %d\n",pSrc[IdxIn]);
//														OutputDebugString(Text);
														pDst[IdxOut++]	=	pSrc[IdxIn++];
														assert(!pReference || pReference[IdxOut-1]==pDst[IdxOut-1]);
													}
													Bits>>=1;
												}
												return FinalSize;
											}
};
#endif

