#ifndef __DXPSREFLECT__
#define __DXPSREFLECT__

#include <vector>
#include <string>
#include "DXPSReflection.hpp"

const uint32_t	COMPILER_VERSION	=	0xDeadFace;

class CDXPSRPragma
{
	uint32_t				m_Iterations;
public:

									CDXPSRPragma():
									m_Iterations(0)
									{

									}
	uint32_t				Iterations()const{return m_Iterations;}
	void						Iterations(uint32_t	I){m_Iterations=I;}
};

class CDXPSReflect
{
//	std::string			m_FileID;
	std::string			m_ShaderFileName;
	std::string			m_BinaryOutput;
	std::string			m_ShaderHalfStripped;
	std::string			m_ShaderDisassembled;
	std::string			m_ShaderStripped;
	std::string			m_ShaderCache;
	bool						m_VertexShader;
	std::string			m_PragmaParams;
	std::string			m_Entry;
	tdPatchMap			m_SemanticPatches;
	CDXPSRPragma		m_Pragma;

	CDXPSReflection	m_Reflection;

	void						ParsePragmas(std::vector<uint8_t>& rProgram);

	void						PatchCentroid(std::vector<uint8_t>& rProgram);
	void						PatchRefraction(std::vector<uint8_t>& rProgram);
	void						PatchPowAbs(std::vector<uint8_t>& rProgram);
	void						PatchToBigOfANumeric(std::vector<uint8_t>& rProgram);

	void						ToFile(const std::string& rFileName,const std::vector<uint8_t>&	rOut);
	void						FromFile(const std::string& rFileName,std::vector<uint8_t>&	rIn);
	bool						Execute(const std::string& rFileName,const std::string& rParams,std::string &outError);

	uint64_t				Profile(uint32 randomSched);
	bool						Compile(uint32 randomSched,bool ErrorStream);
	bool						HalfStrip();
	bool						Disasseble();
	bool						Strip();
	bool						Reflect(std::vector<uint8_t>& rProgram);

public:
									CDXPSReflect(const std::string& rEntry,const bool VertexShader,const std::string& rOutFile,const std::string& rInFile);
};

#endif
