#!/usr/bin/python

from __future__ import with_statement
import sys, string, xmlrpclib, re, os

if len(sys.argv) < 5:
    exit("Usage: " + sys.argv[0] + " spacekey pagetitle contentType filename");

print "Uploading CHM file to Confluence with Python Script...";

spacekey = sys.argv[1];
pagetitle = sys.argv[2];
contentType = sys.argv[3];
filename = sys.argv[4];

print "Space: " + spacekey + ", page: " + pagetitle;

with open(filename, 'rb') as f:
    data = f.read(); # slurp all the data

server = xmlrpclib.ServerProxy('http://confluence:8080/rpc/xmlrpc');
token = server.confluence1.login('script', 'script');
page = server.confluence1.getPage(token, spacekey, pagetitle);

if page is None:
    exit("First run - could not find page " + spacekey + ":" + pagetitle);

attachment = {};
attachment['fileName'] = os.path.basename(filename);
attachment['contentType'] = contentType;

try:
	server.confluence1.removeAttachment(token, page['id'], filename);
except:
    print "Could not delete attachment " + filename;
 
server.confluence1.addAttachment(token, page['id'], attachment, xmlrpclib.Binary(data));

print "Added attachment to Confluence page: " + filename;
print "Exit. Status OK.";