#include <string>				// STL string
#include "types.h"

class CColorImage;

class CHTMLWriter
{
public:
	CHTMLWriter( const char *szFolderName, const char *szResourceName );
	~CHTMLWriter();

	void AddHeadline( const char *szText );

	void AddLine( const char *szText, ... );
	void Add( const char *szText, ... );

	//! \param szName must not be 0
	//! \param szHyperlink can be 0
	void AddImage( CColorImage &rImg, const char *szName, const char *szHyperlink=0 );

	bool SaveHTML( const char *szFilename, const char *szTitle );

	void Add( const CHTMLWriter &rhs );

private: // ---------------------------------------------------------

	std::string						m_sHTMLData;					//
	std::string						m_sResourceName;			// without extension e.g. c:\temp\compare01
	std::string						m_sFolderName;				// 
	uint32								m_dwImageCount;				//
};