#include <string>								// STL string
#include <stdarg.h>
#include "types.h"							// uint32


class CColorImage;
struct IDirect3D9;
struct IDirect3DDevice9;

class CResult
{
public:

	CResult() 
	{
	}

	void AddError( const char *szLine, ... ) 
	{ 
		va_list		arglist;
		char		buf[1024];
		va_start(arglist, szLine);
		vsnprintf(buf,sizeof(buf),szLine, arglist);
		va_end(arglist);	
		m_sErrors+=buf;
		m_sErrors+="; "; 
	}

	bool IsError() 
	{ 
		return !m_sErrors.empty(); 
	}

	const char *GetErrors() 
	{ 
		return m_sErrors.c_str(); 
	}

private: // ---------------------------------------------------

	std::string m_sErrors;
};


class CDifferenceValues
{
public:

	CDifferenceValues() 
	{
		Reset();
	}

	void Reset()
	{
		m_fDifference = 0;
		m_fDifferenceSquared = 0;
		m_fMaxDifference = 0;
	}

	// ---------------------------------------------------------

	float m_fDifference;
	float m_fDifferenceSquared;
	float m_fMaxDifference;
};


class CImageVerifier
{
public:

	// constructor
	CImageVerifier();
	// destructor
	~CImageVerifier();

	void Setup( const char *szReference, const char *szSource );

	void BuildDifferenceImage( CColorImage &rDiff, CResult &result );

	bool ComputeDifferenceValues( unsigned int x, unsigned int y, unsigned int width, unsigned int height, CDifferenceValues& result );

	CColorImage *GetSrc() { return m_pSource; }
	CColorImage *GetRef() { return m_pReference; }

	uint32 GetUniqueId() { return m_dwUniqueId++; }

private: // -----------------------------------------------

	uint32											m_dwUniqueId;						//
	CColorImage	*								m_pSource;							//
	CColorImage *								m_pReference;						//

	friend class CColorImage;
};