#pragma once
#include <string>									// STL string
#include "LevelStats.h"						// CLevelStats

#include "ExcelWorksheetRef.h"		// CExcelWorksheetRef

class CLevelStatsProcessor
{
public:

	CLevelStatsProcessor( const char *szDestFile );

	~CLevelStatsProcessor();

	void ProcessFile( const char *szSourceFile );

	uint32 GetDestX();

	void IncreaseDestX();

private: // -----------------------------------------------------------------

	struct SSourceRef
	{
		CExcelWorksheetRef							m_excelSrcSummary;						//
		CExcelWorksheetRef							m_excelSrcModulesMemoryInfo;	//
		CExcelWorksheetRef							m_excelSrcTimeDemo;						//
		CExcelWorksheetRef							m_excelSrcProfiler;						//
	};

	CLevelStats											m_Dest;
	std::string											m_sDestFile;									//
	uint32													m_dwDestX;										// 0xffffffff means it's not computed yet, used GetDestX() to get the value

	CExcelWorksheetRef							m_excelDstSummary;						// 
	CExcelWorksheetRef							m_excelDstTimeDemo;						// 
	CExcelWorksheetRef							m_excelDstProfiler;						// 

	// -------------------------------------------------------------------

	void AddHeader( CExcelWorksheetRef &rWorksheet, const uint32 dwX, const uint32 dwBuild );

	// separated words by defined char
	// slow
	// counting starts with 0
	std::string GetWords( const std::string sIn, const uint32 dwStartId, const uint32 dwEndId, const char cSeparator=' ' );

	void CreateDestWorksheet( class CLevelStats &Dest, CExcelWorksheetRef &ref, const char *szWorksheetName );

	void ProcessLevelWorksheet( const char *szSourceFile, SSourceRef &SourceRef, const uint32 dwX );
};