#ifndef __detectencryptkey_h__
#define __detectencryptkey_h__

#pragma once

const int EncryptkeySize = 20;

class GenerateEncryptKey
{
public:
	void Generate(uint32 seed, char* outputBuffer, uint32 len);

protected:
	void ConvertASCCode(uint8* buffer, uint32 len);
};

static const size_t LicenseInfoSize = 128;

class CDetectEncryptkey
{
public:
	CDetectEncryptkey();
	~CDetectEncryptkey();

	void Run();
	bool LoadLicenseInfo(const char* filename);

protected:
	bool IsCorrectKey(const char* key);
	void WriteKey(const char* key);
	

private:
	char m_licenseInfoBuffer[LicenseInfoSize];
	
};

#endif // __detectencryptkey_h__