// LevelfileUtility.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "AesCryptography.h"
#include "DetectEncryptkey.h"

bool DecryptFile(const char* filename, const char* key, int len)
{
	FILE* r = fopen(filename, "rb");
	if (NULL == r)
		return false;

	uint32 fileBufferSize = 512;
	size_t readFileSize = 0;
	char* fileBuffer = NULL;
	do
	{
		fileBufferSize *= 2;
		if (NULL != fileBuffer)
		{
			delete [] fileBuffer;
			fileBuffer = NULL;
		}
		fileBuffer = new char[fileBufferSize];
		fseek(r , 0, SEEK_SET);
		readFileSize = fread(fileBuffer, 1, fileBufferSize, r);
	} while(readFileSize >= fileBufferSize);

	fclose(r);

	CAesCryptography cryptObj;
	cryptObj.SetKeyValue((uint8*)key, len);

	char* encryptBuffer = new char[readFileSize];
	cryptObj.DecryptBuffer((uint8*)fileBuffer, readFileSize, (uint8*)encryptBuffer);

	delete [] fileBuffer;
	remove(filename);

	FILE* fp = fopen(filename, "wb");
	if (NULL == fp)
		return false;

	fwrite(encryptBuffer, sizeof(char), readFileSize, fp);
	fclose(fp);
	delete [] encryptBuffer;

	return true;
}

void ReadKeyFromFile(char* key, int len)
{
	const char* filename = "FindKey.txt";
	FILE* r = fopen(filename, "rb");
	if (NULL == r)
		return;
	uint32 readFileSize = fread(key, 1, len, r);
	fclose(r);
}

void ConvertTargetFiles(const char *path, const char* decryptKey)
{
	HANDLE hSrch;
	WIN32_FIND_DATA wfd;
	BOOL bResult=TRUE;
	char drive[_MAX_DRIVE] = {0,};
	char dir[MAX_PATH] = {0,};
	char newpath[MAX_PATH] = {0,};

	//printf("\npath = %s\n",path);
	hSrch=FindFirstFile(path,&wfd);
	if (hSrch == INVALID_HANDLE_VALUE) 
		return;

	_splitpath(path,drive,dir,NULL,NULL);
	while (bResult) 
	{
		std::string targetPath = dir;
		targetPath += wfd.cFileName;
		printf("DecryptFile %s\n", targetPath.c_str());
		DecryptFile(targetPath.c_str(), decryptKey, strlen(decryptKey));
		//printf("%s%s%s\n",drive,dir,wfd.cFileName);
		bResult=FindNextFile(hSrch,&wfd);
	}
	FindClose(hSrch);
}

void DetectEncryptkey(const char* filename)
{
	printf("DetectedEncryptkey mode.\n");
	CDetectEncryptkey findKey;
	findKey.LoadLicenseInfo(filename);
	findKey.Run();
}

int _tmain(int argc, _TCHAR* argv[])
{
	if (argc < 2)
		return 0;

	std::string excuteMode = argv[1];
	if ("DetectEncryptkey" == excuteMode)
	{
		DetectEncryptkey(argv[2]);
	}
	else if ("DecryptFile" == excuteMode)
	{
		printf("DecryptFile mode.\n");
		char encryptKey[EncryptkeySize] = {0,};
		ReadKeyFromFile(encryptKey, EncryptkeySize);
		printf("Path : %s EncryptKey : %s\n", argv[2], encryptKey);
		ConvertTargetFiles(argv[2], encryptKey);
	}
	return 0;
}

