//#include "stdafx.h"
#include <stdio.h>
#include <string.h>
#include <string>
#include "DetectEncryptkey.h"
#include "AesCryptography.h"
#include "LicenseServerCommon.h"

#define NO_DEBUG_MSG 1

//////////////////////////////////////////////////////////////////////////

void GenerateEncryptKey::Generate(uint32 seed, char* outputBuffer, uint32 len)
{
	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));
	char* buffer = new char[len];
	sprintf(buffer, "aekqutc8id72zty%04d", seed);
	for(uint32 i=0; i<len-1; ++i)
		buffer[i] ^= ++seed;
	cryptObj.EncryptBuffer((uint8*)buffer, len-1, (uint8*)outputBuffer);
	ConvertASCCode((uint8*)outputBuffer, len-1);
	outputBuffer[len-1] = 0;
	delete []  buffer;
}

void GenerateEncryptKey::ConvertASCCode(uint8* buffer, uint32 len)
{
	for(uint32 i=0; i<len; ++i)
	{
		buffer[i] %= 77;
		buffer[i] += 48;
		if (buffer[i] == ';')
			buffer[i] = '0';
	}
}

//////////////////////////////////////////////////////////////////////////

CDetectEncryptkey::CDetectEncryptkey()
{
}

CDetectEncryptkey::~CDetectEncryptkey()
{
}

bool CDetectEncryptkey::TryDetect(const char* outputFilename)
{
	char buffer[EncryptkeySize] = {0,};
	const int CheckRange = 5000;
	for(int i=0;i<CheckRange; ++i)
	{
		GenerateEncryptKey generator;
		generator.Generate(i, buffer, EncryptkeySize);
		if (IsCorrectKey(buffer))
		{
#ifndef NO_DEBUG_MSG
			printf("Find!! Serial(%04d) Key(%s)\n", i, buffer);
#endif
			WriteKey(buffer, outputFilename);
			return true;
		}
	}
#ifndef NO_DEBUG_MSG
	printf("End.\n" );
#endif
	return false;
}

bool CDetectEncryptkey::LoadLicenseInfo( const char* filename )
{
	FILE* r = fopen(filename, "rb");
	if (NULL == r)
		return false;

	uint32 readFileSize = fread(m_licenseInfoBuffer, 1, LicenseInfoSize, r);
	if (readFileSize != LicenseInfoSize)
		return false;

	fclose(r);
	return true;
}

bool CDetectEncryptkey::IsCorrectKey( const char* key )
{
	static uint8 DataXorTable[] = 
	{
		0x14,0x2D,0xA2,0xF6,0xB2,0x81,0x1B,0xEB,0x4D,0x8C,0xF4,0xB4,0xC1,0xA2,0x5F,0x28
	};

	const std::string fakeString = "TheGettingStartedsectioncontainsalltheinformationyoullneedtogettheCryENGINE3SandboxinstalledonyourPCandready";
	CAesCryptography cryptObj;
	cryptObj.SetKeyValue((const uint8*)key, strlen(key));
	char xorBuffer[LicenseInfoSize] = {0,};
	int xorTableLength = sizeof(DataXorTable)-1;
	int fakeStringLength = fakeString.length()-1;
	int encryptKeyOffset = 0;
	for(int i=0; i<LicenseInfoSize; ++i)
	{
		xorBuffer[i] = fakeString.at(i%fakeStringLength)^DataXorTable[i%xorTableLength];
		if (i>=20 && i<39)
			xorBuffer[i] = key[encryptKeyOffset++]^DataXorTable[i%xorTableLength];
	}
	char outputBuffer[LicenseInfoSize] = {0,};
	cryptObj.EncryptBuffer((const uint8*)xorBuffer, LicenseInfoSize, (uint8*)outputBuffer);

	return (0 == memcmp(outputBuffer, m_licenseInfoBuffer, LicenseInfoSize));
}

void CDetectEncryptkey::WriteKey( const char* key, const char* filename )
{
	FILE* fp = fopen(filename, "wb");
	if (NULL == fp)
		return;

	fwrite(key, sizeof(char), strlen(key), fp);
	fclose(fp);
}