#ifndef __detectencryptkey_h__
#define __detectencryptkey_h__

#pragma once

typedef	unsigned char			uint8;
typedef	unsigned char			BYTE;
typedef	signed char				int8;
typedef	unsigned short		uint16;
typedef	signed short			int16;
typedef	unsigned int			uint32;
typedef	signed int				int32;
typedef	float							f32;
typedef	double						f64;
typedef double						real;


const int EncryptkeySize = 20;

const static char* KeyFilename = "temp.out";

class GenerateEncryptKey
{
public:
	void Generate(uint32 seed, char* outputBuffer, uint32 len);

protected:
	void ConvertASCCode(uint8* buffer, uint32 len);
};

static const size_t LicenseInfoSize = 128;

class CDetectEncryptkey
{
public:
	CDetectEncryptkey();
	~CDetectEncryptkey();

	bool TryDetect(const char* outputFilename);
	bool LoadLicenseInfo(const char* filename);

protected:
	bool IsCorrectKey(const char* key);
	void WriteKey(const char* key, const char* filename);
	

private:
	char m_licenseInfoBuffer[LicenseInfoSize];
	
};

#endif // __detectencryptkey_h__