#include "LevelfileUtility.h"
#include "AesCryptography.h"
#include "DetectEncryptkey.h"
#include <stdio.h>

bool LevelfileUtility::DecryptFile(const char* filename, const char* key, int keyLen)
{
	FILE* r = fopen(filename, "rb");
	if (NULL == r)
		return false;

	uint32 fileBufferSize = 512;
	size_t readFileSize = 0;
	char* fileBuffer = NULL;
	do
	{
		fileBufferSize *= 2;
		if (NULL != fileBuffer)
		{
			delete [] fileBuffer;
			fileBuffer = NULL;
		}
		fileBuffer = new char[fileBufferSize];
		fseek(r , 0, SEEK_SET);
		readFileSize = fread(fileBuffer, 1, fileBufferSize, r);
	} while(readFileSize >= fileBufferSize);

	fclose(r);

	CAesCryptography cryptObj;
	cryptObj.SetKeyValue((uint8*)key, keyLen);

	char* encryptBuffer = new char[readFileSize];
	cryptObj.DecryptBuffer((uint8*)fileBuffer, readFileSize, (uint8*)encryptBuffer);

	delete [] fileBuffer;
	remove(filename);

	FILE* fp = fopen(filename, "wb");
	if (NULL == fp)
		return false;

	fwrite(encryptBuffer, sizeof(char), readFileSize, fp);
	fclose(fp);
	delete [] encryptBuffer;

	return true;

}

bool LevelfileUtility::DetectEncryptkey( const char* licenseFile, const char* outputFile )
{
	CDetectEncryptkey findKey;
	if (false == findKey.LoadLicenseInfo(licenseFile))
		return false;
	if (false == findKey.TryDetect(outputFile))
		return false;
	return true;
}