import zipfile
import glob, os, sys
import LevelfileUtility

def DecryptFile(filename, key):
    if -1 != filename.find('level.editor_xml'):
        return
    print '\t','%s'%(filename)
    util = LevelfileUtility.LevelfileUtility()
    util.DecryptFile(filename,key, len(key))
    
def DetectKey(license_file, key_output_file):
  util = LevelfileUtility.LevelfileUtility()
  return util.DetectEncryptkey(license_file, key_output_file)
    
  
def AutoDecrypt(srcFilename, dstFilename):
  input_filename = srcFilename
  key_output_file = "key.out"
  zip_work_dir = 'ZipWorkDirectory'
  
  input_file = zipfile.ZipFile(input_filename, "r")
  print '[Unzip %s...]'%(input_filename)
  for name in input_file.namelist():
      data = input_file.read(name)
      input_file.extract(name, zip_work_dir)
      print '\t', name
  input_file.close()
  
  print '[Detect encryption key]'
  license_file = zip_work_dir + '/license.editor_data'
  if False == DetectKey(license_file, key_output_file):
    return False
  
  print '[Read encryption key]'
  if os.path.exists(key_output_file) == False:
    return False
  key_file = open(key_output_file, "r")
  encryption_key = key_file.read()
  key_file.close()
  os.remove(key_output_file)
  
  print '[Decrypt files]'
  for name in glob.glob("%s/*"%(zip_work_dir)):
      DecryptFile(name, encryption_key)
  
  license_info_file = '%s/license.editor_data'%(zip_work_dir)
  #Remove license_info_file
  os.remove(license_info_file)
  
  print '[Zip %s...]'%(dstFilename)
  output_file = zipfile.ZipFile(dstFilename, "w")
  
  for name in glob.glob("%s/*"%(zip_work_dir)):
      output_file.write(name, os.path.basename(name), zipfile.ZIP_DEFLATED)
      print '\t', name
      os.remove(name)
  output_file.close()
  os.removedirs(zip_work_dir)
  return True