import wx
import os
import AutoDecryptLevelfile

class LevelDecryptorFrame(wx.Frame):
    def __init__(self):
        wx.Frame.__init__(self, None, -1, 'Level Decryptor', 
                size=(420, 160),
                style=wx.DEFAULT_FRAME_STYLE&~(wx.MAXIMIZE_BOX))
        panel = wx.Panel(self, -1) 
        basicLabel = wx.StaticText(panel, -1, "Source file:")
        self.sourceText = wx.TextCtrl(panel, -1, "", size=(220, -1))
        self.sourceText.SetInsertionPoint(0)
        self.browseButton = wx.Button(panel, -1, "Browse")
        self.Bind(wx.EVT_BUTTON, self.OnClickBrowseButton, self.browseButton)

        pwdLabel = wx.StaticText(panel, -1, "Dest file:")
        self.destText = wx.TextCtrl(panel, -1, "", size=(220, -1))
        sizer = wx.FlexGridSizer(cols=4, hgap=6, vgap=6)
        self.decryptButton = wx.Button(panel, -1, "Decrypt it!")
        self.Bind(wx.EVT_BUTTON, self.OnClickDecryptButton, self.decryptButton)
        sizer.AddMany([
          wx.StaticText(panel, size=(20,10)), wx.StaticText(panel), wx.StaticText(panel), wx.StaticText(panel),
          wx.StaticText(panel), basicLabel, self.sourceText, self.browseButton, 
          wx.StaticText(panel), pwdLabel, self.destText, wx.StaticText(panel), 
          wx.StaticText(panel), wx.StaticText(panel), self.decryptButton])
        panel.SetSizer(sizer)
        self.CreateStatusBar()
        self.SetStatusText("Select source level file")
        
    def OnClickBrowseButton(self, event):
        wildcard = "Level file (*.cry)|*.cry|" \
            "All files (*.*)|*.*"
        dialog = wx.FileDialog(None, "Choose a file", os.getcwd(), "", wildcard, wx.OPEN)
        if dialog.ShowModal() == wx.ID_OK:
            self.sourceText.SetValue(dialog.GetPath())
            filename = os.path.split(dialog.GetPath())[1]
            statusMessage = "%s is selected."%(filename)
            self.SetStatusText(statusMessage)
            destFilename = os.path.split(dialog.GetPath())[0]+'\Decrypted_'+filename
            self.destText.SetValue(destFilename)
        dialog.Destroy()
        
    def OnClickDecryptButton(self, event):
        if len(self.sourceText.GetValue()) == 0:
          return
        if len(self.destText.GetValue()) == 0:
          return
        srcFilepath = self.sourceText.GetValue()
        dstFilepath = self.destText.GetValue()
        srcFilename = os.path.split(srcFilepath)[1]
        dstFilename = os.path.split(dstFilepath)[1]
        statusMessage = "Decrypting %s..."%(srcFilename)
        self.SetStatusText(statusMessage)
        result = AutoDecryptLevelfile.AutoDecrypt(srcFilepath, dstFilepath)
        resultMessage = ''
        messageBoxStyle = wx.OK
        if result:
          resultMessage = "Decrypting success.\n%s is created."%(dstFilename)
        else:
          resultMessage = 'Decrypting fail.'
          messageBoxStyle = wx.OK | wx.ICON_ERROR
        wx.MessageBox(resultMessage, "Decrypt file", messageBoxStyle)
        self.SetStatusText(resultMessage)

if __name__ == '__main__':
    app = wx.PySimpleApp()
    frame = LevelDecryptorFrame()
    frame.Show()
    app.MainLoop()
