#pragma once

#include <stdlib.h>

namespace DataTypeConvertor
{
	template<typename T>
	inline void ToNumeric(const char* text, T& numeric) 
	{}

	template<>
	inline void ToNumeric(const char* text, std::string& numeric) 
	{ 
		numeric = text; 
	}

	template<>
	inline void ToNumeric(const char* text, int& numeric) 
	{ 
		numeric = atoi(text); 
	}

	template<>
	inline void ToNumeric(const char* text, char& numeric) 
	{ 
		numeric = atoi(text); 
	}

	template<>
	inline void ToNumeric(const char* text, unsigned char& numeric) 
	{ 
		numeric = atoi(text);	
	}

	template<>
	inline void ToNumeric(const char* text, short& numeric) 
	{ 
		numeric = atoi(text); 
	}

	template<>
	inline void ToNumeric(const char* text, unsigned short& numeric) 
	{ 
		numeric = atoi(text);	
	}

	template<>
	inline void ToNumeric(const char* text, uint32& numeric) 
	{ 
		numeric = strtoul(text, NULL, 10);	
	}

	template<>
	inline void ToNumeric(const char* text, float& numeric)
	{ 
		numeric = (float)atof(text); 
	}

	template<>
	inline void ToNumeric(const char* text, double& numeric)
	{ 
		numeric = atof(text); 
	}

	template<>
	inline void ToNumeric(const char* text, bool& numeric) 
	{ 
		numeric = (strcmp(text, "true")==0);
	}

	template<typename T>
	inline void ToString(const T numeric, char* str, uint32 buffer_size)
	{}

	template<>
	inline void ToString(const std::string numeric, char* str, uint32 buffer_size) 
	{ 
		sprintf(str, "%s", numeric.c_str());
	}

	template<>
	inline void ToString(const char* numeric, char* str, uint32 buffer_size) 
	{ 
		sprintf(str, "%s", numeric);
	}

	template<>
	inline void ToString(const int numeric, char* str, uint32 buffer_size) 
	{
		sprintf(str, "%d", numeric);
	}

	template<>
	inline void ToString(const char numeric, char* str, uint32 buffer_size) 
	{
		sprintf(str, "%d", numeric);
	}

	template<>
	inline void ToString(const unsigned char numeric, char* str, uint32 buffer_size) 
	{
		sprintf(str, "%d", numeric);
	}

	template<>
	inline void ToString(const short numeric, char* str, uint32 buffer_size) 
	{
		sprintf(str, "%d", numeric);
	}

	template<>
	inline void ToString(const unsigned short numeric, char* str, uint32 buffer_size) 
	{
		sprintf(str, "%d", numeric);
	}

	template<>
	inline void ToString(const uint32 numeric, char* str, uint32 buffer_size) 
	{
		sprintf(str, "%d", numeric);
	}

	template<>
	inline void ToString(const float numeric, char* str, uint32 buffer_size) 
	{
		sprintf(str, "%.4f", numeric);
	}

	template<>
	inline void ToString(const double numeric, char* str, uint32 buffer_size) 
	{
		sprintf(str, "%.4f", numeric);
	}

	template<>
	inline void ToString(const bool numeric, char* str, uint32 buffer_size) 
	{
		if (numeric)
			sprintf(str, "true");
		else
			sprintf(str, "false");
	}
};
