////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   licenseconnection.h
//  Version:     v1.00
//  Created:     27/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: Manage communication with License Server
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#ifndef __licenseconnection_h__
#define __licenseconnection_h__

#pragma once

// only for release
#ifdef NDEBUG
#define USING_TAGES_SECURITY
#endif

#ifdef USING_TAGES_SECURITY
#	define TAGES_EXPORT __declspec(dllexport)
#else 
#	define TAGES_EXPORT
#endif // USING_TAGES_SECURITY

#include "LicenseServerCommon.h"


class CTinyClientSocket;
class CProtocolBuilder;
class CProtocolAssembler;

class CLicenseConnection
{
	enum EProgressStep
	{
		ePS_None,
		ePS_InitSocket,
		ePS_ConnectServer,
		ePS_LoginServer,
	};

public:
	CLicenseConnection(void);
	~CLicenseConnection(void);

	TAGES_EXPORT	EPMErrorCode	Authenticate(const char* key);
	TAGES_EXPORT	void					SetConnectionInfo(const char* ip, int port);
	TAGES_EXPORT	void					SetDefaultConnectionInfo();
	TAGES_EXPORT	void					GetLicenseKey(std::string& key);
	TAGES_EXPORT	void					GetEncryptKey(std::string& key);
	TAGES_EXPORT	uint32				GetRemainSecond();
	TAGES_EXPORT	uint32				GetDisconnectedPeriod();
	TAGES_EXPORT	uint32				GetFloatLicenses();
	TAGES_EXPORT	void					SetProxy(std::string& ip, int port, std::string& authInfo);
	TAGES_EXPORT	void					ResetLogin();
	TAGES_EXPORT	void					GetLocalIp(std::string& ip);
	TAGES_EXPORT	void					GetMacAddress(std::string& mac);
	TAGES_EXPORT	void					SetAccountInfo(const std::string& account, const std::string& password);
	ECreateAccountResult RequestCreateAccount(const SCreateAccountParam& param);
	ELoginAccountResult RequestLoginAccount(const std::string& username, const std::string& password, bool& agreeLicenseFlag);
	bool RequestPasswordRemind( const std::string& username, const std::string& email );
	void Logoff();
	TAGES_EXPORT	void SetVersion(const std::string& version);
	TAGES_EXPORT	void SetAppName(const std::string& appName);

			
protected:
	TAGES_EXPORT	bool					VerifyLocalNetworkDeviceInfo();
	TAGES_EXPORT	EPMErrorCode	RemoteAuthenticate(const std::string& key);
	TAGES_EXPORT	bool					SendLogin( const std::string& key ) const;
	TAGES_EXPORT	bool					SendLoginAccount( const std::string& username, const std::string& password ) const;
	TAGES_EXPORT	bool					SendAuth( const std::string& key) const;
	TAGES_EXPORT	bool					SendCreateAccount(const SCreateAccountParam& param) const;
								bool					SendPasswordRemind(const std::string& username, const std::string& email) const;
	TAGES_EXPORT	void					ResetConnection();
	TAGES_EXPORT	EPMErrorCode	ReceiveLoginResult();
	TAGES_EXPORT	ELoginAccountResult ReceiveLoginAccountResult(bool& agreeLicenseFlag);
	TAGES_EXPORT	EPMErrorCode	ReceiveAuthResult() const;
	TAGES_EXPORT	ECreateAccountResult ReceiveCreateAccount() const;
	bool ReceivePasswordRemindResult();
	TAGES_EXPORT	EPMErrorCode	LoginProcess(const std::string& key);
	TAGES_EXPORT	EPMErrorCode	AuthProcess(const std::string& key);
	TAGES_EXPORT	void					UpdateLastAuthenticatedTick();
	TAGES_EXPORT	bool					InitSocket();
	TAGES_EXPORT	bool					ConnectServer();

private:
	CTinyClientSocket*	m_clientSocket;
	CProtocolBuilder*		m_builder;
	CProtocolAssembler*	m_assembler;
	std::string							m_serverIp;
	int									m_serverPort;
	std::string							m_localIp;
	std::string							m_localMac;
	std::string							m_key;
	uint32							m_remainSecond;
	uint32							m_lastAutheticatedTick;
	std::string							m_encryptKey;
	std::string							m_proxyIp;
	int									m_proxyPort;
	std::string							m_proxyAuthInfo;
	uint32 m_floatLicenses;
	EProgressStep m_progressStep;
	std::string m_username;
	std::string m_password;
	std::string m_sessionKey;
	std::string m_appname;
	std::string m_version;
	std::string m_sessionId;
};

#endif // __licenseconnection_h__

