////////////////////////////////////////////////////////////////////////////
//
//  Crytek Engine Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   LicenseServerCommon.h
//  Version:     v1.00
//  Created:     24/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: 
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#ifndef __licenseservercommon_h__
#define __licenseservercommon_h__

#pragma once

typedef int32 TimeType;

const uint32 LicenseKeyLength = 64;
const uint32 EncryptKeyLength = 64;
const uint32 UniKeyDummyLength0 = 23;
const uint32 UniKeyDummyLength1 = 7;
const uint32 UniKeyDummyLength2 = 39;

struct SUniKeySaveData
{
	uint32 dataVersion;
	char dummyData0[UniKeyDummyLength0];
	TimeType	startTime;
	TimeType	expireTime;
	char dummyData1[UniKeyDummyLength1];
	uint32		validityTerm;
	TimeType	lastLoginTime;
	uint32	concurrentClientCount;
	char dummyData2[UniKeyDummyLength2];
	char		licenseKey[LicenseKeyLength];
	char		encryptKey[EncryptKeyLength];
};

const uint32 UniKeyDataVersion = 10;

const uint8 UniKeyDataCryptKey[] = {0x93, 0xE2, 0x34, 0x3B, 0xF2, 0x04, 0x10, 0x4D};
const uint8 NetworkCryptKey[] = {0x27, 0xB0, 0x31, 0xBA, 0x24, 0x40, 0xD2, 0xED};
const uint8 CachedLicenseCryptKey[] = {0x28, 0x3E, 0xD4, 0xAA, 0x72, 0x16, 0x1E, 0x2B};

enum EPMErrorCode
{
	PMEC_NO_ERROR = 0,

	PMEC_CANT_WRITE_TO_SOCKET,
	PMEC_CANT_READ_FROM_SOCKET,
	PMEC_OLD_APP_VERSION,
	PMEC_NETWORK_DEVICE,
	PMEC_CONNECT_FAILED,

	PMEC_KEY_EXPIRED,
	PMEC_KEY_INVALID,
	PMEC_INVALID_TIMEFRAME,
	PMEC_KEY_NOT_FOUND,
	PMEC_PROXY_CONNECT_FAILED,
	PMEC_OVER_CONNECTION,
	PMEC_NO_DONGLE,
	PMEC_INVALID_ADDRESS,
	PMEC_REGISTRY_NOT_FOUND,
	PMEC_REQUEST_ACCOUNTLOGIN,
	PMEC_DOUBLE_LOGIN,
	PMEC_INVALID_CONNECT_TYPE,
};

static const char* ResultTrue = "true";
static const char* ResultFalse = "false";

enum ECreateAccountResult
{
	eCA_Success,
	eCA_Undefined,
	eCA_BanCharacter,
	eCA_DuplicateUsername,
	eCA_DuplicateEmail,
	eCA_InvalidDomain
};

enum ELoginAccountResult
{
	eLA_Success,
	eLA_Undefined,
	eLA_InvalidLicense,
	eLA_InvalidAccount,
	eLA_InactiveAccount
};

struct SCreateAccountParam
{
	std::string username;
	std::string password;
	std::string email;
	std::string firstname;
	std::string lastname;
	std::string address;
	std::string city;
	std::string state;
	std::string zipcode;
	std::string country;
};

struct SAuthenticateParam
{
	std::string licenseKey;
	std::string macAddress;
	std::string application;
	std::string sessionId;
};

#endif // __licenseservercommon_h__