#include "stdafx.h"
#ifdef USING_DATABASE_MODE

#ifdef WIN32
#pragma comment(lib, "libmysql.lib")
#endif

#include "MySQLConnection.h"

#ifdef WIN32
#include <WinSock2.h>
#endif
#include <mysql.h>
#include <errmsg.h>
#include <string.h>
#include <stdlib.h>
#include <ace/Event.h>
#include <ace/Time_Value.h>
#include <ace/OS_NS_time.h>

struct SMySQLConnectionImpl
{
	MYSQL				ConnectionHandle;
	MYSQL_RES*	ResultSet;
	MYSQL_ROW		ResultRow;
	int					NumField;

	SMySQLConnectionImpl()
	{
		ResultSet = NULL;
		NumField = 0;
	}
};

CMySQLConnection::CMySQLConnection() : m_impl(new SMySQLConnectionImpl())
{
}

CMySQLConnection::~CMySQLConnection()
{
	if (NULL != m_impl)
	{
		delete m_impl;
		m_impl = NULL;
	}
}

bool CMySQLConnection::Init()
{
	return (NULL != mysql_init(&m_impl->ConnectionHandle));
}

bool CMySQLConnection::Connect( const char* ip, const int port, const char* user, const char* password, const char* defaultDB )
{
	m_ip = ip;
	m_port = port;
	m_user = user;
	m_password = password;
	m_defaultDB = defaultDB;
	return (NULL != mysql_real_connect(&m_impl->ConnectionHandle, ip, user, password, defaultDB, port, (char *)NULL, 0));
}

bool CMySQLConnection::Connect()
{
	return Connect(m_ip.c_str(), m_port, m_user.c_str(), m_password.c_str(), m_defaultDB.c_str());
}

static void EventSleep(int32 ms)
{
	ACE_Time_Value waitTime(ms/1000, (ms%1000)*1000);
	ACE_Event eventObj;
	eventObj.wait(&waitTime, 0);
}

bool CMySQLConnection::TryReConnect()
{
	const int TryCount = 5;
	bool result = false;
	for (int i=0;i<TryCount;++i)
	{
		if (Connect())
		{
			result = true;
			break;
		}
		EventSleep(1000);
	}
	if (result)
		WriteLog("ReConnect success");
	else
		WriteLog("ReConnect fail");
	return result;
}

void CMySQLConnection::Disconnect()
{
	mysql_close(&m_impl->ConnectionHandle);
}

bool CMySQLConnection::ExecuteQuery( const char* query, bool leaveLog ) 
{
	std::string logMessage;
	logMessage.reserve(strlen(query));
	int resultCode = mysql_real_query(&m_impl->ConnectionHandle, query, (unsigned int)strlen(query));
	if (0 == resultCode)
	{
		logMessage = query;
		logMessage += " success";
		if (leaveLog)
			WriteLog(logMessage.c_str());
		return true;
	}
	else
	{
		unsigned int errorCode = mysql_errno(&m_impl->ConnectionHandle);
		char errorCodeStr[32] = {0,};
		sprintf(errorCodeStr, "(%d)", errorCode);
		logMessage = query;
		logMessage += " fail";
		logMessage += errorCodeStr;
		WriteLog(logMessage.c_str());

		// CR_SERVER_GONE_ERROR or CR_SERVER_LOST
		if (errorCode >= CR_ERROR_FIRST)
			TryReConnect();
		return false;
	}
}

bool CMySQLConnection::StoreResult() const
{
	m_impl->ResultSet = mysql_store_result(&m_impl->ConnectionHandle);
	return (NULL != m_impl->ResultSet);
}

bool CMySQLConnection::FetchRow() const
{
	m_impl->ResultRow = mysql_fetch_row(m_impl->ResultSet);
	m_impl->NumField = mysql_num_fields(m_impl->ResultSet);
	return (NULL != m_impl->ResultRow);
}

bool CMySQLConnection::GetData( int index, char* value ) const
{
	if (m_impl->NumField <= index)
		return false;
	MYSQL_FIELD* fld = mysql_fetch_field_direct( m_impl->ResultSet, index );
	if (NULL == fld)
		return false;
	strcpy(value, m_impl->ResultRow[index]);
	return true;
}

bool CMySQLConnection::GetData( int index, int* value ) const
{
	if (m_impl->NumField <= index)
		return false;
	MYSQL_FIELD* fld = mysql_fetch_field_direct( m_impl->ResultSet, index );
	if (NULL == fld)
		return false;
	*value = atoi(m_impl->ResultRow[index]);
	return true;
}


bool CMySQLConnection::GetFieldInfo( int index, char* name, char* value, bool& isNumeric ) const
{
	if (m_impl->NumField <= index)
		return false;
	MYSQL_FIELD* fld = mysql_fetch_field_direct( m_impl->ResultSet, index );
	if (NULL == fld)
		return false;
	strcpy(name, fld->name);
	if (NULL != m_impl->ResultRow[index])
		strcpy(value, m_impl->ResultRow[index]);
	if (
			MYSQL_TYPE_DECIMAL == fld->type || 
			MYSQL_TYPE_TINY == fld->type || 
			MYSQL_TYPE_SHORT == fld->type || 
			MYSQL_TYPE_LONG == fld->type || 
			MYSQL_TYPE_FLOAT == fld->type || 
			MYSQL_TYPE_DOUBLE == fld->type || 
			MYSQL_TYPE_TIMESTAMP == fld->type || 
			MYSQL_TYPE_LONGLONG == fld->type || 
			MYSQL_TYPE_INT24 == fld->type ||
			MYSQL_TYPE_BIT == fld->type 
		)
		isNumeric = true;
	else
		isNumeric = false;

	return true;
}


int CMySQLConnection::GetFieldNameLength( int index ) const
{
	if (m_impl->NumField <= index)
		return -1;
	MYSQL_FIELD* fld = mysql_fetch_field_direct( m_impl->ResultSet, index );
	if (NULL == fld)
		return -1;

	return fld->name_length;
}

int CMySQLConnection::GetFieldValueLength( int index ) const
{
	if (m_impl->NumField <= index)
		return -1;
	MYSQL_FIELD* fld = mysql_fetch_field_direct( m_impl->ResultSet, index );
	if (NULL == fld)
		return -1;

	return fld->max_length;
}

void CMySQLConnection::FreeResult() const
{
	mysql_free_result(m_impl->ResultSet);
}

int CMySQLConnection::GetFieldCount() const
{
	return mysql_num_fields(m_impl->ResultSet);
}

void CMySQLConnection::WriteLog( const char* logMessage )
{
}
#endif // USING_DATABASE_MODE