#ifndef __mysqlconnection_h__
#define __mysqlconnection_h__

#pragma once

#ifdef USING_DATABASE_MODE

struct SMySQLConnectionImpl;

class CMySQLConnection
{
public:
	CMySQLConnection();
	virtual ~CMySQLConnection();

public:
	bool	Init();
	bool	Connect(const char* ip, const int port, const char* user, const char* password, const char* defaultDB);
	void	Disconnect();

public:
	bool	ExecuteQuery(const char* query, bool leaveLog);
	bool	StoreResult() const;
	bool	FetchRow() const;
	bool	GetData(int index, char* value) const;
	bool	GetData(int index, int* value) const;
	bool	GetFieldInfo(int index, char* name, char* value, bool& numeric) const;
	int		GetFieldNameLength(int index) const;
	int		GetFieldValueLength(int index) const;
	void	FreeResult() const;
	int		GetFieldCount() const;

protected:
	bool	Connect();
	bool	TryReConnect();
	virtual void WriteLog(const char* logMessage);

private:
	SMySQLConnectionImpl*	m_impl;
	std::string m_ip;
	int	m_port;
	std::string m_user;
	std::string m_password;
	std::string m_defaultDB;
};


#endif // USING_DATABASE_MODE

#endif // __mysqlconnection_h__