////////////////////////////////////////////////////////////////////////////
//
//  Crytek Source File.
//  Copyright (C), Crytek Studios, 2009.
// -------------------------------------------------------------------------
//  File name:   ProtocolAssembler.h
//  Version:     v1.00
//  Created:     24/08/2009 by Younggi Lim
//  Compilers:   Visual Studio.NET
//  Description: assemble protocolbuilder
// -------------------------------------------------------------------------
//  History:
//
////////////////////////////////////////////////////////////////////////////
#ifndef __protocolassembler_h__
#define __protocolassembler_h__

#pragma once

class CProtocolBuilder;

class CProtocolAssembler
{
public:
	CProtocolAssembler();
	virtual ~CProtocolAssembler();

	void	ApplyBuffer(const char* buffer, uint32 &offset, uint32 bufferLength);
	bool	AssembleBuilder(CProtocolBuilder& builder);

protected:
	bool	AddBuffer(const char* buffer, uint32 offset, uint32 bufferLength);

private:
	char*		m_bufferPtr;
	uint32	m_stackedOffset;
	uint32	m_processOffset;
};

#endif // __protocolassembler_h__
