#include "stdafx.h"
#include "TinyClientSocket.h"
#include <ace/SOCK.h>
#include <ace/INET_Addr.h>
#include <ace/SOCK_Connector.h>
#include <ace/Time_Value.h>
#include <ace/INET_Addr.h>
#include <ace/OS_NS_netdb.h>
#include <ace/OS_NS_arpa_inet.h>

CTinyClientSocket::CTinyClientSocket() :
			m_isConnected(false),
			m_stream(NULL)
{
}

CTinyClientSocket::~CTinyClientSocket()
{
}


bool CTinyClientSocket::InitNetwork()
{
	return true;
}

bool CTinyClientSocket::InitSocket()
{
	m_isConnected = false;
	m_stream = new ACE_SOCK_Stream();
	return true;
}

void CTinyClientSocket::FiniNetwork()
{
}

void CTinyClientSocket::FiniSocket()
{
	if (m_isConnected)
		Disconnect();
	if (NULL != m_stream)
	{
		delete m_stream;
		m_stream = NULL;
	}
}

bool CTinyClientSocket::Connect(const char* ip, const int port)
{
	ACE_INET_Addr connectAddr(port, ip);
	ACE_SOCK_Connector connector;
	int result = connector.connect(*m_stream, connectAddr);
	if (-1 == result)
		return false;
	m_isConnected = true;
	return true;
}

void CTinyClientSocket::Disconnect()
{
	m_isConnected = false;
	m_stream->close();
}

bool CTinyClientSocket::Send(const char* buffer, const uint32 len)
{
	if (len <= 0)
		return false;
	if (false == m_isConnected)
		return false;
	return (len == m_stream->send_n(buffer, len));
}

uint32 CTinyClientSocket::Receive(char* buffer, const uint32 len, const uint32 timeoutMs)
{
	ACE_Time_Value waitTime(timeoutMs/1000, (timeoutMs%1000)*1000);
	return (uint32)m_stream->recv(buffer, len, &waitTime);
}

bool CTinyClientSocket::IsConnected() const
{
	return m_isConnected;
}

//////////////////////////////////////////////////////////////////////////
bool CTinyClientSocket::GetLocalIPAddress(std::string& ip) const
{
	const int HostNameLength = 256;
	char hostBuffer[HostNameLength] = {0,};
	ACE_INET_Addr inetAddr;
	inetAddr.get_host_name(hostBuffer, HostNameLength);
	hostent* host = ACE_OS::gethostbyname(hostBuffer);
	struct in_addr addr;
	for (int i=0; host->h_addr_list[i] != 0; ++i) 
	{
		memcpy(&addr, host->h_addr_list[i], sizeof(struct in_addr));
		ip = ACE_OS::inet_ntoa(addr);
		if (ip != "127.0.0.1")
			return true;
	}
	return false;
}


//////////////////////////////////////////////////////////////////////////
bool CTinyClientSocket::GetLocalMacAddress(std::string& mac) const
{
	ACE_OS::macaddr_node_t addrNode;
	if (-1 == ACE_OS::getmacaddress(&addrNode))
		return false;

	const int MacAddressPartCount = 6;
	for (int i=0; i<MacAddressPartCount; ++i)
	{
		mac += DecHex(addrNode.node[i]);
		if (i < MacAddressPartCount-1)
			mac += ":";
	}
	return true;
}

std::string CTinyClientSocket::DecHex(int val) const
{
	int lo = val%16;
	int hi = val/16;
	char a0 = hi<10?hi+'0':hi-10+'a';
	char a1 = lo<10?lo+'0':lo-10+'a';
	char b0[2] = {a0,0};
	char b1[2] = {a1,0};
	return std::string(b0)+std::string(b1);
	//return std::string(hi<10?hi+'0':hi-10+'a')+std::string(lo<10?lo+'0':lo-10+'a');
}
