#ifndef __tinyclientsocket_h__
#define __tinyclientsocket_h__

#pragma once

class ACE_SOCK_Stream;

class CTinyClientSocket
{
public:
	CTinyClientSocket(void);
	virtual ~CTinyClientSocket(void);

	bool	InitNetwork();
	void	FiniNetwork();

	///////////////////////////////////////////////
	// Description:
	//   Create socket and event object
	//////////////////////////////////////////////
	bool	InitSocket();

	///////////////////////////////////////////////
	// Description:
	//   Cleanup socket and event object
	//////////////////////////////////////////////
	void	FiniSocket();

	bool	Connect(const char* ip, const int port);
	bool	Send(const char* buffer, const uint32 len);
	void	Disconnect();

	////////////////////////////////////////////////////////
	// Description:
	//   Receive certain length or certain time
	// Arguments:
	//   length - size of the buffer
	//   timeout - how much time(ms) wait for the packet
	// Return:
	//   How many bytes you receive.
	//   If it's zero, there are no packets or get an error.
	//////////////////////////////////////////////////////
	uint32	Receive(char* buffer, const uint32 length, const uint32 timeout);

	bool	IsConnected() const;
	bool	GetLocalIPAddress(std::string& ip) const;
	bool	GetLocalMacAddress(std::string& mac) const;

protected:
	std::string	DecHex(int val) const;

private:
	bool			m_isConnected;
	ACE_SOCK_Stream* m_stream;

};

#endif // __tinyclientsocket_h__

