#include "stdafx.h"
#include "UniKeyFR.h"
#include "LicenseDataJob.h"
#include <string>
#include "ProtocolBuilder.h"
#include <time.h>
#include "AesCryptography.h"
#include "LicenseServerCommon.h"
#include "SimpleFileLog.h"

//////////////////////////////////////////////////////////////////////////
std::string Base64Encode(const char* pBytesToEncode, int bufferLen) 
{
	const std::string base64_chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZABCDEFGHIJKLMNOPQRSTUVWXYZ012345678923";
	unsigned int in_len = bufferLen;

	std::string ret;
	int i = 0;
	int j = 0;
	unsigned char char_array_3[3];
	unsigned char char_array_4[4];

	while (in_len--) 
	{
		char_array_3[i++] = (unsigned char)*(pBytesToEncode++);
		if (i == 3) {
			char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
			char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
			char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
			char_array_4[3] = char_array_3[2] & 0x3f;

			for(i = 0; (i <4) ; i++)
				ret += base64_chars[char_array_4[i]];
			i = 0;
		}
	}

	if (i)
	{
		for(j = i; j < 3; j++)
			char_array_3[j] = '\0';

		char_array_4[0] = (char_array_3[0] & 0xfc) >> 2;
		char_array_4[1] = ((char_array_3[0] & 0x03) << 4) + ((char_array_3[1] & 0xf0) >> 4);
		char_array_4[2] = ((char_array_3[1] & 0x0f) << 2) + ((char_array_3[2] & 0xc0) >> 6);
		char_array_4[3] = char_array_3[2] & 0x3f;

		for (j = 0; (j < i + 1); j++)
			ret += base64_chars[char_array_4[j]];

		while((i++ < 3))
			ret += '=';
	}

	return ret;
}

std::string GenerateRandomKey()
{
	std::string key;
	const int ArraySize = 6;
	char randomArray[ArraySize] = {0,};

	for (int i=0;i<ArraySize; ++i)
	{
		randomArray[i] = rand()%255 + 1;
	}

	key = Base64Encode((const char*)randomArray, ArraySize);
	return key.substr(0, 4);
}

std::string GenerateDongleLicenseKey()
{
	std::string resultKey;
	srand((unsigned int)time(NULL));
	const int KeyPartCount = 4;
	for (int i=0;i<KeyPartCount;++i)
	{
		resultKey += GenerateRandomKey();
		if (i<KeyPartCount-1)
			resultKey += "-";
	}
	return resultKey;
}

//////////////////////////////////////////////////////////////////////////


const uint32 OneDaySecond = 24*60*60;

CLicenseDataJob::CLicenseDataJob() : m_configReader(new CProtocolBuilder()), m_outputLog(new CSimpleFileLog())
{
	srand((unsigned)time(NULL));
	m_outputLog->SetFilename("LicenseDataWriteOutput.log");
	m_password4dongle[0] = 19067;
	m_password4dongle[1] = 43378;
	m_password4dongle[2] = 64671;
	m_password4dongle[3] = 8007;
}

CLicenseDataJob::~CLicenseDataJob()
{
	if (NULL != m_configReader)
	{
		delete m_configReader;
		m_configReader = NULL;
	}
	if (NULL != m_outputLog)
	{
		delete m_outputLog;
		m_outputLog = NULL;
	}
}

bool CLicenseDataJob::ReadConfigFile( const char* filename )
{
	FILE* r = fopen(filename, "rb");
	if (NULL == r)
		return false;

	const int BufferMax = 1024;
	char* fileBuffer = new char[BufferMax];
	size_t fileSize = fread(fileBuffer, 1, BufferMax, r);
	fclose(r);

	std::string readString(fileBuffer, fileSize);
	delete [] fileBuffer;
	while ( readString.find("\r\n") != std::string::npos )
	{
		readString.erase ( readString.find ("\r\n"), 2 );
	}

	return m_configReader->Parse(readString);
}

bool CLicenseDataJob::Execute()
{
	if (false == TryWithCustomPassword())
	{
		OutputLog("====ChangePassword start.====\n");
		bool result = ChangePassword();
		if (result)
			OutputLog("====ChangePassword success.====\n");
		else
			OutputLog("====ChangePassword fail.====\n");
	}

	if (m_configReader->GetValue<bool>("WriteLicenseData"))
	{
		OutputLog("====WriteLicenseData start.====\n");
		bool result = WriteLicenseData();
		if (result)
		{
			OutputLog("====WriteLicenseData success.====\n");
		}
		else
		{
			OutputLog("====WriteLicenseData fail.====\n");
			return false;
		}
	}

	OutputLog("====ReadLicenseData start. ====\n");
	return ReadLicenseData();
}

void CLicenseDataJob::MakeRandomBuffer( char* buffer, uint32 len )
{
	for(uint32 i=0; i<len; ++i)
		buffer[i] = rand();
}

bool CLicenseDataJob::ChangePassword()
{
	WORD handle, p1, p2, p3, p4;
	DWORD retcode, lp1, lp2;
	p1 = 1234;
	p2 = 1234;
	p3 = 1234;
	p4 = 1234;

	lp1 = 0, lp2 = 1;
	retcode = UniKey_Find(&handle, &lp1, &lp2);
	if (retcode)
	{
		OutputLog("UniKey_Find error code: %d \n", retcode);
		return false;
	}
	// return the hardware ID (HID)                             
	OutputLog("Find UniKey: %08X\n", lp1);

	retcode = UniKey_Vender_Logon(&handle, &p1, &p2, &p3, &p4);
	if (retcode)
	{
		OutputLog("UniKey_Vender_Logon error code: %d \n", retcode);
		return false;
	}

	//DWORD seed = m_configReader->GetValue<uint32>("SeedForNewPassword");
	DWORD seed = 2591;
	OutputLog("ChangePassword seed is %d.\n", seed);
	retcode = UniKey_Generate_New_Password(&handle, &seed, &p1, &p2, &p3, &p4);
	if (retcode)
	{
		OutputLog("UniKey_Generate_New_Password error code: %d \n", retcode);
		return false;
	}
	OutputLog("New password is %d %d %d %d\n", p1, p2, p3, p4);

	UniKey_Logoff(&handle);
	return true;
};

bool CLicenseDataJob::WriteLicenseData()
{
	WORD handle, p1, p2, p3, p4;
	DWORD retcode, lp1, lp2;
	p1 = m_configReader->GetValue<int16>("Password1");
	p2 = m_configReader->GetValue<int16>("Password2");
	p3 = m_configReader->GetValue<int16>("Password3");
	p4 = m_configReader->GetValue<int16>("Password4");

	p1 = 19067;
	p2 = 43378;
	p3 = 64671;
	p4 = 8007;

	lp1 = 0, lp2 = 1;
	retcode = UniKey_Find(&handle, &lp1, &lp2);
	if (retcode)
	{
		OutputLog("UniKey_Find error code: %d \n", retcode);
		return false;
	}
	// return the hardware ID (HID)                             
	OutputLog("Find UniKey: %08X\n", lp1);

	retcode = UniKey_Vender_Logon(&handle, &p1, &p2, &p3, &p4);
	if (retcode)
	{
		OutputLog("UniKey_Vender_Logon error code: %d \n", retcode);
		return false;
	}

	uint32 maxConnection = m_configReader->GetValue<uint32>("MaxConnection");
	uint32 termSec = m_configReader->GetValue<uint32>("Sec");
	uint32 termDay = m_configReader->GetValue<uint32>("Day");
	uint32 termMonth = m_configReader->GetValue<uint32>("Month");
	uint32 termYear = m_configReader->GetValue<uint32>("Year");
	std::string mac = m_configReader->GetValue<std::string>("Mac");
	std::string key = m_configReader->GetValue<std::string>("Key");
	if (key.empty())
		key = GenerateDongleLicenseKey();

	OutputLog("Key = %s\n", key.c_str());
	OutputLog("MaxConnection = %d\n", maxConnection);
	OutputLog("Validity Term : ");
	if (termYear > 0)
		OutputLog("%d Year(s) ", termYear);
	if (termMonth > 0)
		OutputLog("%d Month(s) ", termMonth);
	if (termDay > 0)
		OutputLog("%d Day(s) ", termDay);
	if (termSec > 0)
		OutputLog("%d Sec(s) ", termSec);

	OutputLog("\n");
	SUniKeySaveData saveData;
	MakeRandomBuffer(saveData.dummyData0, UniKeyDummyLength0);
	MakeRandomBuffer(saveData.dummyData1, UniKeyDummyLength1);
	MakeRandomBuffer(saveData.dummyData2, UniKeyDummyLength2);
	time((time_t*)&saveData.startTime);
	saveData.dataVersion = UniKeyDataVersion;

	uint32 addSecond = termSec + termDay*OneDaySecond + termMonth*30*OneDaySecond + termYear*365*OneDaySecond;
	saveData.validityTerm = addSecond;
	saveData.expireTime = 0;
	saveData.startTime = 0;
	saveData.lastLoginTime = 0;
	//tm stime0, stime1;
	//localtime_s(&stime0, &saveData.startTime);
	//localtime_s(&stime1, &saveData.expireTime);
	saveData.concurrentClientCount = maxConnection;
	strcpy(saveData.licenseKey, key.c_str());

	WORD offset = 0;
	WORD dataSize = sizeof(SUniKeySaveData);

	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));

	char buffer[256] = {0,};
	cryptObj.EncryptBuffer((uint8*)&saveData, dataSize, (uint8*)buffer);

	retcode = UniKey_Write_Memory(&handle, &offset, &dataSize, (BYTE*)buffer);
	if (retcode)
	{
		OutputLog("UniKey_Write_Memory error code: %d \n", retcode);
		return false;
	}

	UniKey_Logoff(&handle);
	return true;
}

bool CLicenseDataJob::ReadLicenseData()
{
	WORD handle, p1, p2, p3, p4;
	DWORD retcode, lp1, lp2;
	p1 = m_password4dongle[0];
	p2 = m_password4dongle[1];
	p3 = m_password4dongle[2];
	p4 = m_password4dongle[3];

	OutputLog("Password %d, %d, %d, %d\n", p1, p2, p3, p4);

	lp1 = 0, lp2 = 1;
	retcode = UniKey_Find(&handle, &lp1, &lp2);
	if (retcode)
	{
		OutputLog("UniKey_Find error code: %d \n", retcode);
		return false;
	}
	// return the hardware ID (HID)                             
	OutputLog("Find UniKey: %08X\n", lp1);

	retcode = UniKey_Vender_Logon(&handle, &p1, &p2, &p3, &p4);
	if (retcode)
	{
		OutputLog("UniKey_Vender_Logon error code: %d \n", retcode);
		return false;
	}

	SUniKeySaveData readData;
	memset(&readData, 0, sizeof(SUniKeySaveData));
	unsigned short offset = 0;
	unsigned short dataSize = sizeof(SUniKeySaveData);
	char buffer[256] = {0,};
	retcode = UniKey_Read_Memory(&handle, &offset, &dataSize, (unsigned char*)buffer);
	if (SUCCESS != retcode)
		return false;

	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));
	cryptObj.DecryptBuffer((unsigned char*)&buffer, dataSize, (unsigned char*)&readData);

	OutputLog("DataVersion = %d\n", readData.dataVersion);
	OutputLog("MaxConnection = %d\n", readData.concurrentClientCount);
	OutputLog("LicenseKey = %s\n", readData.licenseKey);
	OutputLog("ValidityTerm = %d sec or %d days\n", readData.validityTerm, readData.validityTerm/OneDaySecond);

	char timeBuffer[64] = {0,};
	time_t t = readData.startTime;
	OutputLog("StartTime = %s", ctime(&t));
	t = readData.expireTime;
	OutputLog("ExpireTime = %s", ctime(&t));
	t = readData.lastLoginTime;
	OutputLog("LastLoginTime = %s", ctime(&t));

	UniKey_Logoff(&handle);
	return true;
}

void CLicenseDataJob::OutputLog(const char* formatStr, ...)
{
	int logBufferSize = 512;
	int resultBufferLength = 0;
	char* buffer = NULL;
	do 
	{
		if (NULL != buffer)
		{
			delete[] buffer;
			buffer = NULL;
		}
		logBufferSize *= 2;
		buffer = new char[logBufferSize];
		memset(buffer, 0, logBufferSize);
		va_list argList;
		va_start(argList, formatStr);
		resultBufferLength = vsnprintf_s(buffer, logBufferSize, _TRUNCATE, formatStr, argList);
		va_end(argList);
	} while(resultBufferLength >= logBufferSize);

	printf(buffer);
	m_outputLog->Log(buffer);
}

bool CLicenseDataJob::TryWithCustomPassword()
{
	OutputLog("====TryWithCustomPassword start.====\n");
	WORD handle, p1, p2, p3, p4;
	DWORD retcode, lp1, lp2;
	p1 = m_password4dongle[0];
	p2 = m_password4dongle[1];
	p3 = m_password4dongle[2];
	p4 = m_password4dongle[3];

	lp1 = 0, lp2 = 1;
	retcode = UniKey_Find(&handle, &lp1, &lp2);
	if (retcode)
	{
		OutputLog("UniKey_Find error code: %d \n", retcode);
		return false;
	}
	// return the hardware ID (HID)                             
	OutputLog("Find UniKey: %08X\n", lp1);

	retcode = UniKey_Vender_Logon(&handle, &p1, &p2, &p3, &p4);
	if (retcode)
	{
		OutputLog("UniKey_Vender_Logon error code: %d \n", retcode);
		return false;
	}

	UniKey_Logoff(&handle);
	return true;

}