#ifndef __licensedatajob_h__
#define __licensedatajob_h__

#pragma once

class CProtocolBuilder;
class CSimpleFileLog;

class CLicenseDataJob
{
public:
	CLicenseDataJob();
	~CLicenseDataJob();

	bool ReadConfigFile(const char* filename);
	bool Execute();

protected:
	void MakeRandomBuffer(char* buffer, uint32 len);
	bool ChangePassword();
	bool WriteLicenseData();
	bool ReadLicenseData();
	bool TryWithCustomPassword();

	void OutputLog(const char* formatStr, ...);

private:
	CProtocolBuilder* m_configReader;
	CSimpleFileLog* m_outputLog;
	unsigned short m_password4dongle[4];

};

#endif // __licensedatajob_h__