#include "stdafx.h"
#include "ClientModeManager.h"
#include "EncryptedLicenseData.h"
#include "UserPool.h"

//////////////////////////////////////////////////////////////////////////
CClientModeManager::CClientModeManager() : 
		m_userPool(new CUserPool()),
		m_sessionKeyContainer(new CUserPool()),
		m_licenseData(new CEncryptedLicenseData())
{
}

CClientModeManager::~CClientModeManager()
{
	SAFE_DELETE(m_licenseData);
	SAFE_DELETE(m_sessionKeyContainer);
	SAFE_DELETE(m_userPool);
}

EPMErrorCode CClientModeManager::LoginUser(uint32 userId, std::string key, std::string mac, std::string sessionKey)
{
	if (PMEC_NO_ERROR != m_licenseData->GetErrorCode())
		return m_licenseData->GetErrorCode();

	bool poolResult = m_userPool->Login(userId, mac);
	if (false == poolResult)
		return PMEC_OVER_CONNECTION;

	poolResult = m_sessionKeyContainer->Login(userId, sessionKey);
	if (false == poolResult)
		return PMEC_OVER_CONNECTION;

	return PMEC_NO_ERROR;
}

void CClientModeManager::LogoffUser(uint32 userId)
{
	m_userPool->Logoff(userId);
	m_sessionKeyContainer->Logoff(userId);
}

EPMErrorCode CClientModeManager::AuthenticateUser( uint32 userId, std::string key, std::string mac, std::string sessionKey )
{
	if (PMEC_NO_ERROR != m_licenseData->GetErrorCode())
		return m_licenseData->GetErrorCode();

	bool poolResult = m_userPool->Authenticate(userId, mac);
	if (false == poolResult)
		return PMEC_OVER_CONNECTION;

	poolResult = m_sessionKeyContainer->Authenticate(userId, sessionKey);
	if (false == poolResult)
		return PMEC_OVER_CONNECTION;

	return PMEC_NO_ERROR;
}

void CClientModeManager::GetLicenseKey(std::string& key)
{
	m_licenseData->GetLicenseKey(key);
}

void CClientModeManager::GetEncryptKey(std::string& key)
{
	m_licenseData->GetEncryptKey(key);
}

void CClientModeManager::SetLicenseKey( const std::string& key )
{
	m_licenseData->SetLicenseKey(key.c_str());
}

void CClientModeManager::SetEncryptKey( const std::string& key )
{
	m_licenseData->SetEncryptKey(key.c_str());
}

void CClientModeManager::SetErrorCode( EPMErrorCode code )
{
	m_licenseData->SetErrorCode(code);
}

EPMErrorCode CClientModeManager::GetErrorCode()
{
	return m_licenseData->GetErrorCode();
}

void CClientModeManager::SetMaxUserCount( uint32 count )
{
	m_userPool->SetMaxUser(count);
	m_sessionKeyContainer->SetMaxUser(count);
	m_licenseData->SetUserCount(count);
}

uint32 CClientModeManager::GetMaxUserCount()
{
	return m_licenseData->GetUserCount();
}

void CClientModeManager::SetGlobalLicenseServerStreamId( uint32 streamId )
{
	m_globalLicenseServerStreamId = streamId;
}

uint32 CClientModeManager::GetGlobalLicenseServerStreamId()
{
	return m_globalLicenseServerStreamId;
}

void CClientModeManager::GetLocalIp( std::string& ip )
{
	ip = m_localIp;
}

void CClientModeManager::SetLocalIp( const std::string& ip )
{
	m_localIp = ip;
}

void CClientModeManager::GetMacAddress( std::string& mac )
{
	mac = m_localMac;
}

void CClientModeManager::SetMacAddress( const std::string& mac )
{
	m_localMac = mac;
}