#ifndef __clientmodemanager_h__
#define __clientmodemanager_h__

#pragma once

#include "LicenseServerCommon.h"

//////////////////////////////////////////////////////////////////////////
class CUserPool;
class CEncryptedLicenseData;
class CClientModeManager
{
public:
	CClientModeManager();
	~CClientModeManager();

	TAGES_EXPORT	EPMErrorCode	LoginUser(uint32 userId, std::string key, std::string mac, std::string sessionKey);
	TAGES_EXPORT	void	LogoffUser(uint32 userId);
	TAGES_EXPORT	EPMErrorCode	AuthenticateUser(uint32 userId, std::string key, std::string mac, std::string sessionKey);
	TAGES_EXPORT	void SetLicenseKey(const std::string& key);
	TAGES_EXPORT	void SetEncryptKey(const std::string& key);
	TAGES_EXPORT	void GetLicenseKey(std::string& key);
	TAGES_EXPORT	void GetEncryptKey(std::string& key);
	TAGES_EXPORT	void SetErrorCode(EPMErrorCode code);
	TAGES_EXPORT	EPMErrorCode GetErrorCode();
	TAGES_EXPORT	void SetMaxUserCount(uint32 count);
	TAGES_EXPORT	uint32 GetMaxUserCount();
	TAGES_EXPORT	void SetGlobalLicenseServerStreamId(uint32 streamId);
	TAGES_EXPORT	uint32 GetGlobalLicenseServerStreamId();
	TAGES_EXPORT	void GetLocalIp(std::string& ip);
	TAGES_EXPORT	void SetLocalIp(const std::string& ip);
	TAGES_EXPORT	void GetMacAddress(std::string& mac);
	TAGES_EXPORT	void SetMacAddress(const std::string& mac);
	

private:
	CUserPool* m_userPool;
	CUserPool* m_sessionKeyContainer;
	CEncryptedLicenseData* m_licenseData;
	uint32 m_globalLicenseServerStreamId;
	std::string m_localIp;
	std::string m_localMac;
};

#endif // __clientmodemanager_h__