#ifndef __clientmodeserver_h__
#define __clientmodeserver_h__

#pragma once

#include "AbstractJobServer.h"
#include "LicenseServerCommon.h"

class CJobQueue;
class CClientModeManager;
class CLicenseConnection;
class CLicenseConnectionServer;
namespace DreiNetwork
{
	class CycleChecker;
}

class CClientModeServer : public CAbstractJobServer
{
public:
	CClientModeServer();
	~CClientModeServer(void);

	TAGES_EXPORT	virtual bool Init(CJobQueue*);
	TAGES_EXPORT	virtual void Fini();
	TAGES_EXPORT	virtual void Update();
	TAGES_EXPORT	virtual void MakeConnectionWithGlobalServer();

protected:
	TAGES_EXPORT	bool GetProxyInfo(std::string& ip, int& port, std::string& authStr);
	TAGES_EXPORT	EPMErrorCode AuthLicenseConnectionSync(CLicenseConnection& licenseConnection);
	TAGES_EXPORT	void AuthLicenseConnectionAsync();
	TAGES_EXPORT	void ApplyLicenseData(EPMErrorCode retCode, const std::string& encryptKey, uint32 floatLicenses, const std::string localIp, const std::string localMac);
	TAGES_EXPORT	void UpdateLicenseConnection();
	TAGES_EXPORT	bool IsValidServerConfig();
	void PrintErrorCode(EPMErrorCode retCode);
	TAGES_EXPORT	void ConnectGlobalServer();
	TAGES_EXPORT	void ResetConnection();
	


private:
	bool							m_init;
	CJobQueue*				m_jobQueue;
	CClientModeManager* m_clientmodeManager;
	DreiNetwork::CycleChecker* m_licenseCheckTimer;
	std::string m_serverIp;
	int m_serverPort;
	std::string m_licenseKey;
	CLicenseConnectionServer* m_licenseConnectionServer;
};

#endif // __clientmodeserver_h__