#ifndef __databasemodemanager_h__
#define __databasemodemanager_h__

#pragma once

#ifdef USING_DATABASE_MODE

#include "LicenseServerCommon.h"

//////////////////////////////////////////////////////////////////////////

class CDBConnection;
class CLicensekeyPool;

struct SLoginUserResult
{
	EPMErrorCode errorCode;
	bool allowFloatConnection;
	uint8 connectType;
	uint32 floatLicenses;
	uint32 companyID;
	uint32 remainSecond;
	std::string sessionId;
};

class CDatabaseModeManager
{
public:
	CDatabaseModeManager();
	~CDatabaseModeManager();

	bool Init();
	void Fini();

	SLoginUserResult	LoginUser(uint32 userId, const SAuthenticateParam& authParam, const std::string& ip, const std::string& version);
	void	LogoffUser(uint32 userId);
	EPMErrorCode	AuthenticateUser(uint32 userId, const SAuthenticateParam& authParam, const std::string& ip);

	ECreateAccountResult CreateAccount( const SCreateAccountParam& param, const std::string& licenseKey, uint32& userId );
	ELoginAccountResult AuthenticateAccount( const std::string& username, const std::string& password, const std::string& licenseKey, bool& agreelicenseFlag );
	void UpdateAgreeLicense( const std::string& username );
	bool GetStudentPassword(const std::string& username, const std::string& email, std::string& password, uint32& userId);
	

protected:
	bool IsValidUsernameString(const std::string& username);

private:
	CDBConnection* m_dbConn;
	CLicensekeyPool* m_pool;
};

#endif // USING_DATABASE_MODE

#endif // __databasemodemanager_h__