#include "stdafx.h"
#include "DatabaseServer.h"

#ifdef USING_DATABASE_MODE

#include "JobQueue.h"
#include "DatabaseModeManager.h"

CDatabaseServer::CDatabaseServer(void) : 
	m_init(false), 
	m_jobQueue(NULL),
	m_dbModeManager(new CDatabaseModeManager())
{
}

CDatabaseServer::~CDatabaseServer(void)
{
	SAFE_DELETE(m_dbModeManager);
}

bool CDatabaseServer::Init(CJobQueue* que)
{
	m_jobQueue = que;

	if (false == m_dbModeManager->Init())
		return false;

	m_init = true;
	return true;
}

void CDatabaseServer::Fini()
{
	if (false == m_init)
		return;

	m_dbModeManager->Fini();
}

void CDatabaseServer::Update()
{
	while(true)
	{
		CAbstractJob* job = m_jobQueue->PopWork(-1);
		if (NULL == job)
			break;

		job->DBExecute(*m_dbModeManager);
		job->Complete();
		delete job;
		job = NULL;
		if (m_jobQueue->Empty())
			break;
	}
}

#endif // USE_DATABASE_MODE