#include "stdafx.h"
#include "EncryptedLicenseData.h"
#include "AesCryptography.h"

const uint32 ReservedBufferSizeForExtra = 128;
struct SExtraLicenseData
{
	char dummyData0[UniKeyDummyLength0];
	EPMErrorCode errorCode;
	char dummyData1[UniKeyDummyLength1];
	char reservedBuffer[ReservedBufferSizeForExtra];
};

const uint32 ExtraLicenseDataSize = sizeof(SExtraLicenseData);

CEncryptedLicenseData::CEncryptedLicenseData()
{
	m_encryptedBuffer = new char[LicenseDataSize];
	m_decryptedBuffer = new char[LicenseDataSize];
	m_extraEncryptedBuffer = new char[ExtraLicenseDataSize];
	m_extraDecryptedBuffer = new char[ExtraLicenseDataSize];
}

CEncryptedLicenseData::~CEncryptedLicenseData()
{
	delete[] m_encryptedBuffer;
	m_encryptedBuffer = NULL;
	delete[] m_decryptedBuffer;
	m_decryptedBuffer = NULL;

	delete[] m_extraEncryptedBuffer;
	m_extraEncryptedBuffer = NULL;
	delete[] m_extraDecryptedBuffer;
	m_extraDecryptedBuffer = NULL;
}
TimeType CEncryptedLicenseData::GetStartTime()
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	return data.startTime;
}

void CEncryptedLicenseData::SetStartTime( TimeType t )
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	data.startTime = t;
	ApplyEncryptedBuffer(data);
}

TimeType CEncryptedLicenseData::GetExpireTime()
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	return data.expireTime;
}

void CEncryptedLicenseData::SetExpireTime( TimeType t )
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	data.expireTime = t;
	ApplyEncryptedBuffer(data);
}

TimeType CEncryptedLicenseData::GetLastLoginTime()
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	return data.lastLoginTime;
}

void CEncryptedLicenseData::SetLastLoginTime( TimeType t )
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	data.lastLoginTime = t;
	ApplyEncryptedBuffer(data);
}

uint32 CEncryptedLicenseData::GetValidityTerm()
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	return data.validityTerm;
}

void CEncryptedLicenseData::SetValidityTerm( uint32 term )
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	data.validityTerm = term;
	ApplyEncryptedBuffer(data);
}

uint32 CEncryptedLicenseData::GetUserCount()
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	return data.concurrentClientCount;
}

void CEncryptedLicenseData::SetUserCount( uint32 count )
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	data.concurrentClientCount = count;
	ApplyEncryptedBuffer(data);
}

void CEncryptedLicenseData::GetLicenseKey(std::string& key)
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	key = data.licenseKey;
}

void CEncryptedLicenseData::SetLicenseKey( const char* key )
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	strcpy(data.licenseKey, key);
	ApplyEncryptedBuffer(data);
}

void CEncryptedLicenseData::GetEncryptKey(std::string& key)
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	key = data.encryptKey;
}

void CEncryptedLicenseData::SetEncryptKey( const char* key )
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	strcpy(data.encryptKey, key);
	ApplyEncryptedBuffer(data);
}

uint32 CEncryptedLicenseData::GetDataVersion()
{
	SUniKeySaveData	data;
	MakeLicenseData(data);
	return data.dataVersion;
}

void CEncryptedLicenseData::ApplyEncryptedBuffer( const char* buffer )
{
	memcpy(m_encryptedBuffer, buffer, LicenseDataSize);
}

void CEncryptedLicenseData::GetEncryptedBuffer( char* buffer )
{
	memcpy(buffer, m_encryptedBuffer, LicenseDataSize);
}

void CEncryptedLicenseData::MakeLicenseData( SUniKeySaveData& data )
{
	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));
	cryptObj.DecryptBuffer((uint8*)m_encryptedBuffer, LicenseDataSize, (uint8*)m_decryptedBuffer);
	memcpy(&data, m_decryptedBuffer, LicenseDataSize);
}

void CEncryptedLicenseData::ApplyEncryptedBuffer( const SUniKeySaveData& data )
{
	memcpy(m_decryptedBuffer, &data, LicenseDataSize);
	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));
	cryptObj.EncryptBuffer((uint8*)m_decryptedBuffer, LicenseDataSize, (uint8*)m_encryptedBuffer);
}

void CEncryptedLicenseData::MakeExtraLicenseData( SExtraLicenseData& data )
{
	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));
	cryptObj.DecryptBuffer((uint8*)m_extraEncryptedBuffer, ExtraLicenseDataSize, (uint8*)m_extraDecryptedBuffer);
	memcpy(&data, m_extraDecryptedBuffer, ExtraLicenseDataSize);
}

void CEncryptedLicenseData::ApplyExtraEncryptedBuffer( const SExtraLicenseData& data)
{
	memcpy(m_extraDecryptedBuffer, &data, ExtraLicenseDataSize);
	CAesCryptography cryptObj;
	cryptObj.SetKeyValue(UniKeyDataCryptKey, sizeof(UniKeyDataCryptKey));
	cryptObj.EncryptBuffer((uint8*)m_extraDecryptedBuffer, ExtraLicenseDataSize, (uint8*)m_extraEncryptedBuffer);
}

EPMErrorCode CEncryptedLicenseData::GetErrorCode()
{
	SExtraLicenseData data;
	MakeExtraLicenseData(data);
	return data.errorCode;
}

void CEncryptedLicenseData::SetErrorCode( EPMErrorCode code )
{
	SExtraLicenseData	data;
	MakeExtraLicenseData(data);
	data.errorCode = code;
	ApplyExtraEncryptedBuffer(data);
}