#ifndef __encryptedlicensedata_h__
#define __encryptedlicensedata_h__

#pragma once

#include "LicenseServerCommon.h"

const uint32 LicenseDataSize = sizeof(SUniKeySaveData);

struct SExtraLicenseData;

//////////////////////////////////////////////////////////////////////////
class CEncryptedLicenseData
{
public:
	CEncryptedLicenseData();
	~CEncryptedLicenseData();

	TAGES_EXPORT	TimeType	GetStartTime();
	TAGES_EXPORT	void			SetStartTime(TimeType t);
	TAGES_EXPORT	TimeType	GetExpireTime();
	TAGES_EXPORT	void			SetExpireTime(TimeType t);
	TAGES_EXPORT	TimeType	GetLastLoginTime();
	TAGES_EXPORT	void			SetLastLoginTime(TimeType t);
	TAGES_EXPORT	uint32		GetValidityTerm();
	TAGES_EXPORT	void			SetValidityTerm(uint32 term);
	TAGES_EXPORT	uint32		GetUserCount();
	TAGES_EXPORT	void			SetUserCount(uint32 count);
	TAGES_EXPORT	void			GetLicenseKey(std::string& key);
	TAGES_EXPORT	void			SetLicenseKey(const char* key);
	TAGES_EXPORT	void			GetEncryptKey(std::string& key);
	TAGES_EXPORT	void			SetEncryptKey(const char* key);
	TAGES_EXPORT	uint32		GetDataVersion();

	TAGES_EXPORT	EPMErrorCode	GetErrorCode();
	TAGES_EXPORT	void			SetErrorCode(EPMErrorCode code);


	TAGES_EXPORT	void			ApplyEncryptedBuffer(const char* buffer);
	TAGES_EXPORT	void			GetEncryptedBuffer(char* buffer);

protected:
	TAGES_EXPORT	void			MakeLicenseData(SUniKeySaveData& data);
	TAGES_EXPORT	void			ApplyEncryptedBuffer(const SUniKeySaveData& data);
	TAGES_EXPORT	void			MakeExtraLicenseData(SExtraLicenseData& data);
	TAGES_EXPORT	void			ApplyExtraEncryptedBuffer(const SExtraLicenseData& data);
	
private:
	char*			m_encryptedBuffer;
	char*			m_decryptedBuffer;

	char*			m_extraEncryptedBuffer;
	char*			m_extraDecryptedBuffer;
};


#endif // __encryptedlicensedata_h__