#ifndef __jobqueue_h__
#define __jobqueue_h__

#pragma once

#include "ProcessJobs.h"
#include <Drei/TsQueueWithEvent.h>

class CJobQueue
{
public:
	typedef DreiNetwork::TSQueueWithEventT<CAbstractJob*> TsJobQueue;
	CJobQueue(void);
	~CJobQueue(void);

	bool Init();
	void Fini();
	void PushWork(CAbstractJob* job);
	//void	PushDone(CAbstractJob* job);
	CAbstractJob*	PopWork(int32 timeout);
	//CAbstractJob*	PopDone(int32 timeout);
	void Pulse();
	bool Empty();
	
private:
	TsJobQueue	m_workQueue;
	TsJobQueue	m_doneQueue;
};


#endif // __jobqueue_h__