#include "stdafx.h"
#include "LicenseConnectionClient.h"
#include "ProtocolBuilder.h"
#include "ProtocolAssembler.h"
#include "LicenseServerCommon.h"
#include "JobQueue.h"
#include "ServerLog.h"

CLicenseConnectionClient::CLicenseConnectionClient(CJobQueue* que) : 
			m_streamId(0), m_jobQueue(que), m_assembler(new CProtocolAssembler())
{
}

CLicenseConnectionClient::~CLicenseConnectionClient(void)
{
	if (NULL != m_assembler)
	{
		delete m_assembler;
		m_assembler = NULL;
	}
}

void CLicenseConnectionClient::OnConnect(uint32 streamId)
{
	m_streamId = streamId;
#ifdef DEBUG_MESSAGE
	printf("[%02d] OnConnect LicenseConnection\n", streamId);
#endif
	CConnectionEstblished4LicenseConnection* job = new CConnectionEstblished4LicenseConnection(streamId);
	m_jobQueue->PushWork(job);
}

void CLicenseConnectionClient::OnReceive(const char* buffer, uint32 len )
{
	//DREI_LOG(PacketLogger, "OnReceive LicenseConn Len(%d)", len);
	uint32 bufferOffset = 0;
	m_assembler->ApplyBuffer(buffer, bufferOffset, len);

	CProtocolBuilder builder;
	builder.EncryptKey((unsigned char*)NetworkCryptKey, sizeof(NetworkCryptKey));
	while(m_assembler->AssembleBuilder(builder))
	{
		std::string receivedString = builder.MakeString();
		//DREI_LOG(PacketLogger, "Recv LicenseConn Len(%d) : %s", len, receivedString.c_str());

		std::string packetType = builder.GetValue<std::string>("type");
		if ("requestcreateaccount" == packetType)
			PacketHandle_RequestCreateAccount(builder);
		else if ("requestloginaccount" == packetType)
			PacketHandle_RequestLoginAccount(builder);
		else if ("login" == packetType)
			PacketHandle_Login(builder);
		else if ("requestpasswordremind" == packetType)
			PacketHandle_RequestPasswordRemind(builder);
		
		builder.Clear();

#ifdef DEBUG_MESSAGE
		printf("[%02d]Receive LicenseConnection(%s)\n", m_streamId, receivedString.c_str());
#endif
	}
}

void CLicenseConnectionClient::OnClose()
{
#ifdef DEBUG_MESSAGE
	printf("[%02d]Close LicenseConnection\n", m_streamId);
#endif
	DREI_LOG(PacketLogger, ACE_TEXT("Close LicenseConnection (%d)"), m_streamId);
	CConnectionClose4LicenseConnection* job = new CConnectionClose4LicenseConnection(m_streamId);
	m_jobQueue->PushWork(job);
}

void CLicenseConnectionClient::PacketHandle_RequestCreateAccount( CProtocolBuilder& packet )
{
	CCreateAccount4LicenseConnection* job = new CCreateAccount4LicenseConnection(packet.MakeString(), m_streamId);
	m_jobQueue->PushWork(job);
}

void CLicenseConnectionClient::PacketHandle_RequestLoginAccount( CProtocolBuilder& packet )
{
	CLoginAccount4LicenseConnection* job = new CLoginAccount4LicenseConnection(packet.MakeString(), m_streamId);
	m_jobQueue->PushWork(job);
}

void CLicenseConnectionClient::PacketHandle_Login( CProtocolBuilder& packet )
{
	uint32 tick = packet.GetValue<uint32>("tick");

	CLoginResult4LicenseConnection* job = new CLoginResult4LicenseConnection(packet.MakeString(), m_streamId, tick);
	m_jobQueue->PushWork(job);
}

void CLicenseConnectionClient::PacketHandle_RequestPasswordRemind( CProtocolBuilder& packet )
{
	CPasswordRemind4LicenseConnection* job = new CPasswordRemind4LicenseConnection(packet.MakeString(), m_streamId);
	m_jobQueue->PushWork(job);
}