#ifndef __licenseconnectionclient_h__
#define __licenseconnectionclient_h__

#pragma once

#include <Drei/MemoryObject.h>

class CJobQueue;
class CProtocolBuilder;
class CProtocolAssembler;

class CLicenseConnectionClient : public DreiNetwork::MemoryObject
{
public:
	CLicenseConnectionClient(CJobQueue* que);
	~CLicenseConnectionClient(void);

	void	OnConnect(uint32 streamId);
	void	OnReceive(const char* buffer, uint32 len);
	void	OnClose();

protected:
	TAGES_EXPORT	void	PacketHandle_RequestCreateAccount(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_RequestLoginAccount(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_Login(CProtocolBuilder& packet);
	TAGES_EXPORT	void	PacketHandle_RequestPasswordRemind(CProtocolBuilder& packet);

private:
	CJobQueue*					m_jobQueue;
	CProtocolAssembler*	m_assembler;
	uint32							m_streamId;
	std::string					m_remoteIp;
};

#endif // __licenseconnectionclient_h__