#include "stdafx.h"
#include "LicenseConnectionServer.h"
#include <Drei/NetworkFacade.h>
#include <Drei/MessageHeader.h>
#include "ProtocolBuilder.h"
#include "ProtocolAssembler.h"
#include "JobQueue.h"
#include "LicenseConnectionClient.h"
#include "ServerConfig.h"


CLicenseConnectionServer::CLicenseConnectionServer() : 
		m_jobQueue(NULL), 
		m_licenseConnectionClient(NULL), 
		m_proxyHandler(NULL)
{
	InitConnection();
}

CLicenseConnectionServer::~CLicenseConnectionServer(void)
{
	SAFE_DELETE(m_proxyHandler);
}

bool CLicenseConnectionServer::Init(CJobQueue* que)
{
	m_jobQueue = que;
	if (false == this->Open(1))
		return false;
	return true;
}

void CLicenseConnectionServer::Fini()
{
}

void CLicenseConnectionServer::Update()
{
	ACE_Message_Block* headBlock = NULL;
	ACE_Message_Block* commandBlock = NULL;
	using namespace DreiNetwork;
	bool receiveData = NetworkInstance->PopAllMessage(LicenseConnectionQueueId, &headBlock, -1);
	if (false == receiveData)
		return;
	commandBlock = headBlock;
	
	while(NULL != commandBlock)
	{
		MessagePostee postee;
		memcpy(&postee, commandBlock->rd_ptr(), sizeof(MessagePostee));
		commandBlock->rd_ptr(sizeof(MessagePostee));
		ACE_Message_Block* payloadBlock = commandBlock->cont();

		switch(postee.command)
		{
		case eMH_Establish:
			OnConnect(postee, payloadBlock->rd_ptr(), (::uint32)payloadBlock->length());
			break;
		case eMH_Read:
			OnReceive(postee, payloadBlock->rd_ptr(), (::uint32)payloadBlock->length());
			break;
		case eMH_Close:
			OnClose(postee);
			break;
		}
		commandBlock = payloadBlock->cont();
	}
	headBlock->release();
}

void CLicenseConnectionServer::OnConnect( DreiNetwork::MessagePostee& postee, const char* buffer, uint32 len )
{
	if (NULL == m_licenseConnectionClient)
	{
		bool createConnectionInstance = false;
		m_proxyHandler->OnConnect(postee.stream_id, createConnectionInstance);
		if (createConnectionInstance)
			m_licenseConnectionClient = new CLicenseConnectionClient(m_jobQueue);
	}
	if (m_licenseConnectionClient)
		m_licenseConnectionClient->OnConnect(postee.stream_id);
}

void CLicenseConnectionServer::OnReceive( DreiNetwork::MessagePostee& postee, const char* buffer, uint32 len )
{
	if (NULL == m_licenseConnectionClient)
	{
		bool createConnectionInstance = false;
		m_proxyHandler->OnReceive(buffer, len, createConnectionInstance);
		if (false == createConnectionInstance)
			return;
		m_licenseConnectionClient = new CLicenseConnectionClient(m_jobQueue);
		m_licenseConnectionClient->OnConnect(postee.stream_id);
		return;
	}
	if (m_licenseConnectionClient)
		m_licenseConnectionClient->OnReceive(buffer, len);
}

void CLicenseConnectionServer::OnClose( DreiNetwork::MessagePostee& postee )
{
	if (NULL == m_licenseConnectionClient)
		ACE_ASSERT(true);
	if (m_licenseConnectionClient)
		m_licenseConnectionClient->OnClose();
}

void CLicenseConnectionServer::SetProxy( const std::string& targetServerIp, int targetServerPort, const std::string& authStr )
{
	SAFE_DELETE(m_proxyHandler);
	m_proxyHandler = new CProxyConnectionHandler(targetServerIp, targetServerPort, authStr);
}

void CLicenseConnectionServer::InitConnection()
{
	SAFE_DELETE(m_licenseConnectionClient);
	SAFE_DELETE(m_proxyHandler);
	m_proxyHandler = new CNullProxyConnectionHandler();
}
//////////////////////////////////////////////////////////////////////////

CProxyConnectionHandler::CProxyConnectionHandler( const std::string& targetServerIp, int targetServerPort, const std::string& authStr ) :
	m_targetServerIp(targetServerIp),
	m_targetServerPort(targetServerPort),
	m_authStr(authStr)
{}

void CProxyConnectionHandler::OnConnect(uint32 streamId, bool& createConnectionInstance)
{
	createConnectionInstance = false;

	std::string sProxyAuthorization;
	if (false == m_authStr.empty())
		sProxyAuthorization = "Proxy-authorization: Basic "+ m_authStr+ "\r\n";
	char sServerPort[32] = {0,};
	sprintf(sServerPort, "%d", m_targetServerPort);
	std::string sProxyConnect = std::string("CONNECT ")+ m_targetServerIp + ":"+sServerPort+" HTTP/1.0\r\n";
	std::string sProxyPieces = sProxyConnect + sProxyAuthorization + "\r\n";
	NetworkInstance->SendRequest(streamId, sProxyPieces.c_str(), (uint32)sProxyPieces.length());
}

void CProxyConnectionHandler::OnReceive( const char* buffer, uint32 len, bool& createConnectionInstance )
{
	std::string received(buffer, len);
	size_t iter = 0;
	while (received.c_str()[iter]!=32 && iter<len) 
		iter++;
	if (iter==len || received.find("200")!=iter+1)
		return;

	createConnectionInstance = true;
}

//////////////////////////////////////////////////////////////////////////

void CNullProxyConnectionHandler::OnConnect(uint32 streamId, bool& createConnectionInstance)
{
	createConnectionInstance = true;
}

void CNullProxyConnectionHandler::OnReceive( const char* buffer, uint32 len, bool& createConnectionInstance )
{
	ACE_ASSERT(true);
}

//////////////////////////////////////////////////////////////////////////